/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @file Print CKE Document
 */

// Register a plugin named "print".
CKEDITOR.plugins.add( 'print',
{
	init : function( editor, pluginPath )
	{	
		editor.addCommand( 'print', CKEDITOR.plugins.print );
		editor.ui.addButton( 'Print',
			{
				label : editor.lang.print,
				command : 'print'
			});
	}
});

CKEDITOR.plugins.print =
{
	// Print CKE document.
	printCKEDocument : function( editor ){
		editor.window.$.print();
	},

	// Print the whole page.
	printPage : function( editor ){
		window.print();
	},

	exec : function( editor )
	{
		if (editor.config.print == 'page' )
			CKEDITOR.plugins.print.printPage( editor );
		else
			CKEDITOR.plugins.print.printCKEDocument( editor );
	}
};
