/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'button', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadLink = function( editor, selection, ranges, element ){

		// Read attributes.
		var type = element.getAttribute( 'type' );
		var name = element.getAttribute( 'name' );
		var value = element.getAttribute( 'value' );

		// Fill out all fields.
		this.setValueOf( 'info', 'txtName', name );
		this.setValueOf( 'info', 'txtValue', value );
		this.setValueOf( 'info', 'txtType', type );
		
		this.saveSelection();
		this.editMode = true;
		this.editObj = element;

		return false;
	};
	
	return {
		title : editor.lang.button.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk : function( data )
		{
			this.editObj.setAttributes( this.changedAttibutes );
			
			if ( this.editMode == false )
			{			
				// Doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			
			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();
				
			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element && element.getAttribute( 'type' ) )
				{
					var type = element.getAttribute( 'type' );
					if ( type == "button" || type == "reset" || type == "submit" )
					{
						loadLink.apply( this, [ editor, selection, ranges, element ] );
						selection.selectElement( element );
					}
				}
			}

			if ( this.editMode == false )	//New object.
			{
				this.editObj = editor.document.createElement( 'input' );
			}
			this.getContentElement( 'info', 'txtName' ).focus();

			this.changedAttibutes = new Array();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.button.title,
				title : editor.lang.button.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.button.text,
						accessKey : 'V',
						'default' : '',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					},
					{
						id : 'txtType',
						type : 'select',
						label : editor.lang.button.type,
						'default' : editor.config.pluginConfig.forms.defaultValues.buttonType,
						accessKey : 'T',
						items :
						[
							[ editor.lang.button.typeBtn, 'button' ],
							[ editor.lang.button.typeSbm, 'submit' ],
							[ editor.lang.button.typeRst, 'reset' ]
						],
						validate: function()
						{
							addChange( 'type', this );
							return true;
						}
					}
				]
			}
		]
	};
});
