/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'select', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	var resetDialog = function( dialog ){
		var names = dialog.getContentElement( 'info', 'cmbName' );
		var values = dialog.getContentElement( 'info', 'cmbValue' );
		var namesOptions = CKEDITOR.plugins.forms.select.getOptions( names );
		var valuesOptions = CKEDITOR.plugins.forms.select.getOptions( values );

		// Reset dialog.
		for ( var i = namesOptions.length-1 ; i >=0 ; i-- )
		{
			namesOptions[i].parentNode.removeChild( namesOptions[i] );
			valuesOptions[i].parentNode.removeChild( valuesOptions[i] );
		}
		dialog.getContentElement( 'info', 'txtOptName' ).setValue( '' );
		dialog.getContentElement( 'info', 'txtOptValue' ).setValue( '' );
	};
	
	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		var dialog = this;

		//Reset (after checking selection)
		resetDialog( dialog );

		var names = dialog.getContentElement( 'info', 'cmbName' );
		var values = dialog.getContentElement( 'info', 'cmbValue' );
			
		dialog.editObj = element;
		dialog.editMode = true;
		dialog.saveSelection();

		dialog.getContentElement( 'info', 'txtName' ).setValue( dialog.editObj.getAttribute( "name" ) );
		dialog.getContentElement( 'info', 'txtSize' ).setValue( dialog.editObj.getAttribute( "size" ) );
		dialog.getContentElement( 'info', 'chkMulti' ).setValue( dialog.editObj.getAttribute( "multiple" ) );

		var objOptions = CKEDITOR.plugins.forms.select.getOptions( dialog.editObj );

		//Load Options into dialog.
		for ( var i = 0 ; i < objOptions.length ; i++ )
		{
			var oText	= objOptions[i].innerHTML;
			var oValue	= objOptions[i].value;
			if ( objOptions[i].getAttribute( 'selected' ) == 'selected' )
				dialog.getContentElement( 'info', 'txtValue' ).setValue( objOptions[i].value );		
			var oTOption = CKEDITOR.plugins.forms.select.addOption( names, oText, oText, editor.document );
			var oVOption = CKEDITOR.plugins.forms.select.addOption( values, oValue, oValue, editor.document );
		}
	}

	return {
		title : editor.lang.select.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 350,
		onShow : function()
		{
			this.editMode = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'select', true );	
				if ( element )
				{
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
				}
			}

			if ( this.editMode == false )		//New object.
			{
				resetDialog( this );	//Reset (after checking selection)
				this.editObj = this.getParentEditor().document.createElement( 'select' );
			}

			this.pushDefault();
			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		onOk : function()
		{
			var objOptions = CKEDITOR.plugins.forms.select.getOptions( this.editObj );

			// Remove all options.
			for ( var i = objOptions.length-1 ; i >= 0 ; i-- ){
				objOptions[0].parentNode.removeChild( objOptions[0] );
			}

			var selectValue = this.getContentElement( 'info', 'txtValue' ).getValue();
			var optionsNames = CKEDITOR.plugins.forms.select.getOptions( this.getContentElement( 'info', 'cmbName' ) );
			var optionsValues = CKEDITOR.plugins.forms.select.getOptions( this.getContentElement( 'info', 'cmbValue' ) );

			//Set added/changed attributes
			this.editObj.setAttributes( this.changedAttibutes );

			var parentEditor = this.getParentEditor();

			// Add all available options.
			for ( var i = 0 ; i < optionsNames.length ; i++ )
			{
				var sText	= optionsNames[i].value;
				var sValue	= optionsValues[i].value;
				if ( sValue.length == 0 ) sValue = sText;

				var oOption = CKEDITOR.plugins.forms.select.addOption( this.editObj, sText, sValue, parentEditor.document );
				if ( sValue == selectValue )
				{
					oOption.setAttribute( 'selected', 'selected' );
					oOption.selected = true;
				}
			}

			if ( this.editMode == false )
			{
				this.restoreSelection();
				parentEditor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.select.selectInfo,
				title : editor.lang.select.selectInfo,
				accessKey : '',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						align:'center',
						style : 'width:350px',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						widths : [ '25%','75%' ],
						labelLayout : 'horizontal',
						label : editor.lang.select.value,
						style : 'width:350px',
						'default' : '',
						accessKey : 'V',
						disabled : true
					},
					{
						type : 'hbox',
						widths : [ '175px', '170px' ],
						align : 'center',
						children :
						[
							{
								id : 'txtSize',
								type : 'text',
								align : 'center',
								labelLayout : 'horizontal',
								label : editor.lang.select.size,
								'default' : editor.config.pluginConfig.forms.defaultValues.selectSize,
								accessKey : 'S',
								style : 'width:175px',
								validate: function()
								{
									if ( this.getValue() != '' )
									{
										var selectSize = parseInt( this.getValue(), 10 );
										if ( isNaN( selectSize ) )
										{
											this.select();
											return false;
										}
										addChange( 'size', this );
									}
									return true;
								}
							},
							{
								type : 'html',
								align : 'center',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.select.lines ) + '</span>'
							}
						]
					},
					{
						type : 'html',
						align : 'center',
						html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.select.opAvail ) + '</span>'
					},
					{
						type : 'hbox',
						widths : [ '35%', '35%', '15%', '15%' ],
						children :
						[
							{
								id : 'txtOptName',
								type : 'text',
								label : editor.lang.select.opText,
								style : 'width:105px'
							},
							{
								id : 'txtOptValue',
								type : 'text',
								label : editor.lang.select.opValue,
								style : 'width:105px'
							},
							{
								type : 'button',
								style : '',
								label : editor.lang.select.btnAdd,
								title : editor.lang.select.btnAdd,
								onClick : function()
								{
									//Add new option.
									var dialog = this.getDialog();
									var parentEditor = dialog.getParentEditor();
									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									CKEDITOR.plugins.forms.select.addOption(names, name.getValue(), name.getValue(), parentEditor.document );
									CKEDITOR.plugins.forms.select.addOption(values, value.getValue(), value.getValue(), parentEditor.document );

									name.setValue( "" );
									value.setValue( "" );
								}
							},
							{
								type : 'button',
								label : editor.lang.select.btnModify,
								title : editor.lang.select.btnModify,
								onClick : function()
								{
									//Modify selected option.
									var dialog = this.getDialog();
									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( names );
									if ( iIndex >= 0 )
									{
										CKEDITOR.plugins.forms.select.modifyOption( names, iIndex, name.getValue(), name.getValue() );
										CKEDITOR.plugins.forms.select.modifyOption( values, iIndex, value.getValue(), value.getValue() );
									}
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '35%','35%','30%'],
						children :
						[
							{
								type : 'select',
								id : 'cmbName',
								label : '',
								title : '',
								multiple : true,
								size : 5,
								style : 'width:105px',
								items : [],
								onChange : function()
								{
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( names );
									CKEDITOR.plugins.forms.select.setSelectedIndex( values, iIndex );

									name.setValue( names.getValue() );
									value.setValue( values.getValue() );
								}
							},
							{
								type : 'select',
								id : 'cmbValue',
								label : '',
								title : '',
								multiple : true,
								size : 5,
								style : 'width:105px',
								items : [],
								onChange : function()
								{
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );

									var iIndex = CKEDITOR.plugins.forms.select.getSelectedIndex( values );
									CKEDITOR.plugins.forms.select.setSelectedIndex( names, iIndex );

									name.setValue( names.getValue() );
									value.setValue( values.getValue() );
								}
							},
							{
								type : 'vbox',
								children :
								[
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.select.btnUp,
										title : editor.lang.select.btnUp,
										onClick : function()
										{
											//Move up.
											var dialog = this.getDialog();
											var names = dialog.getContentElement( 'info', 'cmbName' );
											var values = dialog.getContentElement( 'info', 'cmbValue' );

											CKEDITOR.plugins.forms.select.changeOptionPosition( names, -1 );
											CKEDITOR.plugins.forms.select.changeOptionPosition( values, -1 );
										}
									},
									{
										type : 'button',
										style : 'width:100%;',
										label : editor.lang.select.btnDown,
										title : editor.lang.select.btnDown,
										onClick : function()
										{
											//Move down.
											var dialog = this.getDialog();
											var names = dialog.getContentElement( 'info', 'cmbName' );
											var values = dialog.getContentElement( 'info', 'cmbValue' );

											CKEDITOR.plugins.forms.select.changeOptionPosition( names, 1 );
											CKEDITOR.plugins.forms.select.changeOptionPosition( values, 1 );
										}
									}
								]
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '40%', '20%', '40%' ],
						children :
						[
							{
								type : 'button',
								label : editor.lang.select.btnSetValue,
								title : editor.lang.select.btnSetValue,
								onClick : function()
								{
									//Set as default value.
									var dialog = this.getDialog();
									var values = dialog.getContentElement( 'info', 'cmbValue' );
									var txtValue = dialog.getContentElement( 'info', 'txtValue' );
									txtValue.setValue( values.getValue() );
								}
							},
							{
								type : 'button',
								label : editor.lang.select.btnDelete,
								title : editor.lang.select.btnDelete,
								onClick : function()
								{
									// Delete option.
									var dialog = this.getDialog();
									var names = dialog.getContentElement( 'info', 'cmbName' );
									var values = dialog.getContentElement( 'info', 'cmbValue' );

									CKEDITOR.plugins.forms.select.removeSelectedOptions( names );
									CKEDITOR.plugins.forms.select.removeSelectedOptions( values );

									var name = dialog.getContentElement( 'info', 'txtOptName' );
									var value = dialog.getContentElement( 'info', 'txtOptValue' );
									name.setValue( "" );
									value.setValue( "" );
								}
							},
							{
								id : 'chkMulti',
								type : 'checkbox',
								label : editor.lang.select.chkMulti,
								'default' : 'url',
								accessKey : 'M',
								validate: function()
								{
									// Multiselect checkbox.
									addChange( 'multiple', this );
									return true;
								}
							}
						]
					}
				]
			}
		]
	};
});
