/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @file Horizontal Page Break
 */

// Register a plugin named "newpage".
CKEDITOR.plugins.add( 'newpage',
{
	init : function( editor, pluginPath )
	{	
		editor.addCommand( 'newpage', CKEDITOR.plugins.newpage );
		editor.ui.addButton( 'NewPage',
			{
				label : editor.lang.newpage,
				command : 'newpage'
			});
		if ( editor.config.pluginConfig.newPage.resetToStartupContent )	
			CKEDITOR.plugins.newpage.newContent = editor.getData();
		else
			CKEDITOR.plugins.newpage.newContent = editor.config.pluginConfig.newPage.newPageContent;
	}
});

CKEDITOR.plugins.newpage =
{
	newContent : '',
	exec : function( editor )
	{
		if ( editor.config.pluginConfig.newPage.confirmation == false || confirm( editor.lang.common.confirmNewPage ) )
			editor.setData( CKEDITOR.plugins.newpage.newContent );
	}
};
