/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @file Horizontal Page Break
 */

// Register a plugin named "pagebreak".
CKEDITOR.plugins.add( 'pagebreak',
{
	init : function( editor, pluginPath )
	{	
		editor.addCommand( 'pagebreak', CKEDITOR.plugins.pagebreak );
		editor.ui.addButton( 'PageBreak',
			{
				label : editor.lang.pagebreak,
				command : 'pagebreak'
			});
	},
	requires : [ 'fakeobjects' ]
});

CKEDITOR.plugins.pagebreak =
{
	pageBreakObject : function( editor, getProtected )
	{
		var breakObject = CKEDITOR.dom.element.createFromHtml( '<div style="page-break-after: always;"><span style="display: none;">&nbsp;</span></div>' );

		if ( getProtected )
			return CKEDITOR.plugins.fakeobjects.protectElement( breakObject );
		else
			return breakObject;
	},
	removeOldBreaks : function( editor, limit )
	{
		// get all elements in CK document
		var elements = editor.document.$.getElementsByTagName( 'img' );
		// check every element for childNodes
		var count = 1;
		for( var i = 0; i < elements.length; i++ )
		{
			element = elements.item( i );
			if ( element.getAttribute( '_cke_protected_html' ) && element.getAttribute( '_cke_real_element_type' ) == "pagebreak" )
				if ( ++count >= limit )
					element.parentNode.removeChild( element );
		}
	},
	exec : function( editor )
	{
		var element = CKEDITOR.plugins.pagebreak.pageBreakObject( editor, true );
		if ( editor.config.pluginConfig.pagebreak.pageBreakeLimit !== false)
			CKEDITOR.plugins.pagebreak.removeOldBreaks( editor, editor.config.pluginConfig.pagebreak.pageBreakeLimit -1 );
		editor.insertElement( element );
	}
};
