/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

var CKPACKAGER =
{
	dir : (function()
		{			
			var packagerDir = new File( System.getProperty( 'java.class.path' ) );
			return packagerDir.getParent();
		})(),

	getPackPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.packDir, relativePath );
		return file.getAbsolutePath();
	},

	getOutputPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.outputDir, relativePath );
		return file.getAbsolutePath();
	},
	
	getPackagerPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.dir, relativePath );
		return file.getAbsolutePath();
	},

	_loadedCode : {},

	loadCode : function( path )
	{
		if ( this._loadedCode[ path ] )
			return;

		load( CKPACKAGER.getPackagerPath( path ) );
		
		this._loadedCode[ path ] = true;
	},

	tools :
	{
		readFile : function( file )
		{
			var data = readFile( file, "UTF-8" );

			// Remove the UTF-8 BOM.
			return data.replace( /^\xEF\xBB\xBF/, '' );
		},

		getFileName : function( file )
		{
			file = new File( file );
			return file.getName();
		}
	}
};
