/*
** This code has been placed into the Public Domain.
** This code was written by Timothy Gerard Endres in 1999.
** 
*/

package com.ice.tartool;

import java.awt.Color;
import java.awt.Dimension;
import java.io.*;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

import javax.activation.*;
import javax.swing.JOptionPane;

import com.ice.tar.*;
import com.ice.util.FileUtilities;
import com.ice.util.UserProperties;


public class
TarTool
	{
	public static final String		RCS_ID = "$Id: TarTool.java,v 1.5 2000/06/16 04:39:28 time Exp $";
	public static final String		RCS_REV = "$Revision: 1.5 $";
	public static final String		RCS_NAME = "$Name:  $";

	public static final String		VERSION_STR = "1.4";
	public static final String		CONFIG_MAIN = "CfgTarTool";

	private static final String		PROP_PREFIX = "TarTool.";
	private static final String		PROP_PACKAGE = "com.ice.tartool";
	private static final String		DEFAULTS_RSRC =
										"/com/ice/tartool/default.properties";

	public MainFrame				mainFrame = null;


	static public void
	main( String argv[] )
		{
		UserProperties.setPropertyPrefix( TarTool.PROP_PREFIX );

		UserProperties.setDefaultsResource( TarTool.DEFAULTS_RSRC );

		String[] myArgs = UserProperties.processOptions( argv );

		// REGISTER OUR MAIN DYNAMIC PROPERTIES
		String propFilename =
			(File.separatorChar == '/')
				? ".tartoolrc" : "tartoolrc.txt";

		String dynamicPath =
			FileUtilities.getUserHomeDirectory()
				+ File.separator + propFilename;

		UserProperties.registerDynamicProperties
			( TarTool.CONFIG_MAIN, dynamicPath, null );

		// LOAD PROPERTIES 
		UserProperties.loadProperties( TarTool.PROP_PACKAGE, null );

		TarTool instance = new TarTool();

		instance.instanceMain( myArgs );
		}

	public void
	shutDown()
		{
		//
		// This setVisible(false) MUST come first, as it saves many
		// of the dynamic properties that we save.
		//
		this.mainFrame.setVisible( false );

		try {
			UserProperties.saveDynamicProperties( CONFIG_MAIN );
			}
		catch ( IOException ex )
			{
			String msg =
				"Error saving the '" + CONFIG_MAIN + "' settings.\n"
				+ ex.getMessage();

			JOptionPane.showMessageDialog
				( null, msg, "Note", JOptionPane.WARNING_MESSAGE );
			}

		this.mainFrame.dispose();

		System.exit(0);
		}

	public void
	instanceMain( String args[] )
		{
		int		iArg = 0;

		String jafClassName =
			"javax.activation.FileTypeMap";

		try {
			Class jafClass =
				Class.forName( jafClassName );

			String mimeProp = 
				UserProperties.getProperty( "mimeTypes", null );

			if ( mimeProp != null )
				{
				byte[] propBytes = mimeProp.getBytes();
				ByteArrayInputStream bin =
					new ByteArrayInputStream( propBytes );
				FileTypeMap.setDefaultFileTypeMap
					( new MimetypesFileTypeMap( bin ) );
				}
			}
		catch ( ClassNotFoundException ex )
			{ }

		for ( ; iArg < args.length ; ++iArg )
			{
			if ( ! args[iArg].startsWith( "-" ) )
				break;

			if ( args[iArg].equals( "-?" )
					|| args[iArg].equals( "-help" )
					|| args[iArg].equals( "-usage" ) )
				{
				this.printUsage();
				}
			else if ( args[iArg].equals( "-mime" ) )
				{
				File mimeFile = new File( args[ ++iArg ] );

				try {
					Class jafClass =
						Class.forName( jafClassName );

					FileTypeMap.setDefaultFileTypeMap(
						new MimetypesFileTypeMap(
							new FileInputStream( mimeFile ) ) );
					}
				catch ( ClassNotFoundException ex )
					{
					System.err.println
						( "Could not load the class named '"
							+ jafClassName + "'.\n"
							+ "The Java Activation package must "
							+ "be installed to use ascii translation." );
					System.exit(1);
					}
				catch ( FileNotFoundException ex )
					{
					System.err.println
						( "Error, could not open the mimetypes file '"
							+ mimeFile.getPath() + "', " + ex.getMessage() );
					System.exit(1);
					}
				}
			else
				{
				System.err.println
					( "ignoring option '" + args[iArg] );
				}
			}


		// CREATE MAIN WINDOW 
		String title =
			UserProperties.getProperty
				( "mainWindow.title",
					"TarTool - Tar Archive Tool" );

		this.mainFrame = new MainFrame( title, this );

		this.mainFrame.setSize( new Dimension( 450, 600 ) );

		if ( iArg < args.length )
			{
			try {
				File tarF = new File( args[ iArg ] );

				if ( ! tarF.exists() )
					throw new FileNotFoundException( args[ iArg ] );

				this.mainFrame.getArchivePanel().openArchive( tarF );
				}
			catch ( FileNotFoundException ex )
				{
				ex.printStackTrace();
				}
			catch ( IOException ex )
				{
				ex.printStackTrace();
				}
			}

		this.mainFrame.setVisible( true );
		this.mainFrame.repaint( 250 );
		}

	public void
	printUsage()
		{
		System.err.println
			( "usage: com.ice.tartool.TarTool [options...]" );

		System.err.println( "TarTool options:" );
		System.err.println( "   -mime file    Reads file for mimetypes." );

		UserProperties.printUsage( System.err );
		}

	}



