/*
** This code has been placed into the Public Domain.
** This code was written by Timothy Gerard Endres in 1999.
** 
*/

package com.ice.tartool;

import java.util.Enumeration;
import java.util.StringTokenizer;

import javax.swing.tree.TreeNode;
import javax.swing.tree.DefaultMutableTreeNode;

import com.ice.tar.TarEntry;


public
class		ArchiveTreeNode
extends		DefaultMutableTreeNode
	{
	private String	name = null;

	private int		subDirs = 0;
	private int		subFiles = 0;

	private int		totalDirs = 0;
	private int		totalFiles = 0;


	public
	ArchiveTreeNode()
		{
		this( ".", new TarEntry( "./" ) );
		}

	public
	ArchiveTreeNode( String name, TarEntry entry )
		{
		super( entry );
		this.name = name;
		}

	public String
	toString()
		{
		return this.getName();
		}

	public boolean
	isLeaf()
		{
		return ! this.getEntry().isDirectory();
		}

	public String
	getName()
		{
		return this.name;
		}

	public TarEntry
	getEntry()
		{
		return (TarEntry) this.getUserObject();
		}

	public int
	getChildCount()
		{
		return super.getChildCount();
		}

	public String
	getPathName()
		{
		StringBuffer result = new StringBuffer();

		TreeNode[] path = this.getPath();
		// We start at 1 to avoid the root
		for ( int i = 1 ; i < path.length ; ++i )
			{
			result.append( ((ArchiveTreeNode) path[i]).getName() );
			if ( i < (path.length - 1) )
				result.append( "/" );
			}

		return result.toString();
		}

	public int
	getFileCount()
		{
		return this.subFiles;
		}

	public int
	getDirectoryCount()
		{
		return this.subDirs;
		}

	public int
	getTotalFileCount()
		{
		return this.totalFiles;
		}

	public int
	getTotalDirectoryCount()
		{
		return this.totalDirs;
		}

	public void
	computeArchiveTotals()
		{
		int[] totals = { 0, 0 };
		this.computeArchiveTotals( totals );
		}

	public void
	computeArchiveTotals( int[] supTotals )
		{
		int[] totals = { 0, 0 };

		for ( Enumeration enum = this.children()
				; enum.hasMoreElements() ; )
			{
			ArchiveTreeNode node =
				(ArchiveTreeNode) enum.nextElement();

			if ( node.isLeaf() )
				{
				++totals[0];
				}
			else
				{
				int[] subTotals = { 0, 0 };
				node.computeArchiveTotals( subTotals );

				totals[0] += subTotals[0];
				totals[1] += subTotals[1];
				totals[1]++;
				}
			}

		supTotals[0] += totals[0];
		supTotals[1] += totals[1];

		this.totalFiles = supTotals[0];
		this.totalDirs = supTotals[1];

		this.subFiles = totals[0];
		this.subDirs = totals[1];
		}

	public ArchiveTreeNode
	getChild( String name )
		{
		ArchiveTreeNode result = null;

		for ( Enumeration enum = this.children()
				; enum.hasMoreElements() ; )
			{
			ArchiveTreeNode node =
				(ArchiveTreeNode) enum.nextElement();

			if ( node.getName().equals( name ) )
				{
				result = node;
				break;
				}
			}

		return result;
		}

	public ArchiveTreeNode
	addPath( TarEntry entry )
		{
		String path = entry.getName();

		boolean isDir = path.endsWith( "/" );

		StringTokenizer tokenizer =
			new StringTokenizer( path, "/", false );
		
		ArchiveTreeNode next;
		ArchiveTreeNode node = this;

		boolean more = tokenizer.hasMoreTokens();
		for ( ; more ; )
			{
			String token = tokenizer.nextToken();

			more = tokenizer.hasMoreTokens();

			next = node.getChild( token );

			if ( next == null )
				{
				if ( more )
					{
					String entryName =
						node.getEntry().getName() + token + "/";

					next =
						new ArchiveTreeNode
							( token, new TarEntry( entryName ) );
					}
				else
					{
					next = new ArchiveTreeNode( token, entry );
					}

				node.add( next );
				}

			node = next;
			}

		return node;
		}

	}

