/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

( function()
{
	var releaser = new CKRELEASER.releaser();

	// Run tests.
	var passCount = 0, failCount = 0;

	function assertEquals( expected, actual, title )
	{
		if ( expected != actual )
		{
			var error = {
				expected :expected,
				actual :actual
			};

			print( 'FAILED: ' + (title ? title : "") );

			if ( !error.expected )
				throw error;

			print( '  Expected: ' + error.expected );
			print( '  Actual  : ' + error.actual );

			failCount++;
		}
		else
			passCount++;
	}

	function error( msg )
	{
		print( msg );
		quit();
	}

	CKRELEASER.release.ignore = [ '.svn', '.settings', '.project' ];

	function prepareTempDirs()
	{
		var tempDir = new File( 'tmp' );

		if ( tempDir.exists() && !CKRELEASER.io.deleteDirectory( 'tmp' ) )
			error( "Can't delete temp directory" );

		if ( !tempDir.mkdir() )
			error( "Can't create temp directory: " + tempDir );

		var tests = [ 'directives', 'skins', 'samples' ];

		for ( var i = 0 ; i < tests.length ; i++ )
		{
			tempDir = new File( 'tmp/' + tests[i] );
			if ( !tempDir.mkdir() )
				error( "Can't create temp directory: " + tempDir );
		}
	}

	function testDirectives()
	{
		print( "\nTesting directives\n" );

		CKRELEASER.version = "3.1beta";
		CKRELEASER.timestamp = "AB89";

		var name = 'directives';
		var testName, tempFile, correctFile, sampleFile;

		var dir = new File( '_assets/directives' );
		var dirList = dir.list();

		for ( var i = 0 ; i < dirList.length ; i++ )
		{
			var f = new File( dir, dirList[i] );

			if ( dirList[i].indexOf( ".correct." ) == -1 )
				continue;

			testName = dirList[i].replace( ".correct.txt", "" );

			sampleFile = new File( '_assets/' + name + '/' + testName + '.txt' );
			correctFile = new File( '_assets/' + name + '/' + testName + '.correct.txt' );
			tempFile = new File( 'tmp/' + name + '/' + testName + '.out.txt' );

			CKRELEASER.io.copy( sampleFile, tempFile );
			releaser.processDirectives( tempFile );

			assertEquals( CKRELEASER.io.readFile( correctFile ), CKRELEASER.io.readFile( tempFile ),
					'releaser.directives[' + testName + ']' );
		}
	}

	function testSkins()
	{
		print( "\nTesting skins\n" );

		CKRELEASER.release.skins.source = '_assets/skins';
		CKRELEASER.release.skins.target = 'tmp/skins';

		var name = 'skins';
		var correctFile, dir, dirList, test, tempFile;

		var skinProcessor = new CKRELEASER.skinProcessor();
		skinProcessor.createSkins( '.', '.' );

		var sourceDir = new File( CKRELEASER.release.skins.source );
		var sourceDirList = sourceDir.list();

		for ( var i = 0 ; i < sourceDirList.length ; i++ )
		{
			if (sourceDirList[i] == ".svn" || sourceDirList[i] == "CVS")
				continue;
			
			dir = new File( CKRELEASER.release.skins.target, sourceDirList[i] );
			assertEquals( true, dir.exists(), dir + " exists?" );

			dirList = dir.list();
			assertEquals( true, dirList.length > 0, dir + " not empty?" );

			var foundCorrect = 0;
			var foundCss = 0;
			/**
			 * Loop through files in the target directory and search for valid
			 * CSS files
			 */
			for ( var j = 0 ; j < dirList.length ; j++ )
			{
				if ( dirList[j].indexOf( ".css" ) != -1 )
					foundCss++;

				if ( dirList[j].indexOf( "correct.txt" ) != -1 )
				{
					foundCorrect++;
					test = dirList[j].replace( ".correct.txt", "" );

					correctFile = new File( dir, dirList[j] );
					tempFile = new File( dir, test + '.css' );

					assertEquals( true, tempFile.exists(), tempFile + " exists?" );

					assertEquals( md5( CKRELEASER.io.readFile( correctFile ) ), md5( CKRELEASER.io.readFile( tempFile ) ),
							'Checking md5 of created file [' + dir.getName() + "/" + test + '.css]' );
				}
			}
			if ( foundCorrect )
				assertEquals( foundCorrect, foundCss, 'The number of created and correct css files must be equal in skin ' + dir.getName() );

			/**
			 * TODO: Loop through files and subdirectories in the source
			 * directory and make sure that all files != .css have been copied.
			 */
		}
	}

	function md5( s )
	{
		s = new java.lang.String( s );
		var m = java.security.MessageDigest.getInstance( "MD5" );
		m.update( s.getBytes(), 0, s.length() );
		return new java.math.BigInteger( 1, m.digest() ).toString( 16 );
	}

	function testSamples()
	{
		print( "\nTesting samples\n" );

		CKRELEASER.release.samples.source = '_assets/samples';
		CKRELEASER.release.samples.target = 'tmp/samples';
		CKRELEASER.release.samples.template = '_assets/samples/sample.html';

		var name = 'skins';
		var test, tempFile, correctFile;

		var samplesProcessor = new CKRELEASER.samplesProcessor();
		samplesProcessor.createSamples( '.', '.' );

		var dir = new File( CKRELEASER.release.samples.target );
		var dirList = dir.list();

		assertEquals( true, dirList.length > 0, dir + " not empty?" );

		for ( var j = 0 ; j < dirList.length ; j++ )
		{
			if ( dirList[j].indexOf( "correct.txt" ) != -1 )
			{
				test = dirList[j].replace( ".correct.txt", "" );
				
				correctFile = new File( dir, dirList[j] );
				
				if ( !correctFile.isDirectory() )
				{
					tempFile = new File( dir, test + '.html' );

					assertEquals( true, tempFile.exists(), tempFile + " exists?" );

					assertEquals( md5( CKRELEASER.io.readFile( correctFile ) ), md5( CKRELEASER.io.readFile( tempFile ) ),
							'Checking md5 of created file [' + test + '.html]' );
				}
			}
		}
	}

	function testRemoveComments()
	{
		var tests = [ "/* comment \r\n\r\n something */\r\n\r\nword", "/* comment \r\n\r\n something */word",
				"/* comment \r\n\r\n something */\r\nword", "/* comment \r\n\r\n something */\n\nword",
				"/* comment \r\n\r\n something */\r\rword", "aa/* comment \r\n\r\n something */bb\n" ];
		var results = [ "\r\nword", "word", "word", "\nword", "\rword", "aabb\n" ];

		for ( var i = 0 ; i < tests.length ; i++ )
			assertEquals( results[i], CKRELEASER.tools.removeComments( tests[i] ) );
	}

	prepareTempDirs();
	testDirectives();
	testSkins();
	testSamples();
	testRemoveComments();

	print( '' );
	print( 'Finished: ' + passCount + ' passed / ' + failCount + ' failed' );

})();