/*
** This code has been placed into the Public Domain.
** This code was written by Timothy Gerard Endres in 1999.
** 
*/

package com.ice.tartool;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.border.*;

import com.ice.util.AWTUtilities;


/**
 * Shows the application's "About" dialog box.
 *
 * @version $Revision: 1.3 $
 * @author Timothy Gerard Endres, <a href="mailto:time@gjt.org">time@gjt.org</a>.
 */

public class
AboutDialog extends JDialog
		implements ActionListener
	{
	static public final String		RCS_ID = "$Id: AboutDialog.java,v 1.3 2000/06/16 04:37:42 time Exp $";
	static public final String		RCS_REV = "$Revision: 1.3 $";

	private String		messageString;
	private JTextArea	messageText;

	public
	AboutDialog( Frame parent )
		{
		super( parent, "About TarTool", true );

		this.messageString = null;

		this.establishDialogContents();

		this.pack();

		// HACK The following is a hack to compensate for
		//      what appears to be bad layout by JFC somewhere.
		//
		Dimension sz = this.getSize();
		if ( sz.width > 540 )
			sz.width = 540;
		sz.height += 20;
		if ( sz.height > 440 )
			sz.height = 440;
		this.setSize( sz );

		Point location =
			AWTUtilities.computeDialogLocation
				( this, sz.width, sz.height );

		this.setLocation( location.x, location.y );
		}

    public void
    actionPerformed( ActionEvent evt )
        {
	    String command = evt.getActionCommand();

		if ( command.compareTo( "OK" ) == 0 )
			{
			this.dispose();
			}
        }

	public void
	establishDialogContents() 
		{
		JButton			button;
		Container		content = this.getContentPane();

 		this.messageText = new JTextArea();
		this.messageText.setEditable( false );
		this.messageText.setBorder(
			new CompoundBorder(
				new EtchedBorder( EtchedBorder.RAISED ),
				new EmptyBorder( 2, 3, 2, 3 ) ) );
		this.messageText.setFont(
			Font.getFont(
				"aboutDialog.font",
				new Font( "Dialog", Font.BOLD, 12 ) ) );

		this.messageText.setText(
			"TarTool  Release " +
			TarTool.VERSION_STR +
			", Tar Archive Viewer\n" +
			"\n" +
			"Written by Tim Endres, time@gjt.org\n" +
			"This software has been placed into the public domain.\n" +
			"\n" +
			"This software is provided AS-IS, with ABSOLUTELY NO WARRANTY.\n" +
			"YOU ASSUME ALL RESPONSIBILITY FOR ANY AND ALL CONSEQUENCES\n" +
			"THAT MAY RESULT FROM THE USE OF THIS SOFTWARE!"
			); 

		JScrollPane scroller = new JScrollPane();
		scroller.getViewport().add( this.messageText );

		JPanel pan = new JPanel();
		pan.setBorder(
			new CompoundBorder(
				new EtchedBorder( EtchedBorder.RAISED ),
				new EmptyBorder( 4, 20, 4, 20 ) ) );

		pan.setLayout( new GridLayout( 1, 1, 20, 20 ) );

		button = new JButton( "OK" );
		button.addActionListener( this );
		button.setActionCommand( "OK" );
		pan.add( button );

		content.setLayout( new GridBagLayout() );

		AWTUtilities.constrain(
			content, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, 0, 1, 1, 1.0, 1.0 );

		AWTUtilities.constrain(
			content, pan,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, 1, 1, 1, 1.0, 0.0 );

		}
	}
