/*
** This code has been placed into the Public Domain.
** This code was written by Timothy Gerard Endres in 1999.
** 
*/

package com.ice.tartool;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;

import javax.swing.*;
import javax.swing.border.*;

import com.ice.tar.TarInputStream;
import com.ice.util.AWTUtilities;
import com.ice.util.FileUtilities;
import com.ice.util.UserProperties;


public class
MainFrame extends JFrame
		implements ActionListener
	{
	private static final String BOUNDS_PROP = "mainFrame.bounds";

	private TarTool				app;
	private JMenuBar			menuBar;
	private ArchivePanel		mainPanel;
	

	public
	MainFrame( String title, TarTool app )
		{
		super( title );

		this.app = app;

		this.mainPanel = new ArchivePanel();
		
		this.getContentPane().add( this.mainPanel );

		this.establishMenuBar();

		this.addWindowListener( this.new WAdapt() );

		int x =
			UserProperties.getProperty
				( "mainWindow.x", 20 );
		int y =
			UserProperties.getProperty
				( "mainWindow.y", 20 );

		this.setLocation( x, y );

		int w =
			UserProperties.getProperty
				( "mainWindow.width", -1 );
		int h =
			UserProperties.getProperty
				( "mainWindow.height", -1 );

		Dimension fSz = this.getSize();

		if ( w == -1 ) w = fSz.width;
		if ( h == -1 ) h = fSz.height;

		this.setSize( w, h );
		}

	/**
	 * @deprecated
	 */

	public void
	show()
		{
		super.show();
		this.loadLayoutProps();
		}

	public void
	setVisible( boolean vis )
		{
		if ( vis )
			{
			this.loadLayoutProps();
			}
		else
			{
			this.saveLayoutProps();
			}

		super.setVisible( vis );
		}

	protected void
	loadLayoutProps()
		{
		int t =
			UserProperties.getProperty
				( "mainFrame.bounds.t", -1 );
		int l =
			UserProperties.getProperty
				( "mainFrame.bounds.l", -1 );
		int w =
			UserProperties.getProperty
				( "mainFrame.bounds.w", -1 );
		int h =
			UserProperties.getProperty
				( "mainFrame.bounds.h", -1 );

		if ( t != -1 && l != -1 && w != -1 && h != -1 )
			{
			this.setSize( w, h );
			this.setLocation( l, t );
			}

		this.mainPanel.loadLayoutProps();
		}

	protected void
	saveLayoutProps()
		{
		Rectangle r = this.getBounds();

		UserProperties.setDynamicProperty
			( TarTool.CONFIG_MAIN, BOUNDS_PROP + ".t", ""+r.y );
		UserProperties.setDynamicProperty
			( TarTool.CONFIG_MAIN, BOUNDS_PROP + ".l", ""+r.x );
		UserProperties.setDynamicProperty
			( TarTool.CONFIG_MAIN, BOUNDS_PROP + ".w", ""+r.width );
		UserProperties.setDynamicProperty
			( TarTool.CONFIG_MAIN, BOUNDS_PROP + ".h", ""+r.height );

		this.mainPanel.saveLayoutProps();
		}

	public ArchivePanel
	getArchivePanel()
		{
		return this.mainPanel;
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "QUIT" ) )
			{
			app.shutDown();
			}
		else if ( command.equals( "OPEN" ) )
			{
			this.mainPanel.actionPerformed( event );
			}
		else if ( command.equals( "CLOSE" ) )
			{
			this.mainPanel.actionPerformed( event );
			}
		else if ( command.startsWith( "EXTRACT" ) )
			{
			this.mainPanel.actionPerformed( event );
			}
		else if ( command.equals( "ABOUT" ) )
			{
			AboutDialog dlg = new AboutDialog( this );
			dlg.show();
			}
		else
			{
			System.err.println
				( "UNKNOWN Command '" + command + "'" );
			}
		}

	private void
	establishMenuBar()
		{
		JMenuItem	item;

		this.menuBar = new JMenuBar();

		this.addFileMenu( this.menuBar );

		this.setJMenuBar( this.menuBar );
		}

	private void
	addFileMenu( JMenuBar mbar )
		{
		JMenu menu;
		JMenuItem	item;

		//
		// F I L E     M E N U
		//
		menu = new JMenu( "File" );
		mbar.add( menu );

		item = new JMenuItem( "Open Archive..." );
		item.addActionListener( this );
		item.setActionCommand( "OPEN" );
		menu.add( item );

		item = new JMenuItem( "Close Archive..." );
		item.addActionListener( this );
		item.setActionCommand( "CLOSE" );
		menu.add( item );

		menu.addSeparator();

		item = new JMenuItem( "Extract Selection..." );
		item.addActionListener( this );
		item.setActionCommand( "EXTRACT" );
		menu.add( item );

		item = new JMenuItem( "Extract Selection (asc)..." );
		item.addActionListener( this );
		item.setActionCommand( "EXTRACT_ASCII" );
		menu.add( item );

		item = new JMenuItem( "Extract Selection (ext)..." );
		item.addActionListener( this );
		item.setActionCommand( "EXTRACT_MIME" );
		menu.add( item );

		menu.addSeparator();

		item = new JMenuItem( "Quit" );
		item.setAccelerator
			( KeyStroke.getKeyStroke
				( KeyEvent.VK_Q, Event.CTRL_MASK ) );
		item.addActionListener( this );
		item.setActionCommand( "QUIT" );
		menu.add( item );

		//
		// H E L P    M E N U
		//
		menu = new JMenu( "Help" );
		mbar.add( menu );

		item = new JMenuItem( "About TarTool..." );
		item.addActionListener( this );
		item.setActionCommand( "ABOUT" );
		menu.add( item );
		}

	class WAdapt extends WindowAdapter
		{
		public void
		windowClosing( WindowEvent e )
			{
			app.shutDown();
			}
		}

	}
