/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importPackage( javax.activation );
importPackage( com.ice.tar );

importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );
importClass( java.io.FileOutputStream );
importClass( java.io.FileInputStream );
importClass( java.io.InputStreamReader );
importClass( java.io.FileOutputStream );
importClass( java.io.OutputStreamWriter );
importClass( java.util.zip.ZipOutputStream );
importClass( java.util.zip.ZipEntry );
importClass( java.util.zip.GZIPInputStream );

( function()
{
	var txtExtensions = {
		'' :0,
		'txt' :1,
		'js' :1,
		'html' :1,
		'css' :1,
		'xml' :1
	};

	function compressDirectory( sourcePath, outStream, compressMethod )
	{
		if ( CKRELEASER.verbose )
			print( "    " + compressMethod + ": " + sourcePath );

		var r = new File( CKRELEASER.releaseDir );

		try
		{
			var compressedDir = new File( sourcePath );

			var dirList = compressedDir.list();
			var readBuffer = new Packages.java.lang.reflect.Array.newInstance( java.lang.Byte.TYPE, 2056 );
			var bytesIn = 0;
			var anEntry, fis;

			for ( var i = 0 ; i < dirList.length ; i++ )
			{
				var f = new File( compressedDir, dirList[i] );

				if ( f.isDirectory() )
				{
					compressDirectory( f.getPath(), outStream, compressMethod );
					continue;
				}

				fis = new FileInputStream( f );
				
				switch ( compressMethod )
				{
					case 'tar.gz':
						anEntry = new TarEntry( f.getCanonicalPath().replace( r.getCanonicalPath(), "" ) );
						break;
					case 'zip':
						anEntry = new ZipEntry( f.getCanonicalPath().replace( r.getCanonicalPath(), "" ) );
						break;
					default:
						throw "Unknown compression method: " + compressMethod;
						break;
				}

				outStream.putNextEntry( anEntry );

				while ( (bytesIn = fis.read( readBuffer )) != -1 )
				{
					outStream.write( readBuffer, 0, bytesIn );
				}
				outStream.closeEntry();

				fis.close();
			}
		}
		catch ( e )
		{
			throw "An error occured during (" + compressMethod + ") compression of " + sourcePath + ": " + e;
		}
	}

	function copyFile( sourceLocation, targetLocation )
	{
		var inStream = new FileInputStream( sourceLocation );
		var outStream = new FileOutputStream( targetLocation );

		var len, buf = new Packages.java.lang.reflect.Array.newInstance( java.lang.Byte.TYPE, 1024 );

		while ( (len = inStream.read( buf )) != -1 )
		{
			outStream.write( buf, 0, len );
		}
		inStream.close();
		outStream.close();
	}

	CKRELEASER.io = {
		deleteDirectory : function( path )
		{
			var dir = new File( path );

			if ( dir.isDirectory() )
			{
				var children = dir.list();
				for ( var i = 0 ; i < children.length ; i++ )
				{
					if ( !this.deleteDirectory( new File( dir, children[i] ) ) )
					{
						return false;
					}
				}
			}

			return dir["delete"]();
		},

		deleteFile : function( path )
		{
			var f = new File( path );

			if ( !f.exists() )
				return true;

			if ( !f.canWrite() )
				throw "Cannot delete file: " + f.getAbsolutePath();

			return f["delete"]();
		},

		saveFile : function( file, text )
		{
			var stream = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( file ), "UTF-8" ) );
			stream.write( text );
			stream.flush();
			stream.close();
		},

		copy : function( sourceLocation, targetLocation )
		{
			if ( CKRELEASER.release.isIgnoredPath( sourceLocation.getAbsolutePath() ) )
				return;

			if ( CKRELEASER.verbose )
				print( "    Copy -> " + targetLocation.toString().replaceFirst( ".*?release(/|\\\\)?", '' ) );

			if ( sourceLocation.isDirectory() )
			{
				if ( !targetLocation.exists() )
				{
					targetLocation.mkdir();
				}

				var children = sourceLocation.list();
				for ( var i = 0 ; i < children.length ; i++ )
				{
					this.copy( new File( sourceLocation, children[i] ), new File( targetLocation, children[i] ) );
				}
			}
			else
			{
				copyFile( sourceLocation, targetLocation );
			}
		},

		zipDirectory : function( sourcePath, targetFile )
		{
			var outStream = new ZipOutputStream( new FileOutputStream( targetFile ) );
			compressDirectory( sourcePath, outStream, "zip" );
			outStream.close();
		},

		targzDirectory : function( sourcePath, targetFile )
		{
			var outStream = new TarGzOutputStream( new FileOutputStream( targetFile ) );
			compressDirectory( sourcePath, outStream, "tar.gz" );
			outStream.close();
		},

		readFile : function( file )
		{
			var inStream = new InputStreamReader( new FileInputStream( file ), "UTF-8" );

			var buffer = new StringBuffer();
			var chars = new Packages.java.lang.reflect.Array.newInstance( java.lang.Character.TYPE, 8192 );
			var count;

			try
			{
				while ( (count = inStream.read( chars, 0, 8192 )) != -1 )
				{
					if ( count > 0 )
					{
						buffer.append( chars, 0, count );
					}
				}
			}
			catch ( e )
			{
				throw 'An I/O error occurred reading the ' + file.getAbsolutePath() + ' file.';
			}
			finally
			{
				inStream.close();
			}

			/* http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4508058 */
			if ( buffer.length() && buffer.charAt( 0 ) == 65279 )
				buffer.deleteCharAt( 0 );

			return String( buffer.toString() );
		},

		getDirectoryInfo : function( file )
		{
			var path_iterator, current_file, files, result = { files: 0, size : 0 };

			if (!file.exists())
				return result;
			
			files = file.listFiles();
			
			if (!files)
				return result;
			
			path_iterator = (java.util.Arrays.asList( files )).iterator();

			while ( path_iterator.hasNext() )
			{
				current_file = path_iterator.next();
				if ( current_file.isFile() )
				{
					result.size += current_file.length();
					result.files++;
				}
				else
				{
					var info = this.getDirectoryInfo( current_file );
					result.size += info.size;
					result.files += info.files;
				}
			}

			return result;
		},
		
		getFileName : function( filePath )
		{
			var file = new File( filePath );
			return file.getName();
		},
		getExtension : function( fileName )
		{
			var pos = fileName.lastIndexOf( "." );
			if ( pos == -1 )
				return "";
			else
				return fileName.substring( pos + 1 ).toLowerCase();
		},

		isTextFile : function( fileName )
		{
			var ext = this.getExtension( fileName );

			return txtExtensions[ext] === 1;
		}

	};
})();
