/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importPackage( org.mozilla.javascript );
importClass( java.io.File );

var jarPath = JavaAdapter(org.mozilla.javascript.Parser)["class"].getResource("/org/mozilla/javascript").toString();
var releaserPath = jarPath.replaceFirst( "^jar:", '' ).replaceFirst( "\/js\.jar\!\/org\/mozilla\/javascript$", '');

load( releaserPath + "/includes/ckreleaser.js" );
CKRELEASER.path = releaserPath;
CKRELEASER.loadCode( "includes/releaser.js" );
	
function error( msg )
{
	print( msg );
	print( '' );
	quit();
}

if (arguments.length > 1 && arguments[arguments.length-1] == '-v')
	CKRELEASER.verbose = 1; 

if ( arguments[0] == '-test' )
{
	CKRELEASER.loadCode( 'test/test.js' );
	quit();
}

CKRELEASER.releaseFile = arguments[0];
CKRELEASER.sourceDir = arguments[1];
CKRELEASER.targetDir = arguments[2];
CKRELEASER.version = arguments[3];
CKRELEASER.zipName = arguments[4];
CKRELEASER.targzName = arguments[5];

if ( !CKRELEASER.releaseFile || !CKRELEASER.sourceDir || !CKRELEASER.targetDir 
		|| !CKRELEASER.version || !CKRELEASER.zipName || !CKRELEASER.targzName)
{
	error( 'Usage:java -jar js.jar ckreleaser.js [release_file] [source_dir] [target_dir] [version] [zip_name] [targz_name]' );
}

CKRELEASER.releaseDir = CKRELEASER.targetDir + "/" + "release";
CKRELEASER.loadCode( 'tools/CKPackager/includes/ckpackager.js' );
CKPACKAGER.packDir = CKRELEASER.sourceDir;
CKPACKAGER.dir = 'tools/CKPackager/';
CKPACKAGER.outputDir = CKRELEASER.releaseDir;
CKPACKAGER.loadCode( 'includes/packager.js' );

(function()
{
	try {
		var releaser = new CKRELEASER.releaser();
		releaser.loadDefinitionFile( CKRELEASER.releaseFile );
		releaser.run();
	}
	catch(e)
	{
		print("");
		error(e);
	}
})();
