/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
 

CKEDITOR.dialog.add( 'flash', function( editor ){
{
	const PARAM = 1,
	OBJECT = 2,
	EMBED = 4;
	
	var regexSize = /^\s*(\d+)((px)|\%)?\s*$/i,
	regexValidSize = /^(\d+)\%?$|^$/i;

	var previewAreaHtml = '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.image.preview ) +'<br>'+
		'<div id="FlashPreviewLoader" style="display:none"><div class="loading">&nbsp;</div></div>'+
		'<div id="FlashPreviewBox">'+
		'<span id="previewContainer"></span>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec, enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at, ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus, augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus, gravida a, gravida sed, lobortis id, turpis. </div></div>';

	var addChange = function( name, input, type ){
		var dialog = input.getDialog();
		var result = false;

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		if ( type & PARAM )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'PARAM' ][ name ] = input.getValue();
				result = true;
			}
		if ( type & OBJECT )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'OBJECT' ][ name ] = input.getValue();
				result = true;
			}
		if ( type & EMBED )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'EMBED' ][ name ] = input.getValue();
				result = true;
			}
		
		return result;
	};

	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var onChange = function( input, attribute )
	{
		var dialog = input.getDialog();
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		if ( !dialog.editObj[ 'preview' ] )
			return 1;
		// Check value
		var aMatch  =  value.match( regexSize );
		if ( aMatch )
		{
			// % is allowed
			if ( aMatch[2] == '%' )
				aMatch[1] += '%';
			value = aMatch[1];
		}

		// Read attributes
		//dialog.editObj[ 'preview' ].setAttribute( 'border', border );	
		//dialog.editObj[ 'preview' ].setStyle( 'border', border + 'px solid black' );

		return 0;
	}

	var readSize = function( dialog )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( dialog.editObj[ 'flash' ].getAttribute( 'height' ) )
		{
			var aMatchH  =  dialog.editObj[ 'flash' ].getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				// % is allowed.
				if ( aMatchH[2] == '%' )
					aMatchH[1] += '%';
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( dialog.editObj[ 'flash' ].getAttribute( 'width' ) )
		{
			var aMatchW  =  dialog.editObj[ 'flash' ].getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				// % is allowed.
				if ( aMatchW[2] == '%' )
					aMatchW[1] += '%';
				widthText = aMatchW[1];
			}
		}

		// Read styles.
		var aMatchW  =  dialog.editObj[ 'flash' ].$.style.width.match( regexSize );
		if ( aMatchW )
		{
			// % is allowed.
			if ( aMatchW[2] == '%' )
				aMatchW[1] += '%';
			widthText = aMatchW[1];
			dialog.changedAttibutes[ 'OBJECT' ][ 'width' ] = widthText;
			dialog.changedAttibutes[ 'EMBED' ][ 'width' ] = widthText;
			dialog.dimensionsInStyle[ 'width' ] = true;
		}
		var aMatchH  =  dialog.editObj[ 'flash' ].$.style.height.match( regexSize );
		if ( aMatchH )
		{
			// % is allowed.
			if ( aMatchH[2] == '%' )
				aMatchH[1] += '%';
			heightText = aMatchH[1];
			dialog.changedAttibutes[ 'OBJECT' ][ 'height' ] = heightText;
			dialog.changedAttibutes[ 'EMBED' ][ 'height' ] = heightText;
			dialog.dimensionsInStyle[ 'height' ] = true;
		}

		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj[ 'flash' ] = CKEDITOR.plugins.fakeobjects.restoreElement( element );

		// Fill out all fields.
		if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl', imgObject ] ) )
			readAttribute.apply( this, [ 'info', 'src', 'txtUrl', imgObject ] )

		readAttribute.apply( this, [ 'advanced', 'id', 'cmbScale', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'play', 'txtChkPlay', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'loop', 'txtChkLoop', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'menu', 'txtChkMenu', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'id', 'txtGenId', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', imgObject ] );	
		readAttribute.apply( this, [ 'advanced', 'style', 'txtGenStyle', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', imgObject ] );

		readSize( this );
		updatePreview( this );

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : editor.lang.flash.title,
		minWidth : 450,
		minHeight : 400,
		onLoad : function()
		{
			if ( editor.config.pluginConfig.flash.uploadTab == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.

			if ( editor.config.pluginConfig.flash.showAdvancedTab == false )
				this.hidePage( 'advanced' );		//Hide Advanded tab.

			if ( editor.config.pluginConfig.flash.showPropertiesTab == false )
				this.hidePage( 'advanced' );		//Hide Proporties tab.
				
			if ( editor.config.pluginConfig.flash.browseServer == false )
				this.getContentElement( 'info', 'browse' ).getElement().hide();
		},	
		onHide : function()
		{
			if ( this.editObj[ 'preview' ] )
				this.editObj[ 'preview' ].setAttribute( 'src', '' );

			this.editObj[ 'preview' ] = false;

			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'fakeobject' ] = false;
			this.editObj[ 'preview' ] = false;
			this.editObj[ 'flash' ] = false;
			
			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'fakeobject' ] = false;
	
			this.changedAttibutes = new Array();
			this.changedAttibutes[ 'PARAM' ] = new Array();
			this.changedAttibutes[ 'OBJECT' ] = new Array();
			this.changedAttibutes[ 'EMBED' ] = new Array();

			this.dimensionsInStyle = new Array();
			this.dimensionsInStyle[ 'width' ] = false;
			this.dimensionsInStyle[ 'height' ] = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'img', true );
				if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'flash' )
				{
					this.editMode[ 'fakeobject' ] = true;
					this.editObj[ 'fakeobject' ] = element;
					element = CKEDITOR.plugins.fakeobjects.restoreElement( this.editObj[ 'fakeobject' ] );
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( this.editObj[ 'fakeobject' ] );
					this.saveSelection();
				}
			}
			updatePreview( this );

			this.allowOnChange = true;
			this.pushDefault();
			this.getContentElement( 'info', 'txtUrl' ).focus();
		},	
		onOk : function()
		{
			this.allowOnChange = true;

			// Create a new fakeobject.
			if ( !this.editMode[ 'fakeobject' ] )
			{
				this.editObj[ 'object' ] = editor.document.createElement( 'object' );
				this.editObj[ 'embed' ] = editor.document.createElement( 'embed' );
			}
			
			// Create a new flash object.
			if ( !this.editMode[ 'fakeobject' ] )
			{
				this.editObj[ 'flash' ] = editor.document.createElement( 'embed' );
				
				// TODO: this.editObj[ 'fakeobject' ].setRealemenet( this.editObj[ 'flash' ] );
			}

			// Set flash attributes.
		//	this.editObj[ 'flash' ].setAttributes( this.changedAttibutes);

			// Set STYLE dimensions.
			if ( this.dimensionsInStyle[ 'width' ] == true )
			{
				this.editObj[ 'object' ].setStyle( 'width',  this.changedAttibutes[ 'OBJECT' ][ 'width' ] + 'px' );
				this.editObj[ 'fakeobject' ].setStyle( 'width',  this.changedAttibutes[ 'OBJECT' ][ 'width' ] + 'px' );
			}
			if ( this.dimensionsInStyle[ 'height' ] == true )
			{
				this.editObj[ 'object' ].setStyle( 'height',  this.changedAttibutes[ 'OBJECT' ][ 'height' ] + 'px' );
				this.editObj[ 'fakeobject' ].setStyle( 'height',  this.changedAttibutes[ 'OBJECT' ][ 'height' ] + 'px' );
			}

			// Insert a new fakeobject.
			if ( this.editMode[ 'fakeobject' ] == false )
			{
				// Append EMBED as child.
				this.editObj[ 'object' ].append( this.editObj[ 'embed' ] );
				this.editObj[ 'fakeobject' ] = CKEDITOR.plugins.fakeobjects.protectElement( this.editObj[ 'object' ] );

				//alert( decodeURIComponent( this.editObj[ 'fakeobject' ].getAttribute( '_cke_protected_html' ) ));

				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj[ 'fakeobject' ] );
			}
			else
			{
				CKEDITOR.plugins.fakeobjects.updateFakeElement( this.editObj[ 'fakeobject' ], this.editObj[ 'object' ] );
			}
			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.common.generalTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.image.url ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'movie', this, PARAM );
											addChange( 'src', this, EMBED );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.common.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.w3schools.com/flash/mouse.swf" );
										}
									}
								]
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '25%', '25%', '25%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtWidth',
								label : editor.lang.flash.width,
								'default' : editor.config.pluginConfig.flash.defaultValues.width,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'width', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtHeight',
								label : editor.lang.flash.height,
								'default' : editor.config.pluginConfig.flash.defaultValues.height,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'height', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtHSpace',
								label : editor.lang.flash.hSpace,
								'default' : editor.config.pluginConfig.flash.defaultValues.hSpace,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'hSpace', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtVSpace',
								label : editor.lang.flash.vSpace,
								'default' : editor.config.pluginConfig.flash.defaultValues.vSpace,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'vSpace', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							}
						]
					},

					{
						type : 'vbox',
						children :
						[
							{
								type : 'html',
								style : 'width:95%;',
								html : previewAreaHtml
							}
						]
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.common.upload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.common.upload,
						action : editor.config.pluginConfig.image.uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.common.uploadSubmit,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'properties',
				label : editor.lang.flash.propertiesTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbScale',
								type : 'select',
								label : editor.lang.flash.scale,
								'default' : editor.config.pluginConfig.flash.defaultValues.scale,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.flash.scaleAll, 'showall' ],
									[ editor.lang.flash.scaleNoBorder, 'noborder' ],
									[ editor.lang.flash.scaleFit, 'exactfit' ]
								],
								validate : function()
								{
									addChange( 'scale', this, PARAM | EMBED );
									return true;
								}
							},
							{
								id : 'cmbAccess',
								type : 'select',
								label : editor.lang.flash.access,
								'default' : editor.config.pluginConfig.flash.defaultValues.access,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.flash.accessAlways, 'always' ],
									[ editor.lang.flash.accessSameDomain, 'samedomain' ],
									[ editor.lang.flash.accessNever, 'never' ]
								],
								validate : function()
								{
									addChange( 'allowscriptaccess', this, PARAM | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbWmode',
								type : 'select',
								label : editor.lang.flash.windowMode,
								'default' : editor.config.pluginConfig.flash.defaultValues.windowMode,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ 'window' ],
									[ 'opaque' ],
									[ 'transparent' ]
								],
								validate : function()
								{
									addChange( 'wmode', this, PARAM );
									return true;
								}
							},
							{
								id : 'cmbQuality',
								type : 'select',
								label : editor.lang.flash.quality,
								'default' : editor.config.pluginConfig.flash.defaultValues.quality,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ 'best' ],
									[ 'high' ],
									[ 'autohigh' ],
									[ 'medium' ],
									[ 'autolow' ],
									[ 'low' ]
								],
								validate : function()
								{
									addChange( 'quality', this, PARAM | EMBED );
									return true;
								}
							},
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbAlign',
								type : 'select',
								label : editor.lang.flash.align,
								'default' : editor.config.pluginConfig.flash.defaultValues.align,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.image.alignLeft , 'left'],
									[ editor.lang.image.alignAbsBottom , 'absBottom'],
									[ editor.lang.image.alignAbsMiddle , 'absMiddle'],
									[ editor.lang.image.alignBaseline , 'baseline'],
									[ editor.lang.image.alignBottom , 'bottom'],
									[ editor.lang.image.alignMiddle , 'middle'],
									[ editor.lang.image.alignRight , 'right'],
									[ editor.lang.image.alignTextTop , 'textTop'],
									[ editor.lang.image.alignTop , 'top']
								],
								validate : function()
								{
									addChange( 'align', this, OBJECT | EMBED );
									return true;
								}
							},
							{
								type : 'html',
								html : '<div></div>',
							}
						]
					},
					{
						type : 'checkbox',
						id : 'chkMenu',
						label : editor.lang.flash.chkMenu,
						checked : editor.config.pluginConfig.flash.defaultValues.menu,
						validate : function()
						{
							addChange( 'menu', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'chkPlay',
						label : editor.lang.flash.chkPlay,
						checked : editor.config.pluginConfig.flash.defaultValues.play,
						validate : function()
						{
							addChange( 'play', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'chkLoop',
						label : editor.lang.flash.chkLoop,
						checked : editor.config.pluginConfig.flash.defaultValues.loop,
						validate : function()
						{
							addChange( 'loop', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'txtChkFull',
						label : editor.lang.flash.chkFull,
						checked : editor.config.pluginConfig.flash.defaultValues.allowfullscreen,
						validate : function()
						{
							addChange( 'allowfullscreen', this, PARAM | EMBED );
							return true;
						}
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.common.advancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenId',
								label : editor.lang.common.id,
								validate : function()
								{
									addChange( 'id', this, OBJECT | EMBED );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.common.advisoryTitle,
								'default' : editor.config.pluginConfig.flash.defaultValues.title,
								validate : function()
								{
									addChange( 'title', this, OBJECT | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtBgcolor',
								label : editor.lang.flash.bgcolor,
								'default' : editor.config.pluginConfig.flash.defaultValues.bgcolor,
								validate : function()
								{				
									addChange( 'bgcolor', this, PARAM | EMBED );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.common.cssClass,
								'default' : editor.config.pluginConfig.flash.defaultValues.cssClass,
								validate : function()
								{
									addChange( 'class', this, OBJECT | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenStyle',
						label : editor.lang.common.cssStyle,
						'default' : editor.config.pluginConfig.flash.defaultValues.cssStyle,
						validate : function()
						{
							addChange( 'style', this, OBJECT | EMBED );
							return true;
						}
					}
				]
			}
		]
	};
};

});
