/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'hiddenfield', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		var name = element.getAttribute( 'name' );
		var value = element.getAttribute( 'value' );

		this.setValueOf( 'info', 'txtName', name );
		this.setValueOf( 'info', 'txtValue', value );

		return false;
	};
	return {
		title : editor.lang.hidden.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 200,
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			this.changedAttibutes = new Array();

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element && element.getAttribute( 'type' ) == "hidden" )
				{
					loadSelection.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );

			this.getContentElement( 'info', 'txtName' ).focus();
		},
		onOk : function()
		{
			this.changedAttibutes[ 'type' ] = 'hidden';
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.hidden.title,
				title : editor.lang.hidden.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.hidden.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.hidden.value,
						'default' : '',
						accessKey : 'V',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					}
				]
			}
		]
	};
});
