/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'radio', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Read attributes.
		var checked = element.getAttribute( 'checked' );
		var name = element.getAttribute( 'name' );
		var value = element.getAttribute( 'value' );

		// Fill out all fields.
		this.setValueOf( 'info', 'txtName', name );
		this.setValueOf( 'info', 'txtValue', value );
		this.setValueOf( 'info', 'cmbSelected', checked );

		return false;
	};
	return {
		title : editor.lang.checkboxAndRadio.radioTitle,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 200,
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			this.changedAttibutes = new Array();

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element && element.getAttribute( 'type' ) == "radio" )
				{
					loadSelection.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );

			this.getContentElement( 'info', 'txtName' ).focus();
		},
		onOk : function()
		{
			this.changedAttibutes[ 'type' ] = 'radio';

			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.checkboxAndRadio.radioTitle,
				title : editor.lang.checkboxAndRadio.radioTitle,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.checkboxAndRadio.value,
						'default' : '',
						accessKey : 'V',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					},
					{
						id : 'cmbSelected',
						type : 'checkbox',
						label : editor.lang.checkboxAndRadio.selected,
						'default' : '',
						accessKey : 'S',
						value : "checked",
						validate: function()
						{
							addChange( 'checked', this );
							return true;
						}
					}
				]
			}
		]
	};
});
