/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'table', function( editor )
{
	var makeElement = function( name ){ return new CKEDITOR.dom.element( name, editor.document ); },
		widthPattern = /^(\d+(?:\.\d+)?)(px|%)$/,
		heightPattern = /^(\d+(?:\.\d+)?)px$/;

	return {
		title : editor.lang.table.title,
		minWidth : 480,
		minHeight : 290,
		onShow : function()
		{
			// Detect if there's a selected table.
			this.restoreSelection();
			var selection = editor.getSelection(),
				ranges = selection.getRanges(),
				me = this,
				selectedTable = null;
			if ( ranges.length > 0 )
			{
				var rangeRoot = ranges[0].getCommonAncestor( true );
				selectedTable = rangeRoot.getAscendant( 'table', true );
			}

			// Fill in relevant fields if there's a selected table.
			if ( selectedTable )
			{
				var syncAttr = function( inputName, attrName )
				{
					me.setValueOf( 'info', inputName, selectedTable.getAttribute( attrName ) );
				},
					widthMatch = widthPattern.exec( selectedTable.$.style.width ),
					heightMatch = heightPattern.exec( selectedTable.$.style.height ),
					caption = selectedTable.getElementsByTag( 'caption' );
				syncAttr( 'txtBorder', 'border' );
				syncAttr( 'cmbAlign', 'align' );
				syncAttr( 'txtCellPad', 'cellpadding' );
				syncAttr( 'txtCellSpace', 'cellspacing' );
				syncAttr( 'txtSummary', 'summary' );

				if ( widthMatch )
				{
					this.setValueOf( 'info', 'txtWidth', widthMatch[1] );
					this.setValueOf( 'info', 'cmbWidthType', widthMatch[2] == 'px' ? 'pixels' : 'percents' );
				}

				if ( heightMatch )
					this.setValueOf( 'info', 'txtHeight', heightMatch[1] );

				this.setValueOf( 'info', 'txtRows', selectedTable.$.rows.length );
				this.setValueOf( 'info', 'txtCols', selectedTable.$.rows[0].cells.length );

				if ( caption.count() > 0 )
				{
					caption = caption.getItem( 0 );
					caption = ( caption.getChild( 0 ) && caption.getChild( 0 ).getText() ) || '';
					caption = CKEDITOR.tools.trim( caption );
					this.setValueOf( 'info', 'txtCaption', caption );
				}

				// Disable the rows and column fields if a table is already selected.
				this.getContentElement( 'info', 'txtRows' ).disable();
				this.getContentElement( 'info', 'txtCols' ).disable();

				// Save a reference to the selected table, and push a new set of default values.
				this._.selectedElement = selectedTable;
				this.pushDefault();
			}
			else
			{
				this._.selectedElement = null;
				this.getContentElement( 'info', 'txtRows' ).enable();
				this.getContentElement( 'info', 'txtCols' ).enable();
			}

			// Put focus into the first relevant text field.
			this.getContentElement( 'info', selectedTable ? 'txtWidth' : 'txtRows' ).select();
		},
		onHide : function()
		{
			if ( this._.selectedElement )
				this.popDefault();
		},
		onOk : function()
		{
			var table = this._.selectedElement || makeElement( 'table' ),
				me = this,
				caption = this.getValueOf( 'info', 'txtCaption' );

			// Insert the caption, if any.
			if ( caption != '' )
			{
				var captionElement = new CKEDITOR.dom.element( 'caption', editor.document );
				captionElement.append( new CKEDITOR.dom.text( caption, editor.document ) );
				table.append( captionElement );
			}

			// Generate the rows and cols.
			if ( !this._.selectedElement )
			{
				var tbody = table.append( makeElement( 'tbody' ) ),
					rows = parseInt( this.getValueOf( 'info', 'txtRows' ), 10 ) || 0;
					cols = parseInt( this.getValueOf( 'info', 'txtCols' ), 10 ) || 0;

				for ( var i = 0 ; i < rows ; i++)
				{
					var row = tbody.append( makeElement( 'tr' ) );
					for ( var j = 0 ; j < cols ; j++ )
					{
						var cell = row.append( makeElement( 'td' ) );
						if ( !CKEDITOR.env.ie )
							cell.append( makeElement( 'br' ) );
					}
				}
			}

			// Set the basic attributes.
			var setAttr = function( inputNameOrFunction, attrName )
			{
				var value = ( typeof( inputNameOrFunction) == 'function' ) ? inputNameOrFunction()
					: me.getValueOf( 'info', inputNameOrFunction );
				if ( value != '' )
					table.setAttribute( attrName, value );
			};
			setAttr( 'txtBorder', 'border' );
			setAttr( 'cmbAlign', 'align' );
			setAttr( 'txtCellPad', 'cellpadding' );
			setAttr( 'txtCellSpace', 'cellspacing' );
			setAttr( 'txtSummary', 'summary' );
			setAttr( function()
				{
					var styles = [];
					if ( me.getValueOf( 'info', 'txtHeight' ) != '' )
						styles.push( 'height:' + me.getValueOf( 'info', 'txtHeight' ) + 'px' );
					if ( me.getValueOf( 'info', 'txtWidth' ) != '' )
					{
						var type = me.getValueOf( 'info', 'cmbWidthType' );
						styles.push( 'width:' + me.getValueOf( 'info', 'txtWidth' ) + ( type == 'pixels' ? 'px' : '%' ) );
					}
					return styles.join( ';' );
				}, 'style' );

			// Insert the table element if we're creating one.
			if ( !this._.selectedElement )
			{
				this.restoreSelection();
				editor.insertElement( table );
				this.clearSavedSelection();
			}

			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.table.title,
				accessKey : 'I',
				elements :
				[
					{
						type : 'hbox',
						widths : [ '40%', '10%', '60%' ],
						children :
						[
							{
								type : 'vbox',
								children :
								[
									{
										type : 'text',
										id : 'txtRows',
										labelLayout : 'horizontal',
										widths : [ '60%','40%' ],
										style : 'width:105px',
										'default' : editor.config.pluginConfig.table.defaultValues.rows,
										label : editor.lang.table.rows,
										validate: function( ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										type : 'text',
										id : 'txtCols',
										labelLayout : 'horizontal',
										widths : [ '60%','40%' ],
										style : 'width:105px',
										'default' : editor.config.pluginConfig.table.defaultValues.columns,
										label : editor.lang.table.columns,
										validate: function( ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										type : 'text',
										id : 'txtBorder',
										labelLayout : 'horizontal',
										widths : [ '60%','40%' ],
										style : 'width:105px',
										'default' : editor.config.pluginConfig.table.defaultValues.border,
										label : editor.lang.table.border,
										validate: function( ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										id : 'cmbAlign',
										type : 'select',
										labelLayout : 'horizontal',
										'default' : editor.config.pluginConfig.table.defaultValues.align,
										widths : [ '40%','60%' ],
										label : editor.lang.table.align,
										items :
										[
											[ editor.lang.table.alignNotSet , ''],
											[ editor.lang.table.alignLeft , 'left'],
											[ editor.lang.table.alignCenter , 'center'],
											[ editor.lang.table.alignRight , 'right']
										]
									}
								]
							},
							{
								type : 'html',
								align : 'right',
								html : ''
							},
							{
								type : 'vbox',
								align : 'right',
								children :
								[
									{
										type : 'hbox',
										align : 'center',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'text',
												id : 'txtWidth',
												labelLayout : 'horizontal',
												widths : [ '50%','50%' ],
												label : editor.lang.table.width,
												'default' : editor.config.pluginConfig.table.defaultValues.width,
												validate: function( ) {
													if ( this.getValue() != '' )
													{
														if ( isNaN( parseInt( this.getValue(), 10 ) ) )
														{
															this.select();
															return false;
														}
													}
													return true;
												}
											},
											{
												id : 'cmbWidthType',
												type : 'select',
												labelLayout : 'horizontal',
												widths : [ '0%','100%' ],
												label : '',
												'default' : editor.config.pluginConfig.table.defaultValues.widthType,
												items :
												[
													[ editor.lang.table.widthPx , 'pixels'],
													[ editor.lang.table.widthPc , 'percents']
												]
											}
										]
									},
									{
										type : 'hbox',
										widths : [ '70%', '30%' ],
										children :
										[
											{
												type : 'text',
												id : 'txtHeight',
												labelLayout : 'horizontal',
												widths : [ '50%','50%' ],
												label : editor.lang.table.height,
												'default' : editor.config.pluginConfig.table.defaultValues.height,
												validate: function( ) {
													if ( this.getValue() != '' )
													{
														if ( isNaN( parseInt( this.getValue(), 10 ) ) )
														{
															this.select();
															return false;
														}
													}
													return true;
												}
											},
											{
												type : 'html',
												html : editor.lang.table.widthPx
											}
										]
									},
									{
										type : 'text',
										id : 'txtCellSpace',
										labelLayout : 'horizontal',
										widths : [ '50%','50%' ],
										style : 'width:140px',
										label : editor.lang.table.cellSpace,
										'default' : editor.config.pluginConfig.table.defaultValues.cellspacing,
										validate: function( ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									},
									{
										type : 'text',
										id : 'txtCellPad',
										labelLayout : 'horizontal',
										widths : [ '50%','50%' ],
										style : 'width:140px',
										label : editor.lang.table.cellPad,
										'default' : editor.config.pluginConfig.table.defaultValues.cellpadding,
										validate: function( ) {
											if ( this.getValue() != '' )
											{
												if ( isNaN( parseInt( this.getValue(), 10 ) ) )
												{
													this.select();
													return false;
												}
											}
											return true;
										}
									}
								]
							}
						]
					},
					{
						type : 'html',
						align : 'right',
						html : ''
					},
					{
						id : 'txtCaption',
						type : 'text',
						label : editor.lang.table.caption,
						widths : [ '30%','70%' ],
						labelLayout : 'horizontal',
						'default' : editor.config.pluginConfig.table.defaultValues.caption,
						style : 'width:400px'
					},
					{
						id : 'txtSummary',
						type : 'text',
						labelLayout : 'horizontal',
						label : editor.lang.table.summary,
						'default' : editor.config.pluginConfig.table.defaultValues.summary,
						widths : [ '30%','70%' ],
						accessKey : 'A',
						style : 'width:400px'
					}
				]
			}
		]
	};
} );
