/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.plugins.add( 'flash',
{
	init : function( editor )
	{
		var flash = CKEDITOR.plugins.flash;

		editor.addCommand( 'flash', new CKEDITOR.dialogCommand( 'flash' ) );
		editor.ui.addButton( 'Flash',
			{
				label : editor.lang.common.flash,
				command : 'flash'
			});
		CKEDITOR.dialog.add( 'flash', this.path + 'dialogs/flash.js' );
	},
	requires : [ 'fakeobjects' ]
} );

CKEDITOR.config.flash =
{
	uploadTab : true,
	uploadAction : 'nowhere.php',
	browseServer : true,
	showAdvancedTab : true,
	showPropertiesTab : true,

	/**
	 * Save as EMBED tag only. This tag is unrecommended.
	 * @type Boolean
	 * @default false
	 */
	embedTagOnly : false,

	/**
	 * Add EMBED tag as alternative: &lt;object&gt&lt;embed&gt&lt;/embed&gt&lt;/object&gt
	 * @type Boolean
	 * @default false
	 */
	addEmbedTag : true,

	/**
	 * Use embedTagOnly and addEmbedTag values on edit.
	 * @type Boolean
	 * @default false
	 */
	convertOnEdit : false,

	defaultValues :
	{
		access :	'',
		width :		'',
		height :	'',
		hSpace :	'',
		vSpace :	'',
		cssClass :	'',
		cssStyle :	'',
		bgcolor :	'',
		title :		'',
		loop :		'true',
		play :		'true',
		menu :		'true',
		align :		'',
		quality :	'high',
		scale :		'',
		flashvars :	'',
		allowfullscreen:'',
		windowMode :	''
	}
};
