/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'button', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element ){
		// Read attributes.
		var type = element.getAttribute( 'type' );
		var name = element.getAttribute( 'name' );
		var value = element.getAttribute( 'value' );

		// Fill out all fields.
		this.setValueOf( 'info', 'txtName', name );
		this.setValueOf( 'info', 'txtValue', value );
		this.setValueOf( 'info', 'txtType', type );

		this.saveSelection();
		this.editMode = true;
		this.editObj = element;

		return false;
	};

	return {
		title : editor.lang.button.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element && element.getAttribute( 'type' ) )
				{
					var type = element.getAttribute( 'type' );
					if ( type == "button" || type == "reset" || type == "submit" )
					{
						loadSelection.apply( this, [ editor, selection, ranges, element ] );
						selection.selectElement( element );
					}
				}
			}

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );
			this.getContentElement( 'info', 'txtName' ).focus();

			this.changedAttibutes = new Array();
		},
		onOk : function()
		{
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.button.title,
				title : editor.lang.button.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.button.text,
						accessKey : 'V',
						'default' : '',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					},
					{
						id : 'txtType',
						type : 'select',
						label : editor.lang.button.type,
						'default' : editor.config.forms.defaultValues.buttonType,
						accessKey : 'T',
						items :
						[
							[ editor.lang.button.typeBtn, 'button' ],
							[ editor.lang.button.typeSbm, 'submit' ],
							[ editor.lang.button.typeRst, 'reset' ]
						],
						validate: function()
						{
							addChange( 'type', this );
							return true;
						}
					}
				]
			}
		]
	};
});
