/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'textarea', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		readAttribute.apply( this, [ 'info', 'name', 'txtName' ] );
		readAttribute.apply( this, [ 'info', 'cols', 'txtColumns' ] );
		readAttribute.apply( this, [ 'info', 'rows', 'txtRows' ] );

		return false;
	};

	var readAttribute = function( page, attribute, input )
	{
		var attributeValue = this.editObj.getAttribute( attribute );
		this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : editor.lang.textarea.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'textarea', true );
				if ( element )
				{
					loadSelection.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'textarea' );

			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		onOk : function()
		{
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.textarea.title,
				title : editor.lang.textarea.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtColumns',
						type : 'text',
						label : editor.lang.textarea.cols,
						'default' : editor.config.forms.defaultValues.textareaCols,
						accessKey : 'C',
						style : 'width:50px',
						validate: function()
						{
							var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
							var isValid = func.apply( this );
							if ( isValid )
								addChange( 'cols', this );
							return isValid;
						}
					},
					{
						id : 'txtRows',
						type : 'text',
						label : editor.lang.textarea.rows,
						'default' : editor.config.forms.defaultValues.textareaRows,
						accessKey : 'R',
						style : 'width:50px',
						validate: function()
						{
							var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
							var isValid = func.apply( this );
							if ( isValid )
								addChange( 'rows', this );
							return isValid;
						}
					}
				]
			}
		]
	};
});
