/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'textfield', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		readAttribute.apply( this, [ 'info', 'name', 'txtName' ] );
		readAttribute.apply( this, [ 'info', 'value', 'txtValue' ] );
		readAttribute.apply( this, [ 'info', 'type', 'cmbType' ] );
		readAttribute.apply( this, [ 'info', 'width', 'txtTextCharWidth' ] );
		readAttribute.apply( this, [ 'info', 'maxlength', 'txtMaxChars' ] );

		return false;
	};

	var readAttribute = function( page, attribute, input )
	{
		var attributeValue = this.editObj.getAttribute( attribute );
		this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}
	return {
		title : editor.lang.textfield.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,

		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element )
				{
					var type = element.getAttribute( 'type' );
					if ( type == "text" || type == null )
					{
						loadSelection.apply( this, [ editor, selection, ranges, element ] );
						selection.selectElement( element );
					}
				}
			}

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );

			this.getContentElement( 'info', 'txtName' ).focus();
			this.changedAttibutes = new Array();
		},
		onOk : function()
		{
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.textfield.title,
				title : editor.lang.textfield.title,
				accessKey : 'I',
				elements : [
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'txtName',
								type : 'text',
								label : editor.lang.textfield.name,
								'default' : '',
								accessKey : 'N',
								validate: function()
								{
									addChange( 'name', this );
									return true;
								}
							},
							{
								id : 'txtValue',
								type : 'text',
								label : editor.lang.textfield.value,
								'default' : '',
								accessKey : 'V',
								validate: function()
								{
									addChange( 'value', this );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'txtTextCharWidth',
								type : 'text',
								label : editor.lang.textfield.charWidth,
								'default' : editor.config.forms.defaultValues.textfieldWidth,
								accessKey : 'C',
								style : 'width:50px',
								validate: function()
								{
									var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
									var isValid = func.apply( this );
									if ( isValid )
										addChange( 'width', this );
									return isValid;
								}
							},
							{
								id : 'txtMaxChars',
								type : 'text',
								label : editor.lang.textfield.maxChars,
								'default' : editor.config.forms.defaultValues.textfieldMaxChars,
								accessKey : 'M',
								style : 'width:50px',
								validate: function()
								{
									var func = CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed );
									var isValid = func.apply( this );
									if ( isValid )
										addChange( 'maxlength', this );
									return isValid;
								}
							}
						]
					},
					{
						id : 'cmbType',
						type : 'select',
						label : editor.lang.textfield.type,
						'default' : editor.config.forms.defaultValues.textfieldType,
						accessKey : 'M',
						items :
						[
							[ editor.lang.textfield.typeText, 'text' ],
							[ editor.lang.textfield.typePass, 'pass' ],
						],
						validate: function()
						{
							addChange( 'type', this );
							return true;
						}
					}
				]
			}
		]
	};
});
