/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.plugins.add( 'forms',
{
	init : function( editor )
	{
		var forms = CKEDITOR.plugins.forms;
		editor.ui.addButton( 'Form',
			{
				label : editor.lang.common.form,
				command : 'form'
			});
		editor.addCommand( 'form', new CKEDITOR.dialogCommand( 'form' ) );

		editor.ui.addButton( 'Checkbox',
			{
				label : editor.lang.common.checkbox,
				command : 'checkbox'
			});
		editor.addCommand( 'checkbox', new CKEDITOR.dialogCommand( 'checkbox' ) );

		editor.ui.addButton( 'Radio',
			{
				label : editor.lang.common.radio,
				command : 'radio'
			});
		editor.addCommand( 'radio', new CKEDITOR.dialogCommand( 'radio' ) );

		editor.ui.addButton( 'TextField',
			{
				label : editor.lang.common.textField,
				command : 'textfield'
			});
		editor.addCommand( 'textfield', new CKEDITOR.dialogCommand( 'textfield' ) );

		editor.ui.addButton( 'Textarea',
			{
				label : editor.lang.common.textarea,
				command : 'textarea'
			});
		editor.addCommand( 'textarea', new CKEDITOR.dialogCommand( 'textarea' ) );

		editor.ui.addButton( 'Select',
			{
				label : editor.lang.common.select,
				command : 'select'
			});
		editor.addCommand( 'select', new CKEDITOR.dialogCommand( 'select' ) );

		editor.ui.addButton( 'Button',
			{
				label : editor.lang.common.button,
				command : 'button'
			});
		editor.addCommand( 'button', new CKEDITOR.dialogCommand( 'button' ) );

		editor.ui.addButton( 'ImageButton',
			{
				label : editor.lang.common.imageButton,
				command : 'imagebutton'
			});
		editor.addCommand( 'imagebutton', new CKEDITOR.dialogCommand( 'imagebutton' ) );

		editor.ui.addButton( 'HiddenField',
			{
				label : editor.lang.common.hiddenField,
				command : 'hiddenfield'
			});
		editor.addCommand( 'hiddenfield', new CKEDITOR.dialogCommand( 'hiddenfield' ) );

		CKEDITOR.dialog.add( 'form',		this.path + 'dialogs/form.js' );
		CKEDITOR.dialog.add( 'checkbox',	this.path + 'dialogs/checkbox.js' );
		CKEDITOR.dialog.add( 'radio', 		this.path + 'dialogs/radio.js' );
		CKEDITOR.dialog.add( 'textfield',	this.path + 'dialogs/textfield.js' );
		CKEDITOR.dialog.add( 'textarea',	this.path + 'dialogs/textarea.js' );
		CKEDITOR.dialog.add( 'select',		this.path + 'dialogs/select.js' );
		CKEDITOR.dialog.add( 'button',		this.path + 'dialogs/button.js' );
		CKEDITOR.dialog.add( 'hiddenfield',	this.path + 'dialogs/hiddenfield.js' );
		CKEDITOR.dialog.add( 'imagebutton',	CKEDITOR.plugins.getPath('image') + 'dialogs/image.js' );
	},
	requires : [ 'image' ]
} );

CKEDITOR.plugins.forms =
{
	select :
	{
		// Add a new option to a SELECT object (combo or list).
		addOption : function( combo, optionText, optionValue, documentObject, index )
		{
			combo = this._getObject( combo, false );
			var oOption;
			if ( documentObject )
				oOption = documentObject.createElement( "OPTION" );
			else
				oOption = document.createElement( "OPTION" );

			oOption = this._getObject( oOption, false );

			if ( combo.$ && oOption.$ && oOption.$.tagName )
			{
				combo.append( oOption );
				oOption.setText( optionText.length > 0 ? CKEDITOR.tools.htmlEncode( optionText ) : '' );
				oOption.setValue( optionValue );
			}
			else
				return false;

			return oOption;
		},

		// Remove all selected options from a SELECT object.
		removeSelectedOptions : function ( combo )
		{
			combo = this._getObject( combo, true );

			// Save the selected index
			var iSelectedIndex = combo.selectedIndex;

			var oOptions = combo.options;

			// Remove all selected options.
			for ( var i = oOptions.length - 1 ; i >= 0 ; i-- )
				if ( oOptions[i].selected ) combo.remove(i);

			// Reset the selection based on the original selected index.
			if ( combo.options.length > 0 )
			{
				if ( iSelectedIndex >= combo.options.length ) iSelectedIndex = combo.options.length - 1;
				combo.selectedIndex = iSelectedIndex;
			}
		},

		//Modify option  from a SELECT object.
		modifyOption : function( combo, index, title, value )
		{
			combo = this._getObject( combo, true  );
			if ( index < 0 ) return ;

			combo.options[ index ].innerHTML	= CKEDITOR.tools.htmlEncode( title ) ;
			combo.options[ index ].value		= CKEDITOR.tools.htmlEncode( value ) ;
		},

		// Moves the selected option by a number of steps (also negative).
		changeOptionPosition : function ( combo, steps )
		{
			combo = this._getObject( combo, true  );
			var iActualIndex = combo.selectedIndex;

			if ( iActualIndex < 0 )
				return;

			var iFinalIndex = iActualIndex + steps;

			if ( iFinalIndex < 0 )
				iFinalIndex = 0;

			if ( iFinalIndex > ( combo.options.length - 1 ) )
				iFinalIndex = combo.options.length - 1;

			if ( iActualIndex == iFinalIndex )
				return;

			var oOption = combo.options[ iActualIndex ];
			var sText	= this._htmlDecode( oOption.innerHTML );
			var sValue	= this._htmlDecode( oOption.value );

			combo.remove( iActualIndex );

			oOption = this.addOption( combo, sText, sValue, null, iFinalIndex );
			oOption.selected = true;
		},
		getSelectedIndex : function( combo )
		{
			combo = this._getObject( combo, true );

			var iIndex = combo.selectedIndex;
			return iIndex;
		},
		setSelectedIndex : function( combo, index )
		{
			combo = this._getObject( combo, true );

			if ( index < 0 ) return ;
			combo.selectedIndex = index;

			return combo;
		},
		getOptions : function ( combo )
		{
			combo = this._getObject( combo, true );
			return combo.options;
		},
		_getObject : function ( obj, getReal )
		{
			if ( obj ){
				// Dialog element.
				if ( obj.domId && obj.getInputElement().$ )
					if ( getReal )
						return obj.getInputElement().$;
					else
						return obj.getInputElement();
				else if ( obj.tagName && ( obj.tagName.toLowerCase() == 'select' || obj.tagName.toLowerCase() == 'option' ) )
					if ( getReal )
						return obj;
					else
						return new CKEDITOR.dom.element( obj );
				else if ( obj.$ )
					if ( getReal )
						return obj.$;
					else
						return obj;
				return false;
			}
			else
				return false;
		},
		_htmlDecode : function( text )
		{
			if ( !text )
				return '';

			text = text.replace( /&gt;/g, '>' );
			text = text.replace( /&lt;/g, '<' );
			text = text.replace( /&amp;/g, '&' );

			return text;
		}
	}
}

CKEDITOR.config.forms =
{
	defaultValues :
	{
		formAction : '',
		formEncoding : 'text/plain',
		formTarget : '',
		formMethod : 'GET',
		textfieldWidth : '',
		textfieldMaxChars : '',
		textfieldType : 'text',
		textareaCols : '',
		textareaRows : '',
		selectSize : '',
		buttonType : 'button'
	}
};
