/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @file Horizontal Page Break
 */

// Register a plugin named "newpage".
CKEDITOR.plugins.add( 'newpage',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'newpage', CKEDITOR.plugins.newpage );
		editor.ui.addButton( 'NewPage',
			{
				label : editor.lang.newpage,
				command : 'newpage'
			});
		if ( editor.config.newpage.resetToStartupContent )
			CKEDITOR.plugins.newpage.newContent = editor.getData();
		else
			CKEDITOR.plugins.newpage.newContent = editor.config.newpage.newPageContent;
	}
});

CKEDITOR.plugins.newpage =
{
	newContent : '',
	exec : function( editor )
	{
		if ( editor.config.newpage.confirmation == false || confirm( editor.lang.common.confirmNewPage ) )
			editor.setData( CKEDITOR.plugins.newpage.newContent );
	}
};

CKEDITOR.config.newpage =
{
	confirmation : true,
	resetToStartupContent : false,
	newPageContent : ''
};
