/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'smiley', function( editor )
{
	var smileySelector =
	{
		type : 'html',
		onClick : function( evt )
		{
			var target = evt.data.getTarget(),
				targetName = target.getName();
			if ( targetName != 'td' && targetName != 'img' )
				return;

			if ( targetName == 'td' )
				target = target.getChild(0).$;
			else
				target = target.$;

			this.getDialog().restoreSelection();
			editor.insertElement( CKEDITOR.dom.element.createFromHtml( '<img src="' +
			CKEDITOR.tools.htmlEncode( target.src ) + '" title="' +
			CKEDITOR.tools.htmlEncode( target.title ) + '" alt="' +
			CKEDITOR.tools.htmlEncode( target.title ) + '" '
					+ '_cke_saved_src="' + CKEDITOR.tools.htmlEncode( target.src ) + '" />',
				editor.document ) );
			this.getDialog().hide();
		},
		style : 'width: 100%; height: 100%; border-collapse: separate;'
	},
		html = [ '<table cellspacing="2" cellpadding="2" border="0"><tbody>' ],
		cellWidth = parseInt( 100 / editor.config.smiley.columns ) + '%',
		images = editor.config.smiley.images,
		columns = editor.config.smiley.columns,
		i;

	for ( i = 0 ; i < images.length ; i++ )
	{
		if ( i % editor.config.smiley.columns == 0 )
			html.push( '<tr>' );

		html.push( '<td class="dark_background hand centered" style="vertical-align: middle;"><img border="0" title="'+
		editor.config.smiley.descriptions[i] +'" src="' +
				CKEDITOR.tools.htmlEncode( editor.config.smiley.path + images[i] ) + '" ' +
				// IE BUG: Below is a workaround to an IE image loading bug to ensure the image sizes are correct.
				( CKEDITOR.env.ie ? 'onload="this.setAttribute(\'width\', 2); this.removeAttribute(\'width\');" ' : '' ) +
				'class="hand" /></td>' );

		if ( i % columns == columns - 1 )
			html.push( '</tr>' );
	}

	if ( i < columns - 1 )
	{
		for ( ; i < columns - 1 ; i++ )
			html.push( '<td></td>' );
		html.push( '</tr>' );
	}

	html.push( '</tbody></table>' );
	smileySelector.html = html.join( '' );

	return {
		title : editor.lang.smiley.title,
		minWidth : editor.config.smiley.windowWidth,
		minHeight : editor.config.smiley.windowHeight,
		contents : [
			{
				id : 'tab1',
				label : '',
				title : '',
				expand : true,
				elements : [
						smileySelector
					]
			}
		],
		buttons : [ CKEDITOR.dialog.cancelButton ]
	};
} );
