/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );
importPackage( java.util.regex );

CKRELEASER.loadCode( 'includes/io.js' );
CKRELEASER.loadCode( 'includes/skinprocessor.js' );
CKRELEASER.loadCode( 'includes/samplesprocessor.js' );
CKRELEASER.loadCode( 'includes/docsprocessor.js' );
CKRELEASER.loadCode( 'includes/tools.js' );

( function()
{
	CKRELEASER.releaser = function()
	{
		CKRELEASER.release = new release();
	};

	function release()
	{
		this.fixLineEnds = false;
		this.ignore = [];
		this.copy = [];
		this.packages = [];
		this.documentation = {};
		this.samples = {};
		this.skins = {};
	}

	release.prototype.isIgnoredPath = function( path )
	{
		if ( !this.ignore )
			return false;

		for ( var i = 0 ; i < this.ignore.length ; i++ )
		{
			if ( path.replace( "\\", "/" ).endsWith( this.ignore[i] ) )
				return true;
		}

		return false;
	};

	release.prototype.addIgnoredPath = function( path )
	{
		this.ignore.push( path );
	};

	release.prototype.removeIgnoredPath = function( path )
	{
		if ( !this.ignore )
			return;

		for ( var i = 0 ; i < this.ignore.length ; i++ )
		{
			if ( path == this.ignore[i] )
			{
				this.ignore.splice( i, 1 );
				return;
			}
		}
	};

	function copyFiles()
	{
		for ( var i = 0 ; i < CKRELEASER.release.copy.length ; i++ )
		{
			var sourceLocation = new File( CKRELEASER.releaseDir, CKRELEASER.release.copy[i].source );
			var targetLocation = new File( CKRELEASER.releaseDir, CKRELEASER.release.copy[i].target );
			CKRELEASER.io.copy( sourceLocation, targetLocation );
		}
	}

	function minifyFile( file )
	{
		var o = {
			output :""
		};
		var ext = CKRELEASER.io.getExtension( file.getName() );

		if ( ext == "css" )
		{
			runCommand( "java", "-jar", "yuicompressor.jar", file.getAbsolutePath(), "--line-break", "4096", "-v", "--charset", "UTF-8",
					"-o", file.getAbsolutePath(), o );

			print( o.output );
		}
		else if ( ext == "js" )
		{
			var source = CKRELEASER.io.readFile( file );
			var compressed = CKPACKAGER.scriptCompressor.compress( source, false, null, false, false );
			CKRELEASER.io.saveFile( file, compressed );
		}
	}

	function fixByteOrderMark( file )
	{
		if ( file.isDirectory() )
		{
			var children = file.list();
			for ( var i = 0 ; i < children.length ; i++ )
				fixByteOrderMark( new File( file, children[i] ) );
		}
		else
		{
			extension = CKRELEASER.io.getExtension( file.getName() );
			switch ( extension )
			{
				case "gif":
				case "jpg":
				case "jpeg":
				case "png":
				case "gz":
				case "zip":
					break;

				case "asp":
				case "js":
					CKRELEASER.io.setByteOrderMark( file, true );
					break;

				default:
					CKRELEASER.io.setByteOrderMark( file, false );
					break;
			}
		}
	}

	function minifyFiles( file )
	{
		if ( file.isDirectory() )
		{
			var children = file.list();
			for ( var i = 0 ; i < children.length ; i++ )
				minifyFiles( new File( file, children[i] ) );
		}
		else
		{
			var ext = CKRELEASER.io.getExtension( file.getName() );

			switch(ext)
			{
				case "css":
				case "html":
				case "js":
				case "txt":
				case "xml":
					minifyFile( file );
					break;
			}
		}
	}

	/**
	 * FIXME: this function shouldn't exist at all
	 */
	function cleanUp()
	{
		var file, text;

		file = new File( CKRELEASER.releaseDir, 'ckeditor.js' );
		if ( !file.exists() )
			throw "ckeditor.js not found";

		text = CKRELEASER.io.readFile( file );
		CKRELEASER.io.saveFile( file, text.replace( /_source\//g, '' ) );
	}

	var regexLib = {
		packagerRemove :Pattern.compile( '(?m-s:^.*?%REMOVE_START%).*?(?m-s:%REMOVE_END%.*?$)', Pattern.DOTALL ),
		packagerRemoveLine :Pattern.compile( '.*%REMOVE_LINE%.*(?:\\r\\n|\\r||\n)?' )
	};

	/*
	 * %VERSION%: 
	 *     the "version" string passed to the CKReleaser execution command.
	 * %TIMESTAMP%: 
	 *     a four characters string containing the
	 *     concatenation of the "Base 36" value of each of the following components
	 *     of the program execution date and time: year + month + day + hour.
	 * %REMOVE_LINE%: 
	 *     removes the line. 
	 * %REMOVE_START% and %REMOVE_END%: 
	 *     removes all lines starting from %REMOVE_START% to %REMOVE_END%, 
	 *     declaration line inclusive.
	 */
	function replaceDirectives( file )
	{
		var text = CKRELEASER.io.readFile( file );
		var replaced = false;

		if ( text.indexOf( "%VERSION%" ) != -1 )
		{
			text = text.replace( /%VERSION%/g, CKRELEASER.version );
			replaced = true;
		}
		if ( text.indexOf( "%TIMESTAMP%" ) != -1 )
		{
			text = text.replace( /%TIMESTAMP%/g, CKRELEASER.timestamp );
			replaced = true;
		}
		if ( text.indexOf( "%REMOVE_START%" ) != -1 && text.indexOf( "%REMOVE_END%" ) != -1 )
		{
			text = String( regexLib.packagerRemove.matcher( text ).replaceAll( '%REMOVE_LINE%' ) );
			text = String( regexLib.packagerRemoveLine.matcher( text ).replaceAll( '' ) );
			replaced = true;
		}
		else if ( text.indexOf( "%REMOVE_LINE%" ) != -1 )
		{
			text = String( regexLib.packagerRemoveLine.matcher( text ).replaceAll( '' ) );
			replaced = true;
		}

		if ( replaced )
		{
			if ( CKRELEASER.verbose )
				print( "\r    Replacing directives in " + file );

			CKRELEASER.io.saveFile( file, text );
		}
	}
		
	function fixLineEndings( file )
	{
		if ( file.isDirectory() )
		{
			var children = file.list();
			for ( var i = 0 ; i < children.length ; i++ )
				fixLineEndings( new File( file, children[i] ) );
		}
		else
		{
			CKRELEASER.tools.fixLineEndings( file, true );
		}
	}
	
	CKRELEASER.releaser.prototype = {
		loadDefinitionFile : function( filePath )
		{
			var file = new File( filePath );

			var releaseCode = 'var release = { ' + CKRELEASER.io.readFile( filePath ) + '\n};';

			var cx = Context.enter(), scope = cx.initStandardObjects();

			cx.evaluateString( scope, releaseCode, file.getName(), 1, null );

			this.loadDefinition( scope.release );
		},

		loadDefinition : function( definitionObject )
		{
			CKRELEASER.release = new release();

			if ( definitionObject.fixLineEnds )
				CKRELEASER.release.fixLineEnds = definitionObject.fixLineEnds;

			if ( definitionObject.ignore )
				CKRELEASER.release.ignore = definitionObject.ignore;

			for ( var i = 0 ; i < CKRELEASER.release.ignore.length ; i++ )
				CKRELEASER.release.ignore[i] = CKRELEASER.release.ignore[i].replace( "\\", "/" );

			if ( definitionObject.copy )
				CKRELEASER.release.copy = definitionObject.copy;

			if ( definitionObject.packages )
				CKRELEASER.release.packages = definitionObject.packages;

			if ( definitionObject.documentation )
				CKRELEASER.release.documentation = definitionObject.documentation;

			if ( definitionObject.samples )
				CKRELEASER.release.samples = definitionObject.samples;

			if ( definitionObject.skins )
				CKRELEASER.release.skins = definitionObject.skins;

			if ( !CKRELEASER.release.packages.length )
				throw "Nothing to release: no packages found in the release file (" + CKRELEASER.releaseFile + ")";
		},

		processDirectives : function( file )
		{
			System.out.print( "." );
			if ( file.isDirectory() )
			{
				var children = file.list();
				for ( var i = 0 ; i < children.length ; i++ )
					this.processDirectives( new File( file, children[i] ) );
			}
			else if ( CKRELEASER.io.isTextFile( file.getName() ) )
				replaceDirectives( file );
		},

		run : function()
		{
			var error, i, info, time = new Date();

			var targetDir = new File( CKRELEASER.targetDir );
			var releaseDir = new File( CKRELEASER.releaseDir );
			var sourceDir = new File( CKRELEASER.sourceDir );

			if ( !sourceDir.exists() )
				throw 'Source directory does not exist (' + CKRELEASER.sourceDir + ')';
			if ( targetDir.exists() )
				throw 'Target directory already exists (' + CKRELEASER.targetDir + ')';
			else if ( !releaseDir.mkdirs() )
				throw "Cannot create release directory (" + releaseDir + ")";

			print( "\nCopying files...\n" );
			CKRELEASER.io.copy( sourceDir, releaseDir );

			print( "\nCopying files to special destination...\n" );
			copyFiles();

			print( "\nPackaging CKEditor...\n" );
			for ( i = 0 ; i < CKRELEASER.release.packages.length ; i++ )
			{
				var packager = new CKPACKAGER.packager();
				packager.loadDefinitionFile( CKRELEASER.release.packages[i] );
				packager.run();
			}

			print( "\nCreating skins...\n" );
			var skinProcessor = new CKRELEASER.skinProcessor();
			skinProcessor.createSkins( CKRELEASER.sourceDir, CKRELEASER.releaseDir );

			print( "\nCreating documentation...\n" );
			var docsProcessor = new CKRELEASER.docsProcessor();
			docsProcessor.createDocumentation( CKRELEASER.sourceDir, CKRELEASER.releaseDir );

			var docsDir = new File( CKRELEASER.releaseDir, CKRELEASER.release.documentation.target );
			info = CKRELEASER.io.getDirectoryInfo( docsDir );
			print( "    Number of created files: " + info.files );
			print( "    Total size.............: " + info.size + " bytes" );

			print( "\nCreating samples...\n" );
			var samplesProcessor = new CKRELEASER.samplesProcessor();
			samplesProcessor.createSamples( CKRELEASER.sourceDir, CKRELEASER.releaseDir );

			print( "\nMinifying files...\n" );
			for ( i = 0 ; i < CKRELEASER.release.copy.length ; i++ )
			{
				if ( CKRELEASER.release.copy[i].minify )
				{
					var targetLocation = new File( CKRELEASER.releaseDir, CKRELEASER.release.copy[i].target );
					minifyFiles( targetLocation );
				}
			}

			print( "\nProcessing directives in files...\n" );
			this.processDirectives( releaseDir );

			print( "\n\nCleaning up...\n" );
			cleanUp();

			print( "\nFixing line endings...\n" );
			fixLineEndings( releaseDir );

			print( "\nFixing byte-order mark in files...\n" );
			fixByteOrderMark( new File( CKRELEASER.releaseDir ) );

			// get information about release directory
			info = CKRELEASER.io.getDirectoryInfo( releaseDir );

			print( "\nCreating compressed files...\n" );

			var zipFile = new File( CKRELEASER.targetDir, CKRELEASER.zipName );
			CKRELEASER.io.zipDirectory( CKRELEASER.releaseDir, zipFile );
			print( "    Created " + zipFile.getName() + "...: " + zipFile.length() + " bytes ("
					+ Math.round( zipFile.length() / info.size * 100 ) + "% of original)" );

			var tarFile = new File( CKRELEASER.targetDir, CKRELEASER.targzName );
			CKRELEASER.io.targzDirectory( CKRELEASER.releaseDir, tarFile );
			print( "    Created " + tarFile.getName() + ": " + tarFile.length() + " bytes ("
					+ Math.round( tarFile.length() / info.size * 100 ) + "% of original)" );

			print( "\n==========================" );

			time = (new Date()) - time;
			time = time / 1000;

			print( "Release process completed:\n" );
			print( "    Number of files: " + info.files );
			print( "    Total size.....: " + info.size + " bytes" );
			print( "    Time taken.....: " + time + " seconds" );
			print( "" );

			if ( error )
			{
				print( "Error details:" );
				print( error );
				print( "" );
			}
		}
	};
})();
