/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2004-2009 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector.impl;

import javax.servlet.ServletContext;

import net.fckeditor.requestcycle.impl.ServerRootPathBuilder;

/**
 * This is a very shallow and simple implementation. It assigns/returns the
 * least amount of variables to work with the direct local filesystem.<br />
 * You may call this implementation and identity implementation:
 * <code>f(x)=x</code>.
 * <p>
 * This maybe interesting for those who
 * <ul>
 * <li>serve userfiles from a static context of a servlet container/application
 * server,</li>
 * <li>serve userfiles from virtual servers with Apache HTTPd on different
 * domains, e.g. <code>http://userfiles.mydomain.com</code>, or</li>
 * <li>serve userfiles on a per-user basis, e.g. uploading to
 * <code>/home/$USERNAME/public_html/fckeditor</code> and an Apache HTTPd serves
 * as <code>/~$USERNAME/fckeditor</code>.</li>
 * </ul>
 * </p>
 * Use the {@link ServerRootPathBuilder} in conjunction with this class.
 * 
 * @version $Id: LocalConnector.java 3060 2009-02-16 21:24:19Z mosipov $
 */
public class LocalConnector extends AbstractLocalFileSystemConnector {

	/**
	 * This method simply assigns the servlet context to the underlying instance
	 * field.
	 */
	public void init(final ServletContext servletContext) throws Exception {
		this.servletContext = servletContext;
	}

	/**
	 * This is an identity implementation, it passes the path as-is.
	 */
	@Override
	protected String getRealUserFilesAbsolutePath(String path) {
		return path;
	}

}
