/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'link', function( editor )
{
	// Handles the event when the "Target" selection box is changed.
	var targetChanged = function()
	{
		var popupFeatures = this.getDialog().getContentElement( 'target', 'popupFeatures' ).getElement(),
			targetName = this.getDialog().getContentElement( 'target', 'linkTargetName' ),
			value = this.getValue();
		if ( value == 'popup' )
		{
			popupFeatures.show();
			targetName.setLabel( editor.lang.link.targetPopupName );
		}
		else
		{
			popupFeatures.hide();
			targetName.setLabel( editor.lang.link.targetFrameName );
			this.getDialog().setValueOf( 'target', 'linkTargetName', value.charAt( 0 ) == '_' ? value : '' );
		}
	},
	// Handles the event when the "Type" selection box is changed.
		linkTypeChanged = function()
	{
		var dialog = this.getDialog(),
			partIds = [ 'urlOptions', 'anchorOptions', 'emailOptions' ],
			typeValue = this.getValue();
		if ( typeValue == 'url' )
		{
			dialog.showPage( 'target' );
			if ( editor.config.link.uploadTab )
				dialog.showPage( 'upload' );
		}
		else
		{
			dialog.hidePage( 'target' );
			dialog.hidePage( 'upload' );
		}

		for ( var i = 0 ; i < partIds.length ; i++ )
		{
			var element = dialog.getContentElement( 'info', partIds[i] ).getElement().getParent().getParent();
			if ( partIds[i] == typeValue + 'Options' )
				element.show();
			else
				element.hide();
		}
	},
	// Loads the parameters in a selected link to the link dialog fields.
		emailRegex = /^mailto:([^?]+)(?:\?(.+))?$/,
		emailSubjectRegex = /subject=([^;?:@&=$,\/]*)/,
		emailBodyRegex = /body=([^;?:@&=$,\/]*)/,
		anchorRegex = /^#(.*)$/,
		urlRegex = /^((?:http|https|ftp|news):\/\/)?(.*)$/,
		selectableTargets = /^(_(?:self|top|parent|blank))$/,
		popupRegex =
		/\s*window.open\(\s*this\.href\s*,\s*(?:'([^']*)'|null)\s*,\s*'([^']*)'\s*\)\s*;\s*return\s*false;*\s*/,
		popupFeaturesRegex = /(?:^|,)([^=]+)=(\d+|yes|no)/gi,
		loadLink = function( editor, selection, ranges, element )
	{
		var href = element.getAttribute( '_cke_saved_href' ) || element.getAttribute( 'href' );
		var emailMatch = '';
		var anchorMatch = '';
		var urlMatch = false;
		if ( href != null )
		{
			emailMatch = href.match( emailRegex );
			anchorMatch = href.match( anchorRegex );
			urlMatch = href.match( urlRegex );
		}
		var me = this;

		// Load the link type and URL.
		if ( emailMatch )
		{
			var subjectMatch = href.match( emailSubjectRegex ),
				bodyMatch = href.match( emailBodyRegex );
			this.setValueOf( 'info', 'linkType', 'email' );
			this.setValueOf( 'info', 'emailAddress', emailMatch[1] );
			subjectMatch && this.setValueOf( 'info', 'emailSubject', decodeURIComponent( subjectMatch[1] ) );
			bodyMatch && this.setValueOf( 'info', 'emailBody', decodeURIComponent( bodyMatch[1] ) );
		}
		else if ( anchorMatch )
		{
			this.setValueOf( 'info', 'linkType', 'anchor' );
			this.setValueOf( 'info', 'anchorName', anchorMatch[1] );
			this.setValueOf( 'info', 'anchorId', anchorMatch[1] );
		}
		else if ( urlMatch )
		{
			var urlMatch = href.match( urlRegex );
			this.setValueOf( 'info', 'linkType', 'url' );
			this.setValueOf( 'info', 'protocol', urlMatch[1] );
			this.setValueOf( 'info', 'url', urlMatch[2] );
		}
		else
		{
			this.setValueOf( 'info', 'linkType', '' );
			this.setValueOf( 'info', 'protocol', '' );
			this.setValueOf( 'info', 'url', '' );
		}

		// Load target and popup settings.
		var target = element.getAttribute( 'target' );
		if ( target == null )
		{
			var onclick = element.getAttribute( '_cke_saved_onclick' ) || element.getAttribute( 'onclick' );
				onclickMatch = onclick && onclick.match( popupRegex );
			if ( onclickMatch )
			{
				this.setValueOf( 'target', 'linkTargetType', 'popup' );
				this.setValueOf( 'target', 'linkTargetName', onclickMatch[1] );

				var featureMatch;
				while ( ( featureMatch = popupFeaturesRegex.exec( onclickMatch[2] ) ) )
				{
					if ( featureMatch[2] == 'yes' || featureMatch[2] == '1' )
						this.setValueOf( 'target', featureMatch[1], true );
					else if ( isFinite( featureMatch[2] ) )
						this.setValueOf( 'target', featureMatch[1], featureMatch[2] );
				}
			}
			else
			{
				this.setValueOf( 'target', 'linkTargetType', 'notSet' );
				this.setValueOf( 'target', 'linkTargetName', '' );
			}
		}
		else
		{
			var targetMatch = target.match( selectableTargets );
			if ( targetMatch )
			{
				this.setValueOf( 'target', 'linkTargetType', target );
				this.setValueOf( 'target', 'linkTargetName', target );
			}
			else
			{
				this.setValueOf( 'target', 'linkTargetType', 'frame' );
				this.setValueOf( 'target', 'linkTargetName', target );
			}
		}

		// Load advanced attributes.
		var advAttr = function( inputName, attrName )
		{
			var value = element.getAttribute( attrName );
			if ( value != null )
				me.setValueOf( 'advanced', inputName, value );
		};
		advAttr( 'advLangDir', 'dir' );
		advAttr( 'advAccessKey', 'accessKey' );
		advAttr( 'advName', 'name' );
		advAttr( 'advLangCode', 'lang' );
		advAttr( 'advTabIndex', 'tabindex' );
		advAttr( 'advTitle', 'title' );
		advAttr( 'advContentType', 'type' );
		advAttr( 'advCSSClasses', 'class' );
		advAttr( 'advCharset', 'charset' );
		advAttr( 'advStyles', 'style' );

		// Record down the selected element in the dialog.
		this._.selectedElement = element;
	};

	return {
		title : editor.lang.link.title,
		minWidth : 400,
		minHeight : 320,
		contents : [
			{
				id : 'info',
				label : editor.lang.link.info,
				title : editor.lang.link.info,
				elements :
				[
					{
						id : 'linkType',
						type : 'select',
						label : editor.lang.link.type,
						'default' : 'url',
						items :
						[
							[ editor.lang.common.url, 'url' ],
							[ editor.lang.link.toAnchor, 'anchor' ],
							[ editor.lang.link.toEmail, 'email' ]
						],
						onChange : linkTypeChanged
					},
					{
						type : 'vbox',
						id : 'urlOptions',
						children :
						[
							{
								type : 'hbox',
								widths : [ '25%', '75%' ],
								children :
								[
									{
										id : 'protocol',
										type : 'select',
										label : editor.lang.common.protocol,
										'default' : 'http://',
										style : 'width : 100%;',
										items :
										[
											[ 'http://' ],
											[ 'https//' ],
											[ 'ftp://' ],
											[ 'news://' ],
											[ '<other>', '' ]
										]
									},
									{
										type : 'text',
										id : 'url',
										label : editor.lang.common.url,
										validate : function()
										{
											if ( this.getDialog().getValueOf( 'info', 'linkType' ) != 'url' )
												return true;

											if ( this.getDialog().fakeObj != false )	// Edit Anchor.
												return true;

											var func = CKEDITOR.dialog.validate.notEmpty( editor.lang.link.noUrl );
											return func.apply( this );
										}
									}
								]
							},
							{
								type : 'button',
								id : 'browse',
								label : editor.lang.common.browseServer
							}
						]
					},
					{
						type : 'vbox',
						id : 'anchorOptions',
						width : 260,
						align : 'center',
						padding : 0,
						children :
						[
							{
								type : 'html',
								id : 'selectAnchorText',
								html : CKEDITOR.tools.htmlEncode( editor.lang.link.selectAnchor )
							},
							{
								type : 'html',
								id : 'noAnchors',
								style : 'text-align: center;',
								html : '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.link.noAnchors ) + '</div>'
							},
							{
								type : 'hbox',
								id : 'selectAnchor',
								children :
								[
									{
										type : 'select',
										id : 'anchorName',
										'default' : '',
										label : editor.lang.link.anchorName,
										style : 'width: 100%;',
										items :
										[
											[ '' ]
										]
									},
									{
										type : 'select',
										id : 'anchorId',
										'default' : '',
										label : editor.lang.link.anchorId,
										style : 'width: 100%;',
										items :
										[
											[ '' ]
										]
									}
								]
							}
						]
					},
					{
						type :  'vbox',
						id : 'emailOptions',
						padding : 1,
						children :
						[
							{
								type : 'text',
								id : 'emailAddress',
								label : editor.lang.link.emailAddress,
								validate : function()
								{
									if ( this.getDialog().getValueOf( 'info', 'linkType' ) != 'email' )
										return true;

									var func = CKEDITOR.dialog.validate.notEmpty( editor.lang.link.noEmail );
									return func.apply( this );
								}
							},
							{
								type : 'text',
								id : 'emailSubject',
								label : editor.lang.link.emailSubject
							},
							{
								type : 'textarea',
								id : 'emailBody',
								label : editor.lang.link.emailBody,
								rows : 3,
								'default' : ''
							}
						]
					}
				]
			},
			{
				id : 'target',
				label : editor.lang.link.target,
				title : editor.lang.link.target,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								type : 'select',
								id : 'linkTargetType',
								label : editor.lang.link.target,
								'default' : 'notSet',
								style : 'width : 100%;',
								'items' :
								[
									[ editor.lang.link.targetNotSet, 'notSet' ],
									[ editor.lang.link.targetFrame, 'frame' ],
									[ editor.lang.link.targetPopup, 'popup' ],
									[ editor.lang.link.targetNew, '_blank' ],
									[ editor.lang.link.targetTop, '_top' ],
									[ editor.lang.link.targetSelf, '_self' ],
									[ editor.lang.link.targetParent, '_parent' ]
								],
								onChange : targetChanged
							},
							{
								type : 'text',
								id : 'linkTargetName',
								label : editor.lang.link.targetFrameName,
								'default' : ''
							}
						]
					},
					{
						type : 'vbox',
						width : 260,
						align : 'center',
						padding : 2,
						id : 'popupFeatures',
						children :
						[
							{
								type : 'html',
								html : CKEDITOR.tools.htmlEncode( editor.lang.link.popupFeatures )
							},
							{
								type : 'hbox',
								children :
								[
									{
										type : 'checkbox',
										id : 'resizable',
										label : editor.lang.link.popupResizable
									},
									{
										type : 'checkbox',
										id : 'status',
										label : editor.lang.link.popupStatusBar
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type : 'checkbox',
										id : 'location',
										label : editor.lang.link.popupLocationBar
									},
									{
										type : 'checkbox',
										id : 'toolbar',
										label : editor.lang.link.popupToolbar
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type : 'checkbox',
										id : 'menubar',
										label : editor.lang.link.popupMenuBar
									},
									{
										type : 'checkbox',
										id : 'fullscreen',
										label : editor.lang.link.popupFullScreen
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type : 'checkbox',
										id : 'scrollbars',
										label : editor.lang.link.popupScrollBars
									},
									{
										type : 'checkbox',
										id : 'dependent',
										label : editor.lang.link.popupDependent
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type :  'text',
										widths : [ '30%', '70%' ],
										labelLayout : 'horizontal',
										label : editor.lang.link.popupWidth,
										id : 'width'
									},
									{
										type :  'text',
										labelLayout : 'horizontal',
										widths : [ '55%', '45%' ],
										label : editor.lang.link.popupLeft,
										id : 'left'
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type :  'text',
										labelLayout : 'horizontal',
										widths : [ '30%', '70%' ],
										label : editor.lang.link.popupHeight,
										id : 'height'
									},
									{
										type :  'text',
										labelLayout : 'horizontal',
										label : editor.lang.link.popupTop,
										widths : [ '55%', '45%' ],
										id : 'top'
									}
								]
							}
						]
					}
				]
			},
			{
				id : 'upload',
				label : editor.lang.link.upload,
				title : editor.lang.link.upload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.common.upload,
						action : editor.config.link.uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.common.uploadSubmit,
						'for' : [ 'upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.link.advanced,
				title : editor.lang.link.advanced,
				elements :
				[
					{
						type : 'vbox',
						padding : 1,
						children :
						[
							{
								type : 'hbox',
								widths : [ '45%', '35%', '20%' ],
								children :
								[
									{
										type : 'text',
										id : 'advId',
										label : editor.lang.link.id
									},
									{
										type : 'select',
										id : 'advLangDir',
										label : editor.lang.link.langDir,
										'default' : '',
										style : 'width: 100%;',
										items :
										[
											[ editor.lang.link.langDirNotSet, '' ],
											[ editor.lang.link.langDirLTR, 'ltr' ],
											[ editor.lang.link.langDirRTL, 'rtl' ]
										]
									},
									{
										type : 'text',
										id : 'advAccessKey',
										label : editor.lang.link.acccessKey,
										maxLength : 1
									}
								]
							},
							{
								type : 'hbox',
								widths : [ '45%', '35%', '20%' ],
								children :
								[
									{
										type : 'text',
										label : editor.lang.link.name,
										id : 'advName'
									},
									{
										type : 'text',
										label : editor.lang.link.langCode,
										id : 'advLangCode',
										'default' : ''
									},
									{
										type : 'text',
										label : editor.lang.link.tabIndex,
										id : 'advTabIndex',
										maxLength : 5
									}
								]
							}
						]
					},
					{
						type : 'vbox',
						padding : 1,
						children :
						[
							{
								type : 'hbox',
								widths : [ '45%', '55%' ],
								children :
								[
									{
										type : 'text',
										label : editor.lang.link.advisoryTitle,
										'default' : '',
										id : 'advTitle'
									},
									{
										type : 'text',
										label : editor.lang.link.advisoryContentType,
										'default' : '',
										id : 'advContentType'
									}
								]
							},
							{
								type : 'hbox',
								widths : [ '45%', '55%' ],
								children :
								[
									{
										type : 'text',
										label : editor.lang.link.cssClasses,
										'default' : '',
										id : 'advCSSClasses'
									},
									{
										type : 'text',
										label : editor.lang.link.charset,
										'default' : '',
										id : 'advCharset'
									}
								]
							},
							{
								type : 'hbox',
								children :
								[
									{
										type : 'text',
										label : editor.lang.link.styles,
										'default' : '',
										id : 'advStyles'
									}
								]
							}
						]
					}
				]
			}
		],
		onShow : function()
		{
			this.fakeObj = false;
			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();
			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges(),
				me = this;

			// Find out whether we have any anchors in the editor.

			// Get all IMG elements in CK document.
			var elements = editor.document.$.getElementsByTagName( 'img' );
			var anchors = new Array();
			for( var i = 0; i < elements.length; i++ )
			{
				element = elements.item( i );
				if ( element.getAttribute( '_cke_protected_html' ) && element.getAttribute( '_cke_real_element_type' ) == "anchor" )
				{
					var domElement = new CKEDITOR.dom.element( element );
					domElement = editor.fakeobjects.restoreElement( domElement );
					anchors.push( domElement );
				}
			}
			if ( anchors.length < 1 )
			{
				this.getContentElement( 'info', 'selectAnchor' ).getElement().hide();
				this.getContentElement( 'info', 'selectAnchorText' ).getElement().hide();
				this.getContentElement( 'info', 'noAnchors' ).getElement().show();
			}
			else
			{
				this.getContentElement( 'info', 'selectAnchor' ).getElement().show();
				this.getContentElement( 'info', 'selectAnchorText' ).getElement().show();
				this.getContentElement( 'info', 'noAnchors' ).getElement().hide();

				var names = this.getContentElement( 'info', 'anchorName' ).clear(),
					ids = this.getContentElement( 'info', 'anchorId' ).clear();
				names.add( '' );
				ids.add( '' );
				for ( var i = 0 ; i < anchors.length ; i++ )
				{
					if ( anchors[i].getAttribute( 'name' ) )
						names.add( anchors[i].getAttribute( 'name' ) );
					else if ( anchors[i].getAttribute( 'id' ) )
						names.add( anchors[i].getAttribute( 'id' ) );
				}
				names.setValue( '' );
				ids.setValue( '' );
			}

			// Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true ),
					element = rangeRoot.getAscendant( 'a', true );
				if ( element && element.getAttribute( 'href' ) )
				{
					loadLink.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
					this.saveSelection();
				}

				element = rangeRoot.getAscendant( 'img', true );
				if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'anchor' )
				{
					this.fakeObj = element;
					element = editor.fakeobjects.restoreElement( this.fakeObj );
					loadLink.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( this.fakeObj );
					this.saveSelection();
				}
			}

			// Push the current values into the dialog default value stack.
			this.pushDefault();

			// Put focus into the first most likely used input.
			var linkType = this.getValueOf( 'info', 'linkType' );
			if ( linkType == 'url' )
				me.getContentElement( 'info', 'url' ).select();
			else if ( linkType == 'email' )
				me.getContentElement( 'info', 'emailAddress' ).select();
			else
				me.getContentElement( 'info', 'anchorName' ).focus();
		},
		onOk : function()
		{
			var attributes = { href : 'javascript:void(0)/*' + CKEDITOR.tools.getNextNumber() + '*/' },
				linkList, subject, body, me = this, editor = this.getParentEditor();

			// Compose the URL.
			switch ( this.getValueOf( 'info', 'linkType' ) )
			{
				case 'url':
					attributes._cke_saved_href = this.getValueOf( 'info', 'protocol' ) + this.getValueOf( 'info', 'url' );
					break;
				case 'anchor':
					attributes._cke_saved_href = '#' + ( this.getValueOf( 'info', 'anchorName' ) || this.getValueOf( 'info', 'anchorId' ) );
					break;
				case 'email':
					linkList = [ 'mailto:', this.getValueOf( 'info', 'emailAddress' ) ];
					subject = encodeURIComponent( this.getValueOf( 'info', 'emailSubject' ) );
					body = encodeURIComponent( this.getValueOf( 'info', 'emailBody' ) );
					if ( subject || body)
					{
						var argList = [];
						linkList.push( '?' );
						subject && argList.push( 'subject=' + subject );
						body && argList.push( 'body=' + body );
						linkList.push( argList.join( '&' ) );
					}
					attributes._cke_saved_href = linkList.join( '' );
					break;
				default:
			}

			// Popups and target.
			if ( this.getValueOf( 'target', 'linkTargetType' ) == 'popup' )
			{
				var onclickList = [ 'window.open(this.href, \'',
						this.getValueOf( 'target', 'linkTargetName' ), '\', \'' ],
					featureList = [ 'resizable', 'status', 'location', 'toolbar', 'menubar', 'fullscreen',
						'scrollbars', 'dependent' ],
					featureLength = featureList.length,
					addFeature = function( featureName )
					{
						if ( me.getValueOf( 'target', featureName ) != '' )
							featureList.push( featureName + '=' + me.getValueOf( 'target', featureName ) );
					};

				for ( var i = 0 ; i < featureLength ; i++ )
					featureList[i] = featureList[i] + ( this.getValueOf( 'target', featureList[i] ) ? '=yes' : '=no' );
				addFeature( 'width' );
				addFeature( 'left' );
				addFeature( 'height' );
				addFeature( 'top' );

				onclickList.push( featureList.join( ',' ), '\'); return false;' );
				attributes._cke_saved_onclick = onclickList.join( '' );
			}
			else
			{
				if ( this.getValueOf( 'target', 'linkTargetType' ) != 'notSet' )
					attributes.target = this.getValueOf( 'target', 'linkTargetName' );
			}

			// Advanced attributes.
			var advAttr = function( inputName, attrName )
			{
				var value = me.getValueOf( 'advanced', inputName );
				if ( value != '' )
					attributes[attrName] = value;
			};
			advAttr( 'advLangDir', 'dir' );
			advAttr( 'advAccessKey', 'accessKey' );
			advAttr( 'advName', 'name' );
			advAttr( 'advLangCode', 'lang' );
			advAttr( 'advTabIndex', 'tabindex' );
			advAttr( 'advTitle', 'title' );
			advAttr( 'advContentType', 'type' );
			advAttr( 'advCSSClasses', 'class' );
			advAttr( 'advCharset', 'charset' );
			advAttr( 'advStyles', 'style' );

			if ( !this._.selectedElement )
			{
				// IE BUG: Selection must be in the editor for getSelection() to work.
				this.restoreSelection();
				this.clearSavedSelection();

				// Create element if current selection is collapsed.
				var selection = editor.getSelection(),
					ranges = selection.getRanges();
				if ( ranges.length == 1 && ranges[0].collapsed )
				{
					ranges[0].insertNode( new CKEDITOR.dom.text( attributes._cke_saved_href, editor.document ) );
					selection.selectRanges( ranges );
				}

				// Apply style.
				var style = new CKEDITOR.style( { element : 'a', attributes : attributes } );
				style.type = CKEDITOR.STYLE_INLINE;		// need to override... dunno why.
				style.apply( editor.document );

				// Id. Apply only to the first link.
				if ( this.getValueOf( 'advanced', 'advId' ) != '' )
				{
					var links = this.getParentEditor().document.$.getElementsByTagName( 'a' );
					for ( var i = 0 ; i < links.length ; i++ )
					{
						if ( links[i].href == attributes.href )
						{
							links[i].id = this.getValueOf( 'advanced', 'advId' );
							break;
						}
					}
				}
			}
			else
			{
				// We're only editing an existing link, so just overwrite the attributes.
				this._.selectedElement.setAttributes( attributes );
				if ( this.fakeObj )
					editor.fakeobjects.updateFakeElement( this.fakeObj, this._.selectedElement );

				delete this._.selectedElement;
			}
		},
		onLoad : function()
		{
			if ( editor.config.link.uploadTab == false )
				this.hidePage( 'upload' );		//Hide Upload tab.

			if ( editor.config.link.browseServer == false )
				this.getContentElement( 'info', 'browse' ).getElement().hide();
		},
		onHide : function()
		{
			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		}
	};
} );
