﻿/* @Packager.Header
<FileDescription>
	Controls the [Enter] keystroke behavior in a document.
</FileDescription>
<Author name="Frederico Caldeira Knabben" email="www.fckeditor.net" />
*/

/*
 *	Constructor.
 *		@targetDocument : the target document.
 *		@enterMode : the behavior for the <Enter> keystroke.
 *			May be "p", "div", "br". Default is "p".
 *		@shiftEnterMode : the behavior for the <Shift>+<Enter> keystroke. 
 *			May be "p", "div", "br". Defaults to "br".
 */
var FCKEnterKey = function( targetWindow, enterMode, shiftEnterMode )
{
	this.Window			= targetWindow ;
	this.EnterMode		= enterMode || 'p' ;
	this.ShiftEnterMode	= shiftEnterMode || 'br' ;

	// Setup the Keystroke Handler.
	var oKeystrokeHandler = new FCKKeystrokeHandler( false ) ;
	oKeystrokeHandler._EnterKey = this ;
	oKeystrokeHandler.OnKeystroke = FCKEnterKey_OnKeystroke ;
	
	oKeystrokeHandler.SetKeystrokes( [
		[ 13		, 'Enter' ],
		[ SHIFT + 13, 'ShiftEnter' ], 
		[ 8			, 'Backspace' ],
		[ 46		, 'Delete' ]
	] ) ;

	oKeystrokeHandler.AttachToElement( targetWindow.document ) ;
}

FCKEnterKey.prototype.TypeName = 'FCKEnterKey' ;		// @Packager.RemoveLine

function FCKEnterKey_OnKeystroke(  keyCombination, keystrokeValue )
{
	var oEnterKey = this._EnterKey ;
	
	/* @Packager.RemoveLine
	try
	{
	@Packager.RemoveLine */
		switch ( keystrokeValue )
		{
			case 'Enter' :
				return oEnterKey.DoEnter() ;
				break ;

			case 'ShiftEnter' :
				return oEnterKey.DoShiftEnter() ;
				break ;

			case 'Backspace' :
				return oEnterKey.DoBackspace() ;
				break ;

			case 'Delete' :
				return oEnterKey.DoDelete() ;
		}
	/* @Packager.RemoveLine
	}
	catch (e)
	{
		// If for any reason we are not able to handle it, go 
		// ahead with the browser default behavior.
	}
	@Packager.RemoveLine */
	
	return false ;
}

/*
 * Executes the <Enter> key behavior.
 */
FCKEnterKey.prototype.DoEnter = function( mode, hasShift )
{
	this._HasShift = ( hasShift === true ) ;
	
	var sMode = mode || this.EnterMode ;

	if ( sMode == 'br' )
		return this._ExecuteEnterBr() ;
	else
		return this._ExecuteEnterBlock( sMode ) ;
}

/*
 * Executes the <Shift>+<Enter> key behavior.
 */
FCKEnterKey.prototype.DoShiftEnter = function()
{
	return this.DoEnter( this.ShiftEnterMode, true ) ;
}

/*
 * Executes the <Backspace> key behavior.
 */
FCKEnterKey.prototype.DoBackspace = function()
{
	var bCustom = false ;

	// Get the current selection.
	var oRange = new FCKDomRange( this.Window ) ;
	oRange.MoveToSelection() ;

	// The selection boundaries must be in the same "block limit" element
	if ( oRange.StartBlockLimit == oRange.EndBlockLimit && oRange.StartBlock && oRange.EndBlock )
	{
		if ( oRange.StartBlock != oRange.EndBlock )
		{
			this.DoEnter() ;
			oRange.MoveToSelection() ;
		}
		
		if ( oRange.CheckStartOfBlock() )
		{
			var oCurrentBlock = oRange.StartBlock ;
			
			var ePrevious = FCKDomTools.GetPreviousSourceElement( oCurrentBlock, true, [ oRange.StartBlockLimit.nodeName ], ['UL','OL'] ) ;

			bCustom = this._ExecuteBackspace( oRange, ePrevious, oCurrentBlock ) ;
		}	
	}

	oRange.Release() ;
	return bCustom ;
}

FCKEnterKey.prototype._ExecuteBackspace = function( range, previous, currentBlock )
{
	var bCustom = false ;

	// We could be in a nested LI.
	if ( !previous && currentBlock.nodeName.IEquals( 'LI' ) && currentBlock.parentNode.parentNode.nodeName.IEquals( 'LI' ) )
	{
		previous = currentBlock.parentNode.parentNode ;
		currentBlock = FCKListHandler.OutdentListItem( currentBlock ) ;
	}

	if ( previous.nodeName.IEquals( 'LI' ) )
	{
		var oNestedList = FCKDomTools.GetLastChild( previous, ['UL','OL'] ) ;
		
		while ( oNestedList )
		{
			previous = FCKDomTools.GetLastChild( oNestedList, 'LI' ) ;
			oNestedList = FCKDomTools.GetLastChild( previous, ['UL','OL'] ) ;
		}
	}

	if ( previous && currentBlock )
	{
		// If we are in a LI, and the previous block is not an LI, we must 
		if ( currentBlock.nodeName.IEquals( 'LI' ) && !previous.nodeName.IEquals( 'LI' ) )
			currentBlock = FCKListHandler.OutdentListItem( currentBlock ) ;

		// Take a reference to the parent for post processing cleanup.
		var oCurrentParent = currentBlock.parentNode ;

		if ( previous.nodeName.toUpperCase() == 'TABLE' ) 
		{
			FCKDomTools.RemoveNode( previous ) ;
			bCustom = true ;
		}
		else
		{
			// Remove the current block.
			FCKDomTools.RemoveNode( currentBlock ) ;
			
			// Remove any empty tag left by the block removal.
			while ( oCurrentParent.innerHTML.Trim().length == 0 )
			{
				var oParent = oCurrentParent.parentNode ;
				oParent.removeChild( oCurrentParent ) ;
				oCurrentParent = oParent ;
			}
			
			// Cleanup the previous and the current elements.
			FCKDomTools.TrimNode( currentBlock ) ;
			FCKDomTools.TrimNode( previous ) ;
			
			// Append a space to the previous.
			// Maybe it is not always desirable...
			// previous.appendChild( this.Window.document.createTextNode( ' ' ) ) ;
			
			// Set the range to the end of the previous element and bookmark it.
			range.SetStart( previous, 2 ) ;
			range.Collapse( true ) ;
			var oBookmark = range.CreateBookmark() ;

			// Move the contents of the block to the previous element and delete it.
			FCKDomTools.MoveChildren( currentBlock, previous ) ;

			// Place the selection at the bookmark.
			range.MoveToBookmark( oBookmark ) ;
			range.Select() ;

			bCustom = true ;
		}
	}
	
	return bCustom ;
}

/*
 * Executes the <Delete> key behavior.
 */
FCKEnterKey.prototype.DoDelete = function()
{
	// The <Delete> has the same effect as the <Backspace>, so we have the same
	// results if we just move to the next block and apply the same <Backspace> logic.

	var bCustom = false ;

	// Get the current selection.
	var oRange = new FCKDomRange( this.Window ) ;
	oRange.MoveToSelection() ;

	// The selection boundaries must be in the same "block limit" element
	if ( oRange.StartBlockLimit == oRange.EndBlockLimit && oRange.StartBlock && oRange.EndBlock )
	{
		if ( oRange.StartBlock != oRange.EndBlock )
		{
			this.DoEnter() ;
			oRange.MoveToSelection() ;
		}
		
		if ( oRange.CheckEndOfBlock() )
		{
			var oCurrentBlock = oRange.StartBlock ;
			
			var eNext = FCKDomTools.GetNextSourceElement( oCurrentBlock, true, [ oRange.StartBlockLimit.nodeName ], ['UL','OL'] ) ;
			
			bCustom = this._ExecuteBackspace( oRange, oCurrentBlock, eNext ) ;
		}	
	}

	oRange.Release() ;
	return bCustom ;
}

FCKEnterKey.prototype._ExecuteEnterBlock = function( blockTag )
{
	// Get the current selection.
	var oRange = new FCKDomRange( this.Window ) ;
	oRange.MoveToSelection() ;
	
	// The selection boundaries must be in the same "block limit" element.
	if ( oRange.StartBlockLimit == oRange.EndBlockLimit )
	{
		// If the StartBlock or EndBlock are not available (for text without a
		// block tag), we must fix them, by moving the text to a block.
		if ( !oRange.StartBlock )
			this._FixBlock( oRange, true, blockTag ) ;

		if ( !oRange.EndBlock )
			this._FixBlock( oRange, false, blockTag ) ;

		// If the selection boundaries are in the same block element
		if ( oRange.StartBlock == oRange.EndBlock )
		{
			// Delete the current selection.
			oRange.DeleteContents() ;
			
			// Get the new selection (it is collapsed at this point).
			oRange.MoveToSelection() ;
			
			var eNewBlock ;
			var bCleanupBlock = false ;

			// Get the current block.
			var eStartBlock = oRange.StartBlock ;
			
			var bIsStartOfBlock	= oRange.CheckStartOfBlock() ;
			var bIsEndOfBlock	= oRange.CheckEndOfBlock() ;

			if ( bIsStartOfBlock && !bIsEndOfBlock )
			{
				eNewBlock = eStartBlock.cloneNode(false) ;

				if ( FCKBrowserInfo.IsIE )
				{
					// To make the block visible, we must fill it with a &nbsp; select it, and delete it.
					eNewBlock.innerHTML = '&nbsp;' ;
					bCleanupBlock = true ;
				}
				else if ( FCKBrowserInfo.IsGeckoLike )
					eNewBlock.innerHTML = GECKO_BOGUS ;
				
				// Place the new block before the current block element.
				eStartBlock.parentNode.insertBefore( eNewBlock, eStartBlock ) ;

				// This is tricky, but to make the new block visible correctly,
				// we must place a &nbsp; inside it and then delete it using a selection.
				if ( FCKBrowserInfo.IsIE )
				{
					// Move the selection to the new block.
					oRange.MoveToElementStart( eNewBlock ) ;
					
					oRange.Expand( 'block_contents' ) ;

					oRange.Select() ;				
					oRange.DeleteContents() ;

					// Move the selection to the new block.
					oRange.MoveToElementStart( eStartBlock ) ;
					oRange.Select() ;				
				}
			}
			else
			{
				// Check if the selection is at the end of the block.
				if ( bIsEndOfBlock )
				{
					var sStartBlockTag = eStartBlock.tagName.toUpperCase() ;

					// If the entire block is selected, and we are in a LI, let's decrease its indentation.
					if ( bIsStartOfBlock && sStartBlockTag == 'LI' )
					{
						var eOutdented = FCKListHandler.OutdentListItem( eStartBlock ) ;
						oRange.MoveToElementStart( eOutdented ) ;
					}
					else
					{
						// If is a header tag, create a new block element.
						if ( (/^H[1-6]$/).test( sStartBlockTag ) )
							eNewBlock = this.Window.document.createElement( blockTag ) ;
						// Otherwise, duplicate the current block.
						else
							eNewBlock = eStartBlock.cloneNode(false) ;
						
						if ( FCKBrowserInfo.IsIE )
						{
							// To make the block visible, we must fill it with a &nbsp; select it, and delete it.
							eNewBlock.innerHTML = '&nbsp;' ;
							bCleanupBlock = true ;
						}
						else if ( FCKBrowserInfo.IsGeckoLike )
						{
							eNewBlock.innerHTML = GECKO_BOGUS ;

							// If the entire block is selected, let's add a bogus in the start block.
							if ( bIsStartOfBlock )
								eStartBlock.innerHTML = GECKO_BOGUS ;
						}
					}
				}
				else
				{
					// Extract the contents of the block from the selection point to the end of its contents.
					oRange.SetEnd( eStartBlock, 2 ) ;
					var eDocFrag = oRange.ExtractContents() ;
					
					// Duplicate the block element after it.
					eNewBlock = eStartBlock.cloneNode(false) ;

					// It could be that we are in a LI with a child UL/OL. Insert a bogus to give us space to type.
					FCKDomTools.TrimNode( eDocFrag.RootNode ) ;
					if ( eDocFrag.RootNode.firstChild.nodeType == 1 && eDocFrag.RootNode.firstChild.tagName.toUpperCase().Equals( 'UL', 'OL' ) )
						eNewBlock.innerHTML = GECKO_BOGUS ;
					
					// Place the extracted contents in the duplicated block.
					eDocFrag.AppendTo( eNewBlock ) ;					
				}

				if ( eNewBlock )
				{
					// Place the new block after the current block element.
					if ( FCKBrowserInfo.IsIE )
					{
						// You gona think I'm crazy, but in IE we have to do
						// this way to make it work properly with LI in some cases.
						eStartBlock.parentNode.insertBefore( eNewBlock, eStartBlock ) ;		
						eNewBlock.swapNode( eStartBlock	) ;	
					}
					else
						FCKDomTools.InsertAfterNode( eStartBlock, eNewBlock ) ;

					// Move the selection to the new block.
					oRange.MoveToElementStart( eNewBlock ) ;
					
					if ( FCKBrowserInfo.IsGecko )
						eNewBlock.scrollIntoView( false ) ;
					
					if ( bCleanupBlock )
						oRange.Expand( 'block_contents' ) ;
				}

				oRange.Select() ;
				
				if ( bCleanupBlock ) 
					oRange.DeleteContents() ;
			}
		}
		else
		{
			// We must divide the current range in three ranges. One for the start block part, other for the end block part, and another for the in between selection.
		
			// Create a clone of the current range for the start block and move the clone end boundary to the end of the start block.
			var oStartRange = oRange.Clone() ;
			oStartRange.SetEnd( oRange.StartBlock, 2 ) ;
			
			// Create a clone of the current range for the end block and move the clone start boundary to the start of the second block.
			var oEndRange = oRange.Clone() ;
			oEndRange.SetStart( oRange.EndBlock, 1 ) ;

			// Move the start of the current range right after the start block.
			oRange.SetStart( oRange.StartBlock, 4 ) ;
			
			// Move the end of the current range right before the end block.
			oRange.SetEnd( oRange.EndBlock, 3 ) ;
			
			// Delete the contents of the three ranges.
			if ( oStartRange.CheckStartOfBlock() )
				FCKDomTools.RemoveNode( oStartRange.StartBlock ) ;
			else
				oStartRange.DeleteContents() ;
			oRange.DeleteContents() ;
			oEndRange.DeleteContents() ;
			
			if ( FCKBrowserInfo.IsGeckoLike && oEndRange.StartBlock.tagName.IEquals( 'LI' ) && !FCKListHandler.CheckListHasContents( oEndRange.StartBlock ) )
				oEndRange.StartBlock.insertBefore( FCKTools.CreateBogusBR( this.Window.document ), oEndRange.StartBlock.firstChild ) ;
			
			// Move the selection to the end block.
			oEndRange.Select() ;
			
			// Release the resources for the Start and End ranges.
			oStartRange.Release() ;
			oEndRange.Release() ;
		}
	}
	
	// Release the resources used by the range.
	oRange.Release() ;
	
	return true ;
}

FCKEnterKey.prototype._ExecuteEnterBr = function( blockTag )
{
	// Get the current selection.
	var oRange = new FCKDomRange( this.Window ) ;
	oRange.MoveToSelection() ;

	// The selection boundaries must be in the same "block limit" element.
	if ( oRange.StartBlockLimit == oRange.EndBlockLimit )
	{
		oRange.DeleteContents() ;
		
		// Get the new selection (it is collapsed at this point).
		oRange.MoveToSelection() ;
	
		var bIsStartOfBlock	= oRange.CheckStartOfBlock() ;
		var bIsEndOfBlock	= oRange.CheckEndOfBlock() ;
		
		var sStartBlockTag = oRange.StartBlock ? oRange.StartBlock.tagName.toUpperCase() : '' ;
		
		if ( !this._HasShift && sStartBlockTag == 'LI' )
			return this._ExecuteEnterBlock( null ) ;

		// If we are at the end of a header block.
		if ( bIsEndOfBlock && (/^H[1-6]$/).test( sStartBlockTag ) )
		{
			// Insert a bogus BR after the current paragraph.
			FCKDomTools.InsertAfterNode( oRange.StartBlock, FCKTools.CreateBogusBR( this.Window.document ) ) ;

			// The space is required by Gecko only to make the cursor blink.
			FCKDomTools.InsertAfterNode( oRange.StartBlock, this.Window.document.createTextNode( '' ) ) ;

			// IE and Gecko have different behaviors regarding the position.
			oRange.SetStart( oRange.StartBlock.nextSibling, FCKBrowserInfo.IsIE ? 3 : 1 ) ;
		}
		else
		{
			// Note that DomRange.InsertNode() will always add at the start boundary.
			
			// This is the textnode where the cursor will be positioned at.
			oRange.InsertNode( this.Window.document.createTextNode( '' ) ) ;

			var eBr = this.Window.document.createElement( 'br' ) ;
			oRange.InsertNode( eBr ) ;

			if ( bIsEndOfBlock && !FCKBrowserInfo.IsIE )
			{
				var eLastBr = FCKDomTools.GetLastChild( eBr.parentNode, 'BR' ) ;

				if ( eLastBr && eLastBr == eBr )
					FCKDomTools.InsertAfterNode( eBr.nextSibling, FCKTools.CreateBogusBR( this.Window.document ) ) ;
			}

			if ( FCKBrowserInfo.IsIE )
			{
				oRange.SetStart( eBr, 4 ) ;
				oRange.Collapse( true ) ;
			}
			else
				oRange.SetStart( eBr.nextSibling, 1 ) ;
		}
		
		oRange.Select() ;
	}

	// Release the resources used by the range.
	oRange.Release() ;
	
	return true ;
}

// Transform a block without a block tag in a valid block (orphan text in the body or td, usually).
FCKEnterKey.prototype._FixBlock = function( range, isStartBlock, blockTag )
{
	var oBookmark = range.CreateBookmark() ;

	// Create a range clone to the ending boundary.
	var oTempRange = range.Clone() ;
	oTempRange.Collapse( isStartBlock ) ;

	// Expands it to the block contents.
	oTempRange.Expand( 'block_contents' ) ;

	var oFixedBlock = this.Window.document.createElement( blockTag ) ;
	
	// In IE, the range boundary cannot be positioned between tags, so we must use markers.
	if ( FCKBrowserInfo.IsIE )
	{
		var eStartMarker	= oTempRange.InsertMarkerTag( true ) ;
		var eEndMarker		= oTempRange.InsertMarkerTag( false ) ;
		
		eStartMarker.parentNode.insertBefore( oFixedBlock, eStartMarker ) ;

		oTempRange.ExtractContents().AppendTo( oFixedBlock ) ;
		FCKDomTools.TrimNode( oFixedBlock ) ;
	}

	oTempRange.ExtractContents().AppendTo( oFixedBlock ) ;
	FCKDomTools.TrimNode( oFixedBlock ) ;

	if ( !FCKBrowserInfo.IsIE )
		oTempRange.InsertNode( oFixedBlock ) ;
	
	range.MoveToBookmark( oBookmark ) ;

	// A bookmark may leave the range boundary between nodes, which causes
	// problems. The following trick will fix it.
	range.Select() ;
	range.MoveToSelection() ;
}