/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importPackage( org.mozilla.javascript );
importClass( java.lang.System );
importClass( java.io.File );

/*
 * Check if we're running the compiled version of this script. If yes, the
 * langtool class should be available.
 */
var isCompiled = true;
var command = "java -cp js.jar org.mozilla.javascript.tools.shell.Main langtool.js";

try
{
	java.lang.Class.forName( "langtool" );
}
catch ( e )
{
	isCompiled = false;
}

if ( isCompiled )
{
	var quit = function()
	{
		System.exit( 0 );
	};

	loadClass( "cklangtool" );
	loadClass( "io" );

	var resource = JavaAdapter( org.mozilla.javascript.Parser )["class"].getResource( "/org/mozilla/javascript" ).toString();
	if ( resource.indexOf( ".exe" ) )
		command = "langtool.exe";
	else
		command = "java -jar langtool.jar";
}
else
{
	load( "includes/cklangtool.js" );
	load( "includes/io.js" );
}

if ( !arguments[0] )
	error( 'Usage: ' + command + ' [lang_dir]' );

CKLANGTOOL.languageDir = new File( arguments[0] );
CKLANGTOOL.templateFile = new File( arguments[0], 'en.js' );

if ( !CKLANGTOOL.templateFile.exists() )
{
	error( 'ERROR: The english language file "en.js" was not found (' + CKLANGTOOL.templateFile.getAbsolutePath() + ')' );
}

function error( msg )
{
	print( msg );
	print( '' );
	quit();
}

( function()
{
	try
	{
		var translator = new CKLANGTOOL.translator();
		translator.run();
	}
	catch ( e )
	{
		print( "" );
		error( e );
	}
} )();
