/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

var CKPACKAGER =
{
	isCompiled : false,
	path : "",
	verbose : 0,

	getPackPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.packDir, relativePath );
		return file.getAbsolutePath();
	},

	getOutputPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.outputDir, relativePath );
		return file.getAbsolutePath();
	},

	getPackagerPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.dir, relativePath );
		return file.getAbsolutePath();
	},

	_loadedCode : {},

	load : function( className )
	{
		if ( this._loadedCode[className] )
			return;

		if ( CKPACKAGER.isCompiled )
		{
			loadClass( className );
		}
		else
		{
			load( CKPACKAGER.path + '_source/' + className.replace( /^ckpackager\./, '' ).replace( '.', "/" ) + '.js' );
		}

		this._loadedCode[className] = true;
	},

	tools :
	{
		readFile : function( filePath )
		{
			var file = new File( filePath );
			if ( !file.exists() )
				error( '\nFile does not exist: ' + file.getCanonicalPath() );

			var data = readFile( filePath, "UTF-8" );

			// Remove the UTF-8 BOM.
			return data.replace( /^\xEF\xBB\xBF/, '' );
		},

		getFileName : function( file )
		{
			file = new File( file );
			return file.getName();
		}
	}
};
