/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKRELEASER.loadCode( 'tools/json/json2.js' );

CKRELEASER.docsProcessor = function()
{
};

( function()
{
	CKRELEASER.docsProcessor.prototype = {
		createDocumentation : function( sourceDir, targetDir )
		{
			var confLocation = new File( sourceDir, CKRELEASER.release.documentation.config );
			var targetLocation = new File( targetDir, CKRELEASER.release.documentation.target );

			if ( !confLocation.exists() )
				throw "Missing configuration file (" + confLocation.getAbsolutePath() + ")";

			var jsdocLocation = new File( 'tools/jsdoc' );
			var jsdocPath = jsdocLocation.getAbsolutePath();

			var o = {
				output :""
			};

			var configurationCode = 'var configuration = ' + CKRELEASER.io.readFile( confLocation.getAbsolutePath() ) + '\n;';
			var cx = Context.enter(), scope = cx.initStandardObjects();
			cx.evaluateString( scope, configurationCode, confLocation.getName(), 1, null );

			var confDir = confLocation.getParent();

			var f;

			f = new File( confDir.replace( "\\", "/" ), scope.configuration.t );
			scope.configuration.t = new String( f.getAbsolutePath() );
			f = new File( confDir.replace( "\\", "/" ), scope.configuration.d );
			scope.configuration.d = new String( f.getAbsolutePath() );

			for ( var i = 0 ; i < scope.configuration._.length ; i++ )
			{
				f = new File( confDir.replace( "\\", "/" ), scope.configuration._[i] );
				scope.configuration._[i] = new String( f.getAbsolutePath() );
			}

			var tempFile = File.createTempFile( "ckreleaser_jsdoc", ".conf" );
			CKRELEASER.io.saveFile( tempFile, JSON.stringify( scope.configuration ) );

			runCommand( "java", "-jar", jsdocPath + "/jsrun.jar", jsdocPath + "/app/run.js", "-c=" + tempFile.getAbsolutePath(), "-d="
					+ targetLocation.getAbsolutePath(), o );

			if ( CKRELEASER.verbose )
				print( o.output );
		}
	};
})();
