/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importPackage( org.mozilla.javascript );
importClass( java.io.File );
importClass( java.lang.System );

var isCompiled = true;
var command = "java -cp [...] org.mozilla.javascript.tools.shell.Main ckreleaser.js";
var resource = JavaAdapter( org.mozilla.javascript.Parser )["class"].getResource( "/org/mozilla/javascript" ).toString();

try
{
	java.lang.Class.forName( "ckreleaser.ckreleaser" );
}
catch ( e )
{
	isCompiled = false;
}

if ( isCompiled )
{
	var quit = function()
	{
		System.exit( 0 );
	};

	loadClass( "ckreleaser.includes.ckreleaser" );

	if ( resource.indexOf( ".exe" ) != -1 )
		command = "ckreleaser.exe";
	else
		command = "java -jar ckreleaser.jar";
}
else
{
	var releaserPath = resource.replaceFirst( "^jar:", '' ).replaceFirst( "\/js\.jar\!\/org\/mozilla\/javascript$", '' )
			.replaceAll( "_dev.{1}_thirdparty.{1}rhino", "" );

	load( releaserPath + "_source/includes/ckreleaser.js" );
}

CKRELEASER.isCompiled = isCompiled;
CKRELEASER.path = releaserPath;
CKRELEASER.load( "ckreleaser.includes.releaser" );

function error( msg )
{
	print( msg );
	print( '' );
	quit();
}

if ( arguments.length > 1 && ( arguments[arguments.length - 1] == '-v' || arguments[arguments.length - 1] == '--verbose' ) )
	CKRELEASER.verbose = 1;

if ( arguments[0] == '-test' && !isCompiled )
{
	CKRELEASER.load( 'test.test' );
	quit();
}

CKRELEASER.releaseFile = arguments[0];
CKRELEASER.sourceDir = arguments[1];
CKRELEASER.targetDir = arguments[2];
CKRELEASER.version = arguments[3];
CKRELEASER.zipName = arguments[4];
CKRELEASER.targzName = arguments[5];

if ( !CKRELEASER.releaseFile || !CKRELEASER.sourceDir || !CKRELEASER.targetDir || !CKRELEASER.version || !CKRELEASER.zipName
		|| !CKRELEASER.targzName )
{
	error( '\nUsage: ' + command + ' release_file source_dir target_dir version zip_name targz_name [-v]' +
			'\n' +
			'\n release_file    Path to CKReleaser configuration file.' +
			'\n source_dir      Path to the directory with code of application to be released.' +
			'\n target_dir      Path to the directory, where application will be build.' +
			'\n                 If directory already exists, CKReleaser will not start.' +
			'\n version         The version string used to replace the %VERSION% directive.' +
			'\n zip_name        Name of the .zip file to create.' +
			'\n targz_name      Name of the .tar.gz file to create.' +
			'\n\n -v | --verbose  Enable verbose output.' +
			'\n                 Display detailed exception information when an error occurs.');
}

CKRELEASER.releaseDir = CKRELEASER.targetDir + "/" + "release";
CKRELEASER.load( 'ckpackager.includes.ckpackager' );
CKPACKAGER.isCompiled = isCompiled;
CKPACKAGER.packDir = CKRELEASER.releaseDir;
CKPACKAGER.path = 'tools/CKPackager/';
CKPACKAGER.outputDir = CKRELEASER.releaseDir;
CKPACKAGER.load( 'ckpackager.includes.packager' );

( function()
{
	try
	{
		var releaser = new CKRELEASER.releaser();
		releaser.loadDefinitionFile( CKRELEASER.releaseFile );
		releaser.run();
	}
	catch ( e )
	{
		if ( CKRELEASER.verbose )
		{
			if ( typeof ( e.rhinoException ) != 'undefined' )
			{
				e.rhinoException.printStackTrace();
				quit();
			}
			else if ( typeof ( e.javaException ) != 'undefined' )
			{
				e.javaException.printStackTrace();
				quit();
			}
		}

		print( "" );
		error( e );
	}
} )();
