/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );
importClass( java.io.FileOutputStream );
importClass( java.io.FileInputStream );

CKRELEASER.skinProcessor = function()
{
};

( function()
{
	var importedFiles = {}, copiedFiles = {};

	function processCssFile( sourceLocation, parentLocation )
	{
		var parentPath, path = sourceLocation.getCanonicalPath();
		var lines = CKRELEASER.io.readFile( new File( path ) ).split( /\r\n|\n|\r/ );
		var out = [];
		var isImported = false;

		if ( !parentLocation )
		{
			parentLocation = sourceLocation;
			parentPath = sourceLocation.getCanonicalPath();
		}
		else
		{
			isImported = true;
			parentPath = parentLocation.getCanonicalPath();
			if ( path == parentPath )
				throw "Invalid @import statements, file including itself: " + path;

			if ( importedFiles[parentPath][path] )
				throw "Invalid @import statement in " + parentPath + ", file " + path + " was already imported.";

			importedFiles[parentPath][path] = true;
		}

		for ( var i = 0 ; i < lines.length ; i++ )
		{
			if ( lines[i].indexOf( "@import" ) == -1 )
				out.push( lines[i] );
			else
			{
				var matches = lines[i].match( /^\s*@import\s+url\("(.*?)"\)/ );

				if ( matches[1] )
				{
					var file = new File( sourceLocation.getParent(), matches[1] );
					if ( !file.exists() )
						throw "Importing of CSS file failed, file does not exist (" + file.getPath() + ")";
					else
					{
						if ( !importedFiles[parentPath] )
							importedFiles[parentPath] = {};

						out.push( processCssFile( file, parentLocation ) );
					}
				}
				else
					out.push( lines[i] );
			}
		}

		if ( isImported )
			return CKRELEASER.tools.removeComments( out.join( "\r\n" ) );
		else
			return out.join( "\r\n" );
	}

	function processSkins( sourceLocation, targetLocation )
	{
		if ( !sourceLocation.isDirectory() )
			throw "Skins source is not a directory (" + sourceLocation.getAbsolutePath() + ");";

		if ( !targetLocation.exists() )
			targetLocation.mkdir();

		var children = sourceLocation.list();
		for ( var i = 0 ; i < children.length ; i++ )
		{
			if (children[i] == ".svn" || children[i] == "CVS")
				continue;
			
			importedFiles = {};
			copiedFiles = {};

			if ( false !== processDirectory( new File( sourceLocation, children[i] ), new File( targetLocation, children[i] ) ) )
				print( "    Created skin " + children[i] + "." );

			for ( var parentPath in importedFiles )
			{
				for ( var path in importedFiles[parentPath] )
				{
					if ( !importedFiles[path] )
					{
						if ( CKRELEASER.verbose )
							print( "    CSS file was imported, removing: " + path );
						CKRELEASER.io.deleteFile( copiedFiles[path] );
					}
					else
					{
						if ( CKRELEASER.verbose )
							print( "    CSS file was imported, but is also a root CSS file for another file: " + path );
					}
				}
			}
		}
	}

	function processDirectory( sourceLocation, targetLocation )
	{
		if ( CKRELEASER.release.isIgnoredPath( sourceLocation.getAbsolutePath() ) )
			return;

		if ( sourceLocation.isDirectory() )
		{
			if ( !targetLocation.exists() )
				targetLocation.mkdir();

			var children = sourceLocation.list();
			for ( var i = 0 ; i < children.length ; i++ )
			{
				processDirectory( new File( sourceLocation, children[i] ), new File( targetLocation, children[i] ) );
			}
		}
		else
		{
			if ( sourceLocation.getAbsolutePath().toLowerCase().endsWith( ".css" ) )
			{
				CKRELEASER.io.saveFile( targetLocation, processCssFile( sourceLocation, false ) );
				if ( CKRELEASER.verbose )
					print( "    Created CSS file: " + sourceLocation );
			}
			else
				CKRELEASER.io.copy( sourceLocation, targetLocation );

			copiedFiles[sourceLocation.getCanonicalPath()] = targetLocation;
		}
	}

	CKRELEASER.skinProcessor.prototype.createSkins = function( sourceDir, targetDir )
	{
		var sourceLocation = new File( sourceDir, CKRELEASER.release.skins.source );
		var targetLocation = new File( targetDir, CKRELEASER.release.skins.target );

		processSkins( sourceLocation, targetLocation );
	};

})();
