/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importPackage( java.util.regex );

( function()
{
	CKLANGTOOL.jpformat = function()
	{
	};

	/**
	 * Language code of currently processed file (taken from
	 * CKEDITOR.lang['code']).
	 */
	var languageCode;
	var fileOverviewBlock;

	function printObject( prefix, o )
	{
		var result = [];
		
		for ( var key in o )
		{
			var entry = o[ key ],
				entryName = prefix ? ( prefix + '.' + key ) : key;
			
			if ( typeof entry == 'object' )
				result.push( printObject( entryName, entry ) );
			else
				result.push( entryName + '=' + entry );
		}
		
		return result.join( '\r\n' );
	}
	
	function processFile( file )
	{
		var licenseInfo = "# Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.\r\n# For licensing, see LICENSE.html or http://ckeditor.com/license\r\n\r\n";
		
		fileHeader = getFileOverview( file.getAbsolutePath() ).replace( /\{.*?\}/g, '' ).replace( /@fileOverview/g, '' ).replace(/\s*(\/)?\s*(\*)+(\/)?/g , '').replace(/\s+/g, ' ');
		
		var result = CKLANGTOOL.loadLanguageFile( file );
		
		return licenseInfo + '#' + fileHeader + '\r\n\r\n' + printObject( '', result.translation );
	}

	var regexLib =
	{
		inlineComment :Pattern.compile( "^\\s*\\/\\/" ),
		blockCommentStart :Pattern.compile( "\\/\\*" ),
		blockCommentEnd :Pattern.compile( "\\*\\/" ),
		fileOverview :Pattern.compile( " @fileOverview" ),
	};
	
	/**
	 * Returns an array with missing keys (already marked as //MISSING).
	 */
	function getFileOverview( file )
	{
		fileOverviewBlock = '/**\n* @fileOverview \n*/';

		var inBlockComment = false;
		var blockComment = [];
		var matcher, line;
		var lines = CKLANGTOOL.io.readFileIntoArray( file );

		for ( var j = 0 ; j < lines.length ; j++ )
		{
			line = lines[ j ];
			if ( !inBlockComment )
			{
				matcher = regexLib.inlineComment.matcher( line );
				if ( matcher.find() )
					continue;

				matcher = regexLib.blockCommentStart.matcher( line );
				if ( matcher.find() )
				{
					inBlockComment = true;
					blockComment.push( line );
					continue;
				}
			}
			else
			{
				blockComment.push( line );

				matcher = regexLib.blockCommentEnd.matcher( line );
				if ( matcher.find() )
				{
					inBlockComment = false;

					matcher = regexLib.fileOverview.matcher( blockComment.join( "" ) );
					if ( matcher.find() )
						fileOverviewBlock = blockComment.join( "\n" );
					blockComment = [];
				}
			}
		}

		return fileOverviewBlock;
	}
	
	CKLANGTOOL.jpformat.prototype =
	{
		run : function()
		{
			var children = CKLANGTOOL.languageDir.list();
			var errors, file, status = [];
			var foundFiles = false;
			var fileHeader = "";

			for ( var i = 0 ; i < children.length ; i++ )
			{
				if ( CKLANGTOOL.io.getExtension( children[ i ] ) != "js" )
					continue;

				file = new File( CKLANGTOOL.languageDir, children[ i ] );
				if ( file.isFile() )
				{
					print( "Processing " + file.getAbsolutePath() );
					
					CKLANGTOOL.io.saveFile( new File( CKLANGTOOL.destinationDir, children[i].replaceAll( '.js', '.txt' ) ), processFile(file), false );
					
					foundFiles = true;
				}
			}

			if ( !foundFiles )
			{
				print( "WARNING: language files not found." );
			}

			print( "Process completed." );
		}
	};
})();
