/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2004-2009 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.localization;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

/**
 * An interface which provides the ability to resolve the current user locale
 * independently from any framework or direct implementation.
 * 
 * @version $Id: LocaleResolver.java 3523 2009-05-21 14:58:06Z mosipov $
 * 
 */
public interface LocaleResolver {

	/**
	 * Returns the locale of a given request.
	 * 
	 * @param request
	 *            the current request instance
	 * @return the locale of the request, <code>null</code> if the locale
	 *         couldn't be resolved
	 */
	public Locale resolveLocale(final HttpServletRequest request);

}
