/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.plugins.add( 'uicolor',
{
	requires : [ 'dialog' ],

	init : function( editor )
	{
		editor.addCommand( 'uicolor', new CKEDITOR.dialogCommand( 'uicolor' ) );
		editor.ui.addButton( 'UIColor',
			{
				label : editor.lang.uicolor.title,
				command : 'uicolor'
			});
		CKEDITOR.dialog.add( 'uicolor', this.path + 'dialogs/uicolor.js' );

		var i,
			scripts =
			[
				'yahoo-dom-event.js',
				'animation-min.js',
				'dragdrop-min.js',
				'slider-min.js',
				'element-min.js',
				'colorpicker-min.js'
			];
		for (i in scripts)
		{
			scripts[ i ] = CKEDITOR.getUrl(
				'_source/' + // %REMOVE_LINE%
				'plugins/uicolor/yui/' + scripts[ i ]
			);
		}

		// Honor dependency order.
		CKEDITOR.scriptLoader.load( scripts.slice( 0, 1 ), function()
		{
			CKEDITOR.scriptLoader.load( scripts.slice( 1 ) );
		});

		var styleSheets =
		[
			'slider.css',
			'fonts-min.css',
			'colorpicker.css'
		];
		for (i in styleSheets)
		{
			editor.element.getDocument().appendStyleSheet( CKEDITOR.getUrl(
					'_source/' + // %REMOVE_LINE%
					'plugins/uicolor/yui/assets/' + styleSheets[ i ]
			));
		}
	}
} );
