/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

( function()
{
	var translator = new CKLANGTOOL.translator();
	var jpformat = new CKLANGTOOL.jpformat();

	// Run tests.
	var passCount = 0, failCount = 0;

	
	function deleteDirectory( path )
	{
		var dir = new File( path );

		if ( dir.isDirectory() )
		{
			var children = dir.list();
			for ( var i = 0 ; i < children.length ; i++ )
			{
				if ( !deleteDirectory( new File( dir, children[i] ) ) )
				{
					return false;
				}
			}
		}

		return dir["delete"]();
	}
	
	function copyFile( sourceFile, targetFile )
	{
		try
		{
			var inStream = new FileInputStream( sourceFile );
			var outStream = new FileOutputStream( targetFile );

			var len, buf = new Packages.java.lang.reflect.Array.newInstance( java.lang.Byte.TYPE, 1024 );

			while ( ( len = inStream.read( buf ) ) != -1 )
			{
				outStream.write( buf, 0, len );
			}
			inStream.close();
			outStream.close();
		}
		catch ( e )
		{
			throw "Cannot copy file:\n Source: " + sourceFile.getCanonicalPath() + "\n Destination : "
					+ targetFile.getCanonicalPath() + "\n" + e.message;
		}
	}	
	
	function assertEquals( expected, actual, title )
	{
		if ( expected != actual )
		{
			var error = {
				expected :expected,
				actual :actual
			};

			print( 'FAILED: ' + (title ? title : "") );

			if ( !error.expected )
				throw error;

			print( '  Expected: ' + error.expected );
			print( '  Actual  : ' + error.actual );

			failCount++;
		}
		else
			passCount++;
	}

	function error( msg )
	{
		print( msg );
		quit();
	}

	function prepareTempDirs()
	{
		var tempDir = new File( 'tmp' );

		if ( tempDir.exists() && !deleteDirectory( 'tmp' ) )
			error( "Can't delete temp directory" );

		if ( !tempDir.mkdir() )
			error( "Can't create temp directory: " + tempDir );

		var tests = [ 'jpformat', 'jpformat/out', 'translator' ];

		for ( var i = 0 ; i < tests.length ; i++ )
		{
			tempDir = new File( 'tmp/' + tests[i] );
			if ( !tempDir.mkdir() )
				error( "Can't create temp directory: " + tempDir );
		}
	}
	
	function testTranslator()
	{
		CKLANGTOOL.languageDir = new File( 'tmp/translator' );
		CKLANGTOOL.templateFile = new File( 'tmp/translator', 'en.js' );
		
		var name = 'translator';
		var dir = new File( '_assets/translator' );
		var dirList = dir.list();
		
		for ( var i = 0 ; i < dirList.length ; i++ )
			if ( dirList[i] != '.svn' )
				copyFile( new File( dir, dirList[i] ), new File( CKLANGTOOL.languageDir, dirList[i] ) );

		translator.run();

		dirList = CKLANGTOOL.languageDir.list();
		for ( var i = 0 ; i < dirList.length ; i++ )
		{
			if ( dirList[i].indexOf( ".correct." ) == -1 || dirList[i] == '.svn' )
				continue;
			
			var f = new File( CKLANGTOOL.languageDir, dirList[i] );

			testName = dirList[i].replace( ".correct.txt", "" );

			tempFile = new File( 'tmp/' + name + '/' + testName );
			correctFile = new File( 'tmp/' + name + '/' + testName + '.correct.txt' );
			
			assertEquals( CKLANGTOOL.io.readFile( correctFile ), CKLANGTOOL.io.readFile( tempFile ));
		}
	}
	
	function testJpformat()
	{
		CKLANGTOOL.languageDir = new File( 'tmp/jpformat' );
		CKLANGTOOL.destinationDir = new File( 'tmp/jpformat/out' );
		CKLANGTOOL.templateFile = new File( 'tmp/jpformat', 'en.js' );
		
		var name = 'jpformat';
		var dir = new File( '_assets/jpformat' );
		var dirList = dir.list();
		
		for ( var i = 0 ; i < dirList.length ; i++ )
		{
			if ( dirList[i] != '.svn' )
				copyFile( new File( dir, dirList[i] ), new File( CKLANGTOOL.languageDir, dirList[i] ) );
		}

		jpformat.run();

		dirList = CKLANGTOOL.languageDir.list();
		for ( var i = 0 ; i < dirList.length ; i++ )
		{
			if ( dirList[i].indexOf( ".correct." ) == -1 || dirList[i] == '.svn' )
				continue;
			
			var f = new File( CKLANGTOOL.languageDir, dirList[i] );

			testName = dirList[i].replace( ".correct.txt", "" );

			tempFile = new File( 'tmp/jpformat/out/' + testName );
			correctFile = new File( 'tmp/jpformat/' + testName + '.correct.txt' );
			
			assertEquals( CKLANGTOOL.io.readFile( correctFile ), CKLANGTOOL.io.readFile( tempFile ));
		}
	}

	prepareTempDirs();
	testTranslator();
	testJpformat();

	print( '' );
	print( 'Finished: ' + passCount + ' passed / ' + failCount + ' failed' );

})();