// Shortcuts

var CKTester =
{
	runner :
	{
		registeredCells : [],
		cellVariables : {},
		criterias : [],
/*
		currentCell : // The solved current running cell.
		{
			path : '../editor/tt/unit/htmldataprocessor',
			tags : [ 'editor', 'tt', 'unit', 'htmldataprocessor' ],
			environments : [ 'runners/yuitest/yuitest.js',
							 '${EDITORPATH}/ckeditor.js',
							 'extensions/yuitest/extension.js'
						   ]
		},
*/
		currentTime : 0,
		totalTime : 0,
		totalFailed : 0,
		totalPassed : 0,
		testFrame : null,

		init : function()
		{
			this.testFrame = $( 'testFrame' );
			this.processProfile();
			this.initUI();
		},

		bootstrap : function()
		{
			// Receive 'profile' and 'criteria' from URL parts.
			var url = window.location.search,
				pattern = '=(.*?)(?:&|$)',
				match,
				profile = ( match = url.match( new RegExp( 'profile' + pattern ) ) ) && match[ 1 ],
				criterias = ( match = url.match( new RegExp( 'cells' + pattern ) ) ) && match[ 1 ].split( ',' );

			profile && document.write( '<script src="' + profile + '" type="text/javascript"><\/script>' );
			criterias && ( this.criterias = criterias );
			window.onload = function()
			{
				this.init();
				// Auto start only if there's criteria found.
				if ( this.criterias.length )
					this.rullAll();
			}.bind( this );
		},

		initUI : function()
		{
			// Build criteria auto-complete.
			var tagsDataSource = new YAHOO.util.LocalDataSource( this.registeredTags );
			var startButton = $( 'start-test-btn' ),
				tagsInput = $( 'tagsInput' ),
				tagsAutoComp = new YAHOO.widget.AutoComplete( tagsInput,"tagsContainer", tagsDataSource ),
				start = function()
				{
					this.criterias = tagsInput.value.split( ' ' ).without( '' );
					this.rullAll();
				}.bind( this );

			tagsAutoComp.delimChar = ' ';
			tagsAutoComp.typeAhead = true;
			tagsAutoComp.useShadow = true;
			startButton.observe( 'click', start );
		},
		
		processProfile : function ()
		{
			var profile = this.getProfile(),
				cells = profile.cells,
				resolvers = profile.cellResolvers,
				tags = [];

			// Receive path variables first, cell resolving may need them.  
			this.variables = profile.variables;
			// Merge resolvers in profile.
			this.cellResolvers = this.cellResolvers.concat( resolvers );

			// Sort the resolvers by function names alphabetically,
			// which indicate priority, anonymous ones get 'g'.
			this.cellResolvers = this.cellResolvers.sortBy( function( func )
			{
				var match;
				return func.name
					   || ( match = func.toString().match( /function ([^\s]+)\(/ ) ) && match[ 1 ]
					   || 'l';
			} );

			for ( var i = 0 ; i < cells.length ; i++ )
			{
				var cell = cells[ i ],
					cell =
					{
						path : cell [ 0 ],
						tags : cell[ 1 ] || [],
						environment : cell[ 2 ] || []
					};

				for ( var j = 0 ; j < this.cellResolvers.length ; j++ )
					this.cellResolvers[ j ].call( this, cell );

				tags = tags.concat( cell.tags );
				this.registeredCells.push( cell );
			}

			// Cache the unique tags, 
			// TODO: Count tag frequency.
			this.registeredTags = tags.uniq();
		},

		rullAll : function()
		{
			this.reset();
			if ( !this.registeredCells.length )
			{
				throw 'None test cell existed in the profile!';
				return;
			}

			var criterias = this.criterias;
			this.pendingCells = this.registeredCells.findAll( function( cell ){

				return ( criterias.indexOf( cell.path ) != -1
						 || cell.tags.detect( function( tag )
							{
								return criterias.indexOf( tag ) != -1;
							} ) );
			} );
			this.runCell();
		},

		runCell : function()
		{
			this.currentCell = this.pendingCells.shift();
			this.currentCell && this.testFrame.setAttribute( 'src', this.currentCell.path );
		},

		runSingleCell : function( cell )
		{
			this.currentCell = cell;
			// Open the test frame in a new popup window.
			window.open( cell.path );
		},

		cellStart : function( cell )
		{
			var div = $( 'testLogger' ).appendChild( document.createElement( 'div' ) );
			div.className = 'testEntry';
			div.innerHTML = 'Testing "<a href="javascript:void(0)" target="_blank">' + cell.name + '</a>"...';

			this.currentTime = new Date();

			if ( !this.totalTime )
				this.totalTime = this.currentTime;
		},

		cellComplete : function( cell )
		{
			var finishTime = new Date(),
				results = cell.data.results;

			var failed = results.failed;
			var passed = results.passed;

			var html = '<span class="testIgnore">Unknown</span>';

			if ( failed > 0 )
				html = '<span class="testFail">FAIL</span>';
			else
				html = '<span class="testPass">PASS</span>';

			html += ' Test "<a href="javascript:void(0)">' + cell.name + '</a>" (' + failed + ' failed / ' + passed + ' passed) - ' + ( finishTime - this.currentTime ) + 'ms';

			var div = $('testLogger').lastChild;
			div.innerHTML = html;
			$( div ).childElements().grep( new Selector( 'a' ) )[ 0 ]
					.observe( 'click', this.runSingleCell.curry( cell ).bind( this ) );

			this.totalFailed += failed;
			this.totalPassed += passed;

			$('testFailed').innerHTML = this.totalFailed;
			$('testPassed').innerHTML = this.totalPassed;
			$('totalTime').innerHTML = finishTime - this.totalTime;

			document.title = this.totalFailed + ' failed / ' + this.totalPassed + ' passed - CKEditor Core Tests Runner';

			this.runCell();
		},

		reset : function()
		{
			this.pendingCells = [];
			this.currentCell = null;
			this.currentTime = 0 ;
			this.totalTime = 0 ;
			this.totalPassed = 0 ;
			this.totalFailed = 0;
			$( 'testLogger' ).innerHTML = '';
		},

		replaceVars : function( str )
		{
			for( var i in this.variables )
				str = str.replace( new RegExp( "\\$({|%7B)" + i + "(}|%7D)", 'g' ), this.variables[ i ] ) ;
			return str ;
		},

		getAbsolutePath : function( win, path )
		{
			var temp = new ( win || window ).Image();
			temp.src = path;
			return temp.src;
		},

		// Defined default tag resolvers.
		cellResolvers : [

			// Build tags out of path.
			function a( cell )
			{
				var path = cell.path, tags = cell.tags;
				path.replace( /([^.\/]+)[\/\\]+/g, function( match, tag )
				{
					if ( tags && tags.indexOf( tag ) == -1 )
						tags.push( tag );
				} );
			},

			// Default environment injections.
			function b( cell )
			{
				var tags = cell.tags, env = [];
				if( tags.indexOf( 'unit' ) != -1 )
					env = env.concat( [ 'runners/yuitest/yuitest.js',
								  'runners/yuitest/yuitest.css',
								  'runners/yuitest/extension.js' ] );
				if ( tags.indexOf( 'selenium' ) != -1 )
					env = env.concat( [ 'runners/selenium/selenium.js',
										'runners/selenium/extensions.js' ] );
				cell.environment = env.concat( cell.environment );
			},

			// Figure out absolute paths of cell and it's environment.
			// Note: Execute this resolver at last.
			function z( cell )
			{
				cell.path = this.getAbsolutePath( null, cell.path + '.html' );
				for ( var i = 0 ; i < cell.environment.length ; i++ )
				{
					cell.environment[ i ] = this.getAbsolutePath( null, this.replaceVars( cell.environment[ i ] ) );
				}
			}
		]
	}

};

CKTester.runner.bootstrap();
