CKTester.runner.getProfile = function ()
{
	// Note : All paths specified below should refer to CKTester project root if they are relative.
	return {
		cells : [
			[ '../editor/core/ajax', [  'unit', 'stable' ] ],
			[ '../editor/core/bootstrap', [  'unit', 'stable', 'editor-ondemand' ] ],
			[ '../editor/core/ckeditor', [  'unit', 'stable' ] ],
			[ '../editor/core/editor', [  'unit', 'stable' ] ],
			[ '../editor/core/env', [  'unit', 'stable' ] ],
			[ '../editor/core/event', [  'unit', 'stable' ] ],
			[ '../editor/core/plugins', [  'unit', 'stable' ] ],
			[ '../editor/core/scriptloader', [  'unit', 'stable' ] ],
			[ '../editor/core/tools', [  'unit', 'stable' ] ],
			[ '../editor/core/xml', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/document', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/documentfragment', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/element', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/node', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/range', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/text', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/walker', [  'unit', 'stable' ] ],
			[ '../editor/core/dom/window', [  'unit', 'stable' ] ],
			[ '../editor/core/htmlparser/fragment', [  'unit', 'stable' ] ],
			[ '../editor/core/htmlparser/htmlparser', [  'unit', 'stable' ] ],
			[ '../editor/plugins/domiterator/domiterator', [  'unit', 'stable' ] ],
			[ '../editor/plugins/htmldataprocessor/htmldataprocessor', [  'unit', 'stable' ] ],
			[ '../editor/plugins/link/link', [  'unit', 'stable' ] ],
			[ '../editor/plugins/list/list', [  'unit', 'stable' ] ],
			[ '../editor/plugins/styles/styles', [  'unit', 'stable' ] ],
			[ '../editor/plugins/selection/selection', [  'unit', 'stable' ] ],
 			[ '../editor/tt/4048/4048', [  'unit', 'all', 'kama' ] ]
		],

		variables : 
		{
			'CKEDITOR_ROOT' : '../../ckeditor'
		},

		cellResolvers :
		[
			function( cell )
			{
				var tags = cell.tags, env = cell.environment;

				// Inject CKEditor source.
				if( ( tags.indexOf( 'editor' ) != -1 )
					&& ( tags.indexOf( 'editor-ondemand' ) == -1  ) )
					env.push( '${CKEDITOR_ROOT}/ckeditor_source.js' );
				else if ( tags.indexOf( 'editor-ondemand' ) )
					env.push( '${CKEDITOR_ROOT}/ckeditor_basic_source.js' );

				// Inject CKEditor unit test library.
				if ( tags.indexOf( 'unit' ) != -1  )
					env.push( '${CKEDITOR_ROOT}/_source/core/test.js' );
			}
		]
	};
};
