/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

( function()
{

	function redirectToFort()
	{
		var tags, metas = document.getElementsByTagName( 'meta' );
		for( var i = 0 ; i < metas.length ; i++ )
		{
			if ( metas[ i ].name == 'tags' )
				tags = metas[ i ].content;
		}
		
		var scripts = document.getElementsByTagName( 'script' ), src, newUrl;
		for( var i = 0 ; i < scripts.length ; i++ )
		{
			if ( ( src = scripts [ i ].src )
				&& ( ( newUrl = src.match(/(.*)\bcell\.js/)[ 1 ] ) != -1 ) )
			{
				newUrl = newUrl + 'fort.html?'
					+ '&cells=' + document.location.href
					+ '&tags=' + tags || "";
			}
		}

		document.location.href = newUrl;
	}

	var runnerWindow = opener || ( parent != self ) && parent;

	// Redirect to fort for this single cell, if the test page is opened directly.
	if ( !runnerWindow )
	{
		redirectToFort();
		return;
	}

	var mode = ( runnerWindow == opener ) ? 'standalone' : 'managed',
		runner = runnerWindow.CKTESTER.fort,
		cell = runner.currentCell,
		dependencies = cell && cell.environment;

	if ( cell )
	{
		function writeScript( url )
		{
			document.write( '<script type="text/javascript" src="' + url + '"></script>' ) ;
		}

		function writeStyleSheet( url )
		{
			document.write( '<link href="' + url + '" rel="stylesheet" type="text/css" />' ) ;
		}

		// Cell doesn't require too much APIs right now.
		window.CKTESTER =
		{
			cell :
			{
				getAbsolutePath : runnerWindow.Function.prototype.curry.call(
						 runnerWindow.CKTESTER.fort.getAbsolutePath, window ),

				start : mode == 'managed' ?
					function( data )
					{
						runner.cellStart( runnerWindow.$H( cell ).merge( { name : document.title, data : data } ).toObject() );
					}
					 :
					runnerWindow.Prototype.emptyFunction,

				complete : mode == 'managed' ?
					function( data )
					{
						runner.cellComplete( runnerWindow.$H( cell ).merge( { name : document.title, data : data } ).toObject() );
					}
					 :
					runnerWindow.Prototype.emptyFunction
			}
		};

		for ( var i = 0 ; i < dependencies.length ; i++ )
		{
			var path = dependencies[ i ];
			( path.match( /\.js$/ )? writeScript : writeStyleSheet ) ( path );
		}
	}

} )();
