var FCKDragTableHandler = 
{
	"_DragState" : 0,
	"_LeftCell" : null,
	"_RightCell" : null,
	"_OldCursor" : null,
	"_MouseMoveMode" : 0,	// 0 - find candidate cells for resizing, 1 - drag to resize
	"_ResizeBar" : null,
	"_GetWindowScrollX" : function( w )
	{
		var scrollX = 0;
		if ( w.document.documentElement && w.document.documentElement.scrollLeft ) 
			scrollX = w.document.documentElement.scrollLeft ;
		else if ( w.document.body && w.document.body.scrollLeft )
			scrollX = w.document.body.scrollLeft ;
		else if ( w.scrollX )
			scrollX = w.scrollX ;
		return scrollX ;
	},
	"_GetWindowScrollY" : function( w )
	{
		var scrollY = 0;
		if ( w.document.documentElement && w.document.documentElement.scrollTop )
			scrollY = w.document.documentElement.scrollTop;
		else if ( w.document.body && w.document.body.scrollTop )
			scrollY = w.document.body.scrollTop;
		else if ( w.scrollY )
			scrollY = w.scrollY;
		return scrollY;
	},
	"_GetDocumentPosition" : function( w, node )
	{
		var x = 0 ;
		var y = 0 ;
		var curNode = node ;
		while ( curNode && curNode != w.document.body )
		{
			x += curNode.offsetLeft - curNode.scrollLeft ;
			y += curNode.offsetTop - curNode.scrollTop ;
			curNode = curNode.offsetParent ;
		}
		return { "x" : x, "y" : y } ;
	},
	"_GetWindowPosition" : function( w, node )
	{
		var pos = FCKDragTableHandler._GetDocumentPosition( w, node ) ;
		pos.x -= FCKDragTableHandler._GetWindowScrollX( w ) ;
		pos.y -= FCKDragTableHandler._GetWindowScrollY( w ) ;
		return pos ;
	},
	"_IsInsideNode" : function( w, domNode, pos )
	{
		var myCoords = FCKDragTableHandler._GetWindowPosition( w, domNode ) ; 
		var xMin = myCoords.x ;
		var yMin = myCoords.y ;
		var xMax = parseInt( xMin ) + parseInt( domNode.offsetWidth ) ;
		var yMax = parseInt( yMin ) + parseInt( domNode.offsetHeight ) ;
		if ( pos.x >= xMin && pos.x <= xMax && pos.y >= yMin && pos.y <= yMax )
			return true;
		return false;
	},
	"_GetBorderCells" : function( w, tableNode, evt )
	{
		// Enumerate all the cells in the table.
		var cells = [] ;
		for ( var i = 0 ; i < tableNode.rows.length ; i++ )
		{
			var r = tableNode.rows[i] ;
			for ( var j = 0 ; j < r.cells.length ; j++ )
				cells.push( r.cells[j] ) ;
		}

		if ( cells.length < 1 )
			return null ;

		// Get the cells whose right or left border is nearest to the mouse cursor's x coordinate.
		var minRxDist = null ;
		var minLxDist = null ;
		var minYDist = null ;
		var rbCell = null ;
		var lbCell = null ;
		for ( var i = 0 ; i < cells.length ; i++ )
		{
			var pos = FCKDragTableHandler._GetWindowPosition( w, cells[i] ) ;
			var rightX = pos.x + parseInt( cells[i].offsetWidth ) ;
			var rxDist = evt.clientX - rightX ;
			var yDist = evt.clientY - ( pos.y + ( cells[i].offsetHeight /2 ) ) ;
			if ( minRxDist == null || 
					( Math.abs( rxDist ) <= Math.abs( minRxDist ) &&
					  ( minYDist == null || Math.abs( yDist ) < Math.abs( minYDist ) ) ) )
			{
				minRxDist = rxDist ;
				minYDist = yDist ;
				rbCell = cells[i] ;
			}
		}
		minYDist = null ;
		var rowNode = FCKTools.GetElementAscensor( rbCell, "tr" ) ;
		var cellIndex = rbCell.cellIndex + 1 ;
		if ( cellIndex >= rowNode.cells.length )
			return null ;
		lbCell = rowNode.cells.item( cellIndex ) ;

		// Abort if too far from the border.
		if ( minLxDist < 0 && minRxDist < 0 && minLxDist < -3 )
			return null ; 
		if ( minLxDist > 0 && minRxDist > 0 && minRxDist > 3 )
			return null ;

		return { "leftCell" : lbCell, "rightCell" : rbCell } ;
	},
	"MouseDownListener" : function( FCK, evt )
	{
		if ( FCKDragTableHandler._LeftCell )
		{
			FCKDragTableHandler._MouseMoveMode = 1 ;
			FCKDragTableHandler._CreateResizeBar( FCK.EditorWindow, 
					FCKTools.GetElementAscensor( FCKDragTableHandler._LeftCell, "table" ),
					evt ) ;
		}
	},
	"MouseUpListener" : function( FCK, evt )
	{
		FCKDragTableHandler._MouseMoveMode = 0 ;
	},
	"MouseMoveListener" : function( FCK, evt )
	{
		if ( FCKDragTableHandler._MouseMoveMode == 0 )
			return FCKDragTableHandler._MouseFindHandler( FCK, evt ) ;
		else
			return FCKDragTableHandler._MouseDragHandler( FCK, evt ) ;
	},
	// Calculate the padding of a table cell.
	// It returns the value of paddingLeft + paddingRight of a table cell.
	// This function is used, in part, to calculate the width parameter that should be used for setting cell widths.
	// The equation in question is clientWidth = paddingLeft + paddingRight + width.
	// So that width = clientWidth - paddingLeft - paddingRight.
	// The return value of this function must be pixel accurate acorss all supported browsers, so be careful if you need to modify it.
	"_GetCellPadding" : function( table, cell )
	{
		var attrGuess = parseInt( table.cellPadding ) * 2 ;
		var cssGuess = null ;
		if ( typeof( window.getComputedStyle ) == "function" )
		{
			var styleObj = window.getComputedStyle( cell, null ) ;
			cssGuess = parseInt( styleObj.getPropertyValue( "padding-left" ) ) + 
				parseInt( styleObj.getPropertyValue( "padding-right" ) ) ;
		}
		else
			cssGuess = parseInt( cell.currentStyle.paddingLeft ) + parseInt (cell.currentStyle.paddingRight ) ;

		var cssRuntime = cell.style.padding ;
		if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
			cssGuess = parseInt( cssRuntime ) * 2 ;
		else
		{
			cssRuntime = cell.style.paddingLeft ;
			if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
				cssGuess = parseInt( cssRuntime ) ;
			cssRuntime = cell.style.paddingRight ;
			if ( parseInt( cssRuntime ) == parseInt( cssRuntime ) )
				cssGuess += parseInt( cssRuntime ) ;
		}

		attrGuess = parseInt( attrGuess ) ;
		cssGuess = parseInt( cssGuess ) ;
		if ( attrGuess != attrGuess )
			attrGuess = 0 ;
		if ( cssGuess != cssGuess )
			cssGuess = 0 ;
		return Math.max( attrGuess, cssGuess ) ;
	},
	// Calculate the real width of the table cell.
	// The real width of the table cell is the pixel width that you can set to the width attribute of the table cell and after
	// that, the table cell should be of exactly the same width as before.
	// The real width of a table cell can be calculated as:
	// width = clientWidth - paddingLeft - paddingRight.
	"_GetCellWidth" : function( table, cell )
	{
		var clientWidth = parseInt( cell.clientWidth ) ;
		if ( clientWidth != clientWidth )		// NaN possible? lets just be safe...
			clientWidth = 0 ;
		return clientWidth - FCKDragTableHandler._GetCellPadding( table, cell ) ;
	},
	"_MouseFindHandler" : function( FCK, evt )
	{
		var node = evt.srcElement || evt.originalTarget ;
		try
		{
			if ( ! node || node.nodeType != 1 )
			{
				FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
				FCK.EditorDocument._OldCursor = null ;
				return ;
			}
		}
		catch ( e )
		{
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
			return ;
		}
		var tagName = node.tagName.toLowerCase() ;
		if ( tagName != "table" && tagName != "td" && tagName != "th" )
		{
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
			return ;
		}
		node = FCKTools.GetElementAscensor( node, "table" ) ;
		var cellTuple = FCKDragTableHandler._GetBorderCells( FCK.EditorWindow, node, evt ) ;

		if ( cellTuple == null )
		{
			if ( FCKDragTableHandler._LeftCell )
				FCKDragTableHandler._LeftCell = FCKDragTableHandler._RightCell = null ;
			FCK.EditorDocument.body.style.cursor = FCK.EditorDocument._OldCursor ;
			FCK.EditorDocument._OldCursor = null ;
		}
		else
		{
			FCKDragTableHandler._OldCursor = FCK.EditorDocument.body.style.cursor ;
			FCK.EditorDocument.body.style.cursor = "e-resize" ;
			FCKDragTableHandler._LeftCell = cellTuple["leftCell"] ;
			FCKDragTableHandler._RightCell = cellTuple["rightCell"] ;
		}
	},
	"_MouseDragHandler" : function( FCK, evt )
	{
	},
	"_CreateResizeBar" : function( w, table, evt )
	{
		if ( FCKDragTableHandler._ResizeBar == null )
		{
			FCKDragTableHandler._ResizeBar = w.document.createElement( "div" ) ;
			var rb = FCKDragTableHandler._ResizeBar ;
			rb.style.position = "absolute" ;
			rb.style.backgroundColor = "blue" ;
			w.document.body.appendChild( rb ) ;
		}

		var rb = FCKDragTableHandler._ResizeBar ;
		rb.style.display = "" ;
		rb.style.top = FCKDragTableHandler._GetDocumentPosition( w, table ).y + "px" ;
		rb.style.left = evt.clientX + FCKDragTableHandler._GetWindowScrollX( w ) + "px" ;
		rb.style.height = table.offsetHeight + "px" ;
		var bw = parseInt( table.border ) ;
		if ( bw != bw )
			bw = 0 ;
		var cs = parseInt( table.cellSpacing ) ;
		if ( cs != cs )
			cs = 0 ;
		var barWidth = Math.max( bw, cs, 2 ) ;
		rb.style.width = barWidth + "px" ;
	}
};

FCK.Events.AttachEvent( "OnMouseDown", FCKDragTableHandler.MouseDownListener ) ;
FCK.Events.AttachEvent( "OnMouseUp", FCKDragTableHandler.MouseUpListener ) ;
FCK.Events.AttachEvent( "OnMouseMove", FCKDragTableHandler.MouseMoveListener ) ;
