<?php
/** Arabic (العربية)
  *
  * @addtogroup Language
  */

$linkPrefixExtension = true;
$fallback8bitEncoding = 'windows-1256';

$rtl = true;
$defaultUserOptionOverrides = array(
	# Swap sidebar to right side by default
	'quickbar' => 2,
	# Underlines seriously harm legibility. Force off:
	'underline' => 0,
);
/**
 * A list of date format preference keys which can be selected in user 
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are 
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on 
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'mdy',
	'dmy',
	'ymd',
	'ISO 8601',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value 
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy 
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy or mdy';

/**
 * Associative array mapping old numeric date formats, which may still be 
 * stored in user preferences, to the new string formats.
 */
$datePreferenceMigrationMap = array(
	'default',
	'mdy',
	'dmy',
	'ymd'
);

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in 
 * Language.php, search for sprintfDate. 
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j، Y', # Arabic comma
	'mdy both' => 'H:i، xg j، Y', # Arabic comma

	'dmy time' => 'H:i',
	'dmy date' => 'j xg Y',
	'dmy both' => 'H:i، j xg Y', # Arabic comma

	'ymd time' => 'H:i',
	'ymd date' => 'Y xg j',
	'ymd both' => 'H:i، Y xg j', # Arabic comma

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

$namespaceNames = array(
	NS_MEDIA            => 'ملف',
	NS_SPECIAL          => 'خاص',
	NS_MAIN             => '',
	NS_TALK             => 'نقاش',
	NS_USER             => 'مستخدم',
	NS_USER_TALK        => 'نقاش_المستخدم',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK     => 'نقاش' . '_$1',
	NS_IMAGE            => 'صورة',
	NS_IMAGE_TALK       => 'نقاش_الصورة',
	NS_MEDIAWIKI        => 'ميدياويكي',
	NS_MEDIAWIKI_TALK   => 'نقاش_ميدياويكي',
	NS_TEMPLATE         => 'قالب',
	NS_TEMPLATE_TALK    => 'نقاش_قالب',
	NS_HELP             => 'مساعدة',
	NS_HELP_TALK        => 'نقاش_المساعدة',
	NS_CATEGORY         => 'تصنيف',
	NS_CATEGORY_TALK    => 'نقاش_التصنيف'
);

$magicWords = array(
	'redirect'            => array( 0, "#تحويل", "#REDIRECT" ),
	'notoc'               => array( 0, "__لافهرس__", "__NOTOC__" ),
	'nogallery'           => array( 0, "__لامعرض__", "__NOGALLERY__" ),
	'forcetoc'            => array( 0, "__لصق_فهرس__", "__FORCETOC__" ),
	'toc'                 => array( 0, "__فهرس__", "__TOC__" ),
	'noeditsection'       => array( 0, "__لاتحريرقسم__", "__NOEDITSECTION__" ),
	'start'               => array( 0, "__ابدأ__", "__START__" ),
	'currentmonth'        => array( 1, "شهر", "شهر_حالي", "CURRENTMONTH" ),
	'currentmonthname'    => array( 1, "اسم_شهر", "اسم_شهر_حالي", "CURRENTMONTHNAME" ),
	'currentday'          => array( 1, "يوم", "CURRENTDAY" ),
	'currentday2'         => array( 1, "يوم2", "CURRENTDAY2" ),
	'currentdayname'      => array( 1, "اسم_يوم", "CURRENTDAYNAME" ),
	'currentyear'         => array( 1, "عام", "CURRENTYEAR" ),
	'currenttime'         => array( 1, "وقت", "CURRENTTIME" ),
	'currenthour'         => array( 1, "ساعة", "CURRENTHOUR" ),
	'localmonth'          => array( 1, "شهر_محلي", "LOCALMONTH" ),
	'localmonthname'      => array( 1, "اسم_شهر_محلي", "LOCALMONTHNAME" ),
	'localmonthabbrev'    => array( 1, "اختصار_شهر_محلي", "LOCALMONTHABBREV" ),
	'localday'            => array( 1, "يوم_محلي", "LOCALDAY" ),
	'localday2'           => array( 1, "يوم_محلي2", "LOCALDAY2" ),
	'localdayname'        => array( 1, "اسم_يوم_محلي", "LOCALDAYNAME" ),
	'localyear'           => array( 1, "عام_محلي", "LOCALYEAR" ),
	'localtime'           => array( 1, "وقت_محلي", "LOCALTIME" ),
	'localhour'           => array( 1, "ساعة_محلية", "LOCALHOUR" ),
	'numberofpages'       => array( 1, "عددالصفحات", "عدد_الصفحات", "NUMBEROFPAGES" ),
	'numberofarticles'    => array( 1, "عددالمقالات", "عدد_المقالات", "NUMBEROFARTICLES" ),
	'numberoffiles'       => array( 1, "عددالملفات", "عدد_الملفات", "NUMBEROFFILES" ),
	'numberofusers'       => array( 1, "عددالمستخدمين", "عدد_المستخدمين", "NUMBEROFUSERS" ),
	'numberofedits'       => array( 1, "عددالتعديلات", "عدد_التعديلات", "NUMBEROFEDITS" ),
	'pagename'            => array( 1, "اسم_صفحة", "اسم_الصفحة", "PAGENAME" ),
	'pagenamee'           => array( 1, "عنوان_صفحة", "عنوان_الصفحة", "PAGENAMEE" ),
	'namespace'           => array( 1, "نطاق", "NAMESPACE" ),
	'namespacee'          => array( 1, "عنوان_نطاق", "NAMESPACEE" ),
	'talkspace'           => array( 1, "نطاق_نقاش,نطاق_النقاش", "TALKSPACE" ),
	'talkspacee'          => array( 1, "عنوان_نقاش,عنوان_النقاش", "TALKSPACEE" ),
	'fullpagename'        => array( 1, "اسم_الصفحة_الكامل", "اسم_صفحة_كامل", "FULLPAGENAME" ),
	'fullpagenamee'       => array( 1, "عنوان_الصفحة_الكامل", "عنوان_صفحة_كامل", "FULLPAGENAMEE" ),
	'subpagename'         => array( 1, "اسم_الصفحة_الفرعي", "اسم_صفحة_فرعي", "SUBPAGENAME" ),
	'subpagenamee'        => array( 1, "عنوان_الصفحة_الفرعي", "عنوان_صفحة_فرعي", "SUBPAGENAMEE" ),
	'basepagename'        => array( 1, "اسم_الصفحة_الأساسي", "اسم_صفحة_أساسي", "BASEPAGENAME" ),
	'basepagenamee'       => array( 1, "عنوان_الصفحة_الأساسي", "عنوان_صفحة_أساسي", "BASEPAGENAMEE" ),
	'talkpagename'        => array( 1, "اسم_صفحة_النقاش", "TALKPAGENAME" ),
	'talkpagenamee'       => array( 1, "عنوان_صفحة_النقاش", "TALKPAGENAMEE" ),
	'msg'                 => array( 0, "رسالة:", "MSG:" ),
	'subst'               => array( 0, "نسخ:", "SUBST:" ),
	'msgnw'               => array( 0, "مصدر:", "مصدر_قالب:", "MSGNW:" ),
	'img_thumbnail'       => array( 1, "تصغير", "thumbnail", "thumb" ),
	'img_manualthumb'     => array( 1, "تصغير=$1", "thumbnail=$1", "thumb=$1" ),
	'img_right'           => array( 1, "يمين", "right" ),
	'img_left'            => array( 1, "يسار", "left" ),
	'img_none'            => array( 1, "بدون,بلا", "none" ),
	'img_width'           => array( 1, "$1بك", "$1px" ),
	'img_center'          => array( 1, "مركز", "center", "centre" ),
	'img_framed'          => array( 1, "إطار", "framed", "enframed", "frame" ),
	'img_frameless'       => array( 1, "لاإطار", "frameless" ),
	'img_page'            => array( 1, "صفحة=$1", "صفحة $1", "page=$1", "page $1" ),
	'img_border'          => array( 1, "حد", "حدود", "border" ),
	'img_top'             => array( 1, "أعلى", "top" ),
	'img_text-top'        => array( 1, "نص_أعلى", "text-top" ),
	'img_middle'          => array( 1, "وسط", "middle" ),
	'img_bottom'          => array( 1, "أسفل", "bottom" ),
	'img_text-bottom'     => array( 1, "نص_أسفل", "text-bottom" ),
	'int'                 => array( 0, "محتوى:", "INT:" ),
	'sitename'            => array( 1, "اسم_الموقع", "اسم_موقع", "SITENAME" ),
	'ns'                  => array( 0, "نط:", "NS:" ),
	'localurl'            => array( 0, "عنوان:", "LOCALURL:" ),
	'server'              => array( 0, "الخادم", "خادم", "SERVER" ),
	'servername'          => array( 0, "اسم_الخادم", "اسم_خادم", "SERVERNAME" ),
	'scriptpath'          => array( 0, "مسار", "SCRIPTPATH" ),
	'notitleconvert'      => array( 0, "لاتحويل_عنوان", "__NOTITLECONVERT__", "__NOTC__" ),
	'nocontentconvert'    => array( 0, "لاتحويل_محتوى", "__NOCONTENTCONVERT__", "__NOCC__" ),
	'currentweek'         => array( 1, "أسبوع", "CURRENTWEEK" ),
	'currentdow'          => array( 1, "رقم_يوم_أسبوع", "CURRENTDOW" ),
	'localweek'           => array( 1, "أسبوع_محلي", "LOCALWEEK" ),
	'localdow'            => array( 1, "يوم_محلي_مأ", "LOCALDOW" ),
	'revisionid'          => array( 1, "نسخة", "REVISIONID" ),
	'revisionday'         => array( 1, "يوم_النسخة", "يوم_نسخة", "REVISIONDAY" ),
	'revisionmonth'       => array( 1, "شهر_النسخة", "شهر_نسخة", "REVISIONMONTH" ),
	'revisionyear'        => array( 1, "سنة_النسخة", "عام_النسخة", "REVISIONYEAR" ),
	'plural'              => array( 0, "جمع:", "PLURAL:" ),
	'fullurl'             => array( 0, "عنوان_كامل:", "FULLURL:" ),
	'newsectionlink'      => array( 1, "__وصلة_قسم_جديد__", "__NEWSECTIONLINK__" ),
	'currentversion'      => array( 1, "نسخة_حالية", "CURRENTVERSION" ),
	'currenttimestamp'    => array( 1, "طابع_الوقت_الحالي", "CURRENTTIMESTAMP" ),
	'localtimestamp'      => array( 1, "طابع_الوقت_المحلي", "LOCALTIMESTAMP" ),
	'language'            => array( 0, "#لغة:", "#LANGUAGE:" ),
	'contentlanguage'     => array( 1, "لغة_المحتوى", "لغة_محتوى", "CONTENTLANGUAGE", "CONTENTLANG" ),
	'pagesinnamespace'    => array( 1, "صفحات_في_نطاق", "PAGESINNAMESPACE:", "PAGESINNS:" ),
	'numberofadmins'      => array( 1, "عددالإداريين", "عدد_الإداريين", "NUMBEROFADMINS" ),
	'special'             => array( 0, "خاص", "special" ),
	'defaultsort'         => array( 1, "ترتيب_قياسي", "ترتيب_افتراضي", "DEFAULTSORT:", "DEFAULTSORTKEY:", "DEFAULTCATEGORYSORT:" ),
);

$skinNames = array(
	'standard'    => "كلاسيك",
	'nostalgia'   => "نوستالجيا",
	'cologneblue' => "كولون بلو",
	'monobook'    => "مونوبوك",
	'myskin'      => "واجهتي",
	'chick'       => "تشيك",
	'simple'      => "سيمبل",
);

$digitTransformTable = array(
	'0' => '٠', # &#x0660;
	'1' => '١', # &#x0661;
	'2' => '٢', # &#x0662;
	'3' => '٣', # &#x0663;
	'4' => '٤', # &#x0664;
	'5' => '٥', # &#x0665;
	'6' => '٦', # &#x0666;
	'7' => '٧', # &#x0667;
	'8' => '٨', # &#x0668;
	'9' => '٩', # &#x0669;
	'.' => '٫', # &#x066b; wrong table ?
	',' => '٬', # &#x066c;
);

$specialPageAliases = array(
	'DoubleRedirects'           => array( "تحويلات_مزدوجة" ),
	'BrokenRedirects'           => array( "تحويلات_مكسورة" ),
	'Disambiguations'           => array( "توضيحات" ),
	'Userlogin'                 => array( "دخول_المستخدم" ),
	'Userlogout'                => array( "خروج_المستخدم" ),
	'Preferences'               => array( "تفضيلات" ),
	'Watchlist'                 => array( "قائمة_المراقبة" ),
	'Recentchanges'             => array( "أحدث_التغييرات" ),
	'Upload'                    => array( "رفع" ),
	'Imagelist'                 => array( "قائمة_الصور" ),
	'Newimages'                 => array( "صور_جديدة" ),
	'Listusers'                 => array( "قائمة_المستخدمين" ),
	'Statistics'                => array( "إحصاءات" ),
	'Randompage'                => array( "عشوائي", "صفحة_عشوائية" ),
	'Lonelypages'               => array( "صفحات_يتيمة" ),
	'Uncategorizedpages'        => array( "صفحات_غير_مصنفة" ),
	'Uncategorizedcategories'   => array( "تصنيفات_غير_مصنفة" ),
	'Uncategorizedimages'       => array( "صور_غير_مصنفة" ),
	'Uncategorizedtemplates'    => array( "قوالب_غير_مصنفة" ),
	'Unusedcategories'          => array( "تصنيفات_غير_مستخدمة" ),
	'Unusedimages'              => array( "صور_غير_مستخدمة" ),
	'Wantedpages'               => array( "صفحات_مطلوبة" ),
	'Wantedcategories'          => array( "تصنيفات_مطلوبة" ),
	'Mostlinked'                => array( "الأكثر_وصلا" ),
	'Mostlinkedcategories'      => array( "أكثر_التصنيفات_وصلا" ),
	'Mostlinkedtemplates'       => array( "أكثر_القوالب_وصلا" ),
	'Mostcategories'            => array( "أكثر_الصفحات_تصنيفا" ),
	'Mostimages'                => array( "أكثر_الصور_وصلا" ),
	'Mostrevisions'             => array( "الأكثر_تعديلا" ),
	'Fewestrevisions'           => array( "الأقل_تعديلا" ),
	'Shortpages'                => array( "صفحات_قصيرة" ),
	'Longpages'                 => array( "صفحات_طويلة" ),
	'Newpages'                  => array( "صفحات_جديدة" ),
	'Ancientpages'              => array( "صفحات_قديمة" ),
	'Deadendpages'              => array( "صفحات_مسدودة" ),
	'Protectedpages'            => array( "صفحات_محمية" ),
	'Allpages'                  => array( "كل_الصفحات" ),
	'Prefixindex'               => array( "فهرس" ),
	'Ipblocklist'               => array( "قائمة_منع_أيبي" ),
	'Specialpages'              => array( "صفحات_خاصة" ),
	'Contributions'             => array( "مساهمات" ),
	'Emailuser'                 => array( "راسل_المستخدم" ),
	'Whatlinkshere'             => array( "ماذا_يصل" ),
	'Recentchangeslinked'       => array( "تغييرات_مرتبطة" ),
	'Movepage'                  => array( "نقل_صفحة" ),
	'Blockme'                   => array( "منعي" ),
	'Booksources'               => array( "مصدر_كتاب" ),
	'Categories'                => array( "تصنيفات" ),
	'Export'                    => array( "تصدير" ),
	'Version'                   => array( "إصدار" ),
	'Allmessages'               => array( "كل_الرسائل" ),
	'Log'                       => array( "سجل" ),
	'Blockip'                   => array( "منع_أيبي" ),
	'Undelete'                  => array( "استرجاع" ),
	'Import'                    => array( "استيراد" ),
	'Lockdb'                    => array( "غلق_قاعدة" ),
	'Unlockdb'                  => array( "فتح_قاعدة" ),
	'Userrights'                => array( "صلاحيات" ),
	'MIMEsearch'                => array( "بحث_MIME" ),
	'Unwatchedpages'            => array( "صفحات_غيرمراقبة" ),
	'Listredirects'             => array( "عرض_التحويلات" ),
	'Revisiondelete'            => array( "حذف_تعديل" ),
	'Unusedtemplates'           => array( "قوالب_غير_مستخدمة" ),
	'Randomredirect'            => array( "تحويلة_عشوائية" ),
	'Mypage'                    => array( "صفحتي" ),
	'Mytalk'                    => array( "نقاشي" ),
	'Mycontributions'           => array( "مساهماتي" ),
	'Listadmins'                => array( "عرض_الإداريين" ),
	'Popularpages'              => array( "صفحات_مشهورة" ),
	'Search'                    => array( "بحث" ),
	'Resetpass'                 => array( "ضبط_كلمة_السر" ),
	'Withoutinterwiki'          => array( "بدون_إنترويكي" ),
);

$messages = array(
# User preference toggles
'tog-underline'               => 'خط تحت الوصلات',
'tog-highlightbroken'         => 'إظهار الوصلات المكسورة <a href="" class="new">بهذا الشكل</a> (البديل بهذا الشكل<a href="" class="internal">؟</a>).',
'tog-justify'                 => 'اجعل عرض الأسطر في الفقرات متساوٍ',
'tog-hideminor'               => 'خبئ التعديلات الطفيفة في أحدث التغييرات',
'tog-extendwatchlist'         => 'مدد قائمة المراقبة لإظهار جميع التغييرات المطبقة',
'tog-usenewrc'                => 'شكل متقدم من صفحة أحدث التغييرات (جافا سكريبت)',
'tog-numberheadings'          => 'رقّم الأقسام تلقائيا',
'tog-showtoolbar'             => 'اعرض شريط التحرير (جافا سكريبت)',
'tog-editondblclick'          => 'عدل الصفحات عند النقر المزدوج على الصفحة (جافا سكريبت)',
'tog-editsection'             => 'مكن تعديل الأقسام عن طريق وصلات [تحرير]',
'tog-editsectiononrightclick' => 'مكّن تحرير الأقسام في عن طريق كبسة الفأرة اليمين<br /> على عناوين الأقسام (يتطلب جافا سكريبت)',
'tog-showtoc'                 => 'عرض فهرس المحتويات (للصفحات التي تحتوي على أكثر من 3 أقسام)',
'tog-rememberpassword'        => 'تذكر بيانات دخولي على هذا الحاسوب',
'tog-editwidth'               => 'صندوق التحرير يأخذ كامل عرض المساحة المتاحة',
'tog-watchcreations'          => 'أضف الصفحات التي أنشئها إلى قائمة مراقبتي',
'tog-watchdefault'            => 'أضف الصفحات التي أحررها إلى قائمة مراقبتي',
'tog-watchmoves'              => 'أضف الصفحات التي أنقلها إلى قائمة مراقبتي',
'tog-watchdeletion'           => 'أضف الصفحات التي أحذفها إلى قائمة مراقبتي',
'tog-minordefault'            => "خيار ''هذا تعديل طفيف'' هو الخيار الافتراضي",
'tog-previewontop'            => 'إظهار العرض المسبق قبل صندوق التحرير',
'tog-previewonfirst'          => 'اعرض الصفحة عند حفظها بعد أول تعديل',
'tog-nocache'                 => 'امنع حفظ نسخة من الصفحة بعد زيارتها',
'tog-enotifwatchlistpages'    => 'أرسل لي رسالة عندما يتم تغيير صفحة أراقبها',
'tog-enotifusertalkpages'     => 'أرسل لي رسالة عندما يتم تغيير صفحة نقاشي',
'tog-enotifminoredits'        => 'أرسل لي رسالة للتعديلات الطفيفة أيضا',
'tog-enotifrevealaddr'        => 'إظهار عنوان بريدي الإلكتروني في رسائل التنويه',
'tog-shownumberswatching'     => 'اعرض عدد المستخدمين المراقبين للصفحة',
'tog-fancysig'                => '<br />فقط توقيع (بدون وصلة أوتوماتيكية)',
'tog-externaleditor'          => 'استخدم محرر نصوص خارجيا تلقائيا',
'tog-externaldiff'            => 'استخدام فروقا خارجية افتراضيا',
'tog-showjumplinks'           => 'فعل وصلات "اذهب إلى".',
'tog-uselivepreview'          => 'استخدم الاستعراض السريع (جافاسكريبت) (تجريبي)',
'tog-forceeditsummary'        => 'نبهني عند إدخال ملخص تحرير فارغ',
'tog-watchlisthideown'        => 'أخف تعديلاتي من قائمة المراقبة',
'tog-watchlisthidebots'       => 'أخف تعديلات البوت من قائمة المراقبة',
'tog-watchlisthideminor'      => 'أخف التعديلات الطفيفة من قائمة المراقبة',
'tog-nolangconversion'        => 'عطّل تحويل المتغيرات',
'tog-ccmeonemails'            => 'أرسل لي نسخا من رسائل البريد الإلكتروني التي أرسلها للمستخدمين الآخرين',
'tog-diffonly'                => 'لا تعرض محتوى الصفحة عند المقارنة بين التعديلات',

'underline-always'  => 'دائما',
'underline-never'   => 'لا',
'underline-default' => 'تبعا لإعدادات المتصفح',

'skinpreview' => '(عرض)',

# Dates
'sunday'        => 'الأحد',
'monday'        => 'الإثنين',
'tuesday'       => 'الثلاثاء',
'wednesday'     => 'الأربعاء',
'thursday'      => 'الخميس',
'friday'        => 'الجمعة',
'saturday'      => 'السبت',
'sun'           => 'أحد',
'mon'           => 'إثنين',
'tue'           => 'ثلاثاء',
'wed'           => 'أربعاء',
'thu'           => 'خميس',
'fri'           => 'جمعة',
'sat'           => 'سبت',
'january'       => 'يناير',
'february'      => 'فبراير',
'march'         => 'مارس',
'april'         => 'أبريل',
'may_long'      => 'مايو',
'june'          => 'يونيو',
'july'          => 'يوليو',
'august'        => 'أغسطس',
'september'     => 'سبتمبر',
'october'       => 'أكتوبر',
'november'      => 'نوفمبر',
'december'      => 'ديسمبر',
'january-gen'   => 'يناير',
'february-gen'  => 'فبراير',
'march-gen'     => 'مارس',
'april-gen'     => 'أبريل',
'may-gen'       => 'مايو',
'june-gen'      => 'يونيو',
'july-gen'      => 'يوليو',
'august-gen'    => 'أغسطس',
'september-gen' => 'سبتمبر',
'october-gen'   => 'أكتوبر',
'november-gen'  => 'نوفمبر',
'december-gen'  => 'ديسمبر',
'jan'           => 'يناير',
'feb'           => 'فبراير',
'mar'           => 'مارس',
'apr'           => 'أبريل',
'may'           => 'مايو',
'jun'           => 'يونيو',
'jul'           => 'يوليو',
'aug'           => 'أغسطس',
'sep'           => 'سبتمبر',
'oct'           => 'أكتوبر',
'nov'           => 'نوفمبر',
'dec'           => 'ديسمبر',

# Bits of text used by many pages
'categories'            => 'تصنيفات',
'pagecategories'        => '{{PLURAL:$1|تصنيف|تصنيفات}}',
'category_header'       => 'المقالات في التصنيف "$1"',
'subcategories'         => 'التصنيفات الفرعية',
'category-media-header' => 'الملفات في التصنيف "$1"',

'mainpagetext'      => "<big>'''تم تشغيل ميدياويكي بنجاح.'''</big>",
'mainpagedocfooter' => 'انظر [http://meta.wikimedia.org/wiki/Help:Contents دليل المستخدم] لمعلومات حول استخدام الويكي.

== البداية ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings قائمة إعدادات الضبط]
* [http://www.mediawiki.org/wiki/Manual:FAQ اسئلة متكررة حول ميدياويكي]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce القائمة البريدية الخاصة بإصدار ميدياويكي]',

'about'          => 'حول',
'article'        => 'مقالة',
'newwindow'      => '(تفتح في نافذة جديدة)',
'cancel'         => 'إلغاء',
'qbfind'         => 'بحث',
'qbbrowse'       => 'تصفح',
'qbedit'         => 'عدل',
'qbpageoptions'  => 'هذه الصفحة',
'qbpageinfo'     => 'سياق النص',
'qbmyoptions'    => 'صفحاتي',
'qbspecialpages' => 'الصفحات الخاصة',
'moredotdotdot'  => 'المزيد...',
'mypage'         => 'صفحتي',
'mytalk'         => 'صفحة نقاشي',
'anontalk'       => 'النقاش لعنوان الأيبي هذا',
'navigation'     => 'إبحار',

# Metadata in edit box
'metadata_help' => 'بيانات ميتا:',

'errorpagetitle'    => 'خطأ',
'returnto'          => 'ارجع إلى $1.',
'tagline'           => 'من {{SITENAME}}',
'help'              => 'مساعدة',
'search'            => 'بحث',
'searchbutton'      => 'بحث',
'go'                => 'اذهب',
'searcharticle'     => 'اذهب',
'history'           => 'تاريخ الصفحة',
'history_short'     => 'تاريخ',
'updatedmarker'     => 'تم تعديل الصفحة بعد زيارتي الأخيرة',
'info_short'        => 'معلومات',
'printableversion'  => 'نسخة للطباعة',
'permalink'         => 'وصلة دائمة',
'print'             => 'طباعة',
'edit'              => 'عدل',
'editthispage'      => 'عدل هذه الصفحة',
'delete'            => 'حذف',
'deletethispage'    => 'احذف هذه الصفحة',
'undelete_short'    => 'استرجاع {{PLURAL:$1|تعديل واحد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'protect'           => 'حماية',
'protect_change'    => 'تغيير مستوى الحماية',
'protectthispage'   => 'احم هذه الصفحة',
'unprotect'         => 'إزالة الحماية',
'unprotectthispage' => 'إزالة حماية هذه الصفحة',
'newpage'           => 'صفحة جديدة',
'talkpage'          => 'ناقش هذه الصفحة',
'talkpagelinktext'  => 'نقاش',
'specialpage'       => 'صفحة خاصة',
'personaltools'     => 'أدوات شخصية',
'postcomment'       => 'أرسل تعليقا',
'articlepage'       => 'عرض صفحة المحتوى',
'talk'              => 'نقاش',
'views'             => 'معاينة',
'toolbox'           => 'أدوات',
'userpage'          => 'عرض صفحة المستخدم',
'projectpage'       => 'عرض صفحة المشروع',
'imagepage'         => 'عرض صفحة الصورة',
'mediawikipage'     => 'عرض صفحة الرسالة',
'templatepage'      => 'عرض صفحة القالب',
'viewhelppage'      => 'عرض صفحة المساعدة',
'categorypage'      => 'عرض صفحة التصنيف',
'viewtalkpage'      => 'عرض النقاش',
'otherlanguages'    => 'بلغات أخرى',
'redirectedfrom'    => '(تم التحويل من $1)',
'redirectpagesub'   => 'صفحة تحويل',
'lastmodifiedat'    => 'آخر تعديل لهذه الصفحة كان في $2، $1.', # $1 date, $2 time
'viewcount'         => 'تم عرض هذه الصفحة {{PLURAL:$1|مرة واحدة|مرتان|$1 مرات|$1 مرة}}.',
'protectedpage'     => 'صفحة محمية',
'jumpto'            => 'اذهب إلى:',
'jumptonavigation'  => 'إبحار',
'jumptosearch'      => 'بحث',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => 'حول {{SITENAME}}',
'aboutpage'         => 'Project:حول',
'bugreports'        => 'تقارير الأخطاء',
'bugreportspage'    => 'Project:بلاغ أخطاء',
'copyright'         => 'المحتويات تحت  $1.',
'copyrightpagename' => 'حقوق النسخ في {{SITENAME}}',
'copyrightpage'     => 'Project:حقوق النسخ',
'currentevents'     => 'الأحداث الجارية',
'currentevents-url' => 'الأحداث الجارية',
'disclaimers'       => 'عدم مسؤولية',
'disclaimerpage'    => 'Project:عدم مسؤولية عام',
'edithelp'          => 'مساعدة التحرير',
'edithelppage'      => 'مساعدة:تحرير',
'faq'               => 'الأسئلة الأكثر تكرارا',
'faqpage'           => 'Project:أسئلة متكررة',
'helppage'          => 'Help:محتويات',
'mainpage'          => 'الصفحة الرئيسية',
'policy-url'        => 'Project:سياسة',
'portal'            => 'بوابة المجتمع',
'portal-url'        => 'Project:بوابة المجتمع',
'privacy'           => 'سياسة الخصوصية',
'privacypage'       => 'Project:سياسة الخصوصية',
'sitesupport'       => 'التبرعات',
'sitesupport-url'   => 'Project:دعم الموقع',

'badaccess'        => 'خطأ في الصلاحيات المطلوبة',
'badaccess-group0' => 'ليس من المسموح لك تنفيذ الأمر الذي طلبته.',
'badaccess-group1' => 'الأمر الذي طلبته مقصور على المستخدمين في المجموعة $1.',
'badaccess-group2' => 'الأمر الذي طلبته مقصور على المستخدمين في إحدى المجموعتين $1 .',
'badaccess-groups' => 'الأمر الذي طلبته مقصور على المستخدمين في إحدى المجموعات $1.',

'versionrequired'     => 'يلزم الإصدار $1 من ميدياويكي',
'versionrequiredtext' => 'يلزم الإصدار رقم $1 من ميدياويكي لاستعمال هذه الصفحة. انظر [[Special:Version|رقم الإصدار]]',

'ok'                  => 'موافق',
'pagetitle'           => '$1 - {{SITENAME}}',
'retrievedfrom'       => 'تم الاسترجاع من "$1"',
'youhavenewmessages'  => 'توجد لديك $1 ($2).',
'newmessageslink'     => 'رسائل جديدة',
'newmessagesdifflink' => 'آخر تغيير',
'editsection'         => 'تحرير',
'editold'             => 'تحرير',
'editsectionhint'     => 'تحرير القسم: $1',
'toc'                 => 'فهرست',
'showtoc'             => 'إظهار',
'hidetoc'             => 'إخفاء',
'thisisdeleted'       => 'هل تريد استعراض أو استرجاع $1؟',
'viewdeleted'         => 'عرض $1؟',
'restorelink'         => '{{PLURAL:$1|تعديل واحد محذوف|تعديلان محذوفان|$1 تعديلات محذوفة|$1 تعديل محذوف|$1 تعديلا محذوفا}}',
'feedlinks'           => 'تلقيم:',
'feed-invalid'        => 'نوع اشتراك التليقم خاطئ.',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => 'مقالة',
'nstab-user'      => 'صفحة مستخدم',
'nstab-media'     => 'صفحة ميديا',
'nstab-special'   => 'خاص',
'nstab-project'   => 'صفحة مشروع',
'nstab-image'     => 'ملف',
'nstab-mediawiki' => 'رسالة',
'nstab-template'  => 'قالب',
'nstab-help'      => 'صفحة مساعدة',
'nstab-category'  => 'تصنيف',

# Main script and global functions
'nosuchaction'      => 'لا يوجد أمر كهذا',
'nosuchactiontext'  => 'الأمر في مسار الصفحة لم يتم التعرف عليه من خلال الويكي',
'nosuchspecialpage' => 'لا توجد صفحة خاصة بهذا الاسم',
'nospecialpagetext' => 'لقد طلبت صفحة خاصة غير صحيحة، قائمة الصفحات الخاصة الصحيحة موجودة في[[Special:Specialpages|قائمة الصفحات الخاصة]].',

# General errors
'error'                => 'خطأ',
'databaseerror'        => 'خطأ في قاعدة البيانات',
'dberrortext'          => 'حدث خطأ في صيغة الاستعلام.
ربما يكون هذا عيب بالبرنامج.
آخر استعلام طُلب من قاعدة البيانات كان:
<blockquote><tt>$1</tt></blockquote>
من داخل الدالة "<tt>$2</tt>".
MySQL أرجعت الخطأ "<tt>$3: $4</tt>".',
'dberrortextcl'        => 'حدث خطأ في صيغة الاستعلام.
آخر استعلام طُلب من قاعدة البيانات كان:
"$1"
من داخل الدالة "$2".
MySQL أرجعت الخطأ "$3: $4"',
'noconnect'            => 'عفوا! تعاني الويكي من بعض المشاكل التقنية، و لا يمكن الاتصال بخادم قاعدة البيانات. <br />
$1',
'nodb'                 => 'لم يتمكن من اختيار قاعدة البيانات $1',
'cachederror'          => 'هذه نسخة مخبأة من الصفحة المطلوبة، و قد لا تكون محدثة.',
'laggedslavemode'      => 'تحذير: هذه الصفحة قد لا تحتوي على أحدث التغييرات.',
'readonly'             => 'قاعدة البيانات مغلقة',
'enterlockreason'      => 'اذكر سبب المنع والوقت المتوقع لرفع المنع',
'readonlytext'         => 'قاعدة البيانات مغلقة حاليا أمام الإضافات والتعديلات، السبب غالبا ما يكون الصيانة، وستعود قاعدة البيانات للوضع الطبيعي قريبا.
الإداري الذي أغلق قاعدة البيانات أعطى التفسير التالي:
<p>$1',
'missingarticle'       => 'لم تعثر قاعدة البيانات على نص الصفحة المفترض، باسم "$1".

عادة ما يكون السبب في ذلك اتباع وصلة فرق قديمة أو وصلة لتاريخ صفحة محذوفة. إذا كنت تعتقد أن السبب غير ذلك، فمن الممكن أن تكون هناك علة في البرنامج. الرجاء إعلام أحد الإداريين عن هذا الخطأ مع ذكر الوصلة.',
'readonly_lag'         => 'تم إغلاق قاعدة البيانات تلقائيا حتى تستطيع الخوادم التابعة ملاحقة الخادم الرئيسي',
'internalerror'        => 'خطأ داخلي',
'filecopyerror'        => 'لا يمكن نسخ الملف من  "$1" إلى "$2".',
'filerenameerror'      => 'لا يمكن تغيير اسم الملف من  "$1" إلى "$2".',
'filedeleteerror'      => 'لا يمكن حذف الملف "$1".',
'filenotfound'         => 'لا يمكن إيجاد الملف "$1".',
'unexpected'           => 'قيمة غير متوقعة: "$1"="$2".',
'formerror'            => 'خطأ: طلبك لم ينفذ',
'badarticleerror'      => 'لا يمكن إجراء هذا الأمر على هذه الصفحة.',
'cannotdelete'         => 'لم يتم حذف الصفحة أو الملف المطلوب. (ربما يكون قد تم حذفه من قبل مستخدم آخر. )',
'badtitle'             => 'عنوان خاطئ',
'badtitletext'         => 'عنوان الصفحة المطلوبة إما خاطئ أو فارغ، و ربما الوصلة بين اللغات أو بين المشاريع خاطئة. ومن الممكن وجود رموز لا تصلح للاستعمال في العنوان.',
'perfdisabled'         => 'عفوا! هذه الخاصية معطله حاليا لأنها تؤثر بشكل سلبي على أداء الويكي و تبطئها إلى حد استحالة استخدامها.',
'perfcached'           => 'القائمة التالية تم تخزينها في وقت سابق وقد لا تكون محدثة بعد:',
'perfcachedts'         => 'البيانات التالية مخزنة سابقا، آخر تحديث لها كان في $1.',
'querypage-no-updates' => 'تم تعطيل عمليات التحديث والإضافة لهذه الصفحة في الوقت الحالي. البيانات المعروضة هنا لن يتم تحديثها الآن.',
'wrong_wfQuery_params' => 'معاملات خاطئة في wfQuery()<br />
الدالة: $1<br />
الاستعلام: $2',
'viewsource'           => 'عرض المصدر',
'viewsourcefor'        => 'ل $1',
'protectedpagetext'    => 'تمت حماية هذه الصفحة لمنع التعديلات.',
'namespaceprotected'   => "لا تمتلك الصلاحية لتعديل الصفحات في نطاق '''$1'''.",
'viewsourcetext'       => 'يمكنك مشاهدة ونسخ مصدر هذه الصفحة:',
'protectedinterface'   => 'هذه الصفحة تتضمن نص الواجهة للبرنامج ولقد تم إغلاقها لمنع التخريب.',
'editinginterface'     => "'''تحذير''': أنت تقوم بتحرير صفحة تستخدم في الواجهة النصية للبرنامج؛ أية تغييرات لهذه الصفحة سوف تظهر في لواجهة المستخدم للمستخدمين الآخرين.",
'sqlhidden'            => '(استعلام SQL مخبئ)',
'cascadeprotected'     => 'تمت حماية هذه الصفحة من التعديل بسبب كونها مدمجة في {{PLURAL:$1|صفحة|صفحات}} التالية، والتي تم استعمال خاصية "حماية الصفحات المدمجة" بها:',

# Login and logout pages
'logouttitle'                => 'خروج المستخدم',
'logouttext'                 => '<strong>أنت الآن غير مسجل الدخول للنظام.</strong><br />
تستطيع المتابعة باستعمال {{SITENAME}} كمجهول، أو الدخول مرة أخرى بنفس الاسم أو باسم آخر. من الممكن أن ترى بعض الصفحات في كما وأنك مسجل في النظام، وذلك بسبب استعمال الصفحات المخبأة في المتصفح لديك.',
'welcomecreation'            => '== مرحبا يا $1! ==
تم إنشاء حسابك بنجاح؛ لا تنس أن تقوم بتغيير تفضيلاتك في {{SITENAME}}.',
'loginpagetitle'             => 'دخول المستخدم',
'yourname'                   => 'اسم المستخدم:',
'yourpassword'               => 'كلمة السر:',
'yourpasswordagain'          => 'أعد كتابة كلمة السر:',
'remembermypassword'         => 'تذكر بياناتي على هذا الحاسوب',
'yourdomainname'             => 'نطاقك:',
'externaldberror'            => 'هناك إما خطأ في دخول قاعدة البيانات الخارجية أو أنه غير مسموح لك بتحديث حسابك الخارجي.',
'loginproblem'               => '<b>حدثت مشكلة أثناء الدخول.</b><br />يرجى المحاولة مرى أخرى!',
'alreadyloggedin'            => '<strong>$1، أنت مسجل للدخول من قبل!</strong><br />',
'login'                      => 'دخول',
'loginprompt'                => 'يجب أن يدعم متصفحك الكوكيز لتتمكن من الدخول إلى {{SITENAME}}.',
'userlogin'                  => 'دخول / إنشاء حساب',
'logout'                     => 'خروج',
'userlogout'                 => 'خروج',
'notloggedin'                => 'غير مسجل',
'nologin'                    => 'لم تشترك بعد؟ $1.',
'nologinlink'                => 'قم بإنشاء حساب',
'createaccount'              => 'أنشئ حسابا جديدا',
'gotaccount'                 => 'هل قمت بالتسجيل سابقا؟ $1.',
'gotaccountlink'             => 'دخول',
'createaccountmail'          => 'عبر البريد الإلكتروني',
'badretype'                  => 'كلمات السر التي أدخلتها غير متطابقة.',
'userexists'                 => 'اسم المستخدم الذي أدخلته مستخدم من قبل؛ يرجى اختيار اسم مستخدم آخر.',
'youremail'                  => 'البريد الإلكتروني:',
'username'                   => 'اسم المستخدم:',
'uid'                        => 'رقم المستخدم:',
'yourrealname'               => 'الاسم الحقيقي:',
'yourlanguage'               => 'اللغة:',
'yourvariant'                => 'متغير',
'yournick'                   => 'اللقب:',
'badsig'                     => 'صيغة توقيع خاطئة؛ تحقق من بيانات الHTML.',
'badsiglength'               => 'التوقيع طويل جدا؛ لابد أن يكون أقل من $1 حرف.',
'email'                      => 'البريد الإلكتروني',
'prefs-help-realname'        => 'الاسم الحقيقي اختياري و لو اخترت أن تعرض اسمك هنا سيستخدم هذا في الإشارة إلى مساهماتك.',
'loginerror'                 => 'خطأ في الدخول',
'prefs-help-email'           => 'البريد الإلكتروني هو مدخل اختياري يمكّن الآخرين من الاتصال بك عن طريق صفحتك أو صفحة نقاشك من دون معرفة هويتك.',
'nocookiesnew'               => 'تم إنشاء حساب المستخدم و لكنك لست مسجل الدخول بعد. يستخدم {{SITENAME}} كوكيز لتسجيل الدخول. لديك الكوكيز معطلة. من فضلك فعلها, ثم أدخل باسم الحساب و كلمة السر الجديدتين.',
'nocookieslogin'             => '{{SITENAME}} يستخدم الكوكيز لتسجيل الدخول؛ لديك الكوكيز معطلة؛ من فضلك فعلها ثم حاول مرة أخرى.',
'noname'                     => 'لم تحدد اسم مستخدم صحيح.',
'loginsuccesstitle'          => 'تم الدخول بشكل صحيح',
'loginsuccess'               => "'''لقد قمت بتسجيل الدخول ل{{SITENAME}} باسم \"\$1\".'''",
'nosuchuser'                 => 'لا يوجد مستخدم بالاسم "$1".
تأكد من إملاء الاسم، أو قم بإنشاء حساب جديد.',
'nosuchusershort'            => 'لا يوجد مستخدم باسم "$1"؛ تأكد من إملاء الاسم.',
'nouserspecified'            => 'يجب عليك تحديد اسم مستخدم.',
'wrongpassword'              => 'كلمة السر التي أدخلتها غير صحيحة؛ يرجى إعادة المحاولة.',
'wrongpasswordempty'         => 'كلمة السر المدخلة كانت فارغة؛ من فضلك حاول مرة أخرى.',
'mailmypassword'             => 'أرسل لي كلمة السر عبر البريد الإلكتروني.',
'passwordremindertitle'      => 'تذكير بكلمة السر من {{SITENAME}}',
'passwordremindertext'       => 'لقد طلب شخص ما (غالبًا أنت، من عنوان الأيبي $1) أن نرسل لك كلمة سر جديدة لـ{{SITENAME}} ($4).

كلمة السر الآن للمستخدم "$2" هي "$3". 
عليك أن تقوم بالدخول إلى الموقع وتغيير كلمة السر خاصتك الآن إلا إذا لم تكن أنت من طلب هذا، اقرأ أدناه في هذه الحالة.

إذا لم تكن أنت من قام بطلب كلمة السر أو أنك تذكرت كلمة السر السابقة ولا ترغب بتغييرها فبإمكانك أن تتغاضى عن هذه الرسالة وأن تستمر في استخدام كلمة السر السابقة خاصتك.',
'noemail'                    => 'لا يوجد أي عنوان بريد إلكتروني مسجل للمستخدم "$1".',
'passwordsent'               => 'تم إرسال كلمة سر جديدة إلى العنوان البريدي المسجل للمستخدم "$1".
يرجى محاولة تسجيل الدخول مرة أخرى عند استلامها.',
'blocked-mailpassword'       => 'تم منع عنوان الأيبي الخاص بك من التحرير، ولمنع التخريب لا يمكنك أن تستخدم خاصية استرجاع كلمة السر.',
'eauthentsent'               => 'تم إرسال رسالة تأكيد إلكترونية إلى العنوان المسمى. حتى ترسل أي رسالة أخرى لذلك الحساب عليك أن تتبع التعليمات الواردة في الرسالة لتأكيد أن هذا الحساب هو لك بالفعل.',
'throttled-mailpassword'     => 'تم بالفعل إرسال تذكير بكلمة السر، في خلال الـ$1 ساعة الماضية.
لمنع التخريب، تذكير واحد فقط سيتم إرساله كل
$1 ساعة.',
'mailerror'                  => 'خطأ أثناء إرسال البريد: $1',
'acct_creation_throttle_hit' => 'معذرة، لقد قمت بإنشاء $1 حساب. لا يمكنك عمل المزيد.',
'emailauthenticated'         => 'تم تأكيد بريدك الإلكتروني على $1.',
'emailnotauthenticated'      => 'لم يتم التحقق من بريدك الإلكتروني؛ لن يتم إرسال رسائل لأي من الميزات التالية.',
'noemailprefs'               => 'يجب تحديد عنوان بريد إلكتروني لتفعيل هذه الخصائص.',
'emailconfirmlink'           => 'أكد غنوان بريدك الإلكتروني',
'invalidemailaddress'        => 'لا يمكن قبول عنوان البريد الإلكتروني الذي زودته حيث يبدو خاطئا؛ من فضلك ضع عنوانا مضبوطا أو أفرغ هذا الحقل.',
'accountcreated'             => 'تم إنشاء الحساب',
'accountcreatedtext'         => 'تم إنشاء الحساب الخاص ب$1.',

# Password reset dialog
'resetpass'               => 'أعد ضبط كلمة سر الحساب',
'resetpass_announce'      => 'تم تسجيل دخولك بكلمة سر مؤقتة؛ للدخول بشكل نهائي، يجب عليك ضبط كلمة سر جديدة هنا:',
'resetpass_text'          => '<!-- أضف نصا هنا -->',
'resetpass_header'        => 'أعد ضبط كلمة السر',
'resetpass_submit'        => 'ضبط كلمة السر والدخول',
'resetpass_success'       => 'تم تغيير كلمة السر الخاصة بك بنجاح! يتم تسجيل دخولك الآن...',
'resetpass_bad_temporary' => 'كلمة السر المؤقتة خاطئة؛ ربما تم تغيير كلمة السر فعليا بنجاح أو ربما قمت بطلب كلمة سر مؤقتة جديدة.',
'resetpass_forbidden'     => 'لا يمكن تغيير كلمات السر على هذه الويكي',
'resetpass_missing'       => 'لم يتم استقبال بيانات.',

# Edit page toolbar
'bold_sample'     => 'نص عريض',
'bold_tip'        => 'نص عريض',
'italic_sample'   => 'نص مائل',
'italic_tip'      => 'نص مائل',
'link_sample'     => 'عنوان وصلة',
'link_tip'        => 'وصلة داخلية',
'extlink_sample'  => 'http://www.example.com نص الوصلة',
'extlink_tip'     => 'وصلة خارجية (تذكر إضافة http:// قبل عنوان الوصلة)',
'headline_sample' => 'نص عنوان رئيسي',
'headline_tip'    => 'عنوان من المستوى الثاني',
'math_sample'     => 'أدخل الصيغة هنا',
'math_tip'        => 'صيغة رياضية (لا تك)',
'nowiki_sample'   => 'أدخل النص غير المنسق هنا',
'nowiki_tip'      => 'أهمل تهيئة الويكي',
'image_sample'    => 'Example.jpg',
'image_tip'       => 'إدراج صورة',
'media_sample'    => 'Example.ogg',
'media_tip'       => 'وصلة ملف وسائط',
'sig_tip'         => 'توقيعك مع الساعة والتاريخ',
'hr_tip'          => 'خط أفقي (تجنب الاستخدام بكثرة)',

# Edit pages
'summary'                   => 'ملخص',
'subject'                   => 'موضوع',
'minoredit'                 => 'هذا تعديل طفيف',
'watchthis'                 => 'راقب هذه الصفحة',
'savearticle'               => 'حفظ الصفحة',
'preview'                   => 'عرض مسبق',
'showpreview'               => 'عرض التعديلات',
'showlivepreview'           => 'عرض مباشر',
'showdiff'                  => 'أظهر الفرق',
'anoneditwarning'           => "'''تحذير:''' لم تقم بالدخول؛ سيتم تسجيل عنوان الأيبي الخاص بك في تاريخ هذه الصفحة.",
'missingsummary'            => "'''تنبيه:''' لم تقم بكتابة ملخص للتعديل الذي قمت به. إذا قمت بضغط حفظ الصفحة مرة أخرى فسوف يتم حفظ تغييرك بلا ملخص.",
'missingcommenttext'        => 'الرجاء كتابة تعليق في الأسفل.',
'missingcommentheader'      => "'''تنبيه:''' لم تقم بوضع عنوان لهذا التعليق، إذا قمت بالضغط على حفظ الصفحة مجددا، سيتم حفظ تعليقك بدون عنوان.",
'summary-preview'           => 'عرض مسبق للملخص',
'subject-preview'           => 'معاينة العنوان',
'blockedtitle'              => 'المستخدم ممنوع',
'blockedtext'               => "<big>'''تم منع اسم المستخدم أو عنوان الأيبي الخاص بك.'''</big>

سبب المنع هو: ''$2''. وقام بالمنع $1.

من الممكن التواصل مع $1 للنقاش حول المنع، أو مع أحد [[{{MediaWiki:grouppage-sysop}}|الإداريين]] حول ذلك>
تذكر أنه لا يمكن لك استعمال خاصية إرسال رسائل إلكترونية للمستخدمين إلا إذا كنت قد وضعت عنوان بريدي صحيح في صفحة [[Special:Preferences|التفضيلات]] الخاصة بك.

عنوان ال IP الخاص بك حاليا هو $3 وكود المنع هو #$5. يرجى إضافة أيهما أو كلاهما في أي رسالة للتساؤل حول المنع.",
'autoblockedtext'           => 'عنوان الأيبي الخاص بك تم منعه تلقائيا لأنه تم استخدامه بواسطة مستخدم آخر، و الذي تم منعه بواسطة $1.
السبب الممنوح هو التالي:

:\'\'$2\'\'

انتهاء المنع: $6

يمكنك أن تتصل ب $1 أو أحد
[[{{MediaWiki:grouppage-sysop}}|الإداريين]] الآخرين لمناقشة المنع.

لاحظ أنه لا يمكنك استخدام خاصية "أرسل رسالة لهذا المستخدم" إلا لو كان لديك عنوان بريد إلكتروني صحيح مسجل في [[Special:Preferences|تفضيلاتك]].

رقم منعك هو $5. من فضلك اذكر هذا الرقم في أي استفسار.',
'blockedoriginalsource'     => "مصدر '''$1''' معروض بالأسفل:",
'blockededitsource'         => "مبين بالأسفل نص '''تعديلك''' في '''$1''':",
'whitelistedittitle'        => 'الولوج ضروري للتحرير',
'whitelistedittext'         => 'يجب عليك $1 لتتمكن من تعديل الصفحات.',
'whitelistreadtitle'        => 'الولوج ضروري للقراءة',
'whitelistreadtext'         => 'يتعين عليك [[Special:Userlogin|الولوج]] لتتمكن من قراءة الصفحات.',
'whitelistacctitle'         => 'لا يسمح لك بإنشاء اشتراك',
'whitelistacctext'          => 'حتى يُسمح لك بإنشاء حسابات في هذه الويكي عليك أن تقوم [[Special:Userlogin|بالدخول]] وأن تمتلك الصلاحيات المناسبة.',
'confirmedittitle'          => 'تأكيد البريد الإلكتروني مطلوب لبدء التعديل',
'confirmedittext'           => 'يجب عليك تأكيد بريدك الإلكتروني قبل التعديل. من فضلك اكتب و أكد بريدك الإلكتروني من خلال [[Special:Preferences|تفضيلاتك]]',
'nosuchsectiontitle'        => 'لا يوجد قسم بهذا الاسم',
'nosuchsectiontext'         => 'لقد حاولت تحرير قسم غير موجود؛ وحيث أنه لا يوجد القسم $1، فلا يمكن حفظ تعديلك.',
'loginreqtitle'             => 'مطلوب الدخول أولا',
'loginreqlink'              => 'دخول',
'loginreqpagetext'          => 'يجب عليك $1 لتشاهد صفحات أخرى.',
'accmailtitle'              => 'تم إرسال كلمة السر.',
'accmailtext'               => "تم إرسال كلمة السر الخاصة بـ '$1' إلى العنوان $2.",
'newarticle'                => '(جديد)',
'newarticletext'            => "لقد تبعت وصلة لصفحة لم يتم إنشائها بعد.
لإنشاء هذه الصفحة ابدأ الكتابة في الصندوق بالأسفل.
(انظر في [[{{MediaWiki:helppage}}|صفحة المساعدة]] للمزيد من المعلومات)
إذا كانت زيارتك لهذه الصفحة بالخطأ، اضغط على زر ''رجوع'' في متصفح الإنترنت لديك.",
'anontalkpagetext'          => '----
هذه صفحة نقاش لمستخدم مجهول، وهو المستخدم الذي لم يقم بإنشاء حساب في {{SITENAME}}، أو لا يستعمل ذلك الحساب.
لذا يتم استعمال رقم الأيبي للتعريف به. من الممكن أن يشترك عدد من المستخدمين بنفس رقم الأيبي. إذا كنت مستخدما مجهولا
وترى أن رسائل خير موجهة لك قد وصلتك، من الممكن أن تقوم [[Special:Userlogin|بإنشاء حساب أو القيام بالدخول]]
حتى يزول الخلط بينك وبين المستخدمين المجهولين الآخرين.',
'noarticletext'             => 'لا يوجد حاليا أي نص في هذه الصفحة، يمكنك [[Special:Search/{{PAGENAME}}|البحث عن عنوان هذه الصفحة]] في الصفحات الأخرى or [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديل هذه الصفحة].',
'clearyourcache'            => "ملاحظة: قم بإعادة تحميل الصفحة لرؤية التغييرات. إذا لم تظهر التغييرات بعد إعادة التحميل، قد يكون متصفح الإنترنت الذي تستخدمه يقوم بعرض نسخة مخزنة سابقًا. لتجنب عرض هذه النسخة، قد يلزم أن تقوم بأحد هذه الخطوات:
* في متصفح '''موزيلا''' أو '''فايرفوكس''' أو '''سفاري''' اضغظ على ''مفتاح Shift'' أثناء قيامك بضغط زر إعادة التحميل (''Refresh'') أو اضغط ''Ctrl-Shift-R'' (''Cmd-Shift-R'' في حاسب أبل).
* في متصفح '''إنترنت إكسبلورر''' اضغط على مفتاح ''Ctrl'' أثناء قيامك بالنقر على زر إعادة التحميل (''Refresh'') أو اضغط ''Ctrl-F5''.
* في متصفح''' كونكيرر''' (Konqueror) انقر على زر إعادة التحميل (''Reload'') أو اضغط على مفتاح '''F5'''.
* في متصفح '''أوبرا''' (Opera) قد يكون من الضروري مسح المحتويات المخزنة عن طريق قائمة التفضيلات (''Tools&rarr;Preferences'').",
'usercssjsyoucanpreview'    => "<strong>ملاحظة:</strong> استعمل زر 'عرض التعديلات' لتجربة النمط (CSS) أو الجافا سكريبت الجديد قبل حفظ الصفحة.",
'usercsspreview'            => "'''تذكر أنك تقوم بعرض الأنماط المتراصة (CSS) فقط وأنك لم تقم بحفظها بعد!'''",
'userjspreview'             => "'''تذكر أنك فقط تجرب/تعرض الجافا سكريبت الخاص بك، لم يتم الحفظ بعد!'''",
'userinvalidcssjstitle'     => "'''تحذير:''' لا توجد واجهة  \"\$1\". تذكر أن ملفات ال.css و ال.js تستخدم حروف صغيرة في العنوان ، كمثال User:Foo/monobook.css و ليس User:Foo/Monobook.css.",
'updated'                   => '(محدثة)',
'note'                      => '<strong>ملاحظة:</strong>',
'previewnote'               => '<strong>تذكر، هذا فقط عرض مسبق للصفحة، ولم يتم حفظه بعد</strong>!',
'previewconflict'           => 'العرض يوضح النص الموجود في صندوق التحرير العلوي و الذي سيظهر إذا اخترت الحفظ.',
'session_fail_preview'      => '<strong>عفوا! لم نتمكن من حفظ التعديلات التي قمت بها نتيجة لضياع بيانات هذه الجلسة. الرجاء المحاولة مرة أخرى. في حال استمرار المشكلة حاول أن تقوم بالخروج ومن ثم الدخول مرة أخرى.</strong>',
'session_fail_preview_html' => "<strong>عذرا ! لا نستطيع تسجيل تعديلاتك بسبب فقدان بيانات الجلسة.</strong>

''بسبب أن wiki فعل HTML , تم إخفاء عرض التعديلات كوقاية و حماية  ضد الهجمات ب Javascript.''

<strong>إدا كانت هذه محاولة تعديل صادقة، حاول مرة أخرى؛ و في حالة الفشل حاول الخروج تم الدخول مرة أخرى.</strong>",
'importing'                 => 'جاري استيراد $1',
'editing'                   => 'تحرير $1',
'editinguser'               => 'تحرير مستخدم <b>$1</b>',
'editingsection'            => 'تحرير $1 (قسم)',
'editingcomment'            => 'تحرير $1 (تعليق)',
'editconflict'              => 'تضارب في التحرير: $1',
'explainconflict'           => 'لقد قام أحد ما بتعديل الصفحة بعد أن بدأت أنت بتحريرها؛
صندوق النصوص العلوي يحتوي على النص الموجود حاليا في الصفحة؛
والتغييرات التي قمت أنت بها موجودة في الصندوق في أسفل الصفحة؛
يجب أن تقوم بدمج تغييراتك في النص الموجود حاليا.
<b>فقط</b> ما هو موجود في الصندوق العلوي هو ما سيتم حفظه عند الضغط على زر "حفظ الصفحة".
<p>',
'yourtext'                  => 'النص الذي كتبته',
'storedversion'             => 'النسخة المخزنة',
'nonunicodebrowser'         => '<strong>تحذير: متصفحك لا يوافق الترميز الموحد. تمت معالجة هذا لكي تتمكن من تحرير الصفحات بأمان: حروف ليست من ASCII سوف تظهر في صندوق التحريرx كأكواد سداسي عشرية.</strong>',
'editingold'                => '<strong> تحذير: أنت تقوم الآن بتحرير نسخة قديمة من هذه الصفحة. إذا قمت بحفظها، ستفقد كافة التغييرات التي حدثت بعد هذه النسخة. </strong>',
'yourdiff'                  => 'الفروقات',
'copyrightwarning'          => 'يرجى الملاحظة أن جميع المساهمات ل {{SITENAME}} خاضعة وصادرة تحت ترخيص $2 (انظر في $1 للمزيد من التفاصيل)
إذا لم ترد أن تخضع كتابتك للتعديل والتوزيع الحر، لا تضعها هنا<br />. كما أنك تتعهد بأنك قمت بكتابة ما هو موجود بنفسك، أو قمت بنسخها من مصدر يخضع ضمن الملكية العامة، أو مصدر حر آخر. <strong>لا ترسل أي عمل ذي حقوق محفوظة بدون الإذن من صاحب الحق</strong>.',
'copyrightwarning2'         => 'من فضلك لاحظ أن حميع المشاركات في {{SITENAME}} يمكن أن تعدل أو تتغير أو تحذف من قبل المشاركين الآخرين. إذا لم تكن ترغب أن تعدل مشاركاتك بهذا الشكل، لا تضعها هنا.<br />
انت أيضا تقر أنك كتبت هذا بنفسك، أو نسختها من مصدر لا يخضع لحقوق النشر أو يسمح بالنقل بشكلا ما (انظر $1 للتفاصيل).
<strong>لا تضف أي نص ذي حقوق محفوظة!</strong>',
'longpagewarning'           => '<strong>تنبيه: هذه صفحة طويلة وحجمها $1 كيلوبايت، بعض متصفحات الشبكة قد تواجه مشاكل عند محاولة تحرير صفحات يزيد حجمها عن 32 كيلوبايت. يرجى تقسيم الصفحة إلى أقسام أصغر حجما  إن أمكن.</strong>',
'longpageerror'             => '<strong>خطأ: النص الذي أدخلته يجاوز $1 كيلوبايت 
، و هذا أكبر من الحد الأقصى و هو $2 كيلوبايت. لا يمكن حفظ الصفحة.</strong>',
'readonlywarning'           => '<strong>تحذير: لقد أغلقت قاعدة البيانات للصيانة، لذلك لن تتمكن من حفظ التعديلات التي قمت بها حاليا. إذا رغبت بإمكانك أن تنسخ النص الذي تعمل عليه وتحفظه في ملف نصي إلى وقت لاحق.</strong>',
'protectedpagewarning'      => '<strong>تحذير: هذه الصفحة محمية. فقط المستخدمون ذوو الصلاحيات الإدارية يمكن أن يقوموا بتحريرها.</strong>',
'semiprotectedpagewarning'  => "'''ملاحظة:''' هذه الصفحة محمية بحيث يتم تعديلها فقط من قبل المستخدمين المسجلين.",
'cascadeprotectedwarning'   => '<strong>تحذير: تمت حماية هذه الصفحة بحيث يستطيع المستخدمون ذوو الصلاحيات الإدارية فقط تعديلها، وذلك لكونها مدمجة في {{PLURAL:$1|الصفحة|الصفحات}} التالية والتي تمت حمايتها بخاصية "حماية الصفحات المدمجة":</strong>',
'templatesused'             => 'القوالب المستخدمة في هذه الصفحة:',
'templatesusedpreview'      => 'القوالب المستخدمة في هذا العرض المسبق:',
'templatesusedsection'      => 'القوالب المستخدمة في هذا القسم:',
'template-protected'        => '(حماية كاملة)',
'template-semiprotected'    => '(حماية جزئية)',
'edittools'                 => '<!-- النص هنا سيظهر تحت صندوق التحرير و استمارة رفع الصور. -->',
'nocreatetitle'             => 'تم تحديد إنشاء الصفحات',
'nocreatetext'              => 'قام الموقع بتحديد القدرة على إنشاء صفحات جديدة.
يمكنك العودة و تحرير صفحة موجودة بالفعل، أو [[Special:Userlogin|الدخول أو تسجيل حساب]].',
'recreate-deleted-warn'     => "'''تحذير: أنت تقوم بإعادة إنشاء صفحة تم حذفها في السابق.'''

يجب عليك التيقن من أن الاستمرار بتحرير هذه الصفحة ملائم.
سجل الحذف لهذه الصفحة معروض هنا:",

# "Undo" feature
'undo-success' => 'تم استرجاع التعديل. من فضلك، أكد التعديل وقم بحفظ الصفحة أدناه.',
'undo-failure' => 'لم ينجح الاسترجاع بسبب تعديلات متعارضة تمت على الصفحة.',
'undo-summary' => 'الرجوع عن التعديل $1 بواسطة [[Special:Contributions/$2|$2]] ([[نقاش المستخدم:$2|نقاش]])',

# Account creation failure
'cantcreateaccounttitle' => 'لم يتم إنشاء الحساب.',
'cantcreateaccounttext'  => 'تم منع إنشاء الحسابات من عنوان الأيبي هذا (<b>$1</b>).
ربما يكون هذا بسبب التخريب الصادر من مدرستك أو مزود الإنترنت الخاص بك.',

# History pages
'revhistory'          => 'تاريخ التغييرات',
'viewpagelogs'        => 'معاينة السجلات لهذه الصفحة',
'nohistory'           => 'لا يوجد تاريخ للتغييرات لهذه الصفحة.',
'revnotfound'         => 'النسخة غير موجودة',
'revnotfoundtext'     => 'لم يتم العثور على النسخة القديمة من الصفحة التي طلبتها.
من فضلك تأكد من العنوان الذي دخلت به إلى هذه الصفحة.',
'loadhist'            => 'تحميل تاريخ الصفحة',
'currentrev'          => 'النسخة الحالية',
'revisionasof'        => 'نسخة $1',
'revision-info'       => 'نسخة $1 بواسطة $2',
'previousrevision'    => '&rarr; نسخة أقدم',
'nextrevision'        => 'نسخة أحدث &larr;',
'currentrevisionlink' => 'رؤية النسخة الحالية',
'cur'                 => 'الحالي',
'next'                => 'التالي',
'last'                => 'السابق',
'orig'                => 'الأصلي',
'page_first'          => 'الأولى',
'page_last'           => 'الأخيرة',
'histlegend'          => 'اختيار الفرق: علم على صناديق النسخ للمقارنة و اضغط قارن بين النسخ المختارة أو الزر بالأسفل.<br />
مفتاح: (الحالي) = الفرق مع النسخة الحالية
(السابق) = الفرق مع النسخة السابقة، ط = تغيير طفيف',
'deletedrev'          => '[محذوف]',
'histfirst'           => 'أول',
'histlast'            => 'آخر',
'historysize'         => '($1 بايت)',
'historyempty'        => '(فارغ)',

# Revision feed
'history-feed-title'          => 'تاريخ التعديل',
'history-feed-description'    => 'تاريخ التعديل لهذه الصفحة في الويكي',
'history-feed-item-nocomment' => '$1 في $2', # user at time
'history-feed-empty'          => 'الصفحة المطلوبة غير موجودة. من المحتمل أن تكون هذه الصفحة قد حذفت أو نقلت. حاول [[Special:Search|البحث في الويكي]] عن صفحات جديدة ذات صلة.',

# Revision deletion
'rev-deleted-comment'         => '(تم مسح تعليق)',
'rev-deleted-user'            => '(تم مسح اسم مستخدم)',
'rev-deleted-event'           => '(تم مسح المدخلة)',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
تم مسح هذا التعديل من الأرشيف العام.
من الممكن أن يكون هناك تفاصيل حول هذا في [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سجل الحذف].
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
تم مسح هذا التعديل من الأرشيف العام.
بإمكانك رؤية هذا التعديل لكونك إداريا على هذا الموقع.
من الممكن أن يكون هناك تفاصيل حول هذا في [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سجل الحذف].
</div>',
'rev-delundel'                => 'عرض/إخفاء',
'revisiondelete'              => 'امسح/استرجع التعديلات',
'revdelete-nooldid-title'     => 'لا يوجد تعديل مختار',
'revdelete-nooldid-text'      => 'لم تقم بتحديد تعديل أو تعديلات معينة لعمل هذا الإجراء عليها.',
'revdelete-selected'          => "{{PLURAL:$2|النسخة المختارة|النسختان المختارتان|النسخ المختارة}} من '''$1:'''",
'logdelete-selected'          => "{{PLURAL:$2|الحدث المختار|الحدثان المختاران|الأحداث المختارة}} من السجل لـ '''$1:'''",
'revdelete-text'              => 'ستظل الأحداث والتعديلات الملغاة تظهر في تاريخ الصفحة والسجلات،
ولكن لن يكون مسموحا للعامة الدخول إلى بعض محتوياتها.

سيظل لدى الإداريين الآخريين بهذه الويكي الصلاحية لرؤية المحتويات المخفاة
ويستطيعون أيضا استرجاعها مرة أخرى من خلال نفس هذه الواجهة، ما لم تكن هناك ضوابط إضافية تم وضعها.',
'revdelete-legend'            => 'وضع ضوابط:',
'revdelete-hide-text'         => 'إخفاء نص التعديل',
'revdelete-hide-name'         => 'إخفاء الإجراء والهدف منه',
'revdelete-hide-comment'      => 'إخفاء تعليق التعديل',
'revdelete-hide-user'         => 'إخفاء اسم/عنوان المستخدم',
'revdelete-hide-restricted'   => 'تطبيق هذه الضوابط على الإداريين بجانب الآخرين',
'revdelete-suppress'          => 'إخفاء البيانات عن الإداريين بجانب الآخرين',
'revdelete-hide-image'        => 'إخفاء محتويات الملف',
'revdelete-unsuppress'        => 'إزالة الضوابط من التعديلات المسترجعة',
'revdelete-log'               => 'تعليق السجل:',
'revdelete-submit'            => 'تطبيق على التعديل المختار',
'revdelete-logentry'          => 'تغيير مرئية تعديلات في [[$1]]',
'logdelete-logentry'          => 'تغيير مرئية أحداث في [[$1]]',
'revdelete-logaction'         => 'تم ضبط {{PLURAL:$1|تعديل|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}} للوضع $2',
'logdelete-logaction'         => 'تم ضبط {{PLURAL:$1|حدث|حدثين|$1 أحداث|$1 حدث|$1 حدثا}} بخصوص [[$3]] للوضع $2',
'revdelete-success'           => 'تم ضبط مرئية التعديلات بنجاح.',
'logdelete-success'           => 'تم ضبط مرئية الأحداث بنجاح.',

# Oversight log
'oversightlog'    => 'سجل الأوفرسايت',
'overlogpagetext' => 'بالأسفل قائمة بأحدث عمليات الحذف والمنع المتضمنة محتويات تم إخفائها عن الإداريين. انظر [[Special:Ipblocklist|قائمة منع عناوين الأيبي]] لترى حالات المنع والطرد الحالية.',

# Diffs
'difference'                => '(الفرق بين النسخ)',
'loadingrev'                => 'تحميل التعديل للمقارنة',
'lineno'                    => 'سطر $1:',
'editcurrent'               => 'حرر النسخة الحالية من هذه الصفحة',
'selectnewerversionfordiff' => 'اختر نسخة أحدث للمقارنة',
'selectolderversionfordiff' => 'اختر نسخة أقدم للمقارنة',
'compareselectedversions'   => 'قارن بين النسخ المختارة',
'editundo'                  => 'رجوع',
'diff-multi'                => '(عدد التعديلات غير الظاهرة هو $1.)',

# Search results
'searchresults'         => 'نتائج البحث',
'searchresulttext'      => 'للمزيد من المعلومات حول البحث في {{SITENAME}}، راجع [[{{MediaWiki:helppage}}|تصفح]].',
'searchsubtitle'        => 'لصيغة البحث "[[$1]]"',
'searchsubtitleinvalid' => 'لصيغة البحث "$1"',
'badquery'              => 'نص بحث خاطئ',
'badquerytext'          => 'لا يمكننا معالجة طلبك. من المحتمل أنك حاولت البحث عن كلمة بأقل من ثلاثة حروف, و هذا غير مدعم حاليا. كما قد يكون ناتجا عن خلط في أسلوب البحث, مثلا: "سمك و و تفاح". المرجو تجريب شيء آخر.',
'matchtotals'           => 'الاستعلام "$1" يشابه $2 عنوان صفحة
و نصوص $3 صفحة.',
'noexactmatch'          => "'''لا توجد صفحة بالاسم \"\$1\"'''. يمكنك [[\$1|إنشاء هذه الصفحة]].",
'titlematches'          => 'نتائج بحث العناوين',
'notitlematches'        => 'لم يتم إيجاد أي عنوان مطابق',
'textmatches'           => 'نتائج بحث نصوص الصفحات',
'notextmatches'         => 'لم يتم إيجاد أي نص مطابق',
'prevn'                 => '$1 السابقة',
'nextn'                 => '$1 التالية',
'viewprevnext'          => 'عرض ($1) ($2) ($3).',
'showingresults'        => 'القائمة التالية تظهر <b>$1</b> نتيجة أو أقل بدءًا من المدخلة رقم <b>$2</b>.',
'showingresultsnum'     => 'عرض <b>$3</b> نتيجة بدءًا من المدخلة رقم <b>$2</b>.',
'nonefound'             => "'''ملاحظة:''' عمليات البحث غير الناجحة تكون عادة نتيجة للبحث عن كلمات شائعة مثل \"من\" و \"يمتلك\" والتي لا يتم فهرستها، وقد تنتج أيضا من استعمال أكثر من كلمة في البحث (فقط الصفحات التي تحتوي على جميع هذه الكلمات سوف تظهر في نتيجة البحث).",
'powersearch'           => 'بحث',
'powersearchtext'       => 'ابحث في النطاقات:<br />$1<br />$2 عرض التحويلات<br />ابحث عن $3 $9',
'searchdisabled'        => 'لقد تم إيقاف ميزة البحث في النصوص في {{SITENAME}}، في الوقت الحالي من الممكن أن تستعمل محرك البحث جوجل بدلا من خاصية البحث في النصوص. من الممكن أن يكون البحث في جوجل لا يشمل آخر التعديلات والصفحات.',
'blanknamespace'        => 'مقالات',

# Preferences page
'preferences'              => 'تفضيلات',
'mypreferences'            => 'تفضيلاتي',
'prefsnologin'             => 'غير مسجل',
'prefsnologintext'         => 'يجب أن تكون [[Special:Userlogin|مسجلا]] حتى تتمكن من تعديل تفضيلات المستخدم.',
'prefsreset'               => 'أعيدت التفضيلات إلى الإعداد الافتراضي المخزن.',
'qbsettings'               => 'خيارات لوحة الوصلات',
'qbsettings-none'          => 'بلا تحديد',
'qbsettings-fixedleft'     => 'مثبت لليسار',
'qbsettings-fixedright'    => 'مثبت لليمين',
'qbsettings-floatingleft'  => 'حر لليسار',
'qbsettings-floatingright' => 'حر لليمين',
'changepassword'           => 'غير كلمة السر',
'skin'                     => 'واجهة',
'math'                     => 'رياضيات',
'dateformat'               => 'صيغة التاريخ',
'datedefault'              => 'لا تفضيل',
'datetime'                 => 'وقت وتاريخ',
'math_failure'             => 'خطأ رياضيات',
'math_unknown_error'       => 'خطأ مجهول',
'math_unknown_function'    => 'وظيفة مجهولة',
'math_lexing_error'        => 'خطأ في الصيغة',
'math_syntax_error'        => 'خطأ بالصيغة',
'math_image_error'         => 'فشل التحويل لPNG , تحقق من تثبيت كل من Latex و dvips و gs و convert.',
'math_bad_tmpdir'          => 'لا يمكن إنشاء أو كتابة الملف المؤقت',
'math_bad_output'          => 'لا يمكن إنشاء أو كتابة في ملف الخروج',
'prefs-personal'           => 'معلومات المستخدم',
'prefs-rc'                 => 'أحدث التغييرات',
'prefs-watchlist'          => 'قائمة المراقبة',
'prefs-watchlist-days'     => 'عدد الأيام المعروضة في قائمة المراقبة:',
'prefs-watchlist-edits'    => 'عدد التعديلات التي تعرض في قائمة المراقبة الموسعة:',
'prefs-misc'               => 'متفرقات',
'saveprefs'                => 'حفظ التفضيلات',
'resetprefs'               => 'أعد التعديلات الأصلية',
'oldpassword'              => 'كلمة السر القديمة',
'newpassword'              => 'كلمة السر الجديدة:',
'retypenew'                => 'أعد كتابة كلمة السر الجديدة',
'textboxsize'              => 'أبعاد صندوق النصوص',
'rows'                     => 'أسطر',
'columns'                  => 'أعمدة',
'searchresultshead'        => 'خيارات نتائج البحث',
'resultsperpage'           => 'عدد النتائج في الصفحة',
'contextlines'             => 'عدد الأسطر في كل نتيجة',
'contextchars'             => 'عدد الأحرف في كل سطر',
'recentchangesdays'        => 'عدد الأيام المعروضة في أحدث التغييرات:',
'recentchangescount'       => 'عدد التعديلات المعروضة في أحدث التغييرات:',
'savedprefs'               => 'تم حفظ تفضيلاتك.',
'timezonelegend'           => 'المنطقة الزمنية',
'timezonetext'             => 'عدد الساعات بين توقيتك المحلي والتوقيت على الخادم (UTC).',
'localtime'                => 'عرض الوقت المحلي',
'timezoneoffset'           => 'الفرق¹',
'servertime'               => 'وقت الخادم',
'guesstimezone'            => 'ادخل التوقيت من المتصفح',
'allowemail'               => 'السماح بتلقي البريد الإلكتروني من المستخدمين الآخرين',
'defaultns'                => 'ابحث في هذه النطاقات بشكل افتراضي:',
'default'                  => 'مبدئي',
'files'                    => 'ملفات',

# User rights
'userrights-lookup-user'      => 'إدارة مجموعات المستخدمين',
'userrights-user-editname'    => 'أدخل اسم مستخدم:',
'editusergroup'               => 'عدل مجموعات المستخدمين',
'userrights-editusergroup'    => 'تعديل مجموعات المستخدمين',
'saveusergroups'              => 'احفظ مجموعات المستخدم',
'userrights-groupsmember'     => 'عضو في:',
'userrights-groupsavailable'  => 'المجموعات المتاحة:',
'userrights-groupshelp'       => 'قم باختيار المجموعات التي تريد المستخدم أن يضاف إليها أو تتم إزالته منها.
المجموعات الغير مختارة ستترك كما هي. يمكنك إزالة مجموعة بالضغط على كنترل + ضغطة فأرة يسرى.',
'userrights-reason'           => 'سبب التغيير:',
'userrights-available-none'   => 'لا يمكنك تعديل مجموعات المستخدم.',
'userrights-available-add'    => 'يمكنك إضافة المستخدمين ل $1.',
'userrights-available-remove' => 'يمكنك إزالة المستخدمين من $1.',

# Groups
'group'            => 'المجموعة:',
'group-bot'        => 'بوت',
'group-sysop'      => 'إداريون',
'group-bureaucrat' => 'بيروقراطيون',
'group-all'        => '(الكل)',

'group-bot-member'        => 'بوت',
'group-sysop-member'      => 'إداري',
'group-bureaucrat-member' => 'بيروقراط',

'grouppage-bot'        => '{{ns:project}}:بوت',
'grouppage-sysop'      => '{{ns:project}}:إداريون',
'grouppage-bureaucrat' => '{{ns:project}}:بيروقراطيون',

# User rights log
'rightslog'      => 'سجل صلاحيات المستخدمين',
'rightslogtext'  => 'هذا سجل بالتغييرات في صلاحيات المستخدمين.',
'rightslogentry' => 'تغيير صلاحيات $1 من $2 إلى $3',
'rightsnone'     => 'مستخدم عادي',

# Recent changes
'nchanges'                          => '{{PLURAL:$1|تغيير|تغييران|$1 تغييرات|$1 تغيير|$1 تغييرا}}',
'recentchanges'                     => 'أحدث التغييرات',
'recentchangestext'                 => 'تابع آخر التغييرات في الموسوعة من هذه الصفحة.',
'recentchanges-feed-description'    => 'تابع أحدث التغييرات لهذه الويكي عبر هذه التلقيمة.',
'rcnote'                            => 'ستجد بالأسفل آخر <strong>$1</strong> تعديل في آخر <strong>$2</strong> يوم, منذ $3.',
'rcnotefrom'                        => 'في الأسفل التغييرات منذ <b>$2</b> (ولغاية <b>$1</b>).',
'rclistfrom'                        => 'أظهر التغييرات بدءا من $1',
'rcshowhideminor'                   => '$1 التعديلات الطفيفة',
'rcshowhidebots'                    => '$1 تعديلات البوت',
'rcshowhideliu'                     => '$1 تعديلات المستخدمين المسجلين',
'rcshowhideanons'                   => '$1 تعديلات المستخدمين المجهولين',
'rcshowhidepatr'                    => '$1 التعديلات المراجعة',
'rcshowhidemine'                    => '$1 تعديلاتي',
'rclinks'                           => 'أظهر آخر $1 تعديل في آخر $2 يوم، $3',
'diff'                              => 'فرق',
'hist'                              => 'تاريخ',
'hide'                              => 'إخفاء',
'show'                              => 'عرض',
'minoreditletter'                   => 'ط',
'newpageletter'                     => 'ج',
'boteditletter'                     => 'ب',
'sectionlink'                       => '←',
'number_of_watching_users_pageview' => '[$1 مستخدم مراقب]',
'rc_categories'                     => 'حصر لتصنيفات (مفرقة برمز "|")',
'rc_categories_any'                 => 'أي',

# Recent changes linked
'recentchangeslinked'          => 'تغييرات ذات علاقة',
'recentchangeslinked-noresult' => 'لم تحدث تعديلات في الصفحات التي لها وصلات هنا خلال الفترة المحددة.',
'recentchangeslinked-summary'  => "هذه الصفحة الخاصة تعرض آخر التغييرات في الصفحات الموصولة. الصفحات في قائمة مراقبتك معروضة '''بخط عريض'''.",

# Upload
'upload'                      => 'رفع ملف',
'uploadbtn'                   => 'رفع الملف',
'reupload'                    => 'إعادة الرفع',
'reuploaddesc'                => 'الرجوع لصفحة الرفع.',
'uploadnologin'               => 'لم تقم بتسجيل الدخول',
'uploadnologintext'           => 'يجب أن تكون [[Special:Userlogin|مسجلا الدخول]] لتتمكن من رفع الملفات.',
'upload_directory_read_only'  => 'لا يمكن الكتابة على مجلد الرفع ($1) من قبل خادم الشبكة.',
'uploaderror'                 => 'خطأ في الرفع',
'uploadtext'                  => "استعمل الصندوق بالأسفل لرفع الصور, لعرض أو البحث في الصور المحملة سابقا, راجع [[Special:Imagelist|قائمة الملفات المرفوعة]], سجل الرفع و المسح موجود في [[Special:Log/upload|سجل الرفع]].

لإدراج صورة في صفحة, استعمل الوصلات في الصيغ التالية:
*'''<nowiki>[[{{ns:image}}:ملف.jpg]]</nowiki>''',
*'''<nowiki>[[{{ns:image}}:ملف.png|alt text]]</nowiki>''' أو
*'''<nowiki>[[{{ns:media}}:ملف.ogg]]</nowiki>''' للوصل للملف مباشرة.",
'uploadlog'                   => 'سجل الرفع',
'uploadlogpage'               => 'سجل الرفع',
'uploadlogpagetext'           => 'في الأسفل قائمة بآخر الملفات التي تم رفعها.',
'filename'                    => 'اسم الملف',
'filedesc'                    => 'وصف قصير',
'fileuploadsummary'           => 'نبذة:',
'filestatus'                  => 'حالة الترخيص',
'filesource'                  => 'مصدر',
'uploadedfiles'               => 'الملفات المرفوعة',
'ignorewarning'               => 'تغاض عن هذا التحذير واحفظ الملف.',
'ignorewarnings'              => 'أهمل أية تحذيرات',
'minlength1'                  => 'أسماء الملفات يجب أن تتكون من حرف واحد على الأقل.',
'illegalfilename'             => 'يحتوي اسم الملف $1 على رموز غير مقبولة. أعد تسمية الملف من فضلك و قم برفعه مرة أخرى.',
'badfilename'                 => 'تم تغيير اسم الصورة إلى "$1".',
'filetype-badmime'            => 'من غير المسموح به رفع ملفات من النوع "$1".',
'filetype-badtype'            => "يعتبر '''\".\$1\"''' من أنواع الملفات المرفوضة
: قائمة بالأنواع المسموح بها: \$2",
'filetype-missing'            => 'الملف بدون امتداد (مثل ".jpg").',
'large-file'                  => 'ينصح ألا تكون الملفات أكبر من $1؛ هذا الملف حجمه $2.',
'largefileserver'             => 'حجم هذا الملف أكبر من المسموح به على هذا الخادم.',
'emptyfile'                   => 'يبدو أن الملف الذي رفعته فارغ. قد يكون سبب ذلك خطأ في كتابة الاسم. من فضلك تأكد من أنك تريد فعلا رفع هذا الملف.',
'fileexists'                  => 'هناك ملف موجود يحمل نفس هذا الاسم الرجاء التأكد من هذا الملف باتباع الوصلة التالية <strong><tt>$1</tt></strong> قبل القيام بتغييره.',
'fileexists-extension'        => 'يوجد ملف باسم مشابه:<br />
اسم الملف المراد رفعه: <strong><tt>$1</tt></strong><br />
اسم الملف الموجود بالفعل: <strong><tt>$2</tt></strong><br />
الاختلاف الوحيد بينهما هو حالة أحرف الامتداد من حيث الكبر أو الصغر. افحص الملفين من أجل التحقق من عدم تطابقهما من فضلك.',
'fileexists-thumb'            => "'''<center>الصورة الموجودة</center>'''",
'fileexists-thumbnail-yes'    => 'يبدو أن الملف مصغرا لحجم أعلى <i>(تصغير)</i>. افحص الملف <strong><tt>$1</tt></strong> من فضلك.<br />
إن كان هو نفس الملف بالحجم الأصلي فلا داعي لرفع تصغير إضافي.',
'file-thumbnail-no'           => 'يبدأ الملف بـ <strong><tt>$1</tt></strong>. يبدو أن الملف مصغرا لحجم أعلى <i>(تصغير)</i>.
إذا كانت لديك الصورة في درجة استبانة كاملة قم برفعها، أو قم بتغيير اسم الملف من فضلك.',
'fileexists-forbidden'        => 'هناك ملف بنفس الاسم حاليا؛ من فضلك تراجع و اعطه اسما جديدا. [[صورة:$1|تصغير|وسط|$1]]',
'fileexists-shared-forbidden' => 'يوجد ملف بنفس الاسم في مستودع الملفات المشترك، من فضلك ارجع و ارفع هذا الملف تحت اسم جديد. [[صورة:$1|تصغير|وسط|$1]]',
'successfulupload'            => 'تم رفع الملف بنجاح',
'uploadwarning'               => 'تحذير رفع الملفات',
'savefile'                    => 'حفظ الملف',
'uploadedimage'               => 'تم رفع "[[$1]]"',
'uploaddisabled'              => 'تم إيقاف خاصية رفع الملفات.',
'uploaddisabledtext'          => 'تم منع رفع الملفات على هذه الويكي.',
'uploadscripted'              => 'يضم هذا الملف قن HTML أو قن آخر يمكنه أن يأول بطريقة خاطئة بواسطة المتصفح.',
'uploadcorrupt'               => 'هذا الملف غير سليم أو له امتداد خاطيء. الرجاء التأكد من الملف وإعادة الرفع مرة أخرى.',
'uploadvirus'                 => 'هذا الملف يحتوي على فيروس! التفاصيل: $1',
'sourcefilename'              => 'الملف',
'destfilename'                => 'تخرين الملف باسم',
'watchthisupload'             => 'راقب هذه الصفحة',
'filewasdeleted'              => 'تم رفع ثم حذف ملف بهذا الاسم من قبل. من الأفضل مراجعة $1 قبل رفعه مرة أخرى.',

'upload-proto-error'      => 'بروتوكول غير صحيح',
'upload-proto-error-text' => 'الرفع عن بعد يتطلب مسارا يبدأ بـ <code>http://</code> أو <code>ftp://</code>.',
'upload-file-error'       => 'خطأ داخلي',
'upload-file-error-text'  => 'حدث خطأ داخلي عند محاولة عمل ملف مؤقت على الخادم. من فضلك اتصل بمدير نظام.',
'upload-misc-error'       => 'خطأ غير معلوم في الرفع',
'upload-misc-error-text'  => 'حدث خطأ غير معلوم أثناء عملية الرفع. من فضلك تاكد أن المسار صحيح ومن الممكن الدخول عليه ثم حاول مرة أخرى. إذا استمرت المشكلة في الحدوث، راسل مديرا للنظام.',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'لم يتمكن من الوصول للمسار',
'upload-curl-error6-text'  => 'لم يتمكن من الوصول إلى المسار الذي حددته.  راجع من فضلك صحة المسار مرة أخرى وأن الموقع يعمل.',
'upload-curl-error28'      => 'انتهاء مهلة الرفع',
'upload-curl-error28-text' => 'أخذ الموقع وقت طويل للاستجابة. تأكد أن الموقع يعمل وانتظر فترة قصيرة ثم حاول مرة أخرى. ربما يتعين عليك المحاولة في وقت أقل ازدحاما.',

'license'            => 'ترخيص',
'nolicense'          => 'غير محدد',
'upload_source_url'  => '(عنوان ويب صحيح، يمكن الوصول إليه)',
'upload_source_file' => ' (ملف على حاسوبك)',

# Image list
'imagelist'                 => 'قائمة الصور',
'imagelisttext'             => 'فيما يلي قائمة تحوي $1 {{PLURAL:$1|ملف|ملفات}} مرتبة $2.',
'imagelistforuser'          => 'يعرض هذا الصور التي قام $1 برفعها.',
'getimagelist'              => 'جاري إحضار قائمة الملفات',
'ilsubmit'                  => 'بحث',
'showlast'                  => 'عرض آخر $1 ملف بترتيب $2.',
'byname'                    => 'حسب الاسم',
'bydate'                    => 'حسب التاريخ',
'bysize'                    => 'حسب الحجم',
'imgdelete'                 => 'حذف',
'imgdesc'                   => 'وصف',
'imgfile'                   => 'ملف',
'imglegend'                 => 'مفتاح: (وصف) = عرض أو تعديل صفحة الوصف.',
'imghistory'                => 'تاريخ الملف',
'revertimg'                 => 'استرجاع',
'deleteimg'                 => 'احذف',
'deleteimgcompletely'       => 'احذف كل نسخ هذا الملف',
'imghistlegend'             => 'مفتاح: (حالي) = النسخة الموجودة حاليا من الملف، (حذف) = حذف هذه النسخة السابقة، (استرجاع) = استرجاع نسخة قديمة من الملف.
<br /><i>اضغط على التاريخ لرؤية النسخة المرفوعة في ذلك التاريخ.</i>.',
'imagelinks'                => 'وصلات',
'linkstoimage'              => 'الصفحات التالية تحتوي على وصلة لهذا الملف:',
'nolinkstoimage'            => 'لا توجد صفحات تصل لهذا الملف.',
'sharedupload'              => 'هذا الملف تم رفعه للتشارك بين المشاريع ويمكن استعماله في المشاريع الأخرى.',
'shareduploadwiki'          => 'الرجاء رؤية $1 لمزيد من المعلومات.',
'shareduploadwiki-linktext' => 'صفحة وصف الملف',
'noimage'                   => 'لا يوجد ملف بهذا الاسم، بإمكانك أن تقوم بـ$1.',
'noimage-linktext'          => 'رفعه',
'uploadnewversion-linktext' => 'رفع نسخة جديدة للملف',
'imagelist_date'            => 'تاريخ',
'imagelist_name'            => 'اسم',
'imagelist_user'            => 'مستخدم',
'imagelist_size'            => 'حجم',
'imagelist_description'     => 'وصف',
'imagelist_search_for'      => 'ابحث عن اسم الصورة:',

# MIME search
'mimesearch'         => 'بحث MIME',
'mimesearch-summary' => 'تعمل هذه الصفحة على عرض وتصفية الملفات بناء على نوعها. المدخل: نوع المحتوى/النوع الفرعي، كمثال
<tt>image/jpeg</tt>.',
'mimetype'           => 'نوع الملف:',
'download'           => 'تحميل',

# Unwatched pages
'unwatchedpages' => 'صفحات غير مراقبة',

# List redirects
'listredirects' => 'عرض التحويلات',

# Unused templates
'unusedtemplates'     => 'قوالب غير مستعملة',
'unusedtemplatestext' => 'تحتوي هذه الصفحة على قائمة بالصفحات من نطاق قالب غير المستعملة في صفحات أخرى. تذكر بأن تتحقق من عدم وجود وصلات أخرى لهذه القوالب قبل حذفها.',
'unusedtemplateswlh'  => 'وصلات أخرى',

# Random redirect
'randomredirect'         => 'صفحة تحويل عشوائية',
'randomredirect-nopages' => 'لا توجد تحويلات في هذا النطاق.',

# Statistics
'statistics'             => 'إحصاءات',
'sitestats'              => 'إحصاءات {{SITENAME}}',
'userstats'              => 'إحصاءات المستخدم',
'sitestatstext'          => "توجد '''\$1''' صفحة كعدد كلي في قاعدة البيانات.
و هذا يتضمن \"صفحات النقاش\"، الصفحات حول {{SITENAME}}, صفحات \"البذور\" الصغيرة
, صفحات التحويل، و صفحات أخرى ربما لا ترقى لمستوى مقالة.
بخلاف هذه الصفحات، توجد '''\$2''' صفحة يمكن أن يعدوا كصفحات تحتوي على مقالات.

تم رفع '''\$8''' ملف.

تم عرض الصفحات '''\$3''' مرة، و تم عمل '''\$4''' تعديل للصفحات
منذ بداية عمل الويكي.
و هذا بمعدل '''\$5''' للصفحة الواحدة، و '''\$6''' مشاهدة للتعديل الواحد.

طول [http://meta.wikimedia.org/wiki/Help:Job_queue طابور الشغل] هو '''\$7'''.",
'userstatstext'          => "هناك {{PLURAL:$1|مستخدم مسجل وحيد|مستخدمين مسجلين|$3 مستخدمين مسجلين|$3 مستخدم مسجل|$3 مستخدما مسجلا}}, منهم
'''$2''' (أو '''$4%''') {{PLURAL:$2|لديه|لديهما|لديهم}} صلاحيات $5.",
'statistics-mostpopular' => 'أكثر الصفحات مشاهدة',

'disambiguations'      => 'صفحات التوضيح',
'disambiguationspage'  => 'قالب:توضيح',
'disambiguations-text' => "الصفحات التالية تصل إلى '''صفحة توضيح'''. ينبغي في المقابل أن تصل إلى الضفحة الملائمة. <br />تعامل الصفحة كصفحة توضيح إذا كان بها قالب موجود في [[MediaWiki:disambiguationspage|صفحة الميدياويكي هذه]]",

'doubleredirects'     => 'تحويلات مزدوجة',
'doubleredirectstext' => "كل سطر في القائمة التالية يحتوي على وصلات للتحويلة الأولى والثانية بالإضافة إلى أول سطر من نص التحويلة الثانية والذي عادة ما يشير إلى المقالة ''المفترض'' أن يتم التحويل إليها مباشرة من التحويلة الأولى أيضا.",

'brokenredirects'        => 'تحويلات مكسورة',
'brokenredirectstext'    => 'الوصلات التالية تشير لصفحات غير موجودة:',
'brokenredirects-edit'   => '(تحرير)',
'brokenredirects-delete' => '(حذف)',

'withoutinterwiki'        => 'صفحات بدون وصلات لغات أخرى',
'withoutinterwiki-header' => 'الصفحات التالية لا تصل إلى نسخ بلغات أخرى:',

'fewestrevisions' => 'المقالات ذات أقل تعديل',

# Miscellaneous special pages
'nbytes'                  => '{{PLURAL:$1|بايت واحد|$1 بايت|$1 بايت|$1 بايت}}',
'ncategories'             => '{{PLURAL:$1|تصنيف واحد|تصنيفان|$1 تصنيفات|$1 تصنيف|$1 تصنيفا}}',
'nlinks'                  => '{{PLURAL:$1|وصلة واحدة|وصلتان|$1 وصلات|$1 وصلة}}',
'nmembers'                => '{{PLURAL:$1|عضو واحد|عضوان|$1 أعضاء|$1 عضو|$1 عضوا}}',
'nrevisions'              => '{{PLURAL:$1|تعديل وحيد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'nviews'                  => '{{PLURAL:$1|مشاهدة واحدة|مشاهدتان|$1 مشاهدات|$1 مشاهدة}}',
'specialpage-empty'       => 'هذه الصفحة فارغة.',
'lonelypages'             => 'صفحات يتيمة',
'lonelypagestext'         => 'الصفحات التالية لا تصل إليها أيا من صفحات الويكي الأخرى.',
'uncategorizedpages'      => 'صفحات غير مصنفة',
'uncategorizedcategories' => 'تصنيفات غير مصنفة',
'uncategorizedimages'     => 'صور غير مصنفة',
'uncategorizedtemplates'  => 'قوالب غير مصنفة',
'unusedcategories'        => 'تصنيفات غير مستعملة',
'unusedimages'            => 'صور غير مستعملة',
'popularpages'            => 'صفحات مشهورة',
'wantedcategories'        => 'تصنيفات مطلوبة',
'wantedpages'             => 'صفحات مطلوبة',
'mostlinked'              => 'أكثر الصفحات المرتبطة بصفحات أخرى',
'mostlinkedcategories'    => 'أكثر التصنيفات ارتباطا',
'mostlinkedtemplates'     => 'أكثر القوالب وصلا',
'mostcategories'          => 'أكثر المقالات تصنيفا',
'mostimages'              => 'أكثر الصور ارتباطا',
'mostrevisions'           => 'أكثر الصفحات تعديلا',
'allpages'                => 'كل الصفحات',
'prefixindex'             => 'فهرس',
'randompage'              => 'صفحة عشوائية',
'randompage-nopages'      => 'لا توجد صفحات في هذا النطاق.',
'shortpages'              => 'صفحات قصيرة',
'longpages'               => 'صفحات طويلة',
'deadendpages'            => 'صفحات نهاية مسدودة',
'deadendpagestext'        => 'الصفحات التالية لا تحتوي على وصلات إلى صفحات أخرى بهذه الويكي.',
'protectedpages'          => 'صفحات محمية',
'protectedpagestext'      => 'الصفحات التالية محمية من التعديل أو النقل',
'protectedpagesempty'     => 'لا توجد صفحات محمية حاليا.',
'listusers'               => 'قائمة الأعضاء',
'specialpages'            => 'الصفحات الخاصة',
'spheading'               => 'الصفحات الخاصة لكل المستخدمين',
'restrictedpheading'      => 'صفحات خاصة للمخولين فقط',
'rclsub'                  => '(لصفحات تصل بها الصفحة "$1")',
'newpages'                => 'صفحات جديدة',
'newpages-username'       => 'اسم المستخدم:',
'ancientpages'            => 'أقدم الصفحات',
'intl'                    => 'وصلات بين لغات الموسوعة',
'move'                    => 'نقل',
'movethispage'            => 'انقل هذه الصفحة',
'unusedimagestext'        => '<p>الرجاء الانتباه إلى أن بعض الصور الموجودة في هذه القائمة قد يكون مشار إليها باستخدام العنوان الكامل (URL) وهي قيد الاستعمال بالرغم من إدراجها هنا.</p>',
'unusedcategoriestext'    => 'التصنيفات التالية موجودة على الرغم من أنها لا تحتوي على أية مقالات أو تصنيفات أخرى.',

# Book sources
'booksources'               => 'مصدر كتاب',
'booksources-search-legend' => 'البحث عن مصادر الكتب',
'booksources-isbn'          => 'ردمك:',
'booksources-go'            => 'اذهب',
'booksources-text'          => 'توجد أدناه قائمة بوصلات لمواقع أخرى تبيع الكتب الجديدة والمستعملة، أيضا يمكنك أن تحصل على معلومات إضافية عن الكتب التي تبحث عنها من هناك:',

'categoriespagetext' => 'التصنيفات التالية موجودة في الويكي.',
'data'               => 'بيانات',
'userrights'         => 'إدارة صلاحيات المستخدمين',
'groups'             => 'مجموعات المستخدمين',
'isbn'               => 'ردمك',
'alphaindexline'     => '$1 إلى $2',
'version'            => 'إصدار',

# Special:Log
'specialloguserlabel'  => 'المستخدم:',
'speciallogtitlelabel' => 'العنوان:',
'log'                  => 'سجلات',
'all-logs-page'        => 'كل السجلات',
'log-search-legend'    => 'ابحث عن سجلات',
'log-search-submit'    => 'اذهب',
'alllogstext'          => 'عرض شامل لكل السجلات المتوفرة في{{SITENAME}}. باستطاعتك جعل القائمة أكثر تحديدا وذلك باختيار نوع العملية، أو اسم المستخدم، أو الصفحات المتأثرة.',
'logempty'             => 'لا توجد مدخلات مطابقة في السجل.',
'log-title-wildcard'   => 'البحث عن عناوين تبدأ بهذا النص',

# Special:Allpages
'nextpage'          => 'الصفحة التالية ($1)',
'prevpage'          => 'الصفحة السابقة ($1)',
'allpagesfrom'      => 'عرض الصفحات بدءا من:',
'allarticles'       => 'كل المقالات',
'allinnamespace'    => 'كل الصفحات (في نطاق $1)',
'allnotinnamespace' => 'كل الصفحات (ليست في نطاق $1)',
'allpagesprev'      => 'السابق',
'allpagesnext'      => 'التالي',
'allpagessubmit'    => 'اذهب',
'allpagesprefix'    => 'عرض الصفحات التي تبدأ بـ:',
'allpagesbadtitle'  => 'العنوان المقترح للصفحة غير مقبول أو يضم لغات أخرى أو سابقة إنترويكي. يمكن أن يتضمن حروفا لا يمكن استعمالها للعناوين.',
'allpages-bad-ns'   => '{{SITENAME}} لا يوجد بها نطاق "$1".',

# Special:Listusers
'listusersfrom'      => 'عرض المستخدمين بدءا من:',
'listusers-submit'   => 'عرض',
'listusers-noresult' => 'لم يتم إيجاد مستخدم.',

# E-mail user
'mailnologin'     => 'لا يوجد عنوان للإرسال',
'mailnologintext' => 'يجب أن تقوم [[Special:Userlogin|بتسجيل الدخول]] وإدخال بريد إلكتروني صالح في صفحة [[Special:Preferences|التفضيلات]] لتتمكن من إرسال الرسائل لمستخدمين آخرين.',
'emailuser'       => 'أرسل رسالة لهذا المستخدم',
'emailpage'       => 'أرسل رسالة للمستخدم',
'emailpagetext'   => 'لو أن هذا المستخدم قد قام بإدخال عنوان بريدي صحيح في تفضيلاته،
فسيتم إرسال رسالة واحدة له بالنموذج أدناه.
العنوان الذي قمت أنت بإدخاله لك في تفضيلات المستخدم،
سيظهر في مكان المرسل في الرسالة التي سترسل له، ليتمكن من الرد عليك.',
'defemailsubject' => 'رسالة من {{SITENAME}}',
'noemailtitle'    => 'لا يوجد عنوان بريد إلكتروني',
'noemailtext'     => 'لم يحدد هذا المستخدم عنوان بريد إلكتروني صحيح،
أو طلب عدم استلام الرسائل من المستخدمين الآخرين.',
'emailfrom'       => 'من',
'emailto'         => 'إلى',
'emailsubject'    => 'العنوان',
'emailmessage'    => 'نص الرسالة',
'emailsend'       => 'إرسال',
'emailccme'       => 'أرسل لي بنسخة من رسالتي.',
'emailccsubject'  => 'نسخة من رسالتك إلى $1: $2',
'emailsent'       => 'تم إرسال الرسالة',
'emailsenttext'   => 'تم إرسال رسالتك الإلكترونية.',

# Watchlist
'watchlist'            => 'قائمة مراقبتي',
'mywatchlist'          => 'قائمة مراقبتي',
'watchlistfor'         => "(ل '''$1''')",
'nowatchlist'          => 'لا يوجد شيء في قائمة مراقبتك.',
'watchlistanontext'    => 'الرجاء $1 لعرض أو تعديل الصفحات في قائمة مراقبتك.',
'watchlistcount'       => "'''لديك $1 صفحة في قائمة مراقبتك ، متضمنة صفحات النقاش.'''",
'watchnologin'         => 'غير مسجل',
'watchnologintext'     => 'يجب أن تقوم  [[Special:Userlogin|بتسجيل الدخول]] لتتمكن من تعديل قائمة المراقبة لديك.',
'addedwatch'           => 'تمت الإضافة لقائمة المراقبة',
'addedwatchtext'       => 'تمت إضافة الصفحة  "$1" إلى [[Special:Watchlist|قائمة المراقبة]] خاصتك. سيتم وضع التغييرات القادمة على هذه الصفحة، وصفحة النقاش الخاصة بها سيتم وضعها هناك. وسيتم اظهار اسم الصفحة بخط <b>عريض</b> في صفحة [[Special:Recentchanges|أحدث التغييرات]] لتسهيل تحديدها واكتشافها.

إذا كنت تريد إزالة الصفحة من قائمة المراقبة لديك، اضغط على "توقف عن المراقبة" بالأعلى.',
'removedwatch'         => 'تمت الإزالة من قائمة المراقبة',
'removedwatchtext'     => 'تمت إزالة الصفحة "[[:$1]]" من قائمة مراقبتك.',
'watch'                => 'مراقبة',
'watchthispage'        => 'راقب هذه الصفحة',
'unwatch'              => 'إيقاف المراقبة',
'unwatchthispage'      => 'توقف عن مراقبة الصفحة',
'notanarticle'         => 'ليست صفحة محتوى',
'watchnochange'        => 'لم يتم تعديل أي صفحة في قائمة المراقبة لديك خلال الفترة المحددة.',
'watchlist-details'    => 'لديك $1 صفحة في قائمة مراقبتك (بدون عد صفحات النقاش).',
'wlheader-enotif'      => '* خاصية الإعلام بالبريد الإلكتروني مفعلة.',
'wlheader-showupdated' => "* الصفحات التي تم تحريرها بعد زيارتك لها لآخر مرة معروضة بالخط '''العريض'''",
'watchmethod-recent'   => 'فحص التعديلات الأخيرة للصفحات المراقبة',
'watchmethod-list'     => 'إظهار التحريرات في الصفحات المراقبة',
'watchlistcontains'    => 'تحتوي قائمة مراقبتك على $1 {{PLURAL:$1|صفحة|صفحات}}.',
'iteminvalidname'      => "مشكلة في المدخل '$1'، اسم غير صحيح...",
'wlnote'               => 'في الأسفل آخر $1 تعديل في آخر <b>$2</b> ساعة.',
'wlshowlast'           => 'عرض آخر $1 ساعات $2 أيام $3',
'wlsaved'              => 'هذه نسخة مخزنة من قائمة مراقبتك.',
'watchlist-show-bots'  => 'عرض تعديلات البوتات',
'watchlist-hide-bots'  => 'إخفاء تعديلات البوتات',
'watchlist-show-own'   => 'عرض تعديلاتي',
'watchlist-hide-own'   => 'إخفاء تعديلاتي',
'watchlist-show-minor' => 'عرض التعديلات الطفيفة',
'watchlist-hide-minor' => 'إخفاء التعديلات الطفيفة',

# Displayed when you click the "watch" button and it's in the process of watching
'watching'   => 'مراقبة...',
'unwatching' => 'إزالة المراقبة...',

'enotif_mailer'                => 'نظام {{SITENAME}} البريدي للملاحظات',
'enotif_reset'                 => 'اعتبر كل الصفحات تم زيارتها',
'enotif_newpagetext'           => 'هذه صفحة جديدة.',
'enotif_impersonal_salutation' => '{{SITENAME}} مستخدم',
'changed'                      => 'تم التغيير',
'created'                      => 'أنشأ',
'enotif_subject'               => 'صفحة {{SITENAME}} $PAGETITLE تم $CHANGEDORCREATED بواسطة $PAGEEDITOR',
'enotif_lastvisited'           => 'انظر $1 لمراجعة كل التغييرات منذ زيارتك الأخيرة.',
'enotif_lastdiff'              => 'انظر $1 لرؤية هذا التغيير.',
'enotif_anon_editor'           => 'مستخدم مجهول $1',
'enotif_body'                  => 'عزيزي $WATCHINGUSERNAME،

إن صفحة $PAGETITLE في {{SITENAME}} قد تغيرت إلى $CHANGEDORCREATED من قبل $PAGEEDITOR، لرؤية النسخة الحالية من الصفحة انظر هنا: $PAGETITLE_URL.

$NEWPAGE

ملخص التحرير: $PAGESUMMARY $PAGEMINOREDIT

اتصل بالمستخدم المحرر:
بريد إلكتروني: $PAGEEDITOR_EMAIL
صفحة المستخدم: $PAGEEDITOR_WIKI

لن يكون هنالك أي إخطارات أخرى عن أية تغييرات تتم في المستقبل إلا إذا زرت هذه الصفحة. يمكنك أيضا أن تعيد تصفير عداد الإخطارات لجميع الصفحات التي تراقبها في قائمة مراقبتك.

رسالة إرشادية من {{SITENAME}}

--
لتغيير قائمة مراقبتك اذهب إلى:
{{fullurl:{{ns:special}}:Watchlist/edit}}

للاقتراحات والحصول على مساعدة إضافية:
{{fullurl:{{MediaWiki:helppage}}}}',

# Delete/protect/revert
'deletepage'                  => 'احذف الصفحة',
'confirm'                     => 'تأكيد',
'excontent'                   => "المحتوى كان: '$1'",
'excontentauthor'             => "المحتوى كان: '$1' (و المساهم الوحيد كان '$2')",
'exbeforeblank'               => "المحتوى قبل الإفراغ كان: '$1'",
'exblank'                     => 'الصفحة كانت فارغة',
'confirmdelete'               => 'تأكيد الحذف',
'deletesub'                   => '(حذف "$1")',
'historywarning'              => 'تحذير: هذه الصفحة التي توشك على حذفها تحتوي على تغييرات سابقة:',
'confirmdeletetext'           => 'أنت على وشك أن تقوم بحذف صفحة أو صورة بالإضافة إلى جميع التعديلات عليها بشكل دائم من قاعدة البيانات. الرجاء التأكد من عزمك على الحذف وبأنك مدرك لنتائج هذه العملية. عمليات الحذف يجب أن تتم بناء على [[{{MediaWiki:policy-url}}|القواعد المتفق عليها]].',
'actioncomplete'              => 'انتهاء العملية',
'deletedtext'                 => '"$1" تم حذفها.
انظر في $2 لسجل آخر عمليات الحذف.',
'deletedarticle'              => 'تم حذف "[[$1]]"',
'dellogpage'                  => 'سجل الحذف',
'dellogpagetext'              => 'بالأسفل قائمة بأحدث عمليات الحذف.',
'deletionlog'                 => 'سجل الحذف',
'reverted'                    => 'استرجع لنسخة أقدم',
'deletecomment'               => 'سبب الحذف',
'imagereverted'               => 'الاسترجاع لنسخة أقدم كان ناجحا.',
'rollback'                    => 'استرجاع التعديلات',
'rollback_short'              => 'استرجاع',
'rollbacklink'                => 'استرجاع',
'rollbackfailed'              => 'لم ينجح الاسترجاع',
'cantrollback'                => 'لم ينجح الاسترجاع فآخر مساهم هو المستخدم الوحيد الذي عدل هذه الصفحة.',
'alreadyrolled'               => 'لم ينجح استرجاع آخر تعديل لصفحة [[$1]] من قبل [[User:$2|$2]] ([[User talk:$2|نقاش]]) لأن هنالك من قام بتعديل أو استرجاع هذه الصفحة من قبل.

آخر تعديل كان بواسطة [[User:$3|$3]] ([[User talk:$3|نقاش]]).',
'editcomment'                 => 'ملاحظة التحرير كانت: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => 'استرجع تعديلات [[Special:Contributions/$2|$2]] ([[User talk:$2|نقاش]])؛ استرجع حتى تعديل [[User:$1|$1]]',
'rollback-success'            => 'استرجع تعديلات $1؛ استرجع حتى آخر نسخة بواسطة $2.',
'sessionfailure'              => 'يبدو أن هنالك مشكلة في هذه الجلسة الخاصة بك؛ لذلك فقد ألغيت هذه العملية كإجراء احترازي ضد الاختراق. الرجاء الضغط على مفتاح "العودة" (Back) للرجوع للصفحة التي جئت منها ثم قم بإعادة تحميلها قبل المحاولة مرة أخرى.',
'protectlogpage'              => 'سجل الحماية',
'protectlogtext'              => 'بالأسفل قائمة بالصفحات التي تمت حمايتها أو إزالة الحماية عنها. للمزيد من المعلومات انظر [[Special:Protected page|قائمة الصفحات المحمية]].',
'protectedarticle'            => 'تمت حماية "[[$1]]"',
'modifiedarticleprotection'   => 'غير مستوى الحماية ل‍ "[[$1]]"',
'unprotectedarticle'          => 'إزالة حماية [[$1]]',
'protectsub'                  => '(حماية "$1")',
'confirmprotect'              => 'تأكيد الحماية',
'protectcomment'              => 'تعليق:',
'protectexpiry'               => 'تنتهي في:',
'protect_expiry_invalid'      => 'وقت انتهاء المنع غير صحيح.',
'protect_expiry_old'          => 'وقت انتهاء المنع يقع في الماضي.',
'unprotectsub'                => '(إزالة حماية "$1")',
'protect-unchain'             => 'فصل سماح النقل',
'protect-text'                => 'يمكنك هنا أن تعرض و تغير مستوى الحماية للصفحة <strong>$1</strong>.',
'protect-locked-blocked'      => 'لا يمكنك تغيير مستويات الحماية وأنت ممنوع.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-locked-dblock'       => 'لا يمكن تغيير مستويات الحماية بسبب غلق قاعدة البيانات حاليا.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-locked-access'       => 'لا يملك حسابك هذا صلاحية تغيير مستوى حماية الصفحة.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-cascadeon'           => 'هذه الصفحة محمية لكونها مضمنة في {{PLURAL:$1|الصفحة|الصفحات}} التالية، والتي بها خيار حماية الصفحات المدمجة فعال. يمكنك تغيير مستوى حماية هذه الصفحة بدون التأثير على حماية الصفحات المدمجة الأخرى.',
'protect-default'             => 'السماح لجميع المستخدمين',
'protect-level-autoconfirmed' => 'منع المستخدمين غير المسجلين',
'protect-level-sysop'         => 'مدراء النظام فقط',
'protect-summary-cascade'     => 'cascading',
'protect-expiring'            => 'تنتهي في $1 (UTC)',
'protect-cascade'             => 'حماية الصفحات المدمجة بهذه الصفحة',
'restriction-type'            => 'سماح:',
'restriction-level'           => 'مستوى الضوابط:',
'minimum-size'                => 'الحجم الأدنى',
'maximum-size'                => 'الحجم الأقصى',
'pagesize'                    => '(بايت)',

# Restrictions (nouns)
'restriction-edit' => 'تعديل',
'restriction-move' => 'نقل',

# Restriction levels
'restriction-level-sysop'         => 'حماية كاملة',
'restriction-level-autoconfirmed' => 'حماية جزئية',
'restriction-level-all'           => 'أي مستوى',

# Undelete
'undelete'                 => 'معاينة الصفحات المحذوفة',
'undeletepage'             => 'استعراض واسترجاع الصفحات المحذوفة',
'viewdeletedpage'          => 'عرض الصفحات المحذوفة',
'undeletepagetext'         => 'تم حذف الصفحات التالية و لكنها مازلت في الأرشيف و يمكن استرجاعها. يمكن مسح الأرشيف بشكل دوري.',
'undeleteextrahelp'        => "لاسترجاع الصفحة كاملة، اترك جميع الصناديق فارغة
و اضغط '''''استرجاع'''''. للاسترجاع بشكل انتقائي، ضع علامة في الصناديق أمام التعديلات التي تريد استرجاعها، و اضغط '''''استرجاع'''''. الضغط على '''''إلغاء''''' سيؤدي إلى إفراغ التعليق و حذف جميع العلامات من الصناديق.",
'undeleterevisions'        => '$1 نسخة تم أرشفتها',
'undeletehistory'          => 'استرجاع هذه الصفحة يؤدي إلى استرجاع جميع التغييرات المخزنة في تاريخ الصفحة. إذا كان هنالك صفحة جديدة تحمل نفس الاسم، فإن التغييرات القديمة سوف تدمج في تاريخ الصفحة الجديدة.',
'undeletehistorynoadmin'   => 'لقد تم حذف هذه الصفحة للأسباب المدرجة في الأسفل. إلى جانب أسباب الحذف يمكن رؤية المستخدمين الذين قاموا بالتعديل على هذه الصفحة قبل حذفها. بإمكان الإداريين فقط رؤية المحتويات الأصلية للمقال والتعديلات عليها.',
'undelete-revision'        => 'النسخة المحذوفة لصفحة $1 بتاريخ $2:',
'undeleterevision-missing' => 'نسخة غير صحيحة أو مفقودة. ربما لديك وصلة سيئة، أو ربما النسخة تم استرجاعها أو إزالتها من الأرشيف.',
'undeletebtn'              => 'استرجاع',
'undeletereset'            => 'إلغاء',
'undeletecomment'          => 'تعليق:',
'undeletedarticle'         => 'تم استرجاع "[[$1]]"',
'undeletedrevisions'       => 'تم استرجاع {{PLURAL:$1|تعديل واحد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'undeletedrevisions-files' => '$1 مراجعة و $2 ملف تم استرجاعها',
'undeletedfiles'           => '{{PLURAL:$1|ملف|ملفات}} $1 تم استرجاع',
'cannotundelete'           => 'فشل الاسترجاع؛ ربما قام شخص آخر باسترجاع الصفحة بالفعل.',
'undeletedpage'            => "<big>'''تم استرجاع $1'''</big>

راجع [[Special:Log/delete|سجل الحدف]] لمعاينة عمليات الحذف و الاسترجاعات الحديثة.",
'undelete-header'          => 'انظر الصفحات المحذوفة حديثا في [[Special:Log/delete|سجل الحذف]].',
'undelete-search-box'      => 'ابحث في الصفحات المحذوفة',
'undelete-search-prefix'   => 'عرض الصفحات التي تبدأ بـ:',
'undelete-search-submit'   => 'ابحث',
'undelete-no-results'      => 'لم يتم العثور على صفحات بهذه المواصفات في أرشيف المحذوفات',

# Namespace form on various pages
'namespace' => 'النطاق:',
'invert'    => 'عكس الاختيار',

# Contributions
'contributions' => 'مساهمات المستخدم',
'mycontris'     => 'مساهماتي',
'contribsub2'   => 'للمستخدم $1 ($2)',
'nocontribs'    => 'لا توجد تعديلات تطابق هذه المحددات.',
'ucnote'        => 'في الأسفل ستجد آخر <b>$1</b> تعديل لهذا المستخدم في <b>$2</b> أيام.',
'uclinks'       => 'عرض آخر $1 تعديل;  عرض آخر $2 يوم.',
'uctop'         => ' (أعلى)',
'month'         => 'من شهر (و أقدم):',
'year'          => 'من سنة (و أقدم):',

'sp-contributions-newest'      => 'آخر',
'sp-contributions-oldest'      => 'أول',
'sp-contributions-newer'       => '$1 التالية',
'sp-contributions-older'       => '$1 السابقة',
'sp-contributions-newbies'     => 'عرض فقط المساهمات للحسابات الجديدة',
'sp-contributions-newbies-sub' => 'للمبتدئين',
'sp-contributions-blocklog'    => 'سجل المنع',
'sp-contributions-search'      => 'بحث عن مساهمات',
'sp-contributions-username'    => 'عنوان أيبي أو اسم مستخدم:',
'sp-contributions-submit'      => 'بحث',

'sp-newimages-showfrom' => 'أظهر الصور الجديدة انطلاقا من $1',

# What links here
'whatlinkshere'       => 'ماذا يصل هنا',
'notargettitle'       => 'لا هدف',
'notargettext'        => 'لم تحدد الصفحة او المستخدم المستهدف
لعمل هذه الخاصية.',
'linklistsub'         => '(قائمة الوصلات)',
'linkshere'           => "الصفحات التالية تحتوي على وصلة إلى '''[[:$1]]''':",
'nolinkshere'         => "لا توجد صفحات تصل إلى '''[[:$1]]'''.",
'nolinkshere-ns'      => "لا تصل أي صفحة إلى '''[[:$1]]''' في النطاق المختار.",
'isredirect'          => 'صفحة تحويل',
'istemplate'          => 'مضمن',
'whatlinkshere-prev'  => '{{PLURAL:$1|السابق|الـ $1 السابقة}}',
'whatlinkshere-next'  => '{{PLURAL:$1|القادمة|الـ $1 القادمة}}',
'whatlinkshere-links' => '← وصلات',

# Block/unblock
'blockip'                     => 'منع مستخدم',
'blockiptext'                 => 'استخدم الاستمارة أدناه لمنع عنوان أيبي
أو مستخدم مسجل من الكتابة.
يجب أن يتم هذا فقط لمنع التخريب ومتوافقا مع
[[{{MediaWiki:policy-url}}|السياسة]] المتبعة هنا.
قم بذكر السبب أدناه (كمثال، اذكر بعض الصفحات التي قام بتخريبها تحديدا).',
'ipaddress'                   => 'عنوان الأيبي:',
'ipadressorusername'          => 'عنوان الأيبي أو اسم المستخدم:',
'ipbexpiry'                   => 'مدة المنع:',
'ipbreason'                   => 'السبب:',
'ipbreasonotherlist'          => 'سبب آخر',
'ipbreason-dropdown'          => '*أسباب المنع الشائعة
** كتابة معلومات زائفة
** إزالة المحتوى من الصفحات
** سخام وصلات لمواقع خارجية
** كتابة كلام لا معنى له في الصفحات
** سلوك عدواني
** إساءة استخدام حسابات متعددة
** اسم مستخدم غير مقبول',
'ipbanononly'                 => 'منع المستخدمين المجهولين فقط',
'ipbcreateaccount'            => 'منع إنشاء الحسابات',
'ipbemailban'                 => 'منع المستخدم من إرسال بريد إلكتروني',
'ipbenableautoblock'          => 'امنع عناوين الأيبي المستخدمة بواسطة هذا المستخدم',
'ipbsubmit'                   => 'امنع هذا المستخدم',
'ipbother'                    => "مدة المنع (عن اختيار ''غير ذلك'')",
'ipboptions'                  => 'ربع ساعة:15 minutes,ساعة كاملة:1 hour,ساعتين:2 hours,يوم:1 day,ثلاثة أيام:3 days,أسبوع:1 week,أسبوعان:2 weeks,شهر:1 month,ثلاثة شهور:3 months,ستة شهور:6 months,عام كامل:1 year,دائم:infinite',
'ipbotheroption'              => 'غير ذلك',
'ipbotherreason'              => 'سبب إضافي:',
'ipbhidename'                 => 'إخفاء اسم/عنوان المستخدم من سجل المنع وسجل المنع الحالي وقائمة المستخدمين',
'badipaddress'                => 'عنوان أيبي خاطئ',
'blockipsuccesssub'           => 'تم المنع بنجاح',
'blockipsuccesstext'          => 'تم منع [[Special:Contributions/$1|$1]].
<br />انظر [[Special:Ipblocklist|قائمة منع الأيبي]] لمراجعة حالات المنع.',
'ipb-edit-dropdown'           => 'عدل أسباب المنع',
'ipb-unblock-addr'            => 'رفع منع $1',
'ipb-unblock'                 => 'رفع المنع عن مستخدم أو عنوان أيبي',
'ipb-blocklist-addr'          => 'عرض المنع الحالي لـ $1',
'ipb-blocklist'               => 'عرض حالات المنع الحالية',
'unblockip'                   => 'إزالة منع مستخدم',
'unblockiptext'               => 'استخدم الحقل أدناه لاسترجاع صلاحية الكتابة
الخاصة بعنوان أيبي أو مستخدم تم سحبها منه مسبقا.',
'ipusubmit'                   => 'رفع منع هذا العنوان',
'unblocked'                   => 'تم  رفع منع [[مستخدم:$1|$1]]',
'unblocked-id'                => 'منع $1 تم رفعه',
'ipblocklist'                 => 'قائمة أسماء الأعضاء و عناوين الأيبي الممنوعة',
'ipblocklist-submit'          => 'بحث',
'blocklistline'               => '$1, $2 منع $3 ($4)',
'infiniteblock'               => 'غير محدد',
'expiringblock'               => 'ينتهي في $1',
'anononlyblock'               => 'مجهول فقط',
'noautoblockblock'            => 'المنع التلقائي معطل',
'createaccountblock'          => 'إنشاء الحسابات ممنوع.',
'emailblock'                  => 'البريد الإلكتروني ممنوع',
'ipblocklist-empty'           => 'قائمة المنع فارغة.',
'ipblocklist-no-results'      => 'عنوان الأيبي أو اسم المستخدم المطلوب غير ممنوع.',
'blocklink'                   => 'منع مستخدم',
'unblocklink'                 => 'رفع المنع',
'contribslink'                => 'مساهمات',
'autoblocker'                 => 'تم منعك تلقائيا لأن الأيبي الخاص بك تم استخدامه مؤخرا بواسطة المستخدم "[[مستخدم:$1|$1]]". سبب منع $1 هو: "\'\'\'$2\'\'\'"',
'blocklogpage'                => 'سجل المنع',
'blocklogentry'               => 'منع "[[$1]]" لفترة زمنية مدتها $2 $3',
'blocklogtext'                => 'السجل التالي يبين عمليات منع التحرير وإزالة المنع عن المستخدمين. عناوين الأيبي التي تم منعها تلقائيا ليست ضمن هذه القائمة. انظر [[Special:Ipblocklist|عناوين الأيبي الممنوعة]] لرؤية العناوين الممنوعة حاليا.',
'unblocklogentry'             => 'رفع منع $1',
'block-log-flags-anononly'    => 'المستخدمون المجهولون فقط',
'block-log-flags-nocreate'    => 'منع إنشاء حساب',
'block-log-flags-noautoblock' => 'المنع التلقائي معطل',
'block-log-flags-noemail'     => 'البريد الإلكتروني ممنوع',
'range_block_disabled'        => 'إمكانية الإداري لمنع نطاق معطلة.',
'ipb_expiry_invalid'          => 'تاريخ انتهاء المنع غير صحيح.',
'ipb_already_blocked'         => 'سبق منع "$1"',
'ip_range_invalid'            => 'نطاق عناوين الأيبي المدخل غير صحيح.',
'proxyblocker'                => 'مانع البروكسي',
'ipb_cant_unblock'            => 'خطأ: لم يتم إيجاد الممنوع $1. ربما تم رفع منعه بالفعل.',
'proxyblockreason'            => 'تم منع عنوان الأيبي الخاص بك لكونه بروكسي مفتوح. قم بمراسلة مزود خدمة الإنترنت الخاص بك أو الدعم الفني وأعلمهم بهذه المشكلة الأمنية.',
'proxyblocksuccess'           => 'تم الأمر.',
'sorbsreason'                 => 'هذا الأيبي تم إدراجه كبروكسي مفتوح في DNSBL.',
'sorbs_create_account_reason' => 'هذا الأيبي تم إدراجه كبروكسي مفتوح في DNSBL. لا يمكنك إنشاء حساب',

# Developer tools
'lockdb'              => 'أقفل قاعدة البيانات',
'unlockdb'            => 'افتح قاعدة البيانات',
'lockdbtext'          => 'إغلاق قاعدة البيانات سوف يمنع جميع المستخدمين من تحرير الصفحات وتغيير التفضيلات الخاصة بهم وتعديل قائمة المراقبة وغير ذلك من الأمور المتطلبة التعديل على قاعدة البيانات. الرجاء التأكد من أن هذا حقا ما ترغب القيام به، ومن أنك سوف تقوم بإزالة الغلق بعد الانتهاء من الصيانة.',
'unlockdbtext'        => 'فتح قاعدة البيانات سيسترجع قدرة كل المستخدمين على تحرير الصفحات، تغيير تفضيلاتهم
، تعديل قوائم المراقبة الخاصة بهم، و
أشياء أخرى تحتاج التغيير في قاعدة البيانات.
من فضلك أكد أن هذا هو ما تريده.',
'lockconfirm'         => 'نعم، أنا متأكد أني أريد قفل قاعدة البيانات.',
'unlockconfirm'       => 'نعم، أريد فعلا فتح قاعدة البيانات.',
'lockbtn'             => 'أقفل قاعدة البيانات',
'unlockbtn'           => 'فتح قاعدة البيانات',
'locknoconfirm'       => 'لم تقم باختيار خانة التأكيد.',
'lockdbsuccesssub'    => 'نجح إقفال قاعدة البيانات',
'unlockdbsuccesssub'  => 'تم إزالة قفل قاعدة البيانات',
'lockdbsuccesstext'   => 'لقد أغلقت قاعدة البيانات.
<br />تذكر بأن تزيل الغلق بعد اكتمال أعمال الصيانة.',
'unlockdbsuccesstext' => 'تم إعادة فتح قاعدة البيانات',
'lockfilenotwritable' => 'ملف غلق قاعدة البيانات لا يمكن الكتابة عليه. لغلق قاعدة البيانات أو إزالة الغلق يجب أن يكون هذا الملف قابلا للكتابة من قبل الخادم.',
'databasenotlocked'   => 'قاعدة البيانات ليست مغلقة.',

# Move page
'movepage'                => 'نقل صفحة',
'movepagetext'            => "باستعمال النموذج أدناه بإمكانك أن تغير اسم الصفحة، وأن تنقل تاريخها للاسم الجديد.
سيتم إنشاء تحويلة من العنوان القديم للصفحة بالعنوان الجديد. لكن، لن يتم تغيير الوصلات في الصفحات التي تتصل بهذه الصفحة، لذا عليك التأكد من عدم وجود وصلات مقطوعة، أو وصلات متتالية، للتأكد من أن المقالات تتصل مع بعضها بشكل مناسب.

يرجى الملاحظة أنه '''لن يتمّ''' نقل الصفحة إذا وجدت صفحة بالاسم الجديد، إلا إذا كانت صفحة فارغة، أو صفحة تحويل، ولا تاريخ لها. وهذا يعني أنك لا تستطيع وضع صفحة مكان صفحة، كما أنه من الممكن ارجاع الصفحة لمكانها في حال تم النقل بشكل خاطئ.

<b>تحذير!</b> قد يكون لنقل الصفحة آثار كبيرة، وتغييرات غير متوقع بالنسبة للصفحات المشهورة. يرجى فهم وإدارك عواقب نقل الصفحات قبل القيام به.",
'movepagetalktext'        => 'صفحة النقاش المرفقة بالمقالة سيتم نقلها كذلك، إذا وجدت. ولكن لا يتم نقل صفحة النقاش في الحالات التالية:
* نقل الصفحة عبر نطاقات  مختلفة.
* يوجد صفحة نقاش غير فارغة تحت العنوان الجديد للمقالة.
* قمت بإزالة اختيار نقل صفحة النقاش في الأسفل.

وفي الحالات أعلاه، يجب عليك نقل أو دمج محتويات صفحة النقاش يدويا، إذا رغب في ذلك.',
'movearticle'             => 'انقل الصفحة',
'movenologin'             => 'غير مسجل',
'movenologintext'         => 'يجب أن تكون متسخدما مسجلا وأن تقوم [[Special:Userlogin|بالدخول]] لكي تنقل صفحة.',
'newtitle'                => 'إلى العنوان الجديد:',
'move-watch'              => 'راقب هذه الصفحة',
'movepagebtn'             => 'نقل الصفحة',
'pagemovedsub'            => 'تم النقل بنجاح',
'movepage-moved'          => '<big>\'\'\'"$1" تم نقلها إلى "$2"\'\'\'</big>', # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'           => 'توجد صفحة بهذا الاسم،
أو أن الاسم الذي تم اختياره غير صالح.
يرجى اختيار اسم آخر.',
'talkexists'              => "'''تم نقل الصفحة بنجاح، لكن لم
يتم نقل صفحة النقاش المرافقة، بسبب وجود صفحة نقاش
مسبقا تحت العنوان الجديد.
يرجى نقل محتويات صفحة النقاش يدويا، ودمجها مع المحتويات السابقة.
'''",
'movedto'                 => 'تم نقلها إلى',
'movetalk'                => 'انقل صفحة النقاش.',
'talkpagemoved'           => 'تم نقل صفحة النقاش أيضا.',
'talkpagenotmoved'        => '<strong>لم</strong> يتم نقل صفحة النقاش.',
'1movedto2'               => '[[$1]] تم نقلها إلى [[$2]]',
'1movedto2_redir'         => '[[$1]] تم نقلها فوق التحويلة إلى [[$2]]',
'movelogpage'             => 'سجل النقل',
'movelogpagetext'         => 'بالأسفل قائمة بالصفحات التي تم نقلها.',
'movereason'              => 'السبب:',
'revertmove'              => 'استرجاع',
'delete_and_move'         => 'احذف وانقل',
'delete_and_move_text'    => '==يستلزم الحذف==
هناك مقالة تحت الاسم - [[$1]] - الذي طلبت أن تنقل إليه هذه المقالة. هل ترغب بحذف تلك المقالة لإتمام عملية النقل؟',
'delete_and_move_confirm' => 'نعم، احذف الصفحة',
'delete_and_move_reason'  => 'حذف لإفساح مجال للنقل',
'selfmove'                => 'لا يوجد اختلاف في عنوان المصدر و الهدف؛ لا يمكن نقل الصفحة على نفسها.',
'immobile_namespace'      => 'لا يمكن النقل إلى العنوان المراد؛ النطاق غير مسموح بالنقل إليه.',

# Export
'export'            => 'صدّر صفحات',
'exporttext'        => 'يمكنك تصدير النص و تاريخ تعديلات صفحة أو مجموعة صفحات خاصة في صيغة إكس إم إل. وذلك بقصد استيرادها في ويكي آخر يستعمل ميدياويكي بواسطة الصفحة [[Special:Import|صفحة الاستيراد]].

لتصدير صفحات، اكتب العناوين في الصندوق أسفله، عنوان واحد في كل السطر، مع اختيار ما إذا كنت ترغب في النسخة الحالية بالإضافة إلى النسخ القديمة كاملة أو مع معلومات تاريخ الصفحة عنها أو فقط النسخة الحالية مع معلومات عن التعديل الأخير.

في الحالة الأخيرة يمكنك استعمال وصلة مباشرة، كمثال [[{{ns:Special}}:Export/{{Mediawiki:mainpage}}]] للصفحة {{Mediawiki:mainpage}}.',
'exportcuronly'     => 'ضمن النسخة الحالية فقط، وليس تاريخ الصفحة بأكمله',
'exportnohistory'   => "----
ملاحظة:''' تم توقيف التصدير الكامل لتاريخ الصفحة بهذه الترسيمة لأسباب تحسينية'''",
'export-submit'     => 'تصدير',
'export-addcattext' => 'إضافة صفحات من تصنيف:',
'export-addcat'     => 'إضافة',

# Namespace 8 related
'allmessages'               => 'رسائل النظام',
'allmessagesname'           => 'الاسم',
'allmessagesdefault'        => 'النص الافتراضي',
'allmessagescurrent'        => 'النص الحالي',
'allmessagestext'           => 'هذه قائمة برسائل النظام المتوفرة في نطاق ميدياويكي.',
'allmessagesnotsupportedUI' => 'لغة الواجهة الحالية الخاصة بك <b>$1</b> غير مدعمة في {{ns:special}}:Allmessages في هذا الموقع.',
'allmessagesnotsupportedDB' => "لا يمكن استخدام '''{{ns:special}}:Allmessages''' لأن المتغير '''\$wgUseDatabaseMessages''' غير مشغل.",
'allmessagesfilter'         => 'بحث باسم الرسالة:',
'allmessagesmodified'       => 'اعرض المتغير فقط',

# Thumbnails
'thumbnail-more'           => 'تكبير',
'missingimage'             => '<b>صورة غير موجودة</b><br /><i>$1</i>',
'filemissing'              => 'الملف مفقود',
'thumbnail_error'          => 'خطأ في إنشاء صورة مصغرة:  $1',
'thumbnail_dest_directory' => 'غير قادر على إنشاء المجلد الهدف',

# Special:Import
'import'                     => 'استيراد صفحات',
'importinterwiki'            => 'استيراد ويكي',
'import-interwiki-text'      => 'اختر الويكي و عنوان الصفحة المطلوب استيرادها.
تواريخ التعديلات و أسماء المحررين سيتم الحفاظ عليها.
كل عمليات الاستيراد عبر مواقع الويكي يتم تسجيلها في [[Special:Log/import|سجل الاستيراد]].',
'import-interwiki-history'   => 'انسخ تاريخ الصفحة كله',
'import-interwiki-submit'    => 'استيراد',
'import-interwiki-namespace' => 'انقل الصفحات إلى النطاق:',
'importtext'                 => 'من فضلك صدّر الملف من الويكي المصدر عن طريق Special:Export، احفظها على جهازك ثم ارفعها هنا.',
'importstart'                => 'استيراد صفحات...',
'import-revision-count'      => '{{PLURAL:$1|نسخة واحدة|نسخة}} $1',
'importnopages'              => 'لا صفحات للاستيراد',
'importfailed'               => 'فشل استيراد: $1',
'importunknownsource'        => 'نوع مجهول لمصدر الاستيراد',
'importcantopen'             => 'لم يتمكن من فتح الملف المستورد',
'importbadinterwiki'         => 'وصلة إنترويكي خاطئة',
'importnotext'               => 'فارغ أو لا يحتوي على نص',
'importsuccess'              => 'تم الاستيراد بنجاح!',
'importhistoryconflict'      => 'هناك تاريخ تعديلات يتعارض مع تاريخ هذه الصفحة (ربما تكون قد استوردت الصفحة من قبل)',
'importnosources'            => 'لم يتم تحديد مصادر للاستيراد الويكي و الاستيراد المباشر عن طريق الرفع غير فعال.',
'importnofile'               => 'لم يتم رفع ملف استيراد.',
'importuploaderror'          => 'فشل رفع أو استيراد الملف، ربما الملف أكبر من الحجم المسموح به.',

# Import log
'importlogpage'                    => 'سجل الاستيراد',
'importlogpagetext'                => 'استيرادات إدارية (للإداريين فقط) لصفحات من مواقع ويكي أخرى.',
'import-logentry-upload'           => 'تم استيراد $1 عن طريق رفع ملف',
'import-logentry-upload-detail'    => 'تعديل(ات) $1',
'import-logentry-interwiki'        => 'استيراد ويكي $1',
'import-logentry-interwiki-detail' => 'تعديل(ات) من $2 $1',

# Tooltip help for the actions
'tooltip-pt-userpage'             => 'صفحتي الخاصة',
'tooltip-pt-anonuserpage'         => 'صفحة المستخدم للأيبي الذي تقوم بالتحرير من خلاله',
'tooltip-pt-mytalk'               => 'صفحة نقاشي',
'tooltip-pt-anontalk'             => 'نقاش حول التعديلات من عنوان الأيبي هذا',
'tooltip-pt-preferences'          => 'تفضيلاتي',
'tooltip-pt-watchlist'            => 'قائمة بالصفحات التي تقوم بمراقبة التغييرات التي تحدث فيها',
'tooltip-pt-mycontris'            => 'قائمة مساهماتي',
'tooltip-pt-login'                => 'من المفضل أن تقوم بتسجيل الدخول، هذا ليس إلزاميا.',
'tooltip-pt-anonlogin'            => 'من المفضل أن تقوم بتسجيل الدخول، هذا ليس إلزاميا.',
'tooltip-pt-logout'               => 'خروج',
'tooltip-ca-talk'                 => 'نقاش حول صفحة المحتوى',
'tooltip-ca-edit'                 => 'بإمكانك تعديل هذه الصفحة، برجاء استعمال زر عرض التعديلات قبل الحفظ',
'tooltip-ca-addsection'           => 'أضف تعليقا إلى هذا النقاش.',
'tooltip-ca-viewsource'           => 'هذه الصفحة محمية، يمكنك رؤية المصدر النصي لها.',
'tooltip-ca-history'              => 'النسخ السابقة من هذه الصفحة',
'tooltip-ca-protect'              => 'احم هذه الصفحة',
'tooltip-ca-delete'               => 'احذف هذه الصفحة',
'tooltip-ca-undelete'             => 'استرجاع التعديلات التي تمت على هذه الصفحة قبل حذفها',
'tooltip-ca-move'                 => 'انقل هذه الصفحة',
'tooltip-ca-watch'                => 'أضف هذه الصفحة إلى قائمة مراقبتك',
'tooltip-ca-unwatch'              => 'أزل هذه الصفحة من قائمة مراقبتك',
'tooltip-search'                  => 'ابحث في {{SITENAME}}',
'tooltip-p-logo'                  => 'الصفحة الرئيسية',
'tooltip-n-mainpage'              => 'مطالعة الصفحة الرئيسية',
'tooltip-n-portal'                => 'حول المشروع، ماذا يمكن أن تفعل، أين يمكن أن تجد ما تحتاجه',
'tooltip-n-currentevents'         => 'مطالعة سريعة لأهم الأخبار الحالية',
'tooltip-n-recentchanges'         => 'قائمة بأحدث التعديلات في الويكي.',
'tooltip-n-randompage'            => 'اعرض ضفحة عشوائية',
'tooltip-n-help'                  => 'تحتاج مساعدة؟ طالع هذه الصفحة!',
'tooltip-n-sitesupport'           => 'قم بدعمنا',
'tooltip-t-whatlinkshere'         => 'قائمة بكل الصفحات التي تصل هنا',
'tooltip-t-recentchangeslinked'   => 'أحدث التغييرات في الصفحات الموجودة وصلاتها هنا.',
'tooltip-feed-rss'                => 'تلقيم أر إس إس لهذه الصفحة',
'tooltip-feed-atom'               => 'تلقيم أتوم لهذه الصفحة',
'tooltip-t-contributions'         => 'عرض قائمة مساهمات هذا المستخدم',
'tooltip-t-emailuser'             => 'إرسال رسالة لهذا المستخدم',
'tooltip-t-upload'                => 'رفع صور أو ملفات وسائط أخرى',
'tooltip-t-specialpages'          => 'قائمة بكل الصفحات الخاصة',
'tooltip-t-print'                 => 'نسخة للطباعة لهذه الصفحة',
'tooltip-t-permalink'             => 'وصلة دائمة لهذه النسخة من الصفجة',
'tooltip-ca-nstab-main'           => 'عرض صفحة المحتوى',
'tooltip-ca-nstab-user'           => 'اعرض صفحة المستخدم',
'tooltip-ca-nstab-media'          => 'اعرض صفحة ملف الوسائط',
'tooltip-ca-nstab-special'        => 'هذه صفحة خاصة لا تستطيع أن تقوم بتعديلها',
'tooltip-ca-nstab-project'        => 'اعرض صفحة المشروع',
'tooltip-ca-nstab-image'          => 'اعرض صفحة الصورة',
'tooltip-ca-nstab-mediawiki'      => 'اعرض رسالة النظام',
'tooltip-ca-nstab-template'       => 'اعرض القالب',
'tooltip-ca-nstab-help'           => 'اعرض صفحة المساعدة',
'tooltip-ca-nstab-category'       => 'اعرض صفحة التصنيف',
'tooltip-minoredit'               => 'اجعل هذا التعديل تعديلا طفيفا',
'tooltip-save'                    => 'احفظ تغييراتك',
'tooltip-preview'                 => 'اعرض تعديلاتك، استخدم هذا من فضلك قبل الحفظ!',
'tooltip-diff'                    => 'شاهد ماذا تغير بالنص.',
'tooltip-compareselectedversions' => 'شاهد الفروقات بين النسختين المختارتين.',
'tooltip-watch'                   => 'أضف هذه الصفحة إلى قائمة مراقبتك',
'tooltip-recreate'                => 'أعد إنشاء الصفحة رغم كونها حذفت',

# Stylesheets
'common.css'   => '/** النظم المتراصة الموضوعة هنا سيتم تطبيقها على كل الواجهات  */',
'monobook.css' => '/* CSS المعروض هنا سيؤثر على مستخدمي Monobook skin */',

# Scripts
'common.js'   => '/* الجافاسكريبت الموضوع هنا سيتم تحميله لكل المستخدمين مع كل تحميل للصفحة. */',
'monobook.js' => '/* تم الاستغناء عنها؛ استخدم [[MediaWiki:common.js]] */',

# Metadata
'notacceptable' => 'لا يمكن لخادم الويكي تزويدك ببيانات بصيغة يستطيع عميلك قراءتها.',

# Attribution
'anonymous'        => 'مستخدم مجهول ل{{SITENAME}}',
'siteuser'         => 'مستخدم {{SITENAME}} $1',
'lastmodifiedatby' => 'آخر تعديل لهذه الصفحة كان في $2، $1 بواسطة $3.', # $1 date, $2 time, $3 user
'and'              => 'و',
'othercontribs'    => 'بناء على عمل $1.',
'others'           => 'أخرى',
'siteusers'        => '{{SITENAME}} مستخدم(و) $1',

# Spam protection
'spamprotectiontitle'    => 'مانع السخام',
'spamprotectiontext'     => 'تم منع حفظ الصفحة عن طريق مانع السخام. من المحتمل أن يكون هذا بسبب وصلة خارجية.',
'spamprotectionmatch'    => 'النص التالي هو ما نشط مانع السخام الخاص بنا: $1',
'subcategorycount'       => 'يوجد {{PLURAL:$1|تصنيف فرعي واحد|تصنيفان فرعيان|$1 تصنيفات فرعية|$1 تصنيف فرعي|$1 تصنيفا فرعيا}} في هذا التصنيف.',
'categoryarticlecount'   => 'يوجد {{PLURAL:$1|مقال واحد|مقالان|$1 مقالات|$1 مقال|$1 مقالا}} في هذا التصنيف.',
'category-media-count'   => 'يوجد {{PLURAL:$1|ملف واحد|$1 ملفات}} في هذا التصنيف.',
'listingcontinuesabbrev' => ' (متابعة)',
'spambot_username'       => 'تنظيف سخام ميدياويكي',
'spam_reverting'         => 'استرجاع آخر نسخة ليس بها وصلات إلى $1',
'spam_blanking'          => 'كل النسخ احتوت على وصلات ل $1، إفراغ',

# Info page
'infosubtitle'   => 'معلومات الصفحة',
'numedits'       => 'عدد التحريرات (مقالة): $1',
'numtalkedits'   => 'عدد التعديلات (صفحة نقاش): $1',
'numwatchers'    => 'عدد المراقبين: $1',
'numauthors'     => 'عدد المحررين (مقالة): $1',
'numtalkauthors' => 'عدد المستخدمين المحررين للصفحة (صحفة نقاش): $1',

# Math options
'mw_math_png'    => 'دائمًا اعرض على هيئة PNG',
'mw_math_simple' => 'اعرض على هيئة HTML للصيغ البسيطة جدا، وإلا فاعرض بهئية PNG',
'mw_math_html'   => 'اعرض بصيغة HTML إن أمكن، وإلا فاعرض كهيئة PNG',
'mw_math_source' => 'اعرض على هيئة TeX (للمتصفحات النصية)',
'mw_math_modern' => 'مستحسن للمتصفحات الحديثة',
'mw_math_mathml' => 'اعرض بصيغة MathML إن أمكن (تحت التجريب)',

# Patrolling
'markaspatrolleddiff'                 => 'تمت مراجعتها',
'markaspatrolledtext'                 => 'هذه المقالة تمت مراجعتها',
'markedaspatrolled'                   => 'تمت مراجعتها',
'markedaspatrolledtext'               => 'تم الإشارة إلى النسخة المختارة كمراجعة.',
'rcpatroldisabled'                    => 'مراجعة أحدث التغييرات معطلة',
'rcpatroldisabledtext'                => 'خاصية مراجعة أحدث التغييرات معطلة حاليا',
'markedaspatrollederror'              => 'لا يمكن الإشارة بالمراجعة',
'markedaspatrollederrortext'          => 'يجب عليك اختيار النسخة التي تريد أن تشير أنها مراجعة',
'markedaspatrollederror-noautopatrol' => 'لا يمكن السماح لك بالإشارة إلى تعديلاتك الشخصية كتعديلات تمت مراجعتها.',

# Patrol log
'patrol-log-page' => 'سجل المراجعة',
'patrol-log-line' => 'قام بمراجعة $1 من صفحة $2 $3',
'patrol-log-auto' => '(تلقائيا)',
'patrol-log-diff' => 'ن$1',

# Image deletion
'deletedrevision' => 'حذف التعديل القديم $1.',

# Browsing diffs
'previousdiff' => '→ الفرق السابق',
'nextdiff'     => 'الفرق اللاحق ←',

# Media information
'mediawarning'         => "'''تحذير''': هذا الملف يحتوي على كود خبيث، يمكن عند تشغيله السيطرة على نظامك.<hr />",
'imagemaxsize'         => 'حجم الصورة في صفحة وصفها:',
'thumbsize'            => 'حجم العرض المصغر:',
'file-info'            => '(حجم الملف: $1, نوع الملف: $2)',
'file-info-size'       => '($1 × $2 بيكسل, حجم الملف: $3, نوع الملف: $4)',
'file-nohires'         => '<small>لا توجد دقة أعلى متوفرة.</small>',
'show-big-image'       => 'الصورة بدقة أعلى',
'show-big-image-thumb' => '<small>حجم هذا العرض: $1 × $2 بيكسل</small>',

'newimages'    => 'معرض الصور الجديدة',
'showhidebots' => '($1 بوت)',
'noimages'     => 'لا يوجد محتوى ليتم عرضه.',

'passwordtooshort' => 'كلمة السر التي اخترتها قصيرة. يجب أن لا يقل طول الكلمة عن $1 حرف و أن تكون مختلفة عن اسم المستخدم الخاص بك.',

# Metadata
'metadata'          => 'معلومات الصورة (ميتا)',
'metadata-help'     => 'هذا الملف يحتوي معلومات إضافية، غالبا ما تكون أضيفت من قبل آلة التصوير الإلكترونية أو الماسح الضوئي المستخدم في تحميل الصورة إلى الحاسوب. إذا كان الملف قد عُدّل عما كان عليه عند رفع الصورة فإن  المعلومات الواردة هنا قد لا تعبر عن هذه الصورة المعدلة.',
'metadata-expand'   => 'إظهار معلومات إضافية',
'metadata-collapse' => 'إخفاء المعلومات الإضافية',

# EXIF tags
'exif-imagewidth'               => 'العرض',
'exif-imagelength'              => 'الطول',
'exif-orientation'              => 'التوجية',
'exif-samplesperpixel'          => 'عدد المكونات',
'exif-stripoffsets'             => 'موقع بيانات الصورة',
'exif-datetime'                 => 'تاريخ و وقت تغيير الملف',
'exif-imagedescription'         => 'عنوان الصورة',
'exif-make'                     => 'منتج آلة التصوير',
'exif-model'                    => 'نوع آلة التصوير',
'exif-software'                 => 'البرمجيات المستخدمة',
'exif-artist'                   => 'المؤلف',
'exif-copyright'                => 'مالك الحقوق المحفوظة',
'exif-exifversion'              => 'Exif نسخة',
'exif-componentsconfiguration'  => 'معنى كل مكون',
'exif-pixelydimension'          => 'عرض صورة صحيح',
'exif-pixelxdimension'          => 'ارتفاع صورة صحيح',
'exif-makernote'                => 'ملاحظات الصانع',
'exif-usercomment'              => 'تعليقات المستخدم',
'exif-relatedsoundfile'         => 'ملف صوتي مرتبط',
'exif-datetimeoriginal'         => 'تاريخ و وقت الإنتاج',
'exif-exposuretime'             => 'مدة التعرض',
'exif-exposuretime-format'      => '$1 ثانية ($2)',
'exif-shutterspeedvalue'        => 'سرعة الغالق',
'exif-brightnessvalue'          => 'السطوع',
'exif-lightsource'              => 'مصدر الضوء',
'exif-flash'                    => 'فلاش',
'exif-focallength'              => 'البعد البؤري للعدسة',
'exif-focallength-format'       => '$1 ملم',
'exif-flashenergy'              => 'طاقة الفلاش',
'exif-filesource'               => 'مصدر الملف',
'exif-scenetype'                => 'نوع المشهد',
'exif-customrendered'           => 'معالجة الصورة حسب الطّلب',
'exif-contrast'                 => 'التعارض',
'exif-devicesettingdescription' => 'وصف إعدادات الأداة',
'exif-gpssatellites'            => 'الأقمار الصناعية المستخدمة في القياس',
'exif-gpsstatus'                => 'حالة جهاز الاستقبال',
'exif-gpsdop'                   => 'دقة القياس',
'exif-gpsspeedref'              => 'وحدة السرعة',
'exif-gpstrackref'              => 'المرجع لاتجاه الحركة',
'exif-gpstrack'                 => 'اتجاه الحركة',
'exif-gpsimgdirectionref'       => 'المرجغ لاتجاه الصورة',
'exif-gpsimgdirection'          => 'اتجاه الصورة',
'exif-gpsdestdistanceref'       => 'المرجع للمسافة للهدف',
'exif-gpsdestdistance'          => 'المسافة للهدف',

# EXIF attributes
'exif-compression-1' => 'غير مضغوط',

'exif-unknowndate' => 'تاريخ غير معروف',

'exif-orientation-1' => 'وضعية طبيعية', # 0th row: top; 0th column: left

'exif-componentsconfiguration-0' => 'غير موجود',

'exif-exposureprogram-0' => 'غير معرف',
'exif-exposureprogram-1' => 'يدوي',
'exif-exposureprogram-2' => 'برنامج اعتيادي',

'exif-subjectdistance-value' => '$1 متر',

'exif-meteringmode-0'   => 'غير معروف',
'exif-meteringmode-1'   => 'متوسط',
'exif-meteringmode-3'   => 'بقعة',
'exif-meteringmode-5'   => 'نمط',
'exif-meteringmode-6'   => 'جزئي',
'exif-meteringmode-255' => 'غير ذلك',

'exif-lightsource-0'   => 'غير معروف',
'exif-lightsource-1'   => 'ضوء النهار',
'exif-lightsource-2'   => 'فلورسنت',
'exif-lightsource-4'   => 'فلاش',
'exif-lightsource-9'   => 'جو صحو',
'exif-lightsource-10'  => 'جو ملبد بالغيوم',
'exif-lightsource-11'  => 'ظل',
'exif-lightsource-17'  => 'ضوء قياسي A',
'exif-lightsource-18'  => 'ضوء قياسي B',
'exif-lightsource-19'  => 'ضوء قياسي C',
'exif-lightsource-255' => 'مصدر ضوء آخر',

'exif-focalplaneresolutionunit-2' => 'بوصة',

'exif-sensingmethod-1' => 'غير معرف',

'exif-scenetype-1' => 'صورة ملتقطة بشكل مباشر',

'exif-customrendered-0' => 'عملية طبيعية',
'exif-customrendered-1' => 'عملية حسب الطلب',

'exif-scenecapturetype-0' => 'قياسي',
'exif-scenecapturetype-2' => 'بورتريه',
'exif-scenecapturetype-3' => 'مشهد ليلي',

'exif-gaincontrol-0' => 'لا شيء',

'exif-contrast-0' => 'وضعية طبيعية',

'exif-saturation-0' => 'وضعية طبيعية',

'exif-sharpness-0' => 'وضعية طبيعية',

'exif-subjectdistancerange-0' => 'غير معروف',

'exif-gpsstatus-a' => 'عملية القياس الحالية',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'كيلومتر في الساعة',
'exif-gpsspeed-m' => 'ميل في الساعة',
'exif-gpsspeed-n' => 'عقد',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'الاتجاه الحقيقي',
'exif-gpsdirection-m' => 'الاتجاه المغناطيسي',

# External editor support
'edit-externally'      => 'عدل هذا الملف باستخدام تطبيق خارجي',
'edit-externally-help' => 'انظر [http://meta.wikimedia.org/wiki/Help:External_editors تعليمات الإعداد] لمزيد من المعلومات.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'الكل',
'imagelistall'     => 'الكل',
'watchlistall2'    => 'الكل',
'namespacesall'    => 'الكل',
'monthsall'        => 'الكل',

# E-mail address confirmation
'confirmemail'            => 'أكد عنوان البريد الإلكتروني',
'confirmemail_noemail'    => 'ليس لديك غنوان بريد إلكتروني صحيح مسجل في [[Special:Preferences|تفضيلاتك]].',
'confirmemail_text'       => 'هذا الموقع يتطلب تأكيد عنوانك الإلكتروني قبل استعمال خصائص البريد الإلكتروني. اضغط على زر التفعيل بالأسفل ليتم إرسال رسالة تأكيد لعنوانك. ستتضمن الرسالة رمز تفعيل، اضغط على الوصلة التي تحتوي الرمز لتأكيد أن عنوانك الإلكتروني صحيح.',
'confirmemail_pending'    => "<div class=\"error\">
'''تم إرسال كود التأكيد بالفعل من قبل إلى بريدك الإلكتروني، إذا كان حسابك قد تم عمله حالا، ربما يجب أن تنتظر بضع دقائق قبل طلبك لكود آخر.'''
</div>",
'confirmemail_send'       => 'أرسل رمز التفعيل',
'confirmemail_sent'       => 'تم إرسال رسالة التأكيد، شكرا لك.',
'confirmemail_oncreate'   => 'تم إرسال كود تأكيد لعنوان بريدك الإلكتروني.
لا يشترط أن تستخدم الكود للدخول للموسوعة باسمك، ولكن يجب أن تقوم بإدخاله قبل
استخدامك أيا من خواص البريد الإلكتروني المستخدمة هنا في الويكي.',
'confirmemail_sendfailed' => 'لم نستطع إرسال رسالة التأكيد. من فضلك، تأكد من بريدك الإلكتروني.

الخطأ الذي حدث: $1',
'confirmemail_invalid'    => 'رمز تفعيل خاطئ. ربما انتهت فترة صلاحيته.',
'confirmemail_needlogin'  => 'يجب عليك $1 لتأكيد البريد الإلكتروني الخاص بك.',
'confirmemail_success'    => 'تم تأكيد بريدك الإلكتروني، بإمكانك الآن الدخول و التمتع بالويكي.',
'confirmemail_loggedin'   => 'تم تأكيد بريدك الإلكتروني، شكرا لك.',
'confirmemail_error'      => 'ثمة شئ خطأ حدث عند محاولة حفظ تأكيدك.',
'confirmemail_subject'    => 'رسالة تأكيد البريد من {{SITENAME}}',
'confirmemail_body'       => 'شخصا ما, من المحتمل ان يكون أنت من العنوان $1 , قام بتسجيل 
حساب بهذا العنوان الإلكتروني على {{SITENAME}}, الحساب هو:

"$2"

لتأكيد أن هذا الحساب يخصك حقا و تريد تفعيل خواص البريد الإلكتروني به على {{SITENAME}}, افتح هذه الوصلة بمتصفحك:

$3

لو لم يكن هذا * أنت * , لا تضغط هذه الوصلة. رمز التفيعل سينتهي في $4.',

# Inputbox extension, may be useful in other contexts as well
'tryexact'       => 'ابحث عن عنوان مطابق',
'searchfulltext' => 'ابحث في النص الكامل',
'createarticle'  => 'إنشاء مقالة',

# Scary transclusion
'scarytranscludedisabled' => '[التضمين بالإنترويكي معطل]',
'scarytranscludetoolong'  => '[عنوان طويل للغاية؛ معذرة]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">
المتابعات الخاصة بهذه المقالة:<br />
$1
</div>',
'trackbackremove'   => ' ([$1 حذف])',
'trackbacklink'     => 'متابعة',
'trackbackdeleteok' => 'تم بنجاح إلغاء المتابعة.',

# Delete conflict
'deletedwhileediting' => "'''<span style=\"color:red;\">تحذير:</span> لقد تمّ حذف هذه الصفحة بعد أن بدأت بتعديلها.'''",
'confirmrecreate'     => "لقد قام المستخدم [[مستخدم:$1|$1]] ([[نقاش المستخدم:$1|نقاش]]) بحذف هذه المقالة بعد أن بدأت بتحريرها للسبب التالي:
:''$2''
الرجاء التأكد من أنك تريد إعادة إنشاء هذه المقالة.",
'recreate'            => 'أعد الإنشاء',

'unit-pixel' => 'بك',

# HTML dump
'redirectingto' => 'جاري التحويل إلى [[$1]]...',

# action=purge
'confirm_purge'        => 'امسح كاش هذه الصفحة؟

$1',
'confirm_purge_button' => 'تابع',

'youhavenewmessagesmulti' => 'لديك رسائل جديدة على $1',

'searchcontaining' => "ابحث عن المقالات التي تحتوي ''$1''.",
'searchnamed'      => "ابحث عن المقالات التي عنوانها ''$1''.",
'articletitles'    => "المقالات التي تبدأ ب ''$1''",
'hideresults'      => 'إخفاء النتائج',

'loginlanguagelabel' => 'اللغة: $1',

# Multipage image navigation
'imgmultipageprev'   => '&rarr; الصفحة السابقة',
'imgmultipagenext'   => 'الصفحة التالية &larr;',
'imgmultigo'         => 'اذهب!',
'imgmultigotopre'    => 'اذهب إلى صفحة',
'imgmultiparseerror' => 'يبدو أن ملف الصورة به خطأ ما أو غير صحيح، لذا لا يمكن أن تعرض {{SITENAME}} قائمة بالملفات.',

# Table pager
'ascending_abbrev'         => 'تصاعدي',
'descending_abbrev'        => 'تنازلي',
'table_pager_next'         => 'الصفحة التالية',
'table_pager_prev'         => 'الصفحة السابقة',
'table_pager_first'        => 'الصفحة الأولى',
'table_pager_last'         => 'الصفحة الأخيرة',
'table_pager_limit'        => 'اعرض $1 عنصر في الصفحة',
'table_pager_limit_submit' => 'اذهب',
'table_pager_empty'        => 'لا نتائج',

# Auto-summaries
'autosumm-blank'   => 'يرجى الانتباه إلى أن هذه الصفحة تم إفراغها',
'autosumm-replace' => "استبدال الصفحة ب'$1'",
'autoredircomment' => 'تحويل إلى [[$1]]',
'autosumm-new'     => 'صفحة جديدة: $1',

# Size units
'size-bytes'     => '$1 بايت',
'size-kilobytes' => '$1 كيلوبايت',
'size-megabytes' => '$1 ميجابايت',
'size-gigabytes' => '$1 جيجابايت',

# Live preview
'livepreview-loading' => 'جاري التحميل…',
'livepreview-ready'   => 'جاري التحميل… جاهز!',
'livepreview-failed'  => 'فشل العرض المباشر!
حاول تجربة العرض العادي.',
'livepreview-error'   => 'لم ينجح الاتصال: $1 "$2"
حاول تجربة العرض العادي.',

# Friendlier slave lag warnings
'lag-warn-normal' => 'التغييرات الأحدث من $1 ثانية قد لا تظهر في هذه القائمة.',
'lag-warn-high'   => 'نتيجة لوجود تأخر كبير في تحديث قاعدة بيانات الخادم، التغييرات أحدث من $1 ثانية
ربما لا تكون ظاهرة في هذه القائمة.',

# Watchlist editor
'watchlistedit-numitems'       => 'قائمة مراقبتك تحتوي على {{PLURAL:$1|عنوان واحد|$1 عنوان}}، بدون احتساب صفحات النقاش.',
'watchlistedit-noitems'        => 'قائمة مراقبتك لا تحتوي على أية عناوين.',
'watchlistedit-clear-title'    => 'إفراغ قائمة المراقبة',
'watchlistedit-clear-legend'   => 'أفرغ قائمة المراقبة',
'watchlistedit-clear-confirm'  => 'هذا سيزيل كل العناوين من قائمة مراقبتك. هل أنت متأكد أنك تريد فعل هذا؟ يمكنك أيضا [[Special:Watchlist/edit|إزالة عناوين معينة]].',
'watchlistedit-clear-submit'   => 'إفراغ',
'watchlistedit-clear-done'     => 'قائمة مراقبتك تم إفراغها. كل العناوين تم إزالتها.',
'watchlistedit-normal-title'   => 'تعديل قائمة المراقبة',
'watchlistedit-normal-legend'  => 'أزل عناوين من قائمة المراقبة',
'watchlistedit-normal-explain' => 'العناوين في قائمة مراقبتك معروضة بالأسفل. لإزالة عنوان، علم على الصندوق بجانبه، و اضغط إزالة العناوين. يمكنك أيضا [[Special:Watchlist/raw|تعديل القائمة مباشرة]]،
	أو [[Special:Watchlist/clear|إزالة كل العناوين]].',
'watchlistedit-normal-submit'  => 'إزالة العناوين',
'watchlistedit-normal-done'    => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تمت إزالته من قائمة مراقبتك:',
'watchlistedit-raw-title'      => 'تعديل قائمة المراقبة',
'watchlistedit-raw-legend'     => 'عدل قائمة المراقبة',
'watchlistedit-raw-explain'    => 'العناوين في قائمة مراقبتك معروضة بالأسفل، و يمكن تعديلها عن طريق الإضافة و الإزالة من القائمة؛ عنوان واحد لكل سطر. عند الانتهاء، اضغط تحديث قائمة المراقبة.
	يمكنك أيضا [[Special:Watchlist/edit|استخدام المحرر القياسي]].',
'watchlistedit-raw-titles'     => 'العناوين:',
'watchlistedit-raw-submit'     => 'تحديث قائمة المراقبة',
'watchlistedit-raw-done'       => 'قائمة مراقبتك تم تحديثها.',
'watchlistedit-raw-added'      => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تم إضافتها:',
'watchlistedit-raw-removed'    => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تمت إزالته:',

);
