﻿/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

(function()
{
	var stylesManager;

	CKEDITOR.plugins.add( 'stylescombo',
	{
		requires : [ 'richcombo', 'styles' ],

		init : function( editor )
		{
			var config = editor.config,
				lang = editor.lang.stylesCombo,
				pluginPath = this.path,
				styles = {},
				stylesList = [];

			if ( !stylesManager )
				stylesManager = CKEDITOR.stylesSet;

			var comboStylesSet = config.stylesCombo_stylesSet.split( ':' ),
				styleSetName = comboStylesSet[ 0 ],
				externalPath = comboStylesSet[ 1 ];

			stylesManager.addExternal( styleSetName,
					externalPath ?
						comboStylesSet.slice( 1 ).join( ':' ) :
						pluginPath + 'styles/' + styleSetName + '.js', '' );

			function loadStylesSet( callback )
		   {
			   CKEDITOR.stylesSet.load( styleSetName, function( stylesSet )
				   {
					   if ( !stylesList.length )
					   {
						   var stylesDefinitions = stylesSet[ styleSetName ],
							   style,
							   styleName;

						   // Put all styles into an Array.
						   for ( var i = 0 ; i < stylesDefinitions.length ; i++ )
						   {
							   var styleDefinition = stylesDefinitions[ i ];

							   styleName = styleDefinition.name;

							   style = styles[ styleName ] = new CKEDITOR.style( styleDefinition );
							   style._name = styleName;

							   stylesList.push( style );
						   }

						   // Sorts the Array, so the styles get grouped
						   // by type.
						   stylesList.sort( sortStyles );
					   }

					   callback && callback();
				   });
		   }

			editor.ui.addRichCombo( 'Styles',
				{
					label : lang.label,
					title : lang.panelTitle,
					className : 'cke_styles',

					panel :
					{
						css : editor.skin.editor.css.concat( config.contentsCss ),
						multiSelect : true,
						attributes : { 'aria-label' : lang.panelTitle }
					},

					init : function()
					{
						var combo = this;

						loadStylesSet( function()
							{
								var style, styleName;

								// Loop over the Array, adding all items to the
								// combo.
								var lastType;
								for ( var i = 0 ; i < stylesList.length ; i++ )
								{
									style = stylesList[ i ];
									styleName = style._name;

									var type = style.type;

									if ( type != lastType )
									{
										combo.startGroup( lang[ 'panelTitle' + String( type ) ] );
										lastType = type;
									}

									combo.add(
										styleName,
										style.type == CKEDITOR.STYLE_OBJECT ? styleName : buildPreview( style._.definition ),
										styleName );
								}

								combo.commit();

								combo.onOpen();
							});
					},

					onClick : function( value )
					{
						editor.focus();
						editor.fire( 'saveSnapshot' );

						var style = styles[ value ],
							selection = editor.getSelection();

						var elementPath = new CKEDITOR.dom.elementPath( selection.getStartElement() );

						if ( style.type == CKEDITOR.STYLE_INLINE && style.checkActive( elementPath ) )
							style.remove( editor.document );
						else
							style.apply( editor.document );

						editor.fire( 'saveSnapshot' );
					},

					onRender : function()
					{
						editor.on( 'selectionChange', function( ev )
							{
								var currentValue = this.getValue();

								var elementPath = ev.data.path,
									elements = elementPath.elements;

								// For each element into the elements path.
								for ( var i = 0, element ; i < elements.length ; i++ )
								{
									element = elements[i];

									// Check if the element is removable by any of
									// the styles.
									for ( var value in styles )
									{
										if ( styles[ value ].checkElementRemovable( element, true ) )
										{
											if ( value != currentValue )
												this.setValue( value );
											return;
										}
									}
								}

								// If no styles match, just empty it.
								this.setValue( '' );
							},
							this);
					},

					onOpen : function()
					{
						if ( CKEDITOR.env.ie )
							editor.focus();

						var selection = editor.getSelection();

						var element = selection.getSelectedElement(),
							elementPath = new CKEDITOR.dom.elementPath( element || selection.getStartElement() );

						var counter = [ 0, 0, 0, 0 ];
						this.showAll();
						this.unmarkAll();
						for ( var name in styles )
						{
							var style = styles[ name ],
								type = style.type;

							if ( style.checkActive( elementPath ) )
								this.mark( name );
							else if ( type == CKEDITOR.STYLE_OBJECT && !style.checkApplicable( elementPath ) )
							{
								this.hideItem( name );
								counter[ type ]--;
							}

							counter[ type ]++;
						}

						if ( !counter[ CKEDITOR.STYLE_BLOCK ] )
							this.hideGroup( lang[ 'panelTitle' + String( CKEDITOR.STYLE_BLOCK ) ] );

						if ( !counter[ CKEDITOR.STYLE_INLINE ] )
							this.hideGroup( lang[ 'panelTitle' + String( CKEDITOR.STYLE_INLINE ) ] );

						if ( !counter[ CKEDITOR.STYLE_OBJECT ] )
							this.hideGroup( lang[ 'panelTitle' + String( CKEDITOR.STYLE_OBJECT ) ] );
					}
				});

			editor.on( 'instanceReady', function() { loadStylesSet(); } );
		}
	});

	function buildPreview( styleDefinition )
	{
		var html = [];

		var elementName = styleDefinition.element;

		// Avoid <bdo> in the preview.
		if ( elementName == 'bdo' )
			elementName = 'span';

		html = [ '<', elementName ];

		// Assign all defined attributes.
		var attribs	= styleDefinition.attributes;
		if ( attribs )
		{
			for ( var att in attribs )
			{
				html.push( ' ', att, '="', attribs[ att ], '"' );
			}
		}

		// Assign the style attribute.
		var cssStyle = CKEDITOR.style.getStyleText( styleDefinition );
		if ( cssStyle )
			html.push( ' style="', cssStyle, '"' );

		html.push( '>', styleDefinition.name, '</', elementName, '>' );

		return html.join( '' );
	}

	function sortStyles( styleA, styleB )
	{
		var typeA = styleA.type,
			typeB = styleB.type;

		return typeA == typeB ? 0 :
			typeA == CKEDITOR.STYLE_OBJECT ? -1 :
			typeB == CKEDITOR.STYLE_OBJECT ? 1 :
			typeB == CKEDITOR.STYLE_BLOCK ? 1 :
			-1;
	}
})();

/**
 * The "styles definition set" to load into the styles combo. The styles may
 * be defined in the page containing the editor, or can be loaded on demand
 * from an external file when opening the styles combo for the fist time. In
 * the second case, if this setting contains only a name, the styles definition
 * file will be loaded from the "styles" folder inside the stylescombo plugin
 * folder. Otherwise, this setting has the "name:url" syntax, making it
 * possible to set the URL from which loading the styles file.
 * @type string
 * @default 'default'
 * @example
 * // Load from the stylescombo styles folder (mystyles.js file).
 * config.stylesCombo_stylesSet = 'mystyles';
 * @example
 * // Load from a relative URL.
 * config.stylesCombo_stylesSet = 'mystyles:/editorstyles/styles.js';
 * @example
 * // Load from a full URL.
 * config.stylesCombo_stylesSet = 'mystyles:http://www.example.com/editorstyles/styles.js';
 */
CKEDITOR.config.stylesCombo_stylesSet = 'default';
