<?php

# Not a valid entry point, skip unless MEDIAWIKI is defined
if (!defined('MEDIAWIKI')) {
    echo <<<HEREDOC
To install my extension, put the following line in LocalSettings.php:
require_once( "\$IP/extensions/FCKeditor/FCKeditor.php" );
HEREDOC;
    exit( 1 );
}

/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/

error_reporting(E_ALL | E_NOTICE);
ini_set("display_errors", 1);

require_once $IP . "/includes/GlobalFunctions.php";
require_once $IP . "/includes/ParserOptions.php";
require_once $IP . "/includes/Parser.php";
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . "FCKeditor.body.php";

$wgFCKEditorExtDir       = "extensions/FCKeditor";
$wgFCKEditorDir          = "extensions/FCKeditor/fckeditor";
$wgFCKEditorToolbarSet   = "Wiki";
$wgFCKEditorHeight       = "600";
$wgFCKEditorAllow_a_tags      = true; // <a> </a>   : Set this to true if you want to use the **external** link generator of the FCKeditor.
$wgFCKEditorAllow_img_tags    = true; // <img />    : Set this to true if you want to use the file browser and/or the smilies of the FCKeditor.

/**
 * Enable use of AJAX features.
 */
$wgUseAjax = true;
$wgAjaxExportList[] = 'wfSajaxSearchImageFCKeditor';
$wgAjaxExportList[] = 'wfSajaxSearchArticleFCKeditor';
$wgAjaxExportList[] = 'wfSajaxWikiToHTML';

$wgExtensionCredits['other'][] = array(
"name" => "FCKeditor extension",
"author" => "originally written by Mafs, extended by FCKeditor.net",
"version" => 'fck/mw-extension $Rev$ 2007',
"url" => "http://meta.wikimedia.org/wiki/FCKeditor",
"description" => "FCKeditor extension"
);

$oFCKeditorExtension = new FCKeditor();
$oFCKeditorExtension->registerHooks();








