<?php

class FCKeditor
{
    private $count = array();
    private $wgFCKBypassText = "";
    private $debug = 0;
    private $excludedNamespaces;
    static $nsToggles = array(
    'riched_disable_ns_main',
    'riched_disable_ns_talk',
    'riched_disable_ns_user',
    'riched_disable_ns_user_talk',
    'riched_disable_ns_project',
    'riched_disable_ns_project_talk',
    'riched_disable_ns_image',
    'riched_disable_ns_image_talk',
    'riched_disable_ns_mediawiki',
    'riched_disable_ns_mediawiki_talk',
    'riched_disable_ns_template',
    'riched_disable_ns_template_talk',
    'riched_disable_ns_help',
    'riched_disable_ns_help_talk',
    'riched_disable_ns_category',
    'riched_disable_ns_category_talk',
    );

    static $messagesLoaded = false;

    function __call($m,$a)
    {
        print "\n#### " . $m . "\n";
        if (!isset($this->count[$m])) {
            $this->count[$m] = 0;
        }
        $this->count[$m]++;
        return true;
    }

    function onMonoBookTemplateToolboxEnd()
    {
        if ($this->debug) {
            print_r($this->count);
        }
    }

    private function getExcludedNamespaces()
    {
        global $wgUser;

        if ( is_null( $this->excludedNamespaces ) ) {
            $this->excludedNamespaces = array();
            foreach ( self::$nsToggles as $toggle ) {
                if ( $wgUser->getOption( $toggle ) ) {
                    $this->excludedNamespaces[] = constant(strtoupper(str_replace("riched_disable_", "", $toggle)));
                }
            }
        }

        return $this->excludedNamespaces;
    }

    public function registerHooks() {
        global $wgHooks;

        $wgHooks['ParserBeforeStrip'][]                 = $this;
        //$wgHooks['ParserAfterTidy'][]                   = $this;
        $wgHooks['UserToggles'][]                       = $this;
        $wgHooks['MessagesPreLoad'][]                   = $this;
        $wgHooks['EditPage::showEditForm:initial'][]    = array($this, 'onEditPageShowEditFormInitial');

        if ($this->debug) {
            $opcje =  array('ArticleSave',
            'ArticleInsertComplete', 'ArticleSaveComplete', 'TitleMoveComplete', 'ArticleProtect', 'ArticleProtectComplete', 'ArticleDelete', 'ArticleDeleteComplete', 'AlternateEdit', 'ArticleFromTitle', 'ArticleAfterFetchContent',
            'ArticlePageDataBefore', 'ArticlePageDataAfter', 'ParserBeforeStrip', 'ParserAfterStrip', 'ParserBeforeInternalParse', 'InternalParseBeforeLinks', 'ParserBeforeTidy', 'ParserAfterTidy', 'ParserClearState', 'ParserGetVariableValueSwitch',
            'ParserGetVariableValueTs', 'ParserGetVariableValueVarCache', 'OutputPageBeforeHTML', 'OutputPageParserOutput', 'CategoryPageView', 'PageRenderingHash', 'ArticleViewHeader', 'ArticleViewRedirect', 'editSectionLinkForOther', 'editSectionLink',
            'AutoAuthenticate', 'UserLoginComplete', 'UserLogout', 'UserLogoutComplete', 'userCan', 'WatchArticle', 'WatchArticleComplete', 'UnwatchArticle', 'UnwatchArticleComplete', 'MarkPatrolled',
            'MarkPatrolledComplete', 'EmailUser', 'EmailUserComplete', 'UploadVerification', 'UploadComplete', 'SpecialMovepageAfterMove', 'SpecialSearchNogomatch', 'ArticleEditUpdateNewTalk', 'UserRetrieveNewTalks', 'UserClearNewTalkNotification',
            'ArticlePurge', 'SpecialPageGetRedirect', 'SpecialPageExecuteBeforeHeader', 'SpecialPageExecuteBeforePage', 'SpecialPageExecuteAfterPage', 'SpecialVersionExtensionTypes', 'SpecialPage_initList', 'UploadForm:initial', 'UploadForm:BeforeProcessing', 'AddNewAccount',
            'AbortNewAccount', 'BlockIp', 'BlockIpComplete', 'UserRights', 'GetBlockedStatus', 'LogPageActionText', 'LogPageLogHeader', 'LogPageLogName', 'LogPageValidTypes', 'BeforePageDisplay',
            'MonoBookTemplateToolboxEnd', 'PersonalUrls', 'SkinTemplateContentActions', 'SkinTemplateTabs', 'SkinTemplatePreventOtherActiveTabs', 'SkinTemplateSetupPageCss', 'SkinTemplateBuildContentActionUrlsAfterSpecialPage', 'SkinTemplateBuildNavUrlsNav_urlsAfterPermalink', 'UserCreateForm', 'UserLoginForm',
            'ArticleEditUpdatesDeleteFromRecentchanges', 'EditFilter', 'EditPage::showEditForm:initial', 'GetInternalURL', 'GetLocalURL', 'GetFullURL', 'LanguageGetMagic', 'MagicWordMagicWords', 'MagicWordwgVariableIDs', 'MessagesPreLoad',
            'ParserTestParser', 'SpecialContributionsBeforeMainOutput', 'UnknownAction', 'wgQueryPages', 'DisplayOldSubtitle', 'LoadAllMessages', 'RecentChange_save', 'UserToggles', 'BadImage', 'DiffViewHeader',
            'EditFormPreloadText', 'EmailConfirmed', 'FetchChangesList', 'MathAfterTexvc', 'SiteNoticeAfter', 'SiteNoticeBefore');

            foreach ($opcje as $o) {
                $wgHooks[$o][] = $this;
            }
        }
    }

    public function onMessagesPreLoad()
    {
        global $wgMessageCache, $wgUser, $wgContLanguageCode;

        if ( !self::$messagesLoaded ) {
            $lang = $wgUser->getOption( 'language', $wgContLanguageCode );
            $i18nfile = dirname( __FILE__ ) . DIRECTORY_SEPARATOR .'FCKeditor.i18n.' . $lang . '.php';

            if ( file_exists( $i18nfile ) ) {
                require( $i18nfile );
            } else {
                $lang = 'en';
                require( dirname( __FILE__ ) . DIRECTORY_SEPARATOR .'FCKeditor.i18n.en.php' );
            }

            $wgMessageCache->addMessages( $allMessages, $lang );
            self::$messagesLoaded = true;
        }
    }

    /**
     * Bypass parser cut
     *
     * @param unknown_type $q
     * @param unknown_type $text
     * @return unknown
     */
    public function onParserBeforeStrip( $q, $text ) {
        global $wgTitle, $wgUser;

        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if ( in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces() ) ) {
            return true;
        }

        $this->wgFCKBypassText = $text;

        return true;
    }

    /**
     * Bypass parser paste, fixes <a href='' problem
     *
     * @param unknown_type $q
     * @param unknown_type $text
     * @return unknown
     */
    public function onParserAfterTidy( $q, $text ) {
        global $wgOut, $wgTitle, $wgParser;
        global $wgFCKEditorHeight, $wgFCKEditorToolbarSet;
        global $wgFCKEditorAllow_a_tags, $wgFCKEditorAllow_img_tags, $wgUser;

        $List   = array();

        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if (in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces())) {
            return true;
        }

        $fcktext = $this->wgFCKBypassText;

        if ($wgFCKEditorAllow_a_tags) {
            $i = 0;
            $ta = md5("aopen");
            while (preg_match("|(<a.*?>)|i", $fcktext, $a)) {
                $j = $ta."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
            $i = 0;
            $ta = md5("aclose");
            while (preg_match("|(</a>)|i", $fcktext, $a)) {
                $j = $ta."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
        }
        if ($wgFCKEditorAllow_img_tags) {
            $i = 0;
            $timg = md5("img");
            while (preg_match("|(<img[^>]*?/>)|is", $fcktext, $a)) {
                $j = $timg."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
        }

        //$fcktext = str_replace('<p class="line867">&nbsp;</p>', "", $fcktext);

        $tagList = array("pre", "math", "gallery", "nowiki", "html");
        foreach($tagList as $tag) {
            //while (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
            if (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
                $r = preg_replace("|<br.*?>|i", "", $a[0]);
                $r = preg_replace("| |i", " ", $r);
                $fcktext = str_replace($a[0], html_entity_decode($r), $fcktext);
            }
        }

        foreach($q->mTagHooks as $tag => $func) {
            //while (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
            if (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
                $r = preg_replace("|<br.*?>|i", "", $a[0]);
                $r = preg_replace("| |i", " ", $r);
                $fcktext = str_replace($a[0], html_entity_decode($r), $fcktext);
            }
        }

        $state = new StripState;
        $x =& $state;

        $fcktext = $q->strip($fcktext, $x);

        $fcktext = preg_replace("/<\/?tbody>/i","", $fcktext);
        $fcktext = Sanitizer::removeHTMLtags( $fcktext, array( &$q, 'attributeStripCallback' ) );

        $fcktext = $q->replaceVariables($fcktext);
        $fcktext = $q->stripToc( $fcktext );

        $fcktext = $q->replaceInternalLinks( $fcktext );
        $fcktext = $q->replaceExternalLinks( $fcktext );

        # replaceInternalLinks may sometimes leave behind
        # absolute URLs, which have to be masked to hide them from replaceExternalLinks
        $fcktext = str_replace($q->mUniqPrefix."NOPARSE", "", $fcktext);

        $fcktext = $q->doMagicLinks( $fcktext );
        $fcktext = $q->formatHeadings( $fcktext, true );

        $q->replaceLinkHolders( $fcktext );

        $fcktext = $q->unstripNoWiki( $fcktext, $state );
        $fcktext = $q->unstrip($fcktext, $state);

        foreach($List as $item) {
            $fcktext = str_replace($item["index"], $item["content"], $fcktext);
            $i++;
        }

        $text = $fcktext;

        return true;
    }

    /**
     * Add FCK script
     *
     * @param unknown_type $q
     * @return unknown
     */
    public function onEditPageShowEditFormInitial( $form ) {
        global $wgOut, $wgTitle, $wgScriptPath;
        global $wgFCKEditorToolbarSet;
        global $wgFCKEditorExtDir, $wgFCKEditorDir, $wgFCKEditorHeight, $wgUser;
        global $wgStylePath, $wgStyleVersion;
        
        $options = new FCKeditorParserOptions();
        $options->setTidy(true);
        $parser = new FCKeditorParser();
        $parser->setOutputType(OT_HTML);
        $form->textbox1 = $parser->parse($form->textbox1, $wgTitle, $options)->getText();
        
        $EditorAreaCSS = " ";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        
        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if (in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces())) {
            return true;
        }

		$printsheet = htmlspecialchars( "$wgStylePath/common/wikiprintable.css?$wgStyleVersion" );		
		
        
        $script = <<<HEREDOC
<script type="text/javascript" src="$wgScriptPath/$wgFCKEditorDir/fckeditor.js"></script>
<script type="text/javascript"> 
var sEditorAreaCSS = '$printsheet,/mediawiki/skins/monobook/main.css?{$wgStyleVersion}';
</script>
<!--[if lt IE 5.5000]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE50Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 5.5000]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE55Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 6]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE60Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 7]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE70Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if lt IE 7]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IEFixes.css?{$wgStyleVersion}'; </script><![endif]-->

<script type="text/javascript"> 
function onLoadFCKeditor()
{
	if ( document.getElementById('wpTextbox1') )
	{
		var oFCKeditor = new FCKeditor('wpTextbox1') ;
		oFCKeditor.BasePath = '$wgScriptPath/$wgFCKEditorDir/' ;
		oFCKeditor.Config['CustomConfigurationsPath'] = '$wgScriptPath/$wgFCKEditorExtDir/fckeditor_config.js' ;
		//oFCKeditor.Config['EditorAreaCSS'] = sEditorAreaCSS;        
		//oFCKeditor.Config['EditorAreaCSS'] = '/mediawiki/allinone.css?{$wgStyleVersion}';
		oFCKeditor.Height = '$wgFCKEditorHeight' ;
		oFCKeditor.ToolbarSet = '$wgFCKEditorToolbarSet' ;
		oFCKeditor.ReplaceTextarea() ;
		document.getElementById('toolbar').style.cssText = 'display:none;' ;
	    //alert(oFCKeditor.Config['EditorAreaCSS']);
	}
}
addOnloadHook( onLoadFCKeditor ) ;

/*
function showSource() {
    var wp = document.getElementById("wpDiff");
    var s = document.createElement("input");
    s.type="submit";
    s.value="Wiki2HTML";
    s.name="Wiki2HTML";
    s.onclick = function wiki2html() {
        var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
        WikiToHTML_Call();        
        return false;
    }
    wp.parentNode.insertBefore(s, wp.nextSibling);
}

var sajax_debug_mode = false;
var sajax_request_type = "GET";

function WikiToHTML_Result(result)
{
    var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
    oEditor.SetHTML(result.responseText);
}
function WikiToHTML_Call()
{
     var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
     sajax_do_call('wfSajaxWikiToHTML', [oEditor.GetHTML()], WikiToHTML_Result); 
}

addOnloadHook(showSource);
*/
</script>        
HEREDOC;

        $wgOut->addScript($script);

        return true;
    }

    public function onUserToggles( &$extraToggles ) {
        $extraToggles[] = 'riched_disable';
        $extraToggles = array_merge($extraToggles, self::$nsToggles);
        return true;
    }
}

function wfSajaxSearchImageFCKeditor( $term )
{
    global $wgContLang, $wgOut;
    $limit = 10;

    $term = $wgContLang->checkTitleEncoding( $wgContLang->recodeInput( js_unescape( $term ) ) );
    $term1 = str_replace( ' ', '_', $wgContLang->ucfirst( $term ) );
    $term2 = str_replace( ' ', '_', $wgContLang->lc( $term ) );
    $term3 = str_replace( ' ', '_', $wgContLang->uc( $term ) );
    $term = $term1;

    if ( strlen( str_replace( '_', '', $term ) )<3 )
    return "";

    $db =& wfGetDB( DB_SLAVE );
    $res = $db->select( 'page', 'page_title',
    array(  'page_namespace' => NS_IMAGE,
    "LCASE(page_title) LIKE '%". $db->strencode( $term2 ) ."%'" ),
    "wfSajaxSearch",
    array( 'LIMIT' => $limit+1 )
    );

    $ret = "";
    $i=0;
    while ( ( $row = $db->fetchObject( $res ) ) && ( ++$i <= $limit ) ) {        
        $ret .= $row->page_title ."\n";
    }

    $term = htmlspecialchars( $term );    
    
    return $ret;
}

function wfSajaxSearchArticleFCKeditor( $term )
{
    global $wgContLang, $wgOut;
    $limit = 10;

    $term = $wgContLang->checkTitleEncoding( $wgContLang->recodeInput( js_unescape( $term ) ) );
    $term1 = str_replace( ' ', '_', $wgContLang->ucfirst( $term ) );
    $term2 = str_replace( ' ', '_', $wgContLang->lc( $term ) );
    $term3 = str_replace( ' ', '_', $wgContLang->uc( $term ) );
    $term = $term1;

    if ( strlen( str_replace( '_', '', $term ) )<3 )
    return "";

    $db =& wfGetDB( DB_SLAVE );
    $res = $db->select( 'page', 'page_title',
    array(  'page_namespace' => NS_MAIN,
    "LCASE(page_title) LIKE '%". $db->strencode( $term2 ) ."%'" ),
    "wfSajaxSearch",
    array( 'LIMIT' => $limit+1 )
    );

    $ret = "";
    $i=0;
    while ( ( $row = $db->fetchObject( $res ) ) && ( ++$i <= $limit ) ) {        
        $ret .= $row->page_title ."\n";
    }

    $term = htmlspecialchars( $term );    
    
    return $ret;
}

function wfSajaxWikiToHTML( $wiki )
{
        global $wgOut, $wgTitle, $wgScriptPath;
        global $wgFCKEditorToolbarSet;
        global $wgFCKEditorDir, $wgFCKEditorHeight, $wgUser;
        
        $options = new FCKeditorParserOptions();
        $options->setTidy(true);
        $parser = new FCKeditorParser();
        $parser->setOutputType(OT_HTML);
        return $parser->parse($wiki, $wgTitle, $options)->getText();
}


class FCKeditorParser extends Parser
{
    function replaceInternalLinks( $text ) {
        return parent::replaceInternalLinks($text);
    }	
    function formatHeadings( $text, $isMain=true ) {
    	return $text;
    }
    function stripNoGallery($text) {}
    function stripToc( $text ) {
    	return '<span class="fck_magic">' . $text . '</span>';
    }
    function strip( $text, $state, $stripcomments = false , $dontstrip = array () ) {
        $dontstrip[] = "gallery";
        
        return parent::strip($text, $state, $stripcomments , $dontstrip );       
    }       
    function replaceVariables( $text, $args = array(), $argsOnly = false ) {
        return preg_replace("/\{\{([^}]+)\}\}(\}*)/", '<span class="fck_template">{{$1}}$2</span>', $text);
    }
}

class FCKeditorSkin
{
    private $skin;

	function makeImageLinkObj( $nt, $label, $alt, $align = '', $params = array(), $framed = false,
	  $thumb = false, $manual_thumb = '', $valign = '' )
	{
		global $wgContLang, $wgUser, $wgThumbLimits;
		
		$width = (isset($params['width'])) ? " width=\"{$params['width']}\"" : "";
		$height = (isset($params['height'])) ? " height=\"{$params['height']}\"" : "";
		$alt = (!is_null($alt) && strlen($alt)>0) ? "alt=\"$alt\"" : "";
		
		return "<img src=\"{$nt->getFullText()}\"{$width}{$height}{$alt} />";
	}
    
    function makeKnownLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' , $aprops = '', $style = '' )
    {
		$fname = 'FCKeditorSkin::makeKnownLinkObj';
		wfProfileIn( $fname );

		if ( !is_object( $nt ) ) {
			wfProfileOut( $fname );
			return $text;
		}

		//$u = $nt->escapeLocalURL( $query );
		$u = $nt->getFullText();
		
		if ( $nt->getFragment() != '' ) {
			if( $nt->getPrefixedDbkey() == '' ) {
				$u = '';
				if ( '' == $text ) {
					$text = htmlspecialchars( $nt->getFragment() );
				}
			}
			$u .= $nt->getFragmentForURL();
		}
		if ( $text == '' ) {
			$text = htmlspecialchars( $nt->getPrefixedText() );
		}

		list( $inside, $trail ) = Linker::splitTrail( $trail );
		$r = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";
		wfProfileOut( $fname );
		return $r;
    }
    
    function makeBrokenLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' )
    {
		# Fail gracefully
		if ( ! isset($nt) ) {
			# throw new MWException();
			return "<!-- ERROR -->{$prefix}{$text}{$trail}";
		}

		$fname = 'FCKeditorSkin::makeBrokenLinkObj';
		wfProfileIn( $fname );

		//$u = $nt->escapeLocalURL( $query );
		//$u = $nt->getText();
		//$u = $nt->getEscapedText();
		$u = $nt->getFullText();
		//print_r($nt);
		
		if ( '' == $text ) {
			$text = htmlspecialchars( $nt->getPrefixedText() );
		}

		list( $inside, $trail ) = Linker::splitTrail( $trail );
		$s = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";

		wfProfileOut( $fname );
		return $s;
    }    
    
	function makeExternalLink( $url, $text, $escape = true, $linktype = '', $ns = null ) {		
		$url = htmlspecialchars( $url );
		if( $escape ) {
			$text = htmlspecialchars( $text );
		}
		if ($linktype == 'autonumber') {
		    return '<a href="'.$url.'">[autonumber]</a>';
		}
		return '<a href="'.$url.'">'.$text.'</a>';
	}
    
    function __call( $m, $a)
    {
    	return call_user_func_array( array( $this->skin, $m ), $a );
    }
    
    function __construct( &$skin )
    {
    	$this->skin = $skin;
    }
}

class FCKeditorParserOptions extends ParserOptions 
{
    function getNumberHeadings() {return false;}
    function getEditSection() {return false;}
    
	function getSkin() {
		if ( !isset( $this->mSkin ) ) {
			$this->mSkin = new FCKeditorSkin( $this->mUser->getSkin() );
		}
		return $this->mSkin;
	}
}
