<?php

class FCKeditor
{
    private $count = array();
    private $wgFCKBypassText = "";
    private $debug = 0;
    private $excludedNamespaces;
    static $nsToggles = array(
    'riched_disable_ns_main',
    'riched_disable_ns_talk',
    'riched_disable_ns_user',
    'riched_disable_ns_user_talk',
    'riched_disable_ns_project',
    'riched_disable_ns_project_talk',
    'riched_disable_ns_image',
    'riched_disable_ns_image_talk',
    'riched_disable_ns_mediawiki',
    'riched_disable_ns_mediawiki_talk',
    'riched_disable_ns_template',
    'riched_disable_ns_template_talk',
    'riched_disable_ns_help',
    'riched_disable_ns_help_talk',
    'riched_disable_ns_category',
    'riched_disable_ns_category_talk',
    );

    static $messagesLoaded = false;

    function __call($m,$a)
    {
        print "\n#### " . $m . "\n";
        if (!isset($this->count[$m])) {
            $this->count[$m] = 0;
        }
        $this->count[$m]++;
        return true;
    }

    function onMonoBookTemplateToolboxEnd()
    {
        if ($this->debug) {
            print_r($this->count);
        }
    }

    private function getExcludedNamespaces()
    {
        global $wgUser;

        if ( is_null( $this->excludedNamespaces ) ) {
            $this->excludedNamespaces = array();
            foreach ( self::$nsToggles as $toggle ) {
                if ( $wgUser->getOption( $toggle ) ) {
                    $this->excludedNamespaces[] = constant(strtoupper(str_replace("riched_disable_", "", $toggle)));
                }
            }
        }

        return $this->excludedNamespaces;
    }

    public function registerHooks() {
        global $wgHooks;

        $wgHooks['ParserBeforeStrip'][]                 = $this;
        //$wgHooks['ParserAfterTidy'][]                   = $this;
        $wgHooks['UserToggles'][]                       = $this;
        $wgHooks['MessagesPreLoad'][]                   = $this;
        $wgHooks['EditPage::showEditForm:initial'][]    = array($this, 'onEditPageShowEditFormInitial');

        if ($this->debug) {
            $opcje =  array('ArticleSave',
            'ArticleInsertComplete', 'ArticleSaveComplete', 'TitleMoveComplete', 'ArticleProtect', 'ArticleProtectComplete', 'ArticleDelete', 'ArticleDeleteComplete', 'AlternateEdit', 'ArticleFromTitle', 'ArticleAfterFetchContent',
            'ArticlePageDataBefore', 'ArticlePageDataAfter', 'ParserBeforeStrip', 'ParserAfterStrip', 'ParserBeforeInternalParse', 'InternalParseBeforeLinks', 'ParserBeforeTidy', 'ParserAfterTidy', 'ParserClearState', 'ParserGetVariableValueSwitch',
            'ParserGetVariableValueTs', 'ParserGetVariableValueVarCache', 'OutputPageBeforeHTML', 'OutputPageParserOutput', 'CategoryPageView', 'PageRenderingHash', 'ArticleViewHeader', 'ArticleViewRedirect', 'editSectionLinkForOther', 'editSectionLink',
            'AutoAuthenticate', 'UserLoginComplete', 'UserLogout', 'UserLogoutComplete', 'userCan', 'WatchArticle', 'WatchArticleComplete', 'UnwatchArticle', 'UnwatchArticleComplete', 'MarkPatrolled',
            'MarkPatrolledComplete', 'EmailUser', 'EmailUserComplete', 'UploadVerification', 'UploadComplete', 'SpecialMovepageAfterMove', 'SpecialSearchNogomatch', 'ArticleEditUpdateNewTalk', 'UserRetrieveNewTalks', 'UserClearNewTalkNotification',
            'ArticlePurge', 'SpecialPageGetRedirect', 'SpecialPageExecuteBeforeHeader', 'SpecialPageExecuteBeforePage', 'SpecialPageExecuteAfterPage', 'SpecialVersionExtensionTypes', 'SpecialPage_initList', 'UploadForm:initial', 'UploadForm:BeforeProcessing', 'AddNewAccount',
            'AbortNewAccount', 'BlockIp', 'BlockIpComplete', 'UserRights', 'GetBlockedStatus', 'LogPageActionText', 'LogPageLogHeader', 'LogPageLogName', 'LogPageValidTypes', 'BeforePageDisplay',
            'MonoBookTemplateToolboxEnd', 'PersonalUrls', 'SkinTemplateContentActions', 'SkinTemplateTabs', 'SkinTemplatePreventOtherActiveTabs', 'SkinTemplateSetupPageCss', 'SkinTemplateBuildContentActionUrlsAfterSpecialPage', 'SkinTemplateBuildNavUrlsNav_urlsAfterPermalink', 'UserCreateForm', 'UserLoginForm',
            'ArticleEditUpdatesDeleteFromRecentchanges', 'EditFilter', 'EditPage::showEditForm:initial', 'GetInternalURL', 'GetLocalURL', 'GetFullURL', 'LanguageGetMagic', 'MagicWordMagicWords', 'MagicWordwgVariableIDs', 'MessagesPreLoad',
            'ParserTestParser', 'SpecialContributionsBeforeMainOutput', 'UnknownAction', 'wgQueryPages', 'DisplayOldSubtitle', 'LoadAllMessages', 'RecentChange_save', 'UserToggles', 'BadImage', 'DiffViewHeader',
            'EditFormPreloadText', 'EmailConfirmed', 'FetchChangesList', 'MathAfterTexvc', 'SiteNoticeAfter', 'SiteNoticeBefore');

            foreach ($opcje as $o) {
                $wgHooks[$o][] = $this;
            }
        }
    }

    public function onMessagesPreLoad()
    {
        global $wgMessageCache, $wgUser, $wgContLanguageCode;

        if ( !self::$messagesLoaded ) {
            $lang = $wgUser->getOption( 'language', $wgContLanguageCode );
            $i18nfile = dirname( __FILE__ ) . DIRECTORY_SEPARATOR .'FCKeditor.i18n.' . $lang . '.php';

            if ( file_exists( $i18nfile ) ) {
                require( $i18nfile );
            } else {
                $lang = 'en';
                require( dirname( __FILE__ ) . DIRECTORY_SEPARATOR .'FCKeditor.i18n.en.php' );
            }

            $wgMessageCache->addMessages( $allMessages, $lang );
            self::$messagesLoaded = true;
        }
    }

    /**
     * Bypass parser cut
     *
     * @param unknown_type $q
     * @param unknown_type $text
     * @return unknown
     */
    public function onParserBeforeStrip( $q, $text ) {
        global $wgTitle, $wgUser;

        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if ( in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces() ) ) {
            return true;
        }

        $this->wgFCKBypassText = $text;

        return true;
    }

    /**
     * Bypass parser paste, fixes <a href='' problem
     *
     * @param unknown_type $q
     * @param unknown_type $text
     * @return unknown
     */
    public function onParserAfterTidy( $q, $text ) {
        global $wgOut, $wgTitle, $wgParser;
        global $wgFCKEditorHeight, $wgFCKEditorToolbarSet;
        global $wgFCKEditorAllow_a_tags, $wgFCKEditorAllow_img_tags, $wgUser;

        $List   = array();

        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if (in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces())) {
            return true;
        }

        $fcktext = $this->wgFCKBypassText;

        if ($wgFCKEditorAllow_a_tags) {
            $i = 0;
            $ta = md5("aopen");
            while (preg_match("|(<a.*?>)|i", $fcktext, $a)) {
                $j = $ta."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
            $i = 0;
            $ta = md5("aclose");
            while (preg_match("|(</a>)|i", $fcktext, $a)) {
                $j = $ta."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
        }
        if ($wgFCKEditorAllow_img_tags) {
            $i = 0;
            $timg = md5("img");
            while (preg_match("|(<img[^>]*?/>)|is", $fcktext, $a)) {
                $j = $timg."_".md5($i);
                $List[$j]["content"] = $a[0];
                $List[$j]["index"] = $j;
                $fcktext = str_replace($a[0], $j, $fcktext);
                $i++;
            }
        }

        //$fcktext = str_replace('<p class="line867">&nbsp;</p>', "", $fcktext);

        $tagList = array("pre", "math", "gallery", "nowiki", "html");
        foreach($tagList as $tag) {
            //while (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
            if (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
                $r = preg_replace("|<br.*?>|i", "", $a[0]);
                $r = preg_replace("| |i", " ", $r);
                $fcktext = str_replace($a[0], html_entity_decode($r), $fcktext);
            }
        }

        foreach($q->mTagHooks as $tag => $func) {
            //while (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
            if (preg_match("|<($tag.*?)>(.*?)</$tag>|is", $fcktext, $a)) {
                $r = preg_replace("|<br.*?>|i", "", $a[0]);
                $r = preg_replace("| |i", " ", $r);
                $fcktext = str_replace($a[0], html_entity_decode($r), $fcktext);
            }
        }

        $state = new StripState;
        $x =& $state;

        $fcktext = $q->strip($fcktext, $x);

        $fcktext = preg_replace("/<\/?tbody>/i","", $fcktext);
        $fcktext = Sanitizer::removeHTMLtags( $fcktext, array( &$q, 'attributeStripCallback' ) );

        $fcktext = $q->replaceVariables($fcktext);
        $fcktext = $q->stripToc( $fcktext );

        $fcktext = $q->replaceInternalLinks( $fcktext );
        $fcktext = $q->replaceExternalLinks( $fcktext );

        # replaceInternalLinks may sometimes leave behind
        # absolute URLs, which have to be masked to hide them from replaceExternalLinks
        $fcktext = str_replace($q->mUniqPrefix."NOPARSE", "", $fcktext);

        $fcktext = $q->doMagicLinks( $fcktext );
        $fcktext = $q->formatHeadings( $fcktext, true );

        $q->replaceLinkHolders( $fcktext );

        $fcktext = $q->unstripNoWiki( $fcktext, $state );
        $fcktext = $q->unstrip($fcktext, $state);

        foreach($List as $item) {
            $fcktext = str_replace($item["index"], $item["content"], $fcktext);
            $i++;
        }

        $text = $fcktext;

        return true;
    }

    /**
     * Add FCK script
     *
     * @param unknown_type $q
     * @return unknown
     */
    public function onEditPageShowEditFormInitial( $form ) {
        global $wgOut, $wgTitle, $wgScriptPath;
        global $wgFCKEditorToolbarSet;
        global $wgFCKEditorExtDir, $wgFCKEditorDir, $wgFCKEditorHeight, $wgUser;
        global $wgStylePath, $wgStyleVersion;
        
        $options = new FCKeditorParserOptions();
        $options->setTidy(true);
        $parser = new FCKeditorParser();
        $parser->setOutputType(OT_HTML);
        $form->textbox1 = $parser->parse($form->textbox1, $wgTitle, $options)->getText();
        
        $EditorAreaCSS = " ";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        $EditorAreaCSS .= "";
        
        if (!$wgUser->getOption( 'showtoolbar' ) || $wgUser->getOption( 'riched_disable' )) {
            return true;
        }

        if (in_array($wgTitle->getNamespace(), $this->getExcludedNamespaces())) {
            return true;
        }

		$printsheet = htmlspecialchars( "$wgStylePath/common/wikiprintable.css?$wgStyleVersion" );		
		
        
        $script = <<<HEREDOC
<script type="text/javascript" src="$wgScriptPath/$wgFCKEditorDir/fckeditor.js"></script>
<script type="text/javascript"> 
var sEditorAreaCSS = '$printsheet,/mediawiki/skins/monobook/main.css?{$wgStyleVersion}';
</script>
<!--[if lt IE 5.5000]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE50Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 5.5000]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE55Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 6]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE60Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if IE 7]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IE70Fixes.css?{$wgStyleVersion}'; </script><![endif]-->
<!--[if lt IE 7]><script type="text/javascript">sEditorAreaCSS += ',/mediawiki/skins/monobook/IEFixes.css?{$wgStyleVersion}'; </script><![endif]-->

<script type="text/javascript"> 
function onLoadFCKeditor()
{
	if ( document.getElementById('wpTextbox1') )
	{
		var oFCKeditor = new FCKeditor('wpTextbox1') ;
		oFCKeditor.BasePath = '$wgScriptPath/$wgFCKEditorDir/' ;
		oFCKeditor.Config['CustomConfigurationsPath'] = '$wgScriptPath/$wgFCKEditorExtDir/fckeditor_config.js' ;
		//oFCKeditor.Config['EditorAreaCSS'] = sEditorAreaCSS;        
		//oFCKeditor.Config['EditorAreaCSS'] = '/mediawiki/allinone.css?{$wgStyleVersion}';
		oFCKeditor.Height = '$wgFCKEditorHeight' ;
		oFCKeditor.ToolbarSet = '$wgFCKEditorToolbarSet' ;
		oFCKeditor.ReplaceTextarea() ;
		document.getElementById('toolbar').style.cssText = 'display:none;' ;
	    //alert(oFCKeditor.Config['EditorAreaCSS']);
	}
}
addOnloadHook( onLoadFCKeditor ) ;

/*
function showSource() {
    var wp = document.getElementById("wpDiff");
    var s = document.createElement("input");
    s.type="submit";
    s.value="Wiki2HTML";
    s.name="Wiki2HTML";
    s.onclick = function wiki2html() {
        var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
        WikiToHTML_Call();        
        return false;
    }
    wp.parentNode.insertBefore(s, wp.nextSibling);
}

var sajax_debug_mode = false;
var sajax_request_type = "GET";

function WikiToHTML_Result(result)
{
    var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
    oEditor.SetHTML(result.responseText);
}
function WikiToHTML_Call()
{
     var oEditor = FCKeditorAPI.GetInstance('wpTextbox1');        
     sajax_do_call('wfSajaxWikiToHTML', [oEditor.GetHTML()], WikiToHTML_Result); 
}

addOnloadHook(showSource);
*/
</script>        
HEREDOC;

        $wgOut->addScript($script);

        return true;
    }

    public function onUserToggles( &$extraToggles ) {
        $extraToggles[] = 'riched_disable';
        $extraToggles = array_merge($extraToggles, self::$nsToggles);
        return true;
    }
}
