<?php

class FCKeditorSkin
{
    private $skin;

    function makeImageLinkObj( $nt, $label, $alt, $align = '', $params = array(), $framed = false,
    $thumb = false, $manual_thumb = '', $valign = '' )
    {
        $img   = new Image( $nt );
        $imgName = $img->getName();        
        $url = $img->getURL();        
        
        $ret = "<img ";
        
        if ($url) {
            $ret .= "src=\"{$url}\" ";
        }
        else {
            $ret .= "src=\"{$imgName}\" ";
            $ret .= "_fck_mw_valid=\"false"."\" ";
        }
        
        if ($align) {
            $ret .= "_fck_mw_location=\"".strtolower($align)."\" ";
        }
        if (!empty($params)) {
            if (isset($params['width'])) {
                $ret .= "_fck_mw_width=\"".$params['width']."\" ";
            }
            if (isset($params['height'])) {
                $ret .= "_fck_mw_height=\"".$params['height']."\" ";
            }
        }
        if ($thumb) {
            $ret .= "_fck_mw_type=\"thumb"."\" ";
        }
        else if ($framed) {
            $ret .= "_fck_mw_type=\"frame"."\" ";
        }

        if (!is_null($alt)) {
            $ret .= "alt=\"".htmlspecialchars($alt)."\" ";
        }
        
        $ret .= "/>";

        return $ret;
        //return strip_tags(Linker::makeImageLinkObj($nt, $label, $alt, $align , $params , $framed , $thumb , $manual_thumb , $valign ), "<img>");
    }

    function makeKnownLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' , $aprops = '', $style = '' )
    {
        $fname = 'FCKeditorSkin::makeKnownLinkObj';
        wfProfileIn( $fname );

        if ( !is_object( $nt ) ) {
            wfProfileOut( $fname );
            return $text;
        }

        //$u = $nt->escapeLocalURL( $query );
        $u = $nt->getFullText();

        if ( $nt->getFragment() != '' ) {
            if( $nt->getPrefixedDbkey() == '' ) {
                $u = '';
                if ( '' == $text ) {
                    $text = htmlspecialchars( $nt->getFragment() );
                }
            }
            $u .= $nt->getFragmentForURL();
        }
        if ( $text == '' ) {
            $text = htmlspecialchars( $nt->getPrefixedText() );
        }

        list( $inside, $trail ) = Linker::splitTrail( $trail );
        $r = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";
        wfProfileOut( $fname );
        return $r;
    }

    function makeBrokenLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' )
    {
        # Fail gracefully
        if ( ! isset($nt) ) {
            # throw new MWException();
            return "<!-- ERROR -->{$prefix}{$text}{$trail}";
        }

        $fname = 'FCKeditorSkin::makeBrokenLinkObj';
        wfProfileIn( $fname );

        //$u = $nt->escapeLocalURL( $query );
        //$u = $nt->getText();
        //$u = $nt->getEscapedText();
        $u = $nt->getFullText();
        //print_r($nt);

        if ( '' == $text ) {
            $text = htmlspecialchars( $nt->getPrefixedText() );
        }

        list( $inside, $trail ) = Linker::splitTrail( $trail );
        $s = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";

        wfProfileOut( $fname );
        return $s;
    }

    function makeExternalLink( $url, $text, $escape = true, $linktype = '', $ns = null ) {
        $url = htmlspecialchars( $url );
        if( $escape ) {
            $text = htmlspecialchars( $text );
        }
        if ($linktype == 'autonumber') {
            return '<a href="'.$url.'">[n]</a>';
        }
        return '<a href="'.$url.'">'.$text.'</a>';
    }

    function __call( $m, $a)
    {
        return call_user_func_array( array( $this->skin, $m ), $a );
    }

    function __construct( &$skin )
    {
        $this->skin = $skin;
    }
}
