<?php

class FCKeditorSkin
{
    private $skin;

    /**
     * Enter description here...
     *
     * @param Title $nt
     * @param unknown_type $label
     * @param unknown_type $alt
     * @param unknown_type $align
     * @param unknown_type $params
     * @param unknown_type $framed
     * @param unknown_type $thumb
     * @param unknown_type $manual_thumb
     * @param unknown_type $valign
     * @return unknown
     */
    function makeImageLinkObj( $nt, $label, $alt, $align = '', $params = array(), $framed = false,
    $thumb = false, $manual_thumb = '', $valign = '' )
    {
        $orginal = $nt->getText();
        $img   = new Image( $nt );
        $imgName = $img->getName();
        $found = $img->getURL();

        if ($found) {
            //trick to get real Url for image:
            $originalLink = strip_tags(Linker::makeImageLinkObj($nt, $label, $alt, $align , $params , $framed , $thumb , $manual_thumb , $valign ), "<img>");
            $srcPart = substr($originalLink, strpos($originalLink, "src=")+ 5);
            $url = strtok($srcPart, '"');
        }

        $ret = "<img ";

        if ($found) {
            $ret .= "src=\"{$url}\" ";
        }
        else {
            $ret .= "_fck_mw_valid=\"false"."\" ";
        }
        $ret .= "_fck_mw_filename=\"{$orginal}\" ";

        if ($align) {
            $ret .= "_fck_mw_location=\"".strtolower($align)."\" ";
        }
        if (!empty($params)) {
            if (isset($params['width'])) {
                $ret .= "_fck_mw_width=\"".$params['width']."\" ";
            }
            if (isset($params['height'])) {
                $ret .= "_fck_mw_height=\"".$params['height']."\" ";
            }
        }
        $class = "";
        if ($thumb) {            
            $ret .= "_fck_mw_type=\"thumb"."\" ";
            $class .= "fck_mw_frame";
        }
        else if ($framed) {
            $ret .= "_fck_mw_type=\"frame"."\" ";
            $class .= "fck_mw_frame";
        }
        
        if ($align == "right") {
            $class .= ($class?" ":"") . "fck_mw_right";
        } 
        else if($align == "center") {
            $class .= ($class?" ":"") . "fck_mw_center";
        }
        else if($align == "left") {
            $class .= ($class?" ":"") . "fck_mw_left";
        }
        else if($framed || $thumb) {
            $class .= ($class?" ":"") . "fck_mw_right";
        }

        if (!is_null($alt) && !empty($alt) && false !== strpos(FCKeditorParser::$fkc_mw_makeImage_options, $alt) && $alt != "Image:" . $orginal) {
            $ret .= "alt=\"".htmlspecialchars($alt)."\" ";
        }
        else {
            $ret .= "alt=\"\" ";
        }

        if ($class) {
            $ret .= "class=\"$class\" ";
        }
        
        $ret .= "/>";

        return $ret;
    }

    function makeKnownLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' , $aprops = '', $style = '' )
    {
        $fname = 'FCKeditorSkin::makeKnownLinkObj';
        wfProfileIn( $fname );

        if ( !is_object( $nt ) ) {
            wfProfileOut( $fname );
            return $text;
        }

        //$u = $nt->escapeLocalURL( $query );
        $u = $nt->getFullText();

        if ( $nt->getFragment() != '' ) {
            if( $nt->getPrefixedDbkey() == '' ) {
                $u = '';
                if ( '' == $text ) {
                    $text = htmlspecialchars( $nt->getFragment() );
                }
            }
            $u .= $nt->getFragmentForURL();
        }
        if ( $text == '' ) {
            $text = htmlspecialchars( $nt->getPrefixedText() );
        }

        list( $inside, $trail ) = Linker::splitTrail( $trail );
        $r = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";
        wfProfileOut( $fname );
        return $r;
    }

    function makeBrokenLinkObj( $nt, $text = '', $query = '', $trail = '', $prefix = '' )
    {
        # Fail gracefully
        if ( ! isset($nt) ) {
            # throw new MWException();
            return "<!-- ERROR -->{$prefix}{$text}{$trail}";
        }

        $fname = 'FCKeditorSkin::makeBrokenLinkObj';
        wfProfileIn( $fname );

        //$u = $nt->escapeLocalURL( $query );
        //$u = $nt->getText();
        //$u = $nt->getEscapedText();
        $u = $nt->getFullText();
        //print_r($nt);

        if ( '' == $text ) {
            $text = htmlspecialchars( $nt->getPrefixedText() );
        }

        list( $inside, $trail ) = Linker::splitTrail( $trail );
        $s = "<a href=\"{$u}\">{$prefix}{$text}{$inside}</a>{$trail}";

        wfProfileOut( $fname );
        return $s;
    }

    function makeExternalLink( $url, $text, $escape = true, $linktype = '', $ns = null ) {
        $url = htmlspecialchars( $url );
        if( $escape ) {
            $text = htmlspecialchars( $text );
        }
        if ($linktype == 'autonumber') {
            return '<a href="'.$url.'">[n]</a>';
        }
        return '<a href="'.$url.'">'.$text.'</a>';
    }

    function __call( $m, $a)
    {
        return call_user_func_array( array( $this->skin, $m ), $a );
    }

    function __construct( &$skin )
    {
        $this->skin = $skin;
    }
}
