/*
Copyright (c) 2003-2011, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKRELEASER.load( 'tools.json.json2' );

CKRELEASER.docsProcessor = function()
{
};

( function()
{
	CKRELEASER.docsProcessor.prototype =
	{
		createDocumentation : function( sourceDir, targetDir )
		{
			var jsdocDir, jsdocPath;
			var configFile = new File( sourceDir, CKRELEASER.release.documentation.config );
			var targetLocation = new File( targetDir, CKRELEASER.release.documentation.target );

			if ( !configFile.exists() )
				throw "Missing configuration file (" + configFile.getCanonicalPath() + ")";

			var configurationCode = 'var configuration = ' + CKRELEASER.io.readFile( configFile ) + '\n;';
			var cx = Context.enter();
			var scope = cx.initStandardObjects();
			cx.evaluateString( scope, configurationCode, configFile.getName(), 1, null );

			var confDir = configFile.getParent();

			var f;
			f = new File( confDir.replace( "\\", "/" ), scope.configuration.t );
			scope.configuration.t = new String( f.getCanonicalPath() );
			f = new File( confDir.replace( "\\", "/" ), scope.configuration.d );
			scope.configuration.d = new String( f.getCanonicalPath() );

			/**
			 * The compiled version of CKReleaser may be launched anywhere. It
			 * can be launched over the released version of CKEditor without the
			 * _dev directory.
			 */
			if ( CKRELEASER.isCompiled )
			{
				var jsdocTemplateDir;

				if ( !System.getenv( "JSDOCDIR" ) )
				{
					jsdocDir = new File( CKRELEASER.sourceDir, "_dev/_thirdparty/jsdoc-toolkit" );

					if ( !jsdocDir.exists() )
						jsdocDir = new File( CKRELEASER.sourceDir, "jsdoc-toolkit" );

					if ( !jsdocDir.exists() )
					{
						print( "\nERROR: JsDoc Toolkit not found (" + jsdocDir.getCanonicalPath() + ")" );
						print( "       To create documentation, set the JSDOCDIR environment variable" );
						print( "       that points to directory with JsDoc Toolkit." );

						return;
					}
				}
				else
				{
					jsdocDir = new File( System.getenv( "JSDOCDIR" ) );

					if ( !jsdocDir.exists() )
					{
						print( "\nERROR: JsDoc Toolkit not found (" + jsdocDir.getCanonicalPath() + ")" );
						print( "       The JSDOCDIR environment variable points into invalid directory." );

						return;
					}
				}

				if ( !System.getenv( "JSDOCTEMPLATEDIR" ) )
				{
					jsdocTemplateDir = new File( scope.configuration.t );

					if ( !jsdocTemplateDir.exists() )
					{
						print( "\nERROR: JsDoc template not found (" + jsdocTemplateDir.getCanonicalPath() + ")." );
						print( "       You can set the template location in configuration file: " );
						print( "            " + configFile.getCanonicalPath() + "." );
						print( "       As an alternative, set the JSDOCTEMPLATEDIR environment variable that " );
						print( "       points to the directory with JsDoc template." );

						return;
					}
				}
				else
				{
					jsdocTemplateDir = new File( System.getenv( "JSDOCTEMPLATEDIR" ) );
					if ( !jsdocTemplateDir.exists() )
					{
						print( "\nERROR: JsDoc template not found (" + jsdocTemplateDir.getCanonicalPath() + ")" );
						print( "       The JSDOCTEMPLATEDIR environment variable points into invalid directory." );

						return;
					}

					/*
					 * Set the new t attribute based on the JSDOCTEMPLATEDIR environment variable.
					 */
					scope.configuration.t = new String( jsdocTemplateDir.getCanonicalPath() );
				}
			}
			else
			{
				jsdocDir = new File( '_dev/_thirdparty/jsdoc-toolkit' );
			}

			var runjsFile = new File( jsdocDir.getCanonicalPath(), 'app/run.js' );
			if ( !runjsFile.exists() )
			{
				print( "\nERROR: the specified JsDoc Toolkit directory seems to be invalid." );
				print( "Could not find " + runjsFile.getCanonicalPath() + "" );
				return;
			}

			for ( var i = 0 ; i < scope.configuration._.length ; i++ )
			{
				f = new File( confDir.replace( "\\", "/" ), scope.configuration._[i] );
				scope.configuration._[i] = new String( f.getCanonicalPath() );
			}

			var tempFile = File.createTempFile( "ckreleaser_jsdoc", ".conf" );
			CKRELEASER.io.saveFile( tempFile, JSON.stringify( scope.configuration ) );

			var o =
			{
				output : ""
			};

			jsdocPath = jsdocDir.getCanonicalPath();
			runCommand( "java", "-jar", jsdocPath + "/jsrun.jar", jsdocPath + "/app/run.js", "-c=" + tempFile.getCanonicalPath(),
					"-d=" + targetLocation.getCanonicalPath(), o );

			if ( CKRELEASER.verbose )
				print( o.output );
		}
	};
} )();
