/*
Copyright (c) 2003-2011, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importClass( java.lang.StringBuffer );

( function()
{
	var regexLib = {
		eol :Pattern.compile( '(?:\\x09|\\x20)+$' ),
		eof :Pattern.compile( '(?:\\x09|\\x20|\\r|\\n)+$' )
	};

	var lineEnding = {
		"cgi" :"\n",
		"pl" :"\n",
		"sh" :"\n",
		"readme" :"\r\n",
		"afp" :"\r\n",
		"afpa" :"\r\n",
		"ascx" :"\r\n",
		"asp" :"\r\n",
		"aspx" :"\r\n",
		"bat" :"\r\n",
		"cfc" :"\r\n",
		"cfm" :"\r\n",
		"code" :"\r\n",
		"command" :"\r\n",
		"conf" :"\r\n",
		"css" :"\r\n",
		"dtd" :"\r\n",
		"htaccess" :"\r\n",
		"htc" :"\r\n",
		"htm" :"\r\n",
		"html" :"\r\n",
		"js" :"\r\n",
		"jsp" :"\r\n",
		"lasso" :"\r\n",
		"php" :"\r\n",
		"py" :"\r\n",
		"sample" :"\r\n",
		"txt" :"\r\n",
		"xml" :"\r\n"
	};

	CKRELEASER.tools = {
		fixLineEndings : function( file, stripWhiteSpace )
		{
			var buffer = new StringBuffer();
			var inStream = new BufferedReader( new InputStreamReader( new FileInputStream( file ), "UTF-8" ) );
			var line;

			var extension = CKRELEASER.io.getExtension( file.getName() );

			if ( !lineEnding[extension] )
				return;

			while ( (line = inStream.readLine()) != null )
			{
				if ( stripWhiteSpace )
				{
					line = regexLib.eol.matcher( line ).replaceAll( "" );
				}
				buffer.append( line );
				buffer.append( lineEnding[extension] );
			}
			CKRELEASER.io.saveFile( file, regexLib.eof.matcher( buffer.toString() ).replaceAll( lineEnding[extension] ) );
		},

		removeComments : function( text )
		{
			var endIndex, startIndex = 0;
			var iemac = false;
			var preserve = false;

			var sb = new StringBuffer( text );
			while ( (startIndex = sb.indexOf( "/*", startIndex )) >= 0 )
			{
				preserve = sb.length() > startIndex + 2 && sb.charAt( startIndex + 2 ) == '!';
				endIndex = sb.indexOf( "*/", startIndex + 2 );
				if ( endIndex < 0 )
				{
					if ( !preserve )
					{
						sb["delete"]( startIndex, sb.length() );
					}
				}
				else if ( endIndex >= startIndex + 2 )
				{
					if ( sb.charAt( endIndex - 1 ) == '\\' )
					{
						/* 
						 * Looks like a comment to hide rules from IE Mac.
						 * Leave this comment, and the following one, alone...
						 */
						startIndex = endIndex + 2;
						iemac = true;
					}
					else if ( iemac )
					{
						startIndex = endIndex + 2;
						iemac = false;
					}
					else if ( !preserve )
					{
						try
						{
							/* Remove new line character if there is nothing else after a comment */
							if ( sb.charAt( endIndex + 2 ) == 13 && sb.charAt( endIndex + 3 ) == 10 )
								endIndex += 2;
							else if ( sb.charAt( endIndex + 2 ) == 10 && sb.charAt( endIndex + 3 ) == 13 )
								endIndex += 2;
							else if ( sb.charAt( endIndex + 2 ) == 13 && sb.charAt( endIndex + 3 ) == 13 )
								endIndex += 1;
							else if ( sb.charAt( endIndex + 2 ) == 10 && sb.charAt( endIndex + 3 ) == 10 )
								endIndex += 1;
						}
						catch( e ) {
							/* catch StringIndexOutOfBoundsException if comment is at the end of file */	
						}

						sb["delete"]( startIndex, endIndex + 2 );
					}
					else
					{
						startIndex = endIndex + 2;
					}
				}
			}

			return sb.toString();
		}
	};

})();
